<?php

namespace App\Models {

    /**
     * App\Models\Account
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string|null $description
     * @property boolean $is_control_account
     * @property boolean $is_bank_account
     * @property boolean $is_cash_account
     * @property boolean $is_active
     * @property decimal:2 $current_balance
     * @property decimal:2 $opening_balance
     * @property mixed $debit_credit
     * @property string|null $path
     * @property int $level
     * @property int|null $parent_id
     * @property mixed $subtype
     * @property mixed $type
     * @property string|null $name_en
     * @property string $name
     * @property string $code
     * @property int $id
     * @property-read mixed $full_name
     * @property-read mixed $hierarchy
     * @property-read \App\Models\Account $parent
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Account> $children
     * @property-read int|null $children_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\JournalEntryLine> $journalEntryLines
     * @property-read int|null $journalEntryLines_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\BankAccount> $bankAccount
     * @property-read int|null $bankAccount_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\CashTransaction> $cashTransactions
     * @property-read int|null $cashTransactions_count
     * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account whereCode($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account whereName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account whereNameEn($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account whereType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account whereSubtype($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account whereParentId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account whereLevel($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account wherePath($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account whereDebitCredit($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account whereOpeningBalance($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account whereCurrentBalance($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account whereIsActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account whereIsCashAccount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account whereIsBankAccount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account whereIsControlAccount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account whereDescription($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account active()
     * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account byType()
     * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account cashAccounts()
     * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account bankAccounts()
     * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Account extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\AccountBalance
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property array|null $breakdown
     * @property string|null $notes
     * @property \Illuminate\Support\Carbon|null $verified_at
     * @property int|null $verified_by
     * @property boolean $is_verified
     * @property boolean $is_calculated
     * @property int $transaction_count
     * @property decimal:2 $period_credits
     * @property decimal:2 $period_debits
     * @property decimal:2 $net_balance
     * @property decimal:2 $credit_balance
     * @property decimal:2 $debit_balance
     * @property mixed $balance_type
     * @property \Illuminate\Support\Carbon $balance_date
     * @property int|null $cost_center_id
     * @property int $fiscal_year_id
     * @property int $account_id
     * @property int $id
     * @property-read mixed $absolute_balance
     * @property-read mixed $balance_nature
     * @property-read mixed $verification_status
     * @property-read mixed $change_percentage
     * @property-read mixed $change_direction
     * @property-read mixed $balance_type_description
     * @property-read \App\Models\Account $account
     * @property-read \App\Models\FiscalYear $fiscalYear
     * @property-read \App\Models\CostCenter $costCenter
     * @property-read \App\Models\User $verifier
     * @method static \Illuminate\Database\Eloquent\Builder<AccountBalance>|AccountBalance whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AccountBalance>|AccountBalance whereAccountId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AccountBalance>|AccountBalance whereFiscalYearId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AccountBalance>|AccountBalance whereCostCenterId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AccountBalance>|AccountBalance whereBalanceDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AccountBalance>|AccountBalance whereBalanceType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AccountBalance>|AccountBalance whereDebitBalance($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AccountBalance>|AccountBalance whereCreditBalance($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AccountBalance>|AccountBalance whereNetBalance($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AccountBalance>|AccountBalance wherePeriodDebits($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AccountBalance>|AccountBalance wherePeriodCredits($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AccountBalance>|AccountBalance whereTransactionCount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AccountBalance>|AccountBalance whereIsCalculated($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AccountBalance>|AccountBalance whereIsVerified($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AccountBalance>|AccountBalance whereVerifiedBy($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AccountBalance>|AccountBalance whereVerifiedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AccountBalance>|AccountBalance whereNotes($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AccountBalance>|AccountBalance whereBreakdown($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AccountBalance>|AccountBalance whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AccountBalance>|AccountBalance whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AccountBalance>|AccountBalance opening()
     * @method static \Illuminate\Database\Eloquent\Builder<AccountBalance>|AccountBalance closing()
     * @method static \Illuminate\Database\Eloquent\Builder<AccountBalance>|AccountBalance periodEnd()
     * @method static \Illuminate\Database\Eloquent\Builder<AccountBalance>|AccountBalance adjustment()
     * @method static \Illuminate\Database\Eloquent\Builder<AccountBalance>|AccountBalance calculated()
     * @method static \Illuminate\Database\Eloquent\Builder<AccountBalance>|AccountBalance verified()
     * @method static \Illuminate\Database\Eloquent\Builder<AccountBalance>|AccountBalance forAccount()
     * @method static \Illuminate\Database\Eloquent\Builder<AccountBalance>|AccountBalance forFiscalYear()
     * @method static \Illuminate\Database\Eloquent\Builder<AccountBalance>|AccountBalance forCostCenter()
     * @method static \Illuminate\Database\Eloquent\Builder<AccountBalance>|AccountBalance forDate()
     * @method static \Illuminate\Database\Eloquent\Builder<AccountBalance>|AccountBalance betweenDates()
     * @method static \Illuminate\Database\Eloquent\Builder<AccountBalance>|AccountBalance newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<AccountBalance>|AccountBalance newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<AccountBalance>|AccountBalance query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class AccountBalance extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\AccountingSetting
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property int $sort_order
     * @property boolean $requires_restart
     * @property boolean $is_editable
     * @property boolean $is_public
     * @property string|null $default_value
     * @property array|null $options
     * @property string|null $validation_rules
     * @property string|null $description
     * @property string $label
     * @property string $type
     * @property string $group
     * @property string|null $value
     * @property string $key
     * @property int $id
     * @property-read mixed $typed_value
     * @property-read mixed $typed_default_value
     * @property-read mixed $validation_rules_array
     * @method static \Illuminate\Database\Eloquent\Builder<AccountingSetting>|AccountingSetting whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AccountingSetting>|AccountingSetting whereKey($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AccountingSetting>|AccountingSetting whereValue($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AccountingSetting>|AccountingSetting whereGroup($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AccountingSetting>|AccountingSetting whereType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AccountingSetting>|AccountingSetting whereLabel($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AccountingSetting>|AccountingSetting whereDescription($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AccountingSetting>|AccountingSetting whereValidationRules($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AccountingSetting>|AccountingSetting whereOptions($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AccountingSetting>|AccountingSetting whereDefaultValue($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AccountingSetting>|AccountingSetting whereIsPublic($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AccountingSetting>|AccountingSetting whereIsEditable($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AccountingSetting>|AccountingSetting whereRequiresRestart($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AccountingSetting>|AccountingSetting whereSortOrder($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AccountingSetting>|AccountingSetting whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AccountingSetting>|AccountingSetting whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AccountingSetting>|AccountingSetting byGroup()
     * @method static \Illuminate\Database\Eloquent\Builder<AccountingSetting>|AccountingSetting public()
     * @method static \Illuminate\Database\Eloquent\Builder<AccountingSetting>|AccountingSetting editable()
     * @method static \Illuminate\Database\Eloquent\Builder<AccountingSetting>|AccountingSetting ordered()
     * @method static \Illuminate\Database\Eloquent\Builder<AccountingSetting>|AccountingSetting newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<AccountingSetting>|AccountingSetting newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<AccountingSetting>|AccountingSetting query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class AccountingSetting extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\AuditLog
     *
     * @property \Illuminate\Support\Carbon $created_at
     * @property array|null $tags
     * @property string|null $description
     * @property string|null $user_agent
     * @property string|null $ip_address
     * @property string|null $url
     * @property array|null $new_values
     * @property array|null $old_values
     * @property string|null $user_type
     * @property int|null $user_id
     * @property int $auditable_id
     * @property string $auditable_type
     * @property string $event
     * @property int $id
     * @property-read mixed $event_description
     * @property-read mixed $model_type_description
     * @property-read mixed $summary
     * @property-read mixed $important_changes
     * @property-read \App\Models\User $user
     * @property-read \App\Models\AuditLog $auditable
     * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog whereEvent($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog whereAuditableType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog whereAuditableId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog whereUserId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog whereUserType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog whereOldValues($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog whereNewValues($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog whereUrl($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog whereIpAddress($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog whereUserAgent($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog whereDescription($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog whereTags($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog forModel()
     * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog byUser()
     * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog byEvent()
     * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog betweenDates()
     * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog withTag()
     * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog accountingEvents()
     * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog criticalEvents()
     * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<AuditLog>|AuditLog query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class AuditLog extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\BankAccount
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string|null $notes
     * @property boolean $is_active
     * @property decimal:2 $current_balance
     * @property decimal:2 $opening_balance
     * @property string $currency
     * @property string|null $branch
     * @property string|null $swift_code
     * @property string|null $iban
     * @property string $account_number
     * @property string $bank_name
     * @property int $account_id
     * @property int $id
     * @property-read mixed $full_account_name
     * @property-read mixed $formatted_balance
     * @property-read \App\Models\Account $account
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\BankTransaction> $transactions
     * @property-read int|null $transactions_count
     * @method static \Illuminate\Database\Eloquent\Builder<BankAccount>|BankAccount whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<BankAccount>|BankAccount whereAccountId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<BankAccount>|BankAccount whereBankName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<BankAccount>|BankAccount whereAccountNumber($value)
     * @method static \Illuminate\Database\Eloquent\Builder<BankAccount>|BankAccount whereIban($value)
     * @method static \Illuminate\Database\Eloquent\Builder<BankAccount>|BankAccount whereSwiftCode($value)
     * @method static \Illuminate\Database\Eloquent\Builder<BankAccount>|BankAccount whereBranch($value)
     * @method static \Illuminate\Database\Eloquent\Builder<BankAccount>|BankAccount whereCurrency($value)
     * @method static \Illuminate\Database\Eloquent\Builder<BankAccount>|BankAccount whereOpeningBalance($value)
     * @method static \Illuminate\Database\Eloquent\Builder<BankAccount>|BankAccount whereCurrentBalance($value)
     * @method static \Illuminate\Database\Eloquent\Builder<BankAccount>|BankAccount whereIsActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<BankAccount>|BankAccount whereNotes($value)
     * @method static \Illuminate\Database\Eloquent\Builder<BankAccount>|BankAccount whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<BankAccount>|BankAccount whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<BankAccount>|BankAccount active()
     * @method static \Illuminate\Database\Eloquent\Builder<BankAccount>|BankAccount byCurrency()
     * @method static \Illuminate\Database\Eloquent\Builder<BankAccount>|BankAccount newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<BankAccount>|BankAccount newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<BankAccount>|BankAccount query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class BankAccount extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\BankTransaction
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property array|null $attachments
     * @property int $created_by
     * @property int|null $journal_entry_id
     * @property \Illuminate\Support\Carbon|null $cleared_date
     * @property mixed $status
     * @property string|null $check_number
     * @property string|null $payee_payer
     * @property string $description
     * @property string|null $reference
     * @property decimal:2 $amount
     * @property mixed $type
     * @property int $bank_account_id
     * @property \Illuminate\Support\Carbon $transaction_date
     * @property string $transaction_number
     * @property int $id
     * @property-read mixed $formatted_amount
     * @property-read mixed $type_text
     * @property-read mixed $status_text
     * @property-read \App\Models\BankAccount $bankAccount
     * @property-read \App\Models\JournalEntry $journalEntry
     * @property-read \App\Models\User $creator
     * @method static \Illuminate\Database\Eloquent\Builder<BankTransaction>|BankTransaction whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<BankTransaction>|BankTransaction whereTransactionNumber($value)
     * @method static \Illuminate\Database\Eloquent\Builder<BankTransaction>|BankTransaction whereTransactionDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<BankTransaction>|BankTransaction whereBankAccountId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<BankTransaction>|BankTransaction whereType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<BankTransaction>|BankTransaction whereAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<BankTransaction>|BankTransaction whereReference($value)
     * @method static \Illuminate\Database\Eloquent\Builder<BankTransaction>|BankTransaction whereDescription($value)
     * @method static \Illuminate\Database\Eloquent\Builder<BankTransaction>|BankTransaction wherePayeePayer($value)
     * @method static \Illuminate\Database\Eloquent\Builder<BankTransaction>|BankTransaction whereCheckNumber($value)
     * @method static \Illuminate\Database\Eloquent\Builder<BankTransaction>|BankTransaction whereStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<BankTransaction>|BankTransaction whereClearedDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<BankTransaction>|BankTransaction whereJournalEntryId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<BankTransaction>|BankTransaction whereCreatedBy($value)
     * @method static \Illuminate\Database\Eloquent\Builder<BankTransaction>|BankTransaction whereAttachments($value)
     * @method static \Illuminate\Database\Eloquent\Builder<BankTransaction>|BankTransaction whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<BankTransaction>|BankTransaction whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<BankTransaction>|BankTransaction cleared()
     * @method static \Illuminate\Database\Eloquent\Builder<BankTransaction>|BankTransaction pending()
     * @method static \Illuminate\Database\Eloquent\Builder<BankTransaction>|BankTransaction byType()
     * @method static \Illuminate\Database\Eloquent\Builder<BankTransaction>|BankTransaction byPeriod()
     * @method static \Illuminate\Database\Eloquent\Builder<BankTransaction>|BankTransaction newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<BankTransaction>|BankTransaction newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<BankTransaction>|BankTransaction query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class BankTransaction extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Budget
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property \Illuminate\Support\Carbon|null $last_calculated_at
     * @property \Illuminate\Support\Carbon|null $approved_at
     * @property int|null $approved_by
     * @property int $created_by
     * @property decimal:2 $critical_threshold
     * @property decimal:2 $warning_threshold
     * @property boolean $auto_calculate
     * @property boolean $is_active
     * @property array|null $monthly_breakdown
     * @property string|null $description
     * @property mixed $status
     * @property decimal:2 $variance_percentage
     * @property decimal:2 $variance_amount
     * @property decimal:2 $committed_amount
     * @property decimal:2 $actual_amount
     * @property decimal:2 $budgeted_amount
     * @property \Illuminate\Support\Carbon $end_date
     * @property \Illuminate\Support\Carbon $start_date
     * @property mixed $period_type
     * @property int|null $account_id
     * @property int|null $cost_center_id
     * @property int $fiscal_year_id
     * @property string $code
     * @property string $name
     * @property int $id
     * @property-read mixed $remaining_amount
     * @property-read mixed $consumption_percentage
     * @property-read mixed $alert_status
     * @property-read mixed $alert_color
     * @property-read mixed $alert_message
     * @property-read mixed $remaining_days
     * @property-read mixed $period_elapsed_percentage
     * @property-read mixed $daily_burn_rate
     * @property-read mixed $actual_daily_burn_rate
     * @property-read \App\Models\FiscalYear $fiscalYear
     * @property-read \App\Models\CostCenter $costCenter
     * @property-read \App\Models\Account $account
     * @property-read \App\Models\User $creator
     * @property-read \App\Models\User $approver
     * @method static \Illuminate\Database\Eloquent\Builder<Budget>|Budget whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Budget>|Budget whereName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Budget>|Budget whereCode($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Budget>|Budget whereFiscalYearId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Budget>|Budget whereCostCenterId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Budget>|Budget whereAccountId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Budget>|Budget wherePeriodType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Budget>|Budget whereStartDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Budget>|Budget whereEndDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Budget>|Budget whereBudgetedAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Budget>|Budget whereActualAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Budget>|Budget whereCommittedAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Budget>|Budget whereVarianceAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Budget>|Budget whereVariancePercentage($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Budget>|Budget whereStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Budget>|Budget whereDescription($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Budget>|Budget whereMonthlyBreakdown($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Budget>|Budget whereIsActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Budget>|Budget whereAutoCalculate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Budget>|Budget whereWarningThreshold($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Budget>|Budget whereCriticalThreshold($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Budget>|Budget whereCreatedBy($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Budget>|Budget whereApprovedBy($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Budget>|Budget whereApprovedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Budget>|Budget whereLastCalculatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Budget>|Budget whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Budget>|Budget whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Budget>|Budget active()
     * @method static \Illuminate\Database\Eloquent\Builder<Budget>|Budget approved()
     * @method static \Illuminate\Database\Eloquent\Builder<Budget>|Budget forCostCenter()
     * @method static \Illuminate\Database\Eloquent\Builder<Budget>|Budget forAccount()
     * @method static \Illuminate\Database\Eloquent\Builder<Budget>|Budget forPeriod()
     * @method static \Illuminate\Database\Eloquent\Builder<Budget>|Budget overWarningThreshold()
     * @method static \Illuminate\Database\Eloquent\Builder<Budget>|Budget overCriticalThreshold()
     * @method static \Illuminate\Database\Eloquent\Builder<Budget>|Budget newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Budget>|Budget newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Budget>|Budget query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Budget extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\CashTransaction
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property array|null $attachments
     * @property int $created_by
     * @property int|null $journal_entry_id
     * @property string|null $bank_name
     * @property \Illuminate\Support\Carbon|null $check_date
     * @property string|null $check_number
     * @property string|null $payment_method
     * @property int|null $paid_to
     * @property int|null $received_from
     * @property string $description
     * @property string|null $reference
     * @property decimal:2 $amount
     * @property mixed $type
     * @property int $cash_account_id
     * @property \Illuminate\Support\Carbon $transaction_date
     * @property string $transaction_number
     * @property int $id
     * @property-read mixed $formatted_amount
     * @property-read mixed $type_text
     * @property-read \App\Models\Account $cashAccount
     * @property-read \App\Models\Account $contraAccount
     * @property-read \App\Models\CostCenter $costCenter
     * @property-read \App\Models\JournalEntry $journalEntry
     * @property-read \App\Models\User $creator
     * @method static \Illuminate\Database\Eloquent\Builder<CashTransaction>|CashTransaction whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CashTransaction>|CashTransaction whereTransactionNumber($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CashTransaction>|CashTransaction whereTransactionDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CashTransaction>|CashTransaction whereCashAccountId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CashTransaction>|CashTransaction whereType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CashTransaction>|CashTransaction whereAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CashTransaction>|CashTransaction whereReference($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CashTransaction>|CashTransaction whereDescription($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CashTransaction>|CashTransaction whereReceivedFrom($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CashTransaction>|CashTransaction wherePaidTo($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CashTransaction>|CashTransaction wherePaymentMethod($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CashTransaction>|CashTransaction whereCheckNumber($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CashTransaction>|CashTransaction whereCheckDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CashTransaction>|CashTransaction whereBankName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CashTransaction>|CashTransaction whereJournalEntryId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CashTransaction>|CashTransaction whereCreatedBy($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CashTransaction>|CashTransaction whereAttachments($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CashTransaction>|CashTransaction whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CashTransaction>|CashTransaction whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CashTransaction>|CashTransaction receipts()
     * @method static \Illuminate\Database\Eloquent\Builder<CashTransaction>|CashTransaction payments()
     * @method static \Illuminate\Database\Eloquent\Builder<CashTransaction>|CashTransaction byPeriod()
     * @method static \Illuminate\Database\Eloquent\Builder<CashTransaction>|CashTransaction newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<CashTransaction>|CashTransaction newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<CashTransaction>|CashTransaction query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class CashTransaction extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Company
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property boolean $is_active
     * @property string|null $website
     * @property string|null $phone
     * @property string|null $email
     * @property string|null $unit_number
     * @property string $postal_code
     * @property string $additional_number
     * @property string $building_number
     * @property string $street
     * @property string $district
     * @property string $city
     * @property string|null $cr_number
     * @property string $vat_number
     * @property string $name
     * @property int $id
     * @property-read mixed $full_address
     * @property-read mixed $address
     * @property-read mixed $commercial_registration
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Invoice> $invoices
     * @property-read int|null $invoices_count
     * @property-read \App\Models\ZatcaSettings $zatcaSettings
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\ReceiptVoucher> $receiptVouchers
     * @property-read int|null $receiptVouchers_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\PaymentVoucher> $paymentVouchers
     * @property-read int|null $paymentVouchers_count
     * @method static \Illuminate\Database\Eloquent\Builder<Company>|Company whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Company>|Company whereName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Company>|Company whereVatNumber($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Company>|Company whereCrNumber($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Company>|Company whereCity($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Company>|Company whereDistrict($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Company>|Company whereStreet($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Company>|Company whereBuildingNumber($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Company>|Company whereAdditionalNumber($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Company>|Company wherePostalCode($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Company>|Company whereUnitNumber($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Company>|Company whereEmail($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Company>|Company wherePhone($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Company>|Company whereWebsite($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Company>|Company whereIsActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Company>|Company whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Company>|Company whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Company>|Company active()
     * @method static \Illuminate\Database\Eloquent\Builder<Company>|Company newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Company>|Company newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Company>|Company query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Company extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\CostCenter
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property boolean $track_performance
     * @property boolean $requires_approval
     * @property boolean $allow_budget_exceeded
     * @property integer $variance_threshold
     * @property decimal:2 $actual_amount
     * @property string $budget_period
     * @property decimal:2|null $budget_amount
     * @property string|null $phone
     * @property string|null $manager_name
     * @property int|null $manager_id
     * @property boolean $is_active
     * @property string|null $description
     * @property int|null $parent_id
     * @property string|null $type
     * @property string|null $name_en
     * @property string $name
     * @property string $code
     * @property int $id
     * @property-read mixed $full_name
     * @property-read \App\Models\CostCenter $parent
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\CostCenter> $children
     * @property-read int|null $children_count
     * @property-read \App\Models\User $manager
     * @method static \Illuminate\Database\Eloquent\Builder<CostCenter>|CostCenter whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CostCenter>|CostCenter whereCode($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CostCenter>|CostCenter whereName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CostCenter>|CostCenter whereNameEn($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CostCenter>|CostCenter whereType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CostCenter>|CostCenter whereParentId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CostCenter>|CostCenter whereDescription($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CostCenter>|CostCenter whereIsActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CostCenter>|CostCenter whereManagerId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CostCenter>|CostCenter whereManagerName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CostCenter>|CostCenter wherePhone($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CostCenter>|CostCenter whereBudgetAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CostCenter>|CostCenter whereBudgetPeriod($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CostCenter>|CostCenter whereActualAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CostCenter>|CostCenter whereVarianceThreshold($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CostCenter>|CostCenter whereAllowBudgetExceeded($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CostCenter>|CostCenter whereRequiresApproval($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CostCenter>|CostCenter whereTrackPerformance($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CostCenter>|CostCenter whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CostCenter>|CostCenter whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CostCenter>|CostCenter active()
     * @method static \Illuminate\Database\Eloquent\Builder<CostCenter>|CostCenter parents()
     * @method static \Illuminate\Database\Eloquent\Builder<CostCenter>|CostCenter newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<CostCenter>|CostCenter newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<CostCenter>|CostCenter query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class CostCenter extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Customer
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property boolean $is_active
     * @property string|null $notes
     * @property string|null $phone
     * @property string|null $email
     * @property string|null $unit_number
     * @property string $postal_code
     * @property string $additional_number
     * @property string $building_number
     * @property string $street
     * @property string $district
     * @property string $city
     * @property string|null $cr_number
     * @property string|null $national_id
     * @property mixed $customer_type
     * @property string|null $vat_number
     * @property string $name
     * @property int $id
     * @property-read mixed $payment_status
     * @property-read mixed $full_address
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\SalesInvoice> $salesInvoices
     * @property-read int|null $salesInvoices_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Invoice> $invoices
     * @property-read int|null $invoices_count
     * @method static \Illuminate\Database\Eloquent\Builder<Customer>|Customer whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Customer>|Customer whereName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Customer>|Customer whereVatNumber($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Customer>|Customer whereCustomerType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Customer>|Customer whereNationalId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Customer>|Customer whereCrNumber($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Customer>|Customer whereCity($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Customer>|Customer whereDistrict($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Customer>|Customer whereStreet($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Customer>|Customer whereBuildingNumber($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Customer>|Customer whereAdditionalNumber($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Customer>|Customer wherePostalCode($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Customer>|Customer whereUnitNumber($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Customer>|Customer whereEmail($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Customer>|Customer wherePhone($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Customer>|Customer whereNotes($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Customer>|Customer whereIsActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Customer>|Customer whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Customer>|Customer whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Customer>|Customer active()
     * @method static \Illuminate\Database\Eloquent\Builder<Customer>|Customer withBalance()
     * @method static \Illuminate\Database\Eloquent\Builder<Customer>|Customer ofType()
     * @method static \Illuminate\Database\Eloquent\Builder<Customer>|Customer newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Customer>|Customer newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Customer>|Customer query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Customer extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\DeviceInitializationLog
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string|null $error_message
     * @property array|null $response_data
     * @property array|null $request_data
     * @property string|null $user_agent
     * @property string|null $ip_address
     * @property string $verification_status
     * @property \Illuminate\Support\Carbon|null $otp_verified_at
     * @property \Illuminate\Support\Carbon|null $otp_expires_at
     * @property \Illuminate\Support\Carbon|null $otp_requested_at
     * @property string|null $otp_token
     * @property string $csid_number
     * @property int $company_id
     * @property int $id
     * @property-read \App\Models\Company $company
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceInitializationLog>|DeviceInitializationLog whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceInitializationLog>|DeviceInitializationLog whereCompanyId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceInitializationLog>|DeviceInitializationLog whereCsidNumber($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceInitializationLog>|DeviceInitializationLog whereOtpToken($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceInitializationLog>|DeviceInitializationLog whereOtpRequestedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceInitializationLog>|DeviceInitializationLog whereOtpExpiresAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceInitializationLog>|DeviceInitializationLog whereOtpVerifiedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceInitializationLog>|DeviceInitializationLog whereVerificationStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceInitializationLog>|DeviceInitializationLog whereIpAddress($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceInitializationLog>|DeviceInitializationLog whereUserAgent($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceInitializationLog>|DeviceInitializationLog whereRequestData($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceInitializationLog>|DeviceInitializationLog whereResponseData($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceInitializationLog>|DeviceInitializationLog whereErrorMessage($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceInitializationLog>|DeviceInitializationLog whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceInitializationLog>|DeviceInitializationLog whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceInitializationLog>|DeviceInitializationLog newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceInitializationLog>|DeviceInitializationLog newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceInitializationLog>|DeviceInitializationLog query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class DeviceInitializationLog extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\File
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property \Illuminate\Support\Carbon|null $expires_at
     * @property boolean $is_archived
     * @property string $hash
     * @property array|null $tags
     * @property \Illuminate\Support\Carbon|null $last_downloaded_at
     * @property int $download_count
     * @property int|null $folder_id
     * @property int $uploaded_by
     * @property string $access_level
     * @property boolean $is_public
     * @property array|null $metadata
     * @property string $category
     * @property string|null $description
     * @property int $size
     * @property string $mime_type
     * @property string $extension
     * @property string $path
     * @property string $filename
     * @property string $name
     * @property int $id
     * @property-read mixed $formatted_size
     * @property-read mixed $file_url
     * @property-read mixed $download_url
     * @property-read mixed $is_image
     * @property-read mixed $is_document
     * @property-read mixed $is_video
     * @property-read mixed $is_audio
     * @property-read mixed $preview_url
     * @property-read \App\Models\User $uploader
     * @property-read \App\Models\Folder $folder
     * @method static \Illuminate\Database\Eloquent\Builder<File>|File whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<File>|File whereName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<File>|File whereFilename($value)
     * @method static \Illuminate\Database\Eloquent\Builder<File>|File wherePath($value)
     * @method static \Illuminate\Database\Eloquent\Builder<File>|File whereExtension($value)
     * @method static \Illuminate\Database\Eloquent\Builder<File>|File whereMimeType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<File>|File whereSize($value)
     * @method static \Illuminate\Database\Eloquent\Builder<File>|File whereDescription($value)
     * @method static \Illuminate\Database\Eloquent\Builder<File>|File whereCategory($value)
     * @method static \Illuminate\Database\Eloquent\Builder<File>|File whereMetadata($value)
     * @method static \Illuminate\Database\Eloquent\Builder<File>|File whereIsPublic($value)
     * @method static \Illuminate\Database\Eloquent\Builder<File>|File whereAccessLevel($value)
     * @method static \Illuminate\Database\Eloquent\Builder<File>|File whereUploadedBy($value)
     * @method static \Illuminate\Database\Eloquent\Builder<File>|File whereFolderId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<File>|File whereDownloadCount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<File>|File whereLastDownloadedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<File>|File whereTags($value)
     * @method static \Illuminate\Database\Eloquent\Builder<File>|File whereHash($value)
     * @method static \Illuminate\Database\Eloquent\Builder<File>|File whereIsArchived($value)
     * @method static \Illuminate\Database\Eloquent\Builder<File>|File whereExpiresAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<File>|File whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<File>|File whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<File>|File search()
     * @method static \Illuminate\Database\Eloquent\Builder<File>|File ofType()
     * @method static \Illuminate\Database\Eloquent\Builder<File>|File inCategory()
     * @method static \Illuminate\Database\Eloquent\Builder<File>|File public()
     * @method static \Illuminate\Database\Eloquent\Builder<File>|File active()
     * @method static \Illuminate\Database\Eloquent\Builder<File>|File notExpired()
     * @method static \Illuminate\Database\Eloquent\Builder<File>|File newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<File>|File newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<File>|File query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class File extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\FiscalYear
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string|null $notes
     * @property decimal:2 $closing_balance_total
     * @property decimal:2 $opening_balance_total
     * @property int|null $closed_by
     * @property \Illuminate\Support\Carbon|null $closed_at
     * @property boolean $is_closed
     * @property boolean $is_current
     * @property \Illuminate\Support\Carbon $end_date
     * @property \Illuminate\Support\Carbon $start_date
     * @property string $name
     * @property int $id
     * @property-read mixed $duration_in_months
     * @property-read mixed $duration_in_days
     * @property-read mixed $completion_percentage
     * @property-read mixed $remaining_days
     * @property-read mixed $status
     * @property-read \App\Models\User $closedBy
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Budget> $budgets
     * @property-read int|null $budgets_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\AccountBalance> $accountBalances
     * @property-read int|null $accountBalances_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\JournalEntry> $journalEntries
     * @property-read int|null $journalEntries_count
     * @method static \Illuminate\Database\Eloquent\Builder<FiscalYear>|FiscalYear whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<FiscalYear>|FiscalYear whereName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<FiscalYear>|FiscalYear whereStartDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<FiscalYear>|FiscalYear whereEndDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<FiscalYear>|FiscalYear whereIsCurrent($value)
     * @method static \Illuminate\Database\Eloquent\Builder<FiscalYear>|FiscalYear whereIsClosed($value)
     * @method static \Illuminate\Database\Eloquent\Builder<FiscalYear>|FiscalYear whereClosedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<FiscalYear>|FiscalYear whereClosedBy($value)
     * @method static \Illuminate\Database\Eloquent\Builder<FiscalYear>|FiscalYear whereOpeningBalanceTotal($value)
     * @method static \Illuminate\Database\Eloquent\Builder<FiscalYear>|FiscalYear whereClosingBalanceTotal($value)
     * @method static \Illuminate\Database\Eloquent\Builder<FiscalYear>|FiscalYear whereNotes($value)
     * @method static \Illuminate\Database\Eloquent\Builder<FiscalYear>|FiscalYear whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<FiscalYear>|FiscalYear whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<FiscalYear>|FiscalYear current()
     * @method static \Illuminate\Database\Eloquent\Builder<FiscalYear>|FiscalYear open()
     * @method static \Illuminate\Database\Eloquent\Builder<FiscalYear>|FiscalYear closed()
     * @method static \Illuminate\Database\Eloquent\Builder<FiscalYear>|FiscalYear forDate()
     * @method static \Illuminate\Database\Eloquent\Builder<FiscalYear>|FiscalYear newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<FiscalYear>|FiscalYear newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<FiscalYear>|FiscalYear query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class FiscalYear extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Folder
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property int $sort_order
     * @property boolean $is_system
     * @property int $total_size
     * @property int $subfolders_count
     * @property int $files_count
     * @property int $created_by
     * @property array|null $permissions
     * @property string $access_level
     * @property boolean $is_public
     * @property int $level
     * @property string $path
     * @property int|null $parent_id
     * @property string $icon
     * @property string $color
     * @property string|null $description
     * @property string $slug
     * @property string $name
     * @property int $id
     * @property-read mixed $formatted_total_size
     * @property-read mixed $breadcrumb
     * @property-read mixed $full_path
     * @property-read \App\Models\Folder $parent
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Folder> $children
     * @property-read int|null $children_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Folder> $descendants
     * @property-read int|null $descendants_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\File> $files
     * @property-read int|null $files_count
     * @property-read \App\Models\User $creator
     * @method static \Illuminate\Database\Eloquent\Builder<Folder>|Folder whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Folder>|Folder whereName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Folder>|Folder whereSlug($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Folder>|Folder whereDescription($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Folder>|Folder whereColor($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Folder>|Folder whereIcon($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Folder>|Folder whereParentId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Folder>|Folder wherePath($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Folder>|Folder whereLevel($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Folder>|Folder whereIsPublic($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Folder>|Folder whereAccessLevel($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Folder>|Folder wherePermissions($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Folder>|Folder whereCreatedBy($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Folder>|Folder whereFilesCount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Folder>|Folder whereSubfoldersCount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Folder>|Folder whereTotalSize($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Folder>|Folder whereIsSystem($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Folder>|Folder whereSortOrder($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Folder>|Folder whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Folder>|Folder whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Folder>|Folder search()
     * @method static \Illuminate\Database\Eloquent\Builder<Folder>|Folder root()
     * @method static \Illuminate\Database\Eloquent\Builder<Folder>|Folder public()
     * @method static \Illuminate\Database\Eloquent\Builder<Folder>|Folder system()
     * @method static \Illuminate\Database\Eloquent\Builder<Folder>|Folder userFolders()
     * @method static \Illuminate\Database\Eloquent\Builder<Folder>|Folder ordered()
     * @method static \Illuminate\Database\Eloquent\Builder<Folder>|Folder newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Folder>|Folder newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Folder>|Folder query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Folder extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\GoodsReceipt
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string|null $notes
     * @property mixed $status
     * @property \Illuminate\Support\Carbon $receipt_date
     * @property string $receipt_number
     * @property int $user_id
     * @property int $purchase_order_id
     * @property int $id
     * @property-read mixed $total_received_quantity
     * @property-read \App\Models\PurchaseOrder $purchaseOrder
     * @property-read \App\Models\User $user
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\GoodsReceiptItem> $items
     * @property-read int|null $items_count
     * @method static \Illuminate\Database\Eloquent\Builder<GoodsReceipt>|GoodsReceipt whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GoodsReceipt>|GoodsReceipt wherePurchaseOrderId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GoodsReceipt>|GoodsReceipt whereUserId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GoodsReceipt>|GoodsReceipt whereReceiptNumber($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GoodsReceipt>|GoodsReceipt whereReceiptDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GoodsReceipt>|GoodsReceipt whereStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GoodsReceipt>|GoodsReceipt whereNotes($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GoodsReceipt>|GoodsReceipt whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GoodsReceipt>|GoodsReceipt whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GoodsReceipt>|GoodsReceipt ofStatus()
     * @method static \Illuminate\Database\Eloquent\Builder<GoodsReceipt>|GoodsReceipt confirmed()
     * @method static \Illuminate\Database\Eloquent\Builder<GoodsReceipt>|GoodsReceipt newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<GoodsReceipt>|GoodsReceipt newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<GoodsReceipt>|GoodsReceipt query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class GoodsReceipt extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\GoodsReceiptItem
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string|null $notes
     * @property decimal:2 $total_cost
     * @property decimal:2 $unit_cost
     * @property integer $received_quantity
     * @property integer $ordered_quantity
     * @property int $product_id
     * @property int $purchase_order_item_id
     * @property int $goods_receipt_id
     * @property int $id
     * @property-read mixed $remaining_quantity
     * @property-read \App\Models\GoodsReceipt $goodsReceipt
     * @property-read \App\Models\PurchaseOrderItem $purchaseOrderItem
     * @property-read \App\Models\Product $product
     * @method static \Illuminate\Database\Eloquent\Builder<GoodsReceiptItem>|GoodsReceiptItem whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GoodsReceiptItem>|GoodsReceiptItem whereGoodsReceiptId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GoodsReceiptItem>|GoodsReceiptItem wherePurchaseOrderItemId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GoodsReceiptItem>|GoodsReceiptItem whereProductId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GoodsReceiptItem>|GoodsReceiptItem whereOrderedQuantity($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GoodsReceiptItem>|GoodsReceiptItem whereReceivedQuantity($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GoodsReceiptItem>|GoodsReceiptItem whereUnitCost($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GoodsReceiptItem>|GoodsReceiptItem whereTotalCost($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GoodsReceiptItem>|GoodsReceiptItem whereNotes($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GoodsReceiptItem>|GoodsReceiptItem whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GoodsReceiptItem>|GoodsReceiptItem whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GoodsReceiptItem>|GoodsReceiptItem newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<GoodsReceiptItem>|GoodsReceiptItem newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<GoodsReceiptItem>|GoodsReceiptItem query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class GoodsReceiptItem extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\InventoryAdjustment
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string|null $notes
     * @property mixed $status
     * @property string $reason
     * @property mixed $type
     * @property \Illuminate\Support\Carbon $adjustment_date
     * @property string $adjustment_number
     * @property int $user_id
     * @property int $id
     * @property-read mixed $total_items
     * @property-read mixed $total_value_impact
     * @property-read \App\Models\User $user
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\InventoryAdjustmentItem> $items
     * @property-read int|null $items_count
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryAdjustment>|InventoryAdjustment whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryAdjustment>|InventoryAdjustment whereUserId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryAdjustment>|InventoryAdjustment whereAdjustmentNumber($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryAdjustment>|InventoryAdjustment whereAdjustmentDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryAdjustment>|InventoryAdjustment whereType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryAdjustment>|InventoryAdjustment whereReason($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryAdjustment>|InventoryAdjustment whereStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryAdjustment>|InventoryAdjustment whereNotes($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryAdjustment>|InventoryAdjustment whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryAdjustment>|InventoryAdjustment whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryAdjustment>|InventoryAdjustment ofType()
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryAdjustment>|InventoryAdjustment ofStatus()
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryAdjustment>|InventoryAdjustment pending()
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryAdjustment>|InventoryAdjustment approved()
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryAdjustment>|InventoryAdjustment newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryAdjustment>|InventoryAdjustment newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryAdjustment>|InventoryAdjustment query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class InventoryAdjustment extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\InventoryAdjustmentItem
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string|null $notes
     * @property string|null $reason
     * @property decimal:2 $unit_cost
     * @property integer $quantity_difference
     * @property integer $adjusted_quantity
     * @property integer $current_quantity
     * @property int $product_id
     * @property int $inventory_adjustment_id
     * @property int $id
     * @property-read mixed $total_value_change
     * @property-read \App\Models\InventoryAdjustment $inventoryAdjustment
     * @property-read \App\Models\Product $product
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryAdjustmentItem>|InventoryAdjustmentItem whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryAdjustmentItem>|InventoryAdjustmentItem whereInventoryAdjustmentId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryAdjustmentItem>|InventoryAdjustmentItem whereProductId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryAdjustmentItem>|InventoryAdjustmentItem whereCurrentQuantity($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryAdjustmentItem>|InventoryAdjustmentItem whereAdjustedQuantity($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryAdjustmentItem>|InventoryAdjustmentItem whereQuantityDifference($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryAdjustmentItem>|InventoryAdjustmentItem whereUnitCost($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryAdjustmentItem>|InventoryAdjustmentItem whereReason($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryAdjustmentItem>|InventoryAdjustmentItem whereNotes($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryAdjustmentItem>|InventoryAdjustmentItem whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryAdjustmentItem>|InventoryAdjustmentItem whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryAdjustmentItem>|InventoryAdjustmentItem newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryAdjustmentItem>|InventoryAdjustmentItem newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryAdjustmentItem>|InventoryAdjustmentItem query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class InventoryAdjustmentItem extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\InventoryMovement
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property \Illuminate\Support\Carbon $movement_date
     * @property string|null $notes
     * @property int|null $reference_id
     * @property string|null $reference_type
     * @property decimal:2|null $total_cost
     * @property decimal:2|null $unit_cost
     * @property decimal:3 $quantity
     * @property mixed $type
     * @property int $user_id
     * @property int $product_id
     * @property int $id
     * @property-read mixed $direction
     * @property-read mixed $absolute_quantity
     * @property-read mixed $movement_type_display
     * @property-read mixed $is_expired
     * @property-read mixed $is_near_expiry
     * @property-read mixed $days_to_expiry
     * @property-read mixed $stock_change
     * @property-read \App\Models\Item $item
     * @property-read \App\Models\CostCenter $costCenter
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryMovement>|InventoryMovement whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryMovement>|InventoryMovement whereProductId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryMovement>|InventoryMovement whereUserId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryMovement>|InventoryMovement whereType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryMovement>|InventoryMovement whereQuantity($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryMovement>|InventoryMovement whereUnitCost($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryMovement>|InventoryMovement whereTotalCost($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryMovement>|InventoryMovement whereReferenceType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryMovement>|InventoryMovement whereReferenceId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryMovement>|InventoryMovement whereNotes($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryMovement>|InventoryMovement whereMovementDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryMovement>|InventoryMovement whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryMovement>|InventoryMovement whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryMovement>|InventoryMovement ofType()
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryMovement>|InventoryMovement forItem()
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryMovement>|InventoryMovement dateRange()
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryMovement>|InventoryMovement inbound()
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryMovement>|InventoryMovement outbound()
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryMovement>|InventoryMovement newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryMovement>|InventoryMovement newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<InventoryMovement>|InventoryMovement query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class InventoryMovement extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Invoice
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string|null $notes
     * @property string|null $pdf_file_path
     * @property string|null $xml_file_path
     * @property \Illuminate\Support\Carbon|null $sent_to_zatca_at
     * @property array|null $zatca_response
     * @property mixed $status
     * @property string|null $irn
     * @property string|null $qr_code
     * @property int $invoice_counter
     * @property string|null $previous_invoice_hash
     * @property string|null $invoice_hash
     * @property string $uuid
     * @property string $currency
     * @property string|null $last_reminder_sent_at
     * @property string|null $risk_marked_at
     * @property bool $is_high_risk
     * @property string|null $payment_notes
     * @property \Illuminate\Support\Carbon|null $debtor_notification_sent_at
     * @property boolean $debtor_notification_sent
     * @property \Illuminate\Support\Carbon|null $creditor_notification_sent_at
     * @property boolean $creditor_notification_sent
     * @property \Illuminate\Support\Carbon|null $payment_date
     * @property mixed $payment_status
     * @property decimal:2 $remaining_amount
     * @property decimal:2 $paid_amount
     * @property mixed $payment_method
     * @property decimal:2 $total_amount
     * @property decimal:2 $discount_amount
     * @property decimal:2 $tax_amount
     * @property decimal:2 $subtotal
     * @property \Illuminate\Support\Carbon|null $supply_date
     * @property \Illuminate\Support\Carbon|null $due_date
     * @property \Illuminate\Support\Carbon $issue_date
     * @property int $user_id
     * @property int|null $customer_id
     * @property int $company_id
     * @property mixed $type
     * @property string $invoice_number
     * @property int $id
     * @property-read \App\Models\Company $company
     * @property-read \App\Models\Customer $customer
     * @property-read \App\Models\User $user
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\InvoiceItem> $items
     * @property-read int|null $items_count
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice whereInvoiceNumber($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice whereType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice whereCompanyId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice whereCustomerId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice whereUserId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice whereIssueDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice whereDueDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice whereSupplyDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice whereSubtotal($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice whereTaxAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice whereDiscountAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice whereTotalAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice wherePaymentMethod($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice wherePaidAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice whereRemainingAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice wherePaymentStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice wherePaymentDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice whereCreditorNotificationSent($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice whereCreditorNotificationSentAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice whereDebtorNotificationSent($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice whereDebtorNotificationSentAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice wherePaymentNotes($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice whereIsHighRisk($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice whereRiskMarkedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice whereLastReminderSentAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice whereCurrency($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice whereUuid($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice whereInvoiceHash($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice wherePreviousInvoiceHash($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice whereInvoiceCounter($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice whereQrCode($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice whereIrn($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice whereStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice whereZatcaResponse($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice whereSentToZatcaAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice whereXmlFilePath($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice wherePdfFilePath($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice whereNotes($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice ofType()
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice standard()
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice simplified()
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice ofStatus()
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice draft()
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice sent()
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice ofPaymentStatus()
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice unpaid()
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice partiallyPaid()
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice paid()
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice overdue()
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Invoice>|Invoice query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Invoice extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\InvoiceItem
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property boolean $is_taxable
     * @property string|null $zatca_category_code
     * @property decimal:2 $total_with_tax
     * @property decimal:2 $tax_amount
     * @property decimal:2 $tax_rate
     * @property decimal:2 $discount_percentage
     * @property decimal:2 $discount_amount
     * @property decimal:2 $line_total
     * @property decimal:2 $unit_price
     * @property string $unit
     * @property decimal:3 $quantity
     * @property string|null $sku
     * @property string|null $description
     * @property string|null $name_en
     * @property string $name
     * @property int|null $product_id
     * @property int $invoice_id
     * @property int $id
     * @property-read \App\Models\Invoice $invoice
     * @property-read \App\Models\Product $product
     * @method static \Illuminate\Database\Eloquent\Builder<InvoiceItem>|InvoiceItem whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvoiceItem>|InvoiceItem whereInvoiceId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvoiceItem>|InvoiceItem whereProductId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvoiceItem>|InvoiceItem whereName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvoiceItem>|InvoiceItem whereNameEn($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvoiceItem>|InvoiceItem whereDescription($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvoiceItem>|InvoiceItem whereSku($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvoiceItem>|InvoiceItem whereQuantity($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvoiceItem>|InvoiceItem whereUnit($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvoiceItem>|InvoiceItem whereUnitPrice($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvoiceItem>|InvoiceItem whereLineTotal($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvoiceItem>|InvoiceItem whereDiscountAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvoiceItem>|InvoiceItem whereDiscountPercentage($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvoiceItem>|InvoiceItem whereTaxRate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvoiceItem>|InvoiceItem whereTaxAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvoiceItem>|InvoiceItem whereTotalWithTax($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvoiceItem>|InvoiceItem whereZatcaCategoryCode($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvoiceItem>|InvoiceItem whereIsTaxable($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvoiceItem>|InvoiceItem whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvoiceItem>|InvoiceItem whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvoiceItem>|InvoiceItem newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<InvoiceItem>|InvoiceItem newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<InvoiceItem>|InvoiceItem query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class InvoiceItem extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Item
     *
     * @property-read mixed $available_stock
     * @property-read mixed $stock_status
     * @property-read mixed $profit_margin
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\SalesInvoiceDetail> $salesInvoiceDetails
     * @property-read int|null $salesInvoiceDetails_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\PurchaseInvoiceDetail> $purchaseInvoiceDetails
     * @property-read int|null $purchaseInvoiceDetails_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\InventoryMovement> $inventoryMovements
     * @property-read int|null $inventoryMovements_count
     * @method static \Illuminate\Database\Eloquent\Builder<Item>|Item active()
     * @method static \Illuminate\Database\Eloquent\Builder<Item>|Item stockable()
     * @method static \Illuminate\Database\Eloquent\Builder<Item>|Item saleable()
     * @method static \Illuminate\Database\Eloquent\Builder<Item>|Item purchasable()
     * @method static \Illuminate\Database\Eloquent\Builder<Item>|Item ofType()
     * @method static \Illuminate\Database\Eloquent\Builder<Item>|Item ofCategory()
     * @method static \Illuminate\Database\Eloquent\Builder<Item>|Item lowStock()
     * @method static \Illuminate\Database\Eloquent\Builder<Item>|Item overstock()
     * @method static \Illuminate\Database\Eloquent\Builder<Item>|Item newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Item>|Item newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Item>|Item query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Item extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\JournalEntry
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property array|null $attachments
     * @property string|null $reversal_reason
     * @property \Illuminate\Support\Carbon|null $reversed_at
     * @property int|null $reversed_by
     * @property \Illuminate\Support\Carbon|null $posted_at
     * @property int|null $posted_by
     * @property int $created_by
     * @property decimal:2 $total_credit
     * @property decimal:2 $total_debit
     * @property mixed $status
     * @property mixed $type
     * @property string $description
     * @property string|null $reference
     * @property \Illuminate\Support\Carbon $entry_date
     * @property string $entry_number
     * @property int $id
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\JournalEntryLine> $lines
     * @property-read int|null $lines_count
     * @property-read \App\Models\User $creator
     * @property-read \App\Models\User $poster
     * @property-read \App\Models\User $reverser
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\CashTransaction> $cashTransactions
     * @property-read int|null $cashTransactions_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\BankTransaction> $bankTransactions
     * @property-read int|null $bankTransactions_count
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntry>|JournalEntry whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntry>|JournalEntry whereEntryNumber($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntry>|JournalEntry whereEntryDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntry>|JournalEntry whereReference($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntry>|JournalEntry whereDescription($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntry>|JournalEntry whereType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntry>|JournalEntry whereStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntry>|JournalEntry whereTotalDebit($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntry>|JournalEntry whereTotalCredit($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntry>|JournalEntry whereCreatedBy($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntry>|JournalEntry wherePostedBy($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntry>|JournalEntry wherePostedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntry>|JournalEntry whereReversedBy($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntry>|JournalEntry whereReversedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntry>|JournalEntry whereReversalReason($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntry>|JournalEntry whereAttachments($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntry>|JournalEntry whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntry>|JournalEntry whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntry>|JournalEntry posted()
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntry>|JournalEntry draft()
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntry>|JournalEntry byPeriod()
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntry>|JournalEntry byType()
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntry>|JournalEntry newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntry>|JournalEntry newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntry>|JournalEntry query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class JournalEntry extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\JournalEntryLine
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property array|null $dimensions
     * @property int|null $cost_center_id
     * @property int|null $supplier_id
     * @property int|null $customer_id
     * @property string|null $reference
     * @property decimal:2 $credit_amount
     * @property decimal:2 $debit_amount
     * @property string|null $description
     * @property int $account_id
     * @property int $journal_entry_id
     * @property int $id
     * @property-read mixed $amount
     * @property-read mixed $type
     * @property-read mixed $formatted_amount
     * @property-read \App\Models\JournalEntry $journalEntry
     * @property-read \App\Models\Account $account
     * @property-read \App\Models\Customer $customer
     * @property-read \App\Models\Supplier $supplier
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntryLine>|JournalEntryLine whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntryLine>|JournalEntryLine whereJournalEntryId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntryLine>|JournalEntryLine whereAccountId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntryLine>|JournalEntryLine whereDescription($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntryLine>|JournalEntryLine whereDebitAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntryLine>|JournalEntryLine whereCreditAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntryLine>|JournalEntryLine whereReference($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntryLine>|JournalEntryLine whereCustomerId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntryLine>|JournalEntryLine whereSupplierId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntryLine>|JournalEntryLine whereCostCenterId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntryLine>|JournalEntryLine whereDimensions($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntryLine>|JournalEntryLine whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntryLine>|JournalEntryLine whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntryLine>|JournalEntryLine newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntryLine>|JournalEntryLine newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<JournalEntryLine>|JournalEntryLine query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class JournalEntryLine extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\PaymentVoucher
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string|null $beneficiary_account
     * @property mixed $status
     * @property string $description
     * @property string|null $account_code
     * @property string|null $invoice_reference
     * @property string|null $notes
     * @property string|null $reference_number
     * @property mixed $payment_method
     * @property decimal:2 $amount
     * @property \Illuminate\Support\Carbon $payment_date
     * @property int $user_id
     * @property int|null $supplier_id
     * @property string $supplier_name
     * @property int $company_id
     * @property string $voucher_number
     * @property int $id
     * @property-read mixed $beneficiary_name
     * @property-read \App\Models\Company $company
     * @property-read \App\Models\User $user
     * @property-read \App\Models\Customer $supplier
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentVoucher>|PaymentVoucher whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentVoucher>|PaymentVoucher whereVoucherNumber($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentVoucher>|PaymentVoucher whereCompanyId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentVoucher>|PaymentVoucher whereSupplierName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentVoucher>|PaymentVoucher whereSupplierId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentVoucher>|PaymentVoucher whereUserId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentVoucher>|PaymentVoucher wherePaymentDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentVoucher>|PaymentVoucher whereAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentVoucher>|PaymentVoucher wherePaymentMethod($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentVoucher>|PaymentVoucher whereReferenceNumber($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentVoucher>|PaymentVoucher whereNotes($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentVoucher>|PaymentVoucher whereInvoiceReference($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentVoucher>|PaymentVoucher whereAccountCode($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentVoucher>|PaymentVoucher whereDescription($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentVoucher>|PaymentVoucher whereStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentVoucher>|PaymentVoucher whereBeneficiaryAccount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentVoucher>|PaymentVoucher whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentVoucher>|PaymentVoucher whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentVoucher>|PaymentVoucher ofStatus()
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentVoucher>|PaymentVoucher active()
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentVoucher>|PaymentVoucher cancelled()
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentVoucher>|PaymentVoucher ofPaymentMethod()
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentVoucher>|PaymentVoucher forPeriod()
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentVoucher>|PaymentVoucher newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentVoucher>|PaymentVoucher newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentVoucher>|PaymentVoucher query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class PaymentVoucher extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Product
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property boolean $is_active
     * @property boolean $is_taxable
     * @property string|null $zatca_category_code
     * @property string $unit
     * @property int $min_stock
     * @property int $stock_quantity
     * @property decimal:2 $tax_rate
     * @property decimal:2 $price_with_tax
     * @property decimal:2 $price
     * @property string|null $category
     * @property mixed $type
     * @property string|null $barcode
     * @property string $sku
     * @property string|null $description
     * @property string|null $name_en
     * @property string $name
     * @property int $id
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\InvoiceItem> $invoiceItems
     * @property-read int|null $invoiceItems_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\PurchaseOrderItem> $purchaseOrderItems
     * @property-read int|null $purchaseOrderItems_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\InventoryMovement> $inventoryMovements
     * @property-read int|null $inventoryMovements_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\InventoryAdjustmentItem> $inventoryAdjustmentItems
     * @property-read int|null $inventoryAdjustmentItems_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\GoodsReceiptItem> $goodsReceiptItems
     * @property-read int|null $goodsReceiptItems_count
     * @method static \Illuminate\Database\Eloquent\Builder<Product>|Product whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Product>|Product whereName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Product>|Product whereNameEn($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Product>|Product whereDescription($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Product>|Product whereSku($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Product>|Product whereBarcode($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Product>|Product whereType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Product>|Product whereCategory($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Product>|Product wherePrice($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Product>|Product wherePriceWithTax($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Product>|Product whereTaxRate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Product>|Product whereStockQuantity($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Product>|Product whereMinStock($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Product>|Product whereUnit($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Product>|Product whereZatcaCategoryCode($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Product>|Product whereIsTaxable($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Product>|Product whereIsActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Product>|Product whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Product>|Product whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Product>|Product active()
     * @method static \Illuminate\Database\Eloquent\Builder<Product>|Product ofType()
     * @method static \Illuminate\Database\Eloquent\Builder<Product>|Product products()
     * @method static \Illuminate\Database\Eloquent\Builder<Product>|Product services()
     * @method static \Illuminate\Database\Eloquent\Builder<Product>|Product taxable()
     * @method static \Illuminate\Database\Eloquent\Builder<Product>|Product lowStock()
     * @method static \Illuminate\Database\Eloquent\Builder<Product>|Product ofCategory()
     * @method static \Illuminate\Database\Eloquent\Builder<Product>|Product newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Product>|Product newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Product>|Product query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Product extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\PurchaseInvoice
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property array|null $additional_fields
     * @property int|null $journal_entry_id
     * @property string|null $received_by
     * @property \Illuminate\Support\Carbon|null $received_date
     * @property \Illuminate\Support\Carbon|null $delivery_date
     * @property string|null $delivery_address
     * @property string|null $terms_conditions
     * @property string|null $notes
     * @property string|null $payment_terms
     * @property mixed $payment_method
     * @property decimal:4 $exchange_rate
     * @property string $currency
     * @property decimal:2 $remaining_amount
     * @property decimal:2 $paid_amount
     * @property decimal:2 $total_amount
     * @property decimal:2 $other_charges
     * @property decimal:2 $shipping_amount
     * @property decimal:2 $tax_percentage
     * @property decimal:2 $tax_amount
     * @property decimal:2 $discount_percentage
     * @property decimal:2 $discount_amount
     * @property decimal:2 $subtotal
     * @property mixed $payment_status
     * @property mixed $status
     * @property string|null $reference
     * @property int|null $cost_center_id
     * @property int $supplier_id
     * @property \Illuminate\Support\Carbon $due_date
     * @property \Illuminate\Support\Carbon $invoice_date
     * @property string|null $supplier_invoice_number
     * @property string $invoice_number
     * @property int $id
     * @property-read mixed $is_overdue
     * @property-read mixed $days_overdue
     * @property-read mixed $received_percentage
     * @property-read mixed $is_fully_received
     * @property-read \App\Models\Supplier $supplier
     * @property-read \App\Models\CostCenter $costCenter
     * @property-read \App\Models\JournalEntry $journalEntry
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\PurchaseInvoiceDetail> $purchaseInvoiceDetails
     * @property-read int|null $purchaseInvoiceDetails_count
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice whereInvoiceNumber($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice whereSupplierInvoiceNumber($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice whereInvoiceDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice whereDueDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice whereSupplierId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice whereCostCenterId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice whereReference($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice whereStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice wherePaymentStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice whereSubtotal($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice whereDiscountAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice whereDiscountPercentage($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice whereTaxAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice whereTaxPercentage($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice whereShippingAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice whereOtherCharges($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice whereTotalAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice wherePaidAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice whereRemainingAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice whereCurrency($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice whereExchangeRate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice wherePaymentMethod($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice wherePaymentTerms($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice whereNotes($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice whereTermsConditions($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice whereDeliveryAddress($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice whereDeliveryDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice whereReceivedDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice whereReceivedBy($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice whereJournalEntryId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice whereAdditionalFields($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice draft()
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice pending()
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice approved()
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice received()
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice paid()
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice unpaid()
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice overdue()
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoice>|PurchaseInvoice query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class PurchaseInvoice extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\PurchaseInvoiceDetail
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string|null $notes
     * @property string|null $batch_number
     * @property \Illuminate\Support\Carbon|null $expiry_date
     * @property decimal:2 $total_amount
     * @property decimal:2 $tax_amount
     * @property decimal:2 $tax_percentage
     * @property decimal:2 $net_price
     * @property decimal:2 $discount_amount
     * @property decimal:2 $discount_percentage
     * @property decimal:2 $unit_price
     * @property string $unit
     * @property decimal:3 $received_quantity
     * @property decimal:3 $quantity
     * @property string|null $item_description
     * @property int $item_id
     * @property int $purchase_invoice_id
     * @property int $id
     * @property-read mixed $remaining_quantity
     * @property-read mixed $received_percentage
     * @property-read mixed $is_fully_received
     * @property-read mixed $is_partially_received
     * @property-read mixed $received_cost
     * @property-read mixed $is_near_expiry
     * @property-read mixed $is_expired
     * @property-read mixed $days_to_expiry
     * @property-read \App\Models\PurchaseInvoice $purchaseInvoice
     * @property-read \App\Models\Item $item
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoiceDetail>|PurchaseInvoiceDetail whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoiceDetail>|PurchaseInvoiceDetail wherePurchaseInvoiceId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoiceDetail>|PurchaseInvoiceDetail whereItemId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoiceDetail>|PurchaseInvoiceDetail whereItemDescription($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoiceDetail>|PurchaseInvoiceDetail whereQuantity($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoiceDetail>|PurchaseInvoiceDetail whereReceivedQuantity($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoiceDetail>|PurchaseInvoiceDetail whereUnit($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoiceDetail>|PurchaseInvoiceDetail whereUnitPrice($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoiceDetail>|PurchaseInvoiceDetail whereDiscountPercentage($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoiceDetail>|PurchaseInvoiceDetail whereDiscountAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoiceDetail>|PurchaseInvoiceDetail whereNetPrice($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoiceDetail>|PurchaseInvoiceDetail whereTaxPercentage($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoiceDetail>|PurchaseInvoiceDetail whereTaxAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoiceDetail>|PurchaseInvoiceDetail whereTotalAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoiceDetail>|PurchaseInvoiceDetail whereExpiryDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoiceDetail>|PurchaseInvoiceDetail whereBatchNumber($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoiceDetail>|PurchaseInvoiceDetail whereNotes($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoiceDetail>|PurchaseInvoiceDetail whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoiceDetail>|PurchaseInvoiceDetail whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoiceDetail>|PurchaseInvoiceDetail newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoiceDetail>|PurchaseInvoiceDetail newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseInvoiceDetail>|PurchaseInvoiceDetail query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class PurchaseInvoiceDetail extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\PurchaseOrder
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string|null $notes
     * @property decimal:2 $total_amount
     * @property decimal:2 $tax_amount
     * @property decimal:2 $subtotal
     * @property mixed $status
     * @property \Illuminate\Support\Carbon|null $expected_delivery_date
     * @property \Illuminate\Support\Carbon $order_date
     * @property string $po_number
     * @property int $user_id
     * @property int $supplier_id
     * @property int $id
     * @property-read mixed $total_quantity
     * @property-read mixed $total_received_quantity
     * @property-read \App\Models\Supplier $supplier
     * @property-read \App\Models\User $user
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\PurchaseOrderItem> $items
     * @property-read int|null $items_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\GoodsReceipt> $receipts
     * @property-read int|null $receipts_count
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseOrder>|PurchaseOrder whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseOrder>|PurchaseOrder whereSupplierId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseOrder>|PurchaseOrder whereUserId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseOrder>|PurchaseOrder wherePoNumber($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseOrder>|PurchaseOrder whereOrderDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseOrder>|PurchaseOrder whereExpectedDeliveryDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseOrder>|PurchaseOrder whereStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseOrder>|PurchaseOrder whereSubtotal($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseOrder>|PurchaseOrder whereTaxAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseOrder>|PurchaseOrder whereTotalAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseOrder>|PurchaseOrder whereNotes($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseOrder>|PurchaseOrder whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseOrder>|PurchaseOrder whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseOrder>|PurchaseOrder ofStatus()
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseOrder>|PurchaseOrder pending()
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseOrder>|PurchaseOrder approved()
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseOrder>|PurchaseOrder newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseOrder>|PurchaseOrder newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseOrder>|PurchaseOrder query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class PurchaseOrder extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\PurchaseOrderItem
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string|null $notes
     * @property decimal:2 $total_amount
     * @property decimal:2 $tax_rate
     * @property decimal:2 $unit_price
     * @property integer $quantity
     * @property int $product_id
     * @property int $purchase_order_id
     * @property int $id
     * @property-read mixed $tax_amount
     * @property-read mixed $subtotal
     * @property-read \App\Models\PurchaseOrder $purchaseOrder
     * @property-read \App\Models\Product $product
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseOrderItem>|PurchaseOrderItem whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseOrderItem>|PurchaseOrderItem wherePurchaseOrderId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseOrderItem>|PurchaseOrderItem whereProductId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseOrderItem>|PurchaseOrderItem whereQuantity($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseOrderItem>|PurchaseOrderItem whereUnitPrice($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseOrderItem>|PurchaseOrderItem whereTaxRate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseOrderItem>|PurchaseOrderItem whereTotalAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseOrderItem>|PurchaseOrderItem whereNotes($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseOrderItem>|PurchaseOrderItem whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseOrderItem>|PurchaseOrderItem whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseOrderItem>|PurchaseOrderItem newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseOrderItem>|PurchaseOrderItem newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<PurchaseOrderItem>|PurchaseOrderItem query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class PurchaseOrderItem extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\ReceiptVoucher
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property mixed $status
     * @property string $description
     * @property string|null $account_code
     * @property int|null $invoice_id
     * @property string|null $notes
     * @property string|null $reference_number
     * @property mixed $payment_method
     * @property decimal:2 $amount
     * @property \Illuminate\Support\Carbon $receipt_date
     * @property int $user_id
     * @property int $customer_id
     * @property int $company_id
     * @property string $voucher_number
     * @property int $id
     * @property-read \App\Models\Company $company
     * @property-read \App\Models\Customer $customer
     * @property-read \App\Models\User $user
     * @property-read \App\Models\Invoice $invoice
     * @method static \Illuminate\Database\Eloquent\Builder<ReceiptVoucher>|ReceiptVoucher whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ReceiptVoucher>|ReceiptVoucher whereVoucherNumber($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ReceiptVoucher>|ReceiptVoucher whereCompanyId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ReceiptVoucher>|ReceiptVoucher whereCustomerId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ReceiptVoucher>|ReceiptVoucher whereUserId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ReceiptVoucher>|ReceiptVoucher whereReceiptDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ReceiptVoucher>|ReceiptVoucher whereAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ReceiptVoucher>|ReceiptVoucher wherePaymentMethod($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ReceiptVoucher>|ReceiptVoucher whereReferenceNumber($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ReceiptVoucher>|ReceiptVoucher whereNotes($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ReceiptVoucher>|ReceiptVoucher whereInvoiceId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ReceiptVoucher>|ReceiptVoucher whereAccountCode($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ReceiptVoucher>|ReceiptVoucher whereDescription($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ReceiptVoucher>|ReceiptVoucher whereStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ReceiptVoucher>|ReceiptVoucher whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ReceiptVoucher>|ReceiptVoucher whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ReceiptVoucher>|ReceiptVoucher ofStatus()
     * @method static \Illuminate\Database\Eloquent\Builder<ReceiptVoucher>|ReceiptVoucher active()
     * @method static \Illuminate\Database\Eloquent\Builder<ReceiptVoucher>|ReceiptVoucher cancelled()
     * @method static \Illuminate\Database\Eloquent\Builder<ReceiptVoucher>|ReceiptVoucher ofPaymentMethod()
     * @method static \Illuminate\Database\Eloquent\Builder<ReceiptVoucher>|ReceiptVoucher forPeriod()
     * @method static \Illuminate\Database\Eloquent\Builder<ReceiptVoucher>|ReceiptVoucher newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<ReceiptVoucher>|ReceiptVoucher newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<ReceiptVoucher>|ReceiptVoucher query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class ReceiptVoucher extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\SalesInvoice
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property array|null $additional_fields
     * @property int|null $journal_entry_id
     * @property string|null $delivery_method
     * @property \Illuminate\Support\Carbon|null $delivery_date
     * @property string|null $delivery_address
     * @property string|null $terms_conditions
     * @property string|null $notes
     * @property string|null $payment_terms
     * @property mixed $payment_method
     * @property decimal:4 $exchange_rate
     * @property string $currency
     * @property decimal:2 $remaining_amount
     * @property decimal:2 $paid_amount
     * @property decimal:2 $total_amount
     * @property decimal:2 $shipping_amount
     * @property decimal:2 $tax_percentage
     * @property decimal:2 $tax_amount
     * @property decimal:2 $discount_percentage
     * @property decimal:2 $discount_amount
     * @property decimal:2 $subtotal
     * @property mixed $payment_status
     * @property mixed $status
     * @property string|null $reference
     * @property int|null $cost_center_id
     * @property int $customer_id
     * @property \Illuminate\Support\Carbon $due_date
     * @property \Illuminate\Support\Carbon $invoice_date
     * @property string $invoice_number
     * @property int $id
     * @property-read mixed $is_overdue
     * @property-read mixed $days_overdue
     * @property-read \App\Models\Customer $customer
     * @property-read \App\Models\CostCenter $costCenter
     * @property-read \App\Models\JournalEntry $journalEntry
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\SalesInvoiceDetail> $salesInvoiceDetails
     * @property-read int|null $salesInvoiceDetails_count
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice whereInvoiceNumber($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice whereInvoiceDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice whereDueDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice whereCustomerId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice whereCostCenterId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice whereReference($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice whereStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice wherePaymentStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice whereSubtotal($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice whereDiscountAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice whereDiscountPercentage($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice whereTaxAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice whereTaxPercentage($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice whereShippingAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice whereTotalAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice wherePaidAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice whereRemainingAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice whereCurrency($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice whereExchangeRate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice wherePaymentMethod($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice wherePaymentTerms($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice whereNotes($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice whereTermsConditions($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice whereDeliveryAddress($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice whereDeliveryDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice whereDeliveryMethod($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice whereJournalEntryId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice whereAdditionalFields($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice draft()
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice pending()
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice approved()
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice paid()
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice unpaid()
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice overdue()
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoice>|SalesInvoice query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class SalesInvoice extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\SalesInvoiceDetail
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string|null $notes
     * @property decimal:2 $total_amount
     * @property decimal:2 $tax_amount
     * @property decimal:2 $tax_percentage
     * @property decimal:2 $net_price
     * @property decimal:2 $discount_amount
     * @property decimal:2 $discount_percentage
     * @property decimal:2 $unit_price
     * @property string $unit
     * @property decimal:3 $quantity
     * @property string|null $item_description
     * @property int $item_id
     * @property int $sales_invoice_id
     * @property int $id
     * @property-read mixed $profit_margin
     * @property-read mixed $profit_amount
     * @property-read mixed $cost_amount
     * @property-read \App\Models\SalesInvoice $salesInvoice
     * @property-read \App\Models\Item $item
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoiceDetail>|SalesInvoiceDetail whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoiceDetail>|SalesInvoiceDetail whereSalesInvoiceId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoiceDetail>|SalesInvoiceDetail whereItemId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoiceDetail>|SalesInvoiceDetail whereItemDescription($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoiceDetail>|SalesInvoiceDetail whereQuantity($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoiceDetail>|SalesInvoiceDetail whereUnit($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoiceDetail>|SalesInvoiceDetail whereUnitPrice($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoiceDetail>|SalesInvoiceDetail whereDiscountPercentage($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoiceDetail>|SalesInvoiceDetail whereDiscountAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoiceDetail>|SalesInvoiceDetail whereNetPrice($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoiceDetail>|SalesInvoiceDetail whereTaxPercentage($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoiceDetail>|SalesInvoiceDetail whereTaxAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoiceDetail>|SalesInvoiceDetail whereTotalAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoiceDetail>|SalesInvoiceDetail whereNotes($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoiceDetail>|SalesInvoiceDetail whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoiceDetail>|SalesInvoiceDetail whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoiceDetail>|SalesInvoiceDetail newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoiceDetail>|SalesInvoiceDetail newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<SalesInvoiceDetail>|SalesInvoiceDetail query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class SalesInvoiceDetail extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\SavedReport
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property int|null $updated_by
     * @property int $created_by
     * @property array|null $recipients
     * @property boolean $is_active
     * @property boolean $is_public
     * @property \Illuminate\Support\Carbon|null $next_generation_at
     * @property \Illuminate\Support\Carbon|null $last_generated_at
     * @property array|null $schedule_config
     * @property string|null $schedule_frequency
     * @property boolean $is_scheduled
     * @property int|null $file_size
     * @property string|null $file_path
     * @property mixed $format
     * @property array|null $filters
     * @property array $parameters
     * @property string|null $description
     * @property string $report_type
     * @property string $name
     * @property int $id
     * @property-read mixed $report_type_description
     * @property-read mixed $schedule_frequency_description
     * @property-read mixed $formatted_file_size
     * @property-read mixed $status
     * @property-read mixed $status_color
     * @property-read mixed $next_generation_description
     * @property-read \App\Models\User $creator
     * @property-read \App\Models\User $updater
     * @method static \Illuminate\Database\Eloquent\Builder<SavedReport>|SavedReport whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SavedReport>|SavedReport whereName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SavedReport>|SavedReport whereReportType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SavedReport>|SavedReport whereDescription($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SavedReport>|SavedReport whereParameters($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SavedReport>|SavedReport whereFilters($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SavedReport>|SavedReport whereFormat($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SavedReport>|SavedReport whereFilePath($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SavedReport>|SavedReport whereFileSize($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SavedReport>|SavedReport whereIsScheduled($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SavedReport>|SavedReport whereScheduleFrequency($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SavedReport>|SavedReport whereScheduleConfig($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SavedReport>|SavedReport whereLastGeneratedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SavedReport>|SavedReport whereNextGenerationAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SavedReport>|SavedReport whereIsPublic($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SavedReport>|SavedReport whereIsActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SavedReport>|SavedReport whereRecipients($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SavedReport>|SavedReport whereCreatedBy($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SavedReport>|SavedReport whereUpdatedBy($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SavedReport>|SavedReport whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SavedReport>|SavedReport whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SavedReport>|SavedReport scheduled()
     * @method static \Illuminate\Database\Eloquent\Builder<SavedReport>|SavedReport active()
     * @method static \Illuminate\Database\Eloquent\Builder<SavedReport>|SavedReport public()
     * @method static \Illuminate\Database\Eloquent\Builder<SavedReport>|SavedReport byType()
     * @method static \Illuminate\Database\Eloquent\Builder<SavedReport>|SavedReport byCreator()
     * @method static \Illuminate\Database\Eloquent\Builder<SavedReport>|SavedReport dueForGeneration()
     * @method static \Illuminate\Database\Eloquent\Builder<SavedReport>|SavedReport byFormat()
     * @method static \Illuminate\Database\Eloquent\Builder<SavedReport>|SavedReport newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<SavedReport>|SavedReport newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<SavedReport>|SavedReport query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class SavedReport extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Supplier
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property boolean $is_active
     * @property decimal:2 $credit_limit
     * @property string|null $payment_terms
     * @property string|null $commercial_registration
     * @property string|null $tax_number
     * @property string|null $address
     * @property string|null $phone
     * @property string|null $email
     * @property string|null $contact_person
     * @property string|null $name_en
     * @property string $name
     * @property int $id
     * @property-read mixed $payment_status
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\PurchaseInvoice> $purchaseInvoices
     * @property-read int|null $purchaseInvoices_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\PurchaseOrder> $purchaseOrders
     * @property-read int|null $purchaseOrders_count
     * @method static \Illuminate\Database\Eloquent\Builder<Supplier>|Supplier whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Supplier>|Supplier whereName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Supplier>|Supplier whereNameEn($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Supplier>|Supplier whereContactPerson($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Supplier>|Supplier whereEmail($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Supplier>|Supplier wherePhone($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Supplier>|Supplier whereAddress($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Supplier>|Supplier whereTaxNumber($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Supplier>|Supplier whereCommercialRegistration($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Supplier>|Supplier wherePaymentTerms($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Supplier>|Supplier whereCreditLimit($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Supplier>|Supplier whereIsActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Supplier>|Supplier whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Supplier>|Supplier whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Supplier>|Supplier active()
     * @method static \Illuminate\Database\Eloquent\Builder<Supplier>|Supplier withBalance()
     * @method static \Illuminate\Database\Eloquent\Builder<Supplier>|Supplier newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Supplier>|Supplier newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Supplier>|Supplier query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Supplier extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\User
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string|null $remember_token
     * @property string $password
     * @property \Illuminate\Support\Carbon|null $email_verified_at
     * @property boolean $is_active
     * @property mixed $role
     * @property string|null $phone
     * @property string $email
     * @property string $name
     * @property int $id
     * @property-read mixed $role_name
     * @property-read mixed $status_name
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \Illuminate\Notifications\DatabaseNotification> $notifications
     * @property-read int|null $notifications_count
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereEmail($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User wherePhone($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereRole($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereIsActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereEmailVerifiedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User wherePassword($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereRememberToken($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class User extends \Illuminate\Foundation\Auth\User
    {
        //
    }

    /**
     * App\Models\ZatcaSettings
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property array|null $operation_log
     * @property string|null $last_error
     * @property mixed $connection_status
     * @property \Illuminate\Support\Carbon|null $last_connection_test
     * @property boolean $is_active
     * @property string|null $previous_invoice_hash
     * @property int $invoice_counter
     * @property \Illuminate\Support\Carbon|null $token_expires_at
     * @property string|null $access_token
     * @property string|null $password
     * @property string|null $username
     * @property string|null $client_secret
     * @property string|null $client_id
     * @property \Illuminate\Support\Carbon|null $certificate_expires_at
     * @property string|null $certificate_serial
     * @property string|null $public_key
     * @property string|null $secret_key
     * @property string|null $private_key
     * @property string|null $certificate
     * @property mixed $environment
     * @property mixed $connection_type
     * @property int $company_id
     * @property int $id
     * @property-read \App\Models\Company $company
     * @method static \Illuminate\Database\Eloquent\Builder<ZatcaSettings>|ZatcaSettings whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ZatcaSettings>|ZatcaSettings whereCompanyId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ZatcaSettings>|ZatcaSettings whereConnectionType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ZatcaSettings>|ZatcaSettings whereEnvironment($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ZatcaSettings>|ZatcaSettings whereCertificate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ZatcaSettings>|ZatcaSettings wherePrivateKey($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ZatcaSettings>|ZatcaSettings whereSecretKey($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ZatcaSettings>|ZatcaSettings wherePublicKey($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ZatcaSettings>|ZatcaSettings whereCertificateSerial($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ZatcaSettings>|ZatcaSettings whereCertificateExpiresAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ZatcaSettings>|ZatcaSettings whereClientId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ZatcaSettings>|ZatcaSettings whereClientSecret($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ZatcaSettings>|ZatcaSettings whereUsername($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ZatcaSettings>|ZatcaSettings wherePassword($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ZatcaSettings>|ZatcaSettings whereAccessToken($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ZatcaSettings>|ZatcaSettings whereTokenExpiresAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ZatcaSettings>|ZatcaSettings whereInvoiceCounter($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ZatcaSettings>|ZatcaSettings wherePreviousInvoiceHash($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ZatcaSettings>|ZatcaSettings whereIsActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ZatcaSettings>|ZatcaSettings whereLastConnectionTest($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ZatcaSettings>|ZatcaSettings whereConnectionStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ZatcaSettings>|ZatcaSettings whereLastError($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ZatcaSettings>|ZatcaSettings whereOperationLog($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ZatcaSettings>|ZatcaSettings whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ZatcaSettings>|ZatcaSettings whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ZatcaSettings>|ZatcaSettings active()
     * @method static \Illuminate\Database\Eloquent\Builder<ZatcaSettings>|ZatcaSettings environment()
     * @method static \Illuminate\Database\Eloquent\Builder<ZatcaSettings>|ZatcaSettings newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<ZatcaSettings>|ZatcaSettings newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<ZatcaSettings>|ZatcaSettings query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class ZatcaSettings extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

}