<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\CompanyController;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\InvoiceController;
use App\Http\Controllers\ZatcaSettingsController;
use App\Http\Controllers\ReceiptVoucherController;
use App\Http\Controllers\PaymentVoucherController;
use App\Http\Controllers\SupplierController;
use App\Http\Controllers\PurchaseOrderController;
use App\Http\Controllers\InventoryController;
use App\Http\Controllers\GoodsReceiptController;
use App\Http\Controllers\FileManagerController;
use App\Http\Controllers\AccountController;
use App\Http\Controllers\BrimaController;
use App\Http\Controllers\JournalEntryController;
use App\Http\Controllers\FinancialReportController;
use App\Http\Controllers\CashTransactionController;
use App\Http\Controllers\BankAccountController;
use App\Http\Controllers\BankTransactionController;
use App\Http\Controllers\CostCenterController;
use App\Http\Controllers\FiscalYearController;
use App\Http\Controllers\BudgetController;
use App\Http\Controllers\AuditLogController;
use App\Http\Controllers\AccountingSettingController;
use App\Http\Controllers\SavedReportController;
use App\Http\Controllers\ProcurementReportController;
use App\Http\Controllers\ProcurementWorkflowController;
use App\Http\Controllers\PurchaseInvoiceController;
use App\Http\Controllers\SupplierAnalyticsController;
use App\Http\Controllers\SupplierDebtController;
use App\Http\Controllers\SupplierPaymentController;
use App\Http\Controllers\SalesReportController;
use App\Http\Controllers\PurchaseReportController;
use App\Http\Controllers\ProductReportController;
use App\Http\Controllers\CustomerReportController;
use App\Http\Controllers\SupplierReportController;
use App\Http\Controllers\TaxReportController;
use App\Http\Controllers\RestaurantReportsController;
use App\Http\Controllers\CategoryController;

Route::get('/check-env', function () {
    return [
        'PHP Version' => phpversion(),
        'cURL' => function_exists('curl_version') ? 'Enabled' : 'Missing',
        'allow_url_fopen' => ini_get('allow_url_fopen') ? 'On' : 'Off',
    ];
});


// Root route - handles both authenticated and guest users
Route::get('/', function () {
    if (auth()->check()) {
        return redirect('/dashboard');
    }
    return redirect('/login');
})->name('home');

// مسارات المصادقة
Route::middleware('guest')->group(function () {
    Route::get('/login', [AuthController::class, 'showLoginForm'])->name('login');
    Route::post('/login', [AuthController::class, 'login']);
    Route::get('/register', [AuthController::class, 'showRegisterForm'])->name('register');
    Route::post('/register', [AuthController::class, 'register']);
    
    // مسارات إعادة تعيين كلمة المرور
    Route::get('/forgot-password', function () {
        return view('auth.forgot-password');
    })->name('password.request');
    
    Route::post('/forgot-password', function (Illuminate\Http\Request $request) {
        return back()->with('success', 'تم إرسال رابط إعادة تعيين كلمة المرور إلى بريدك الإلكتروني');
    })->name('password.email');
});

// مسار عام للتحقق من الفواتير (للـ QR Code)
Route::get('/invoices/verify/{uuid}', [InvoiceController::class, 'verify'])->name('invoices.verify');

Route::post('/logout', [AuthController::class, 'logout'])->name('logout')->middleware('auth');

// المسارات المحمية بالمصادقة
Route::middleware('auth')->group(function () {
    // الصفحة الرئيسية - إعادة توجيه للوحة التحكم
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    
    // إدارة المستخدمين (مقتصرة على المديرين)
    Route::middleware('admin')->group(function () {
        Route::resource('users', UserController::class);
        Route::patch('/users/{user}/toggle-status', [UserController::class, 'toggleStatus'])->name('users.toggle-status');
    });

    // إدارة الشركات
    Route::resource('companies', CompanyController::class);

    // إدارة العملاء
    Route::resource('customers', CustomerController::class);

    // إدارة الفئات
    Route::resource('categories', CategoryController::class);
    Route::post('/categories/{category}/toggle-status', [CategoryController::class, 'toggleStatus'])->name('categories.toggle-status');
    Route::post('/categories/{category}/duplicate', [CategoryController::class, 'duplicate'])->name('categories.duplicate');
    Route::get('/categories/export', [CategoryController::class, 'export'])->name('categories.export');
    Route::post('/categories/import', [CategoryController::class, 'import'])->name('categories.import');
    Route::post('/categories/bulk-action', [CategoryController::class, 'bulkAction'])->name('categories.bulk-action');
    Route::get('/api/categories/search', [CategoryController::class, 'search'])->name('api.categories.search');
    Route::get('/api/categories/{category}/children', [CategoryController::class, 'getChildren'])->name('api.categories.children');
    Route::get('/api/categories/tree', [CategoryController::class, 'getTree'])->name('api.categories.tree');

    // إدارة المنتجات والخدمات
    Route::get('/products/export-template', [ProductController::class, 'exportTemplate'])->name('products.export-template');
    Route::post('/products/import', [ProductController::class, 'import'])->name('products.import');
    Route::post('/products/preview-import', [ProductController::class, 'previewImport'])->name('products.preview-import');
    Route::get('/products/import-progress', [ProductController::class, 'getImportProgress'])->name('products.import-progress');
    Route::get('/products/export', [ProductController::class, 'export'])->name('products.export');
    
    // مسارات التصدير المعطوب (للتدريب على حل المشاكل)
    Route::get('/products/export-problems', function() {
        return view('products.export-problems');
    })->name('products.export-problems');
    Route::post('/products/export-problematic', [\App\Http\Controllers\ProductExportProblematicController::class, 'export'])->name('products.export-problematic');
    
    Route::resource('products', ProductController::class);

    // مسارات مزامنة ZATCA (يجب أن تكون قبل resource routes لتجنب التضارب)
    Route::get('/invoices/sync', [InvoiceController::class, 'syncWindow'])->name('invoices.sync');
    Route::post('/invoices/sync-all', [InvoiceController::class, 'syncAll'])->name('invoices.sync-all');
    Route::get('/invoices/sync/export', [InvoiceController::class, 'exportSyncReport'])->name('invoices.sync-export');
Route::get('/brima/index',[ BrimaController::class , 'index'])->name('index');

    // مسارات إعدادات الإشعارات (يجب أن تكون قبل resource routes)
    Route::get('/invoices/notification-settings', [InvoiceController::class, 'notificationSettings'])->name('invoices.notification-settings');
    Route::post('/invoices/save-notification-settings', [InvoiceController::class, 'saveNotificationSettings'])->name('invoices.save-notification-settings');
    Route::post('/invoices/test-notifications', [InvoiceController::class, 'testNotifications'])->name('invoices.test-notifications');
    Route::post('/invoices/send-payment-reminders', [InvoiceController::class, 'sendPaymentReminders'])->name('invoices.send-payment-reminders');
    
    // مسارات إدارة الديون (يجب أن تكون قبل resource routes)
    Route::get('/invoices/debt-management', [InvoiceController::class, 'debtManagement'])->name('invoices.debt-management');
    Route::post('/invoices/send-bulk-reminders', [InvoiceController::class, 'sendBulkReminders'])->name('invoices.send-bulk-reminders');
    Route::get('/invoices/export-debt-report', [InvoiceController::class, 'exportDebtReport'])->name('invoices.export-debt-report');
    
    // مسارات تقرير أداء التحصيل (يجب أن تكون قبل resource routes)
    Route::get('/invoices/collection-performance', [InvoiceController::class, 'collectionPerformance'])->name('invoices.collection-performance');
    Route::get('/invoices/export-collection-performance', [InvoiceController::class, 'exportCollectionPerformance'])->name('invoices.export-collection-performance');
    
    // مسارات التحليلات المتقدمة (يجب أن تكون قبل resource routes)
    Route::get('/invoices/payment-analytics', [InvoiceController::class, 'paymentAnalytics'])->name('invoices.payment-analytics');
    Route::get('/invoices/export-analytics', [InvoiceController::class, 'exportPaymentAnalytics'])->name('invoices.export-analytics');
    Route::get('/invoices/chart-data', [InvoiceController::class, 'getChartData'])->name('invoices.chart-data');
    
    // مسارات السداد (يجب أن تكون قبل resource routes)
    Route::get('/invoices/payments-report', [InvoiceController::class, 'paymentsReport'])->name('invoices.payments-report');
    
    // مسارات كشف حساب العملاء (يجب أن تكون قبل resource routes)
    Route::get('/invoices/customer-statement', [InvoiceController::class, 'customerStatement'])->name('invoices.customer-statement');
    Route::get('/invoices/export-customer-statement', [InvoiceController::class, 'exportCustomerStatement'])->name('invoices.export-customer-statement');
    
    // مسارات حركة الصندوق للفواتير (يجب أن تكون قبل resource routes)
    Route::get('/invoices/cash-flow-report', [InvoiceController::class, 'cashFlowReport'])->name('invoices.cash-flow-report');
    Route::get('/invoices/export-cash-flow-report', [InvoiceController::class, 'exportCashFlowReport'])->name('invoices.export-cash-flow-report');
    
    // مسارات البحث المتقدم (يجب أن تكون قبل resource routes)
    Route::get('/invoices/advanced-search', [InvoiceController::class, 'advancedSearch'])->name('invoices.advanced-search');

    // إدارة سندات القبض
    Route::resource('receipt-vouchers', ReceiptVoucherController::class);
    Route::get('/receipt-vouchers/{receiptVoucher}/print', [ReceiptVoucherController::class, 'print'])->name('receipt-vouchers.print');
    Route::get('/receipt-vouchers/export', [ReceiptVoucherController::class, 'export'])->name('receipt-vouchers.export');

    // إدارة سندات الصرف
    Route::resource('payment-vouchers', PaymentVoucherController::class);
    Route::get('/payment-vouchers/{paymentVoucher}/print', [PaymentVoucherController::class, 'print'])->name('payment-vouchers.print');
    Route::get('/payment-vouchers/export', [PaymentVoucherController::class, 'export'])->name('payment-vouchers.export');
    Route::get('/payment-vouchers/summary', [PaymentVoucherController::class, 'summary'])->name('payment-vouchers.summary');

    // مسار الحصول على آخر فاتورة (يجب أن يكون قبل resource routes)
    Route::get('/invoices/last', [InvoiceController::class, 'getLastInvoice'])->name('invoices.last');
    
    // إدارة الفواتير (Resource routes يجب أن تكون بعد المسارات المحددة)
    Route::resource('invoices', InvoiceController::class);
    
    // مسارات الفواتير الفردية (مع معرف الفاتورة)
    Route::post('/invoices/{invoice}/send-to-zatca', [InvoiceController::class, 'sendToZatca'])->name('invoices.send-to-zatca');
    Route::get('/invoices/{invoice}/pdf', [InvoiceController::class, 'downloadPdf'])->name('invoices.pdf');
    Route::get('/invoices/{invoice}/xml', [InvoiceController::class, 'downloadXml'])->name('invoices.xml');
    Route::get('/invoices/{invoice}/ubl-xml', [InvoiceController::class, 'downloadUblXml'])->name('invoices.ubl-xml');
    Route::get('/invoices/{invoice}/whatsapp', [InvoiceController::class, 'sendToWhatsApp'])->name('invoices.whatsapp');
    Route::post('/invoices/{invoice}/email', [InvoiceController::class, 'sendEmail'])->name('invoices.email');
    Route::get('/invoices/{invoice}/print', [InvoiceController::class, 'printPage'])->name('invoices.print');
    Route::get('/invoices/{invoice}/thermal-print', [InvoiceController::class, 'thermalPrintPage'])->name('invoices.thermal-print');
    Route::post('/invoices/{invoice}/generate-qr', [InvoiceController::class, 'generateQr'])->name('invoices.generate-qr');
    Route::post('/invoices/{invoice}/add-payment', [InvoiceController::class, 'addPayment'])->name('invoices.add-payment');
    Route::post('/invoices/{invoice}/sync', [InvoiceController::class, 'syncSingle'])->name('invoices.sync-single');
    Route::post('/invoices/{invoice}/send-reminder', [InvoiceController::class, 'sendSingleReminder'])->name('invoices.send-single-reminder');
    Route::post('/invoices/{invoice}/mark-high-risk', [InvoiceController::class, 'markAsHighRisk'])->name('invoices.mark-high-risk');
    Route::post('/invoices/{invoice}/link-cash-transaction', [InvoiceController::class, 'linkCashTransaction'])->name('invoices.link-cash-transaction');

    // إعدادات ZATCA مع حماية Middleware
    Route::middleware([\App\Http\Middleware\CheckZatcaAccess::class])->group(function () {
        Route::get('/zatca-dashboard', [ZatcaSettingsController::class, 'dashboard'])->name('zatca-settings.dashboard');
        
        // المسارات الخاصة يجب أن تأتي قبل resource routes
        Route::get('/zatca-settings/device-initialization', [ZatcaSettingsController::class, 'deviceInitialization'])->name('zatca-settings.device-initialization');
        Route::get('/zatca-settings/initialization-logs', [ZatcaSettingsController::class, 'initializationLogs'])->name('zatca-settings.initialization-logs');
        Route::get('/zatca-settings/initialization-logs/{log}', [ZatcaSettingsController::class, 'showInitializationLog'])->name('zatca-settings.show-initialization-log');
        Route::post('/zatca-settings/request-otp', [ZatcaSettingsController::class, 'requestOTP'])->name('zatca-settings.request-otp');
        Route::post('/zatca-settings/verify-otp', [ZatcaSettingsController::class, 'verifyOTP'])->name('zatca-settings.verify-otp');
        Route::post('/zatca-settings/test-connection', [ZatcaSettingsController::class, 'testConnection'])->name('zatca-settings.test-connection');
        
        // صفحة المساعدة لبيانات الاعتماد
        Route::get('/zatca-settings/credentials-help', function() {
            return view('zatca-settings.credentials-help');
        })->name('zatca-settings.credentials-help');
        
        // Resource routes تأتي بعد المسارات الخاصة
        Route::resource('zatca-settings', ZatcaSettingsController::class);
        
        // مسارات إضافية للـ resource
        Route::post('/zatca-settings/{zatcaSetting}/refresh-token', [ZatcaSettingsController::class, 'refreshToken'])->name('zatca-settings.refresh-token');
        Route::post('/zatca-settings/{zatcaSetting}/reset-counter', [ZatcaSettingsController::class, 'resetCounter'])->name('zatca-settings.reset-counter');
        Route::get('/zatca-settings/{zatcaSetting}/export', [ZatcaSettingsController::class, 'export'])->name('zatca-settings.export');
    });

    // مسارات تجريبية مؤقتة لاختبار ZATCA
    Route::get('/test-zatca-device-init', function() {
        return 'تعمل تهيئة الأجهزة بشكل صحيح!';
    })->name('test.zatca.device.init');

    Route::get('/zatca-device-init-direct', [\App\Http\Controllers\ZatcaSettingsController::class, 'deviceInitialization'])
        ->name('zatca.device.init.direct');

    // مسارات AJAX للفواتير
    Route::get('/api/products/{product}', [InvoiceController::class, 'getProduct'])->name('api.products.show');
    Route::get('/api/customers/search', [InvoiceController::class, 'searchCustomers'])->name('api.customers.search');
    
    // مسار اختبار XML المحسن (للتطوير فقط)
    Route::get('/invoices/{invoice}/test-xml', [InvoiceController::class, 'testImprovedXml'])->name('invoices.test-xml');

    // إدارة الموردين
    Route::resource('suppliers', SupplierController::class);
    Route::patch('/suppliers/{supplier}/toggle-status', [SupplierController::class, 'toggleStatus'])->name('suppliers.toggle-status');
    Route::get('/suppliers/export', [SupplierController::class, 'export'])->name('suppliers.export');

    // إدارة أوامر الشراء
    Route::resource('purchase-orders', PurchaseOrderController::class);
    Route::patch('/purchase-orders/{purchaseOrder}/status', [PurchaseOrderController::class, 'updateStatus'])->name('purchase-orders.update-status');

    // إدارة فواتير الشراء
    Route::resource('purchase-invoices', PurchaseInvoiceController::class);
    Route::post('/purchase-invoices/{purchaseInvoice}/approve', [PurchaseInvoiceController::class, 'approve'])->name('purchase-invoices.approve');
    Route::post('/purchase-invoices/{purchaseInvoice}/mark-received', [PurchaseInvoiceController::class, 'markAsReceived'])->name('purchase-invoices.mark-received');
    Route::post('/purchase-invoices/{purchaseInvoice}/cancel', [PurchaseInvoiceController::class, 'cancel'])->name('purchase-invoices.cancel');
    Route::post('/purchase-invoices/{purchaseInvoice}/add-payment', [PurchaseInvoiceController::class, 'addPayment'])->name('purchase-invoices.add-payment');
    Route::patch('/purchase-invoices/{purchaseInvoice}/update-status', [PurchaseInvoiceController::class, 'updateStatus'])->name('purchase-invoices.update-status');
    Route::get('/purchase-invoices/{purchaseInvoice}/print', [PurchaseInvoiceController::class, 'print'])->name('purchase-invoices.print');
    Route::get('/purchase-invoices/export', [PurchaseInvoiceController::class, 'export'])->name('purchase-invoices.export');

    // تحليلات الموردين والتقارير
    Route::prefix('suppliers/analytics')->name('suppliers.analytics.')->group(function () {
        Route::get('/dashboard', [SupplierAnalyticsController::class, 'dashboard'])->name('dashboard');
        Route::get('/performance', [SupplierAnalyticsController::class, 'performance'])->name('performance');
        Route::get('/aging-report', [SupplierAnalyticsController::class, 'agingReport'])->name('aging');
        Route::get('/comparison', [SupplierAnalyticsController::class, 'comparison'])->name('comparison');
        Route::get('/{supplier}/statement', [SupplierAnalyticsController::class, 'statement'])->name('statement');
        Route::get('/credit-monitoring', [SupplierAnalyticsController::class, 'creditMonitoring'])->name('credit-monitoring');
        Route::get('/export', [SupplierAnalyticsController::class, 'export'])->name('export');
    });

    // إدارة مدفوعات الموردين
    Route::prefix('suppliers/payments')->name('suppliers.payments.')->group(function () {
        Route::get('/', [SupplierPaymentController::class, 'index'])->name('index');
        Route::get('/create', [SupplierPaymentController::class, 'create'])->name('create');
        Route::post('/', [SupplierPaymentController::class, 'store'])->name('store');
        Route::get('/{payment}', [SupplierPaymentController::class, 'show'])->name('show');
        Route::delete('/{payment}', [SupplierPaymentController::class, 'destroy'])->name('destroy');
        Route::get('/supplier/{supplier}/report', [SupplierPaymentController::class, 'supplierPaymentReport'])->name('supplier-report');
        Route::get('/analysis/dashboard', [SupplierPaymentController::class, 'paymentAnalysis'])->name('analysis');
        Route::get('/api/supplier/{supplier}/outstanding-invoices', [SupplierPaymentController::class, 'getOutstandingInvoices'])->name('outstanding-invoices');
    });


    // إدارة مديونيات الموردين
    Route::prefix('suppliers/debt')->name('suppliers.debt.')->group(function () {
        Route::get('/dashboard', [SupplierDebtController::class, 'dashboard'])->name('dashboard');
        Route::get('/supplier/{supplier}/statement', [SupplierDebtController::class, 'supplierStatement'])->name('statement');
        Route::get('/create-schedule', [SupplierDebtController::class, 'createSchedule'])->name('create-schedule');
        Route::post('/store-schedule', [SupplierDebtController::class, 'storeSchedule'])->name('store-schedule');
        Route::post('/send-reminders', [SupplierDebtController::class, 'sendReminders'])->name('send-reminders');
        Route::post('/apply-penalties', [SupplierDebtController::class, 'applyPenalties'])->name('apply-penalties');
        Route::get('/overdue-report', [SupplierDebtController::class, 'overdueReport'])->name('overdue-report');
        Route::get('/schedule-report', [SupplierDebtController::class, 'scheduleReport'])->name('schedule-report');
        Route::get('/bad-debt-management', [SupplierDebtController::class, 'badDebtManagement'])->name('bad-debt-management');
    });

    // إدارة سير العمل للمشتريات
    Route::prefix('procurement/workflow')->name('procurement.workflow.')->group(function () {
        Route::get('/dashboard', [ProcurementWorkflowController::class, 'dashboard'])->name('dashboard');
        Route::get('/orders', [ProcurementWorkflowController::class, 'orderManagement'])->name('orders');
        Route::post('/bulk-approve-orders', [ProcurementWorkflowController::class, 'bulkApproveOrders'])->name('bulk-approve-orders');
        Route::get('/track-order/{order}', [ProcurementWorkflowController::class, 'trackOrder'])->name('track-order');
        Route::get('/supplier-performance', [ProcurementWorkflowController::class, 'supplierPerformance'])->name('supplier-performance');
        Route::get('/inventory-optimization', [ProcurementWorkflowController::class, 'inventoryOptimization'])->name('inventory-optimization');
        Route::post('/create-auto-purchase-order', [ProcurementWorkflowController::class, 'createAutoPurchaseOrder'])->name('create-auto-purchase-order');
    });

    // تقارير المشتريات الشاملة
    Route::prefix('procurement/reports')->name('procurement.reports.')->group(function () {
        Route::get('/', [ProcurementReportController::class, 'index'])->name('index');
        Route::post('/export', [ProcurementReportController::class, 'export'])->name('export');
        Route::get('/custom-export', [ProcurementReportController::class, 'customExport'])->name('custom-export');
        Route::post('/run-scheduled', [ProcurementReportController::class, 'runScheduled'])->name('run-scheduled');
    });

    // API للموردين والفواتير المعلقة
    Route::prefix('api/suppliers')->name('api.suppliers.')->group(function () {
        Route::get('/{supplier}/outstanding-invoices', [SupplierPaymentController::class, 'getOutstandingInvoices'])
            ->name('outstanding-invoices');
    });

    // إدارة استلام البضائع
    Route::resource('goods-receipts', GoodsReceiptController::class);
    Route::post('/goods-receipts/{goodsReceipt}/confirm', [GoodsReceiptController::class, 'confirm'])->name('goods-receipts.confirm');
    Route::post('/goods-receipts/{goodsReceipt}/cancel', [GoodsReceiptController::class, 'cancel'])->name('goods-receipts.cancel');

    // إدارة المخزون
    Route::prefix('inventory')->name('inventory.')->group(function () {
        Route::get('/', [InventoryController::class, 'index'])->name('index');
        Route::get('/movements', [InventoryController::class, 'movements'])->name('movements');
        Route::get('/valuation', [InventoryController::class, 'valuation'])->name('valuation');
        Route::get('/reports', [InventoryController::class, 'reports'])->name('reports');
        Route::get('/export-report', [InventoryController::class, 'exportReport'])->name('export-report');
        
        // تسويات المخزون
        Route::prefix('adjustments')->name('adjustments.')->group(function () {
            Route::get('/', [InventoryController::class, 'adjustments'])->name('index');
            Route::get('/create', [InventoryController::class, 'createAdjustment'])->name('create');
            Route::post('/', [InventoryController::class, 'storeAdjustment'])->name('store');
            Route::get('/{adjustment}', [InventoryController::class, 'showAdjustment'])->name('show');
            Route::post('/{adjustment}/approve', [InventoryController::class, 'approveAdjustment'])->name('approve');
        });
    });

    // إدارة الملفات
    Route::prefix('file-manager')->name('file-manager.')->group(function () {
        Route::get('/', [FileManagerController::class, 'index'])->name('index');
        Route::post('/upload', [FileManagerController::class, 'upload'])->name('upload');
        Route::get('/search', [FileManagerController::class, 'search'])->name('search');
        
        // الملفات
        Route::prefix('files')->name('files.')->group(function () {
            Route::get('/{file}/download', [FileManagerController::class, 'download'])->name('download');
            Route::get('/{file}/preview', [FileManagerController::class, 'preview'])->name('preview');
            Route::get('/{file}/edit', [FileManagerController::class, 'getFileData'])->name('edit');
            Route::put('/{file}', [FileManagerController::class, 'update'])->name('update');
            Route::delete('/{file}', [FileManagerController::class, 'destroy'])->name('destroy');
        });
        
        // المجلدات
        Route::prefix('folders')->name('folders.')->group(function () {
            Route::post('/', [FileManagerController::class, 'createFolder'])->name('create');
            Route::get('/list', [FileManagerController::class, 'getFoldersList'])->name('list');
            Route::get('/{folder}/edit', [FileManagerController::class, 'getFolderData'])->name('edit');
            Route::put('/{folder}', [FileManagerController::class, 'updateFolder'])->name('update');
            Route::delete('/{folder}', [FileManagerController::class, 'deleteFolder'])->name('destroy');
            Route::get('/{folder}/download', [FileManagerController::class, 'downloadFolder'])->name('download');
        });
        
        // العمليات المتقدمة
        Route::post('/move', [FileManagerController::class, 'move'])->name('move');
    });

    // النظام المحاسبي الشامل
    Route::prefix('accounting')->name('accounting.')->group(function () {
        
        // لوحة تحكم النظام المحاسبي
        Route::get('/', function () {
            return view('accounting.dashboard');
        })->name('dashboard');
        
        // دليل الحسابات - محسن
        Route::prefix('accounts')->name('accounts.')->group(function () {
            Route::get('/', [AccountController::class, 'index'])->name('index');
            Route::get('/tree', [AccountController::class, 'tree'])->name('tree');
            Route::get('/create', [AccountController::class, 'create'])->name('create');
            Route::post('/', [AccountController::class, 'store'])->name('store');
            Route::get('/{account}', [AccountController::class, 'show'])->name('show');
            Route::get('/{account}/edit', [AccountController::class, 'edit'])->name('edit');
            Route::put('/{account}', [AccountController::class, 'update'])->name('update');
            Route::delete('/{account}', [AccountController::class, 'destroy'])->name('destroy');
            Route::get('/{account}/ledger', [AccountController::class, 'ledger'])->name('ledger');
            Route::get('/{account}/statement', [AccountController::class, 'statement'])->name('statement');
            Route::get('/{account}/balance', [AccountController::class, 'balance'])->name('balance');
            Route::get('/export/excel', [AccountController::class, 'export'])->name('export');
            Route::post('/import/excel', [AccountController::class, 'import'])->name('import');
            Route::post('/{account}/activate', [AccountController::class, 'activate'])->name('activate');
            Route::post('/{account}/deactivate', [AccountController::class, 'deactivate'])->name('deactivate');
        });

        // قيود اليومية - محسن
        Route::prefix('journal-entries')->name('journal-entries.')->group(function () {
            Route::get('/', [JournalEntryController::class, 'index'])->name('index');
            Route::get('/create', [JournalEntryController::class, 'create'])->name('create');
            Route::post('/', [JournalEntryController::class, 'store'])->name('store');
            Route::get('/{journalEntry}', [JournalEntryController::class, 'show'])->name('show');
            Route::get('/{journalEntry}/edit', [JournalEntryController::class, 'edit'])->name('edit');
            Route::put('/{journalEntry}', [JournalEntryController::class, 'update'])->name('update');
            Route::delete('/{journalEntry}', [JournalEntryController::class, 'destroy'])->name('destroy');
            Route::post('/{journalEntry}/approve', [JournalEntryController::class, 'approve'])->name('approve');
            Route::post('/{journalEntry}/reject', [JournalEntryController::class, 'reject'])->name('reject');
            Route::post('/{journalEntry}/reverse', [JournalEntryController::class, 'reverse'])->name('reverse');
            Route::get('/{journalEntry}/duplicate', [JournalEntryController::class, 'duplicate'])->name('duplicate');
            Route::get('/{journalEntry}/print', [JournalEntryController::class, 'print'])->name('print');
            Route::post('/bulk/approve', [JournalEntryController::class, 'bulkApprove'])->name('bulk.approve');
            Route::post('/bulk/delete', [JournalEntryController::class, 'bulkDelete'])->name('bulk.delete');
        });

        // الحركات النقدية - محسن
        Route::prefix('cash-transactions')->name('cash-transactions.')->group(function () {
            Route::get('/', [CashTransactionController::class, 'index'])->name('index');
            Route::get('/create', [CashTransactionController::class, 'create'])->name('create');
            Route::post('/', [CashTransactionController::class, 'store'])->name('store');
            Route::get('/{cashTransaction}', [CashTransactionController::class, 'show'])->name('show');
            Route::get('/{cashTransaction}/edit', [CashTransactionController::class, 'edit'])->name('edit');
            Route::put('/{cashTransaction}', [CashTransactionController::class, 'update'])->name('update');
            Route::delete('/{cashTransaction}', [CashTransactionController::class, 'destroy'])->name('destroy');
            Route::post('/{cashTransaction}/approve', [CashTransactionController::class, 'approve'])->name('approve');
            Route::get('/{cashTransaction}/print', [CashTransactionController::class, 'print'])->name('print');
            Route::get('/reports/cash-book', [CashTransactionController::class, 'cashBook'])->name('cash-book');
            Route::get('/reports/summary', [CashTransactionController::class, 'summary'])->name('reports.summary');
        });

        // السنوات المالية - جديد
        Route::prefix('fiscal-years')->name('fiscal-years.')->group(function () {
            Route::get('/', [FiscalYearController::class, 'index'])->name('index');
            Route::get('/create', [FiscalYearController::class, 'create'])->name('create');
            Route::post('/', [FiscalYearController::class, 'store'])->name('store');
            Route::get('/{fiscalYear}', [FiscalYearController::class, 'show'])->name('show');
            Route::get('/{fiscalYear}/edit', [FiscalYearController::class, 'edit'])->name('edit');
            Route::put('/{fiscalYear}', [FiscalYearController::class, 'update'])->name('update');
            Route::delete('/{fiscalYear}', [FiscalYearController::class, 'destroy'])->name('destroy');
            Route::post('/{fiscalYear}/close', [FiscalYearController::class, 'close'])->name('close');
            Route::post('/{fiscalYear}/reopen', [FiscalYearController::class, 'reopen'])->name('reopen');
            Route::post('/{fiscalYear}/set-current', [FiscalYearController::class, 'setCurrent'])->name('set-current');
            Route::get('/{fiscalYear}/closing-report', [FiscalYearController::class, 'closingReport'])->name('closing-report');
        });

        // الميزانيات - جديد
        Route::prefix('budgets')->name('budgets.')->group(function () {
            Route::get('/', [BudgetController::class, 'index'])->name('index');
            Route::get('/create', [BudgetController::class, 'create'])->name('create');
            Route::post('/', [BudgetController::class, 'store'])->name('store');
            Route::get('/{budget}', [BudgetController::class, 'show'])->name('show');
            Route::get('/{budget}/edit', [BudgetController::class, 'edit'])->name('edit');
            Route::put('/{budget}', [BudgetController::class, 'update'])->name('update');
            Route::delete('/{budget}', [BudgetController::class, 'destroy'])->name('destroy');
            Route::post('/{budget}/approve', [BudgetController::class, 'approve'])->name('approve');
            Route::post('/{budget}/activate', [BudgetController::class, 'activate'])->name('activate');
            Route::post('/{budget}/close', [BudgetController::class, 'close'])->name('close');
            Route::get('/reports/comparison', [BudgetController::class, 'comparison'])->name('comparison');
            Route::get('/alerts/dashboard', [BudgetController::class, 'alerts'])->name('alerts');
            Route::post('/calculate-actual', [BudgetController::class, 'calculateActual'])->name('calculate-actual');
        });

        // سجل المراجعة - جديد
        Route::prefix('audit-logs')->name('audit-logs.')->group(function () {
            Route::get('/', [AuditLogController::class, 'index'])->name('index');
            Route::get('/{auditLog}', [AuditLogController::class, 'show'])->name('show');
            Route::get('/dashboard/overview', [AuditLogController::class, 'dashboard'])->name('dashboard');
            Route::get('/trail/model', [AuditLogController::class, 'trail'])->name('trail');
            Route::get('/security/incidents', [AuditLogController::class, 'security'])->name('security');
            Route::get('/compliance/report', [AuditLogController::class, 'compliance'])->name('compliance');
            Route::post('/export', [AuditLogController::class, 'export'])->name('export');
            Route::post('/cleanup', [AuditLogController::class, 'cleanup'])->name('cleanup');
        });

        // إعدادات النظام المحاسبي - جديد
        Route::prefix('settings')->name('settings.')->group(function () {
            Route::get('/', [AccountingSettingController::class, 'index'])->name('index');
            Route::get('/create', [AccountingSettingController::class, 'create'])->name('create');
            Route::post('/', [AccountingSettingController::class, 'store'])->name('store');
            Route::get('/{accountingSetting}', [AccountingSettingController::class, 'show'])->name('show');
            Route::get('/{accountingSetting}/edit', [AccountingSettingController::class, 'edit'])->name('edit');
            Route::put('/{accountingSetting}', [AccountingSettingController::class, 'update'])->name('update');
            Route::delete('/{accountingSetting}', [AccountingSettingController::class, 'destroy'])->name('destroy');
            Route::patch('/{accountingSetting}/update-value', [AccountingSettingController::class, 'updateValue'])->name('update-value');
            Route::post('/bulk-update', [AccountingSettingController::class, 'bulkUpdate'])->name('bulk-update');
            Route::post('/{accountingSetting}/reset', [AccountingSettingController::class, 'reset'])->name('reset');
            Route::post('/load-defaults', [AccountingSettingController::class, 'loadDefaults'])->name('load-defaults');
            Route::post('/clear-cache', [AccountingSettingController::class, 'clearCache'])->name('clear-cache');
            Route::post('/export', [AccountingSettingController::class, 'export'])->name('export');
            Route::post('/import', [AccountingSettingController::class, 'import'])->name('import');
        });

        // التقارير المحفوظة - جديد
        Route::prefix('saved-reports')->name('saved-reports.')->group(function () {
            Route::get('/', [SavedReportController::class, 'index'])->name('index');
            Route::get('/create', [SavedReportController::class, 'create'])->name('create');
            Route::post('/', [SavedReportController::class, 'store'])->name('store');
            Route::get('/{savedReport}', [SavedReportController::class, 'show'])->name('show');
            Route::get('/{savedReport}/edit', [SavedReportController::class, 'edit'])->name('edit');
            Route::put('/{savedReport}', [SavedReportController::class, 'update'])->name('update');
            Route::delete('/{savedReport}', [SavedReportController::class, 'destroy'])->name('destroy');
            Route::post('/{savedReport}/generate', [SavedReportController::class, 'generate'])->name('generate');
            Route::get('/{savedReport}/download', [SavedReportController::class, 'download'])->name('download');
            Route::post('/{savedReport}/toggle-active', [SavedReportController::class, 'toggleActive'])->name('toggle-active');
            Route::post('/{savedReport}/duplicate', [SavedReportController::class, 'duplicate'])->name('duplicate');
            Route::get('/scheduled/dashboard', [SavedReportController::class, 'scheduled'])->name('scheduled');
            Route::post('/generate-due', [SavedReportController::class, 'generateDue'])->name('generate-due');
            Route::post('/cleanup', [SavedReportController::class, 'cleanup'])->name('cleanup');
        });

        // التقارير المالية - محسن
        Route::prefix('reports')->name('reports.')->group(function () {
            Route::get('/', [FinancialReportController::class, 'index'])->name('index');
            Route::get('/trial-balance', [FinancialReportController::class, 'trialBalance'])->name('trial-balance');
            Route::get('/balance-sheet', [FinancialReportController::class, 'balanceSheet'])->name('balance-sheet');
            Route::get('/income-statement', [FinancialReportController::class, 'incomeStatement'])->name('income-statement');
            Route::get('/general-ledger', [FinancialReportController::class, 'generalLedger'])->name('general-ledger');
            Route::get('/cash-flow', [FinancialReportController::class, 'cashFlow'])->name('cash-flow');
            Route::get('/aging-report', [FinancialReportController::class, 'agingReport'])->name('aging-report');
            Route::get('/financial-ratios', [FinancialReportController::class, 'financialRatios'])->name('financial-ratios');
            Route::get('/cost-center-analysis', [FinancialReportController::class, 'costCenterAnalysis'])->name('cost-center-analysis');
            Route::get('/budget-variance', [FinancialReportController::class, 'budgetVariance'])->name('budget-variance');
            
            // تصدير التقارير
            Route::post('/export/{reportType}', [FinancialReportController::class, 'export'])->name('export');
            Route::post('/email/{reportType}', [FinancialReportController::class, 'email'])->name('email');
            Route::get('/export/trial-balance', [FinancialReportController::class, 'exportTrialBalance'])->name('export.trial-balance');
            Route::get('/export/balance-sheet', [FinancialReportController::class, 'exportBalanceSheet'])->name('export.balance-sheet');
            Route::get('/export/income-statement', [FinancialReportController::class, 'exportIncomeStatement'])->name('export.income-statement');
            Route::get('/export/cash-flow', [FinancialReportController::class, 'exportCashFlow'])->name('export.cash-flow');
            Route::get('/export/general-ledger', [FinancialReportController::class, 'exportGeneralLedger'])->name('export.general-ledger');
        });

        // الحسابات البنكية
        Route::prefix('bank-accounts')->name('bank-accounts.')->group(function () {
            Route::get('/', [BankAccountController::class, 'index'])->name('index');
            Route::get('/create', [BankAccountController::class, 'create'])->name('create');
            Route::post('/', [BankAccountController::class, 'store'])->name('store');
            Route::get('/{bankAccount}', [BankAccountController::class, 'show'])->name('show');
            Route::get('/{bankAccount}/edit', [BankAccountController::class, 'edit'])->name('edit');
            Route::put('/{bankAccount}', [BankAccountController::class, 'update'])->name('update');
            Route::delete('/{bankAccount}', [BankAccountController::class, 'destroy'])->name('destroy');
            Route::patch('/{bankAccount}/toggle-status', [BankAccountController::class, 'toggleStatus'])->name('toggle-status');
            Route::get('/{bankAccount}/statement', [BankAccountController::class, 'statement'])->name('statement');
        });

        // الحركات البنكية
        Route::prefix('bank-transactions')->name('bank-transactions.')->group(function () {
            Route::get('/', [BankTransactionController::class, 'index'])->name('index');
            Route::get('/create', [BankTransactionController::class, 'create'])->name('create');
            Route::post('/', [BankTransactionController::class, 'store'])->name('store');
            Route::get('/{bankTransaction}', [BankTransactionController::class, 'show'])->name('show');
            Route::get('/{bankTransaction}/edit', [BankTransactionController::class, 'edit'])->name('edit');
            Route::put('/{bankTransaction}', [BankTransactionController::class, 'update'])->name('update');
            Route::delete('/{bankTransaction}', [BankTransactionController::class, 'destroy'])->name('destroy');
            Route::post('/{bankTransaction}/clear', [BankTransactionController::class, 'clear'])->name('clear');
            Route::post('/{bankTransaction}/cancel', [BankTransactionController::class, 'cancel'])->name('cancel');
        });

        // مراكز التكلفة
        Route::prefix('cost-centers')->name('cost-centers.')->group(function () {
            Route::get('/', [CostCenterController::class, 'index'])->name('index');
            Route::get('/create', [CostCenterController::class, 'create'])->name('create');
            Route::post('/', [CostCenterController::class, 'store'])->name('store');
            Route::get('/{costCenter}', [CostCenterController::class, 'show'])->name('show');
            Route::get('/{costCenter}/edit', [CostCenterController::class, 'edit'])->name('edit');
            Route::put('/{costCenter}', [CostCenterController::class, 'update'])->name('update');
            Route::delete('/{costCenter}', [CostCenterController::class, 'destroy'])->name('destroy');
            Route::patch('/{costCenter}/toggle-status', [CostCenterController::class, 'toggleStatus'])->name('toggle-status');
            Route::get('/performance', [CostCenterController::class, 'performance'])->name('performance');
            Route::get('/{costCenter}/budget-analysis', [CostCenterController::class, 'budgetAnalysis'])->name('budget-analysis');
        });

        // مسارات API للنظام المحاسبي
        Route::prefix('api')->name('api.')->group(function () {
            Route::get('/accounts/search', function () {
                $query = request('q');
                $accounts = \App\Models\Account::where('is_active', true)
                    ->where(function ($q) use ($query) {
                        $q->where('name', 'like', "%{$query}%")
                          ->orWhere('code', 'like', "%{$query}%");
                    })
                    ->limit(20)
                    ->get(['id', 'code', 'name', 'type']);
                
                return response()->json($accounts);
            })->name('accounts.search');

            Route::get('/cost-centers/search', function () {
                $query = request('q');
                $costCenters = \App\Models\CostCenter::where('is_active', true)
                    ->where(function ($q) use ($query) {
                        $q->where('name', 'like', "%{$query}%")
                          ->orWhere('code', 'like', "%{$query}%");
                    })
                    ->limit(20)
                    ->get(['id', 'code', 'name']);
                
                return response()->json($costCenters);
            })->name('cost-centers.search');

            Route::get('/account/{account}/balance', function (\App\Models\Account $account) {
                return response()->json([
                    'current_balance' => $account->current_balance,
                    'formatted_balance' => number_format($account->current_balance, 2),
                    'balance_nature' => $account->balance_nature,
                ]);
            })->name('account.balance');

            Route::get('/fiscal-year/current', function () {
                $fiscalYear = \App\Models\FiscalYear::current()->first();
                return response()->json($fiscalYear);
            })->name('fiscal-year.current');

            Route::get('/stats/dashboard', function () {
                return response()->json([
                    'total_accounts' => \App\Models\Account::count(),
                    'active_accounts' => \App\Models\Account::where('is_active', true)->count(),
                    'total_journal_entries' => \App\Models\JournalEntry::count(),
                    'pending_approval' => \App\Models\JournalEntry::where('is_approved', false)->count(),
                    'total_budgets' => \App\Models\Budget::count(),
                    'over_budget' => \App\Models\Budget::overWarningThreshold()->count(),
                ]);
            })->name('stats.dashboard');
        });

        // العمليات المتقدمة
        Route::prefix('advanced')->name('advanced.')->group(function () {
            Route::get('/balances', function () {
                return view('accounting.advanced.balances');
            })->name('balances');

            Route::post('/balances/calculate', function () {
                $fiscalYearId = request('fiscal_year_id');
                $calculated = \App\Models\AccountBalance::calculateAllBalances($fiscalYearId);
                return back()->with('success', "تم حساب {$calculated} رصيد");
            })->name('balances.calculate');

            Route::get('/maintenance', function () {
                return view('accounting.advanced.maintenance');
            })->name('maintenance');

            Route::post('/maintenance/run', function () {
                \Artisan::call('accounting:maintenance', ['operation' => 'all']);
                return back()->with('success', 'تم تشغيل عمليات الصيانة بنجاح');
            })->name('maintenance.run');

            Route::post('/backup', function () {
                \Artisan::call('accounting:backup');
                return back()->with('success', 'تم إنشاء نسخة احتياطية');
            })->name('backup');

            Route::post('/update-balances', function () {
                \Artisan::call('accounting:update-balances');
                return back()->with('success', 'تم تحديث جميع الأرصدة');
            })->name('update-balances');
        });
    });

    // نظام التقارير الشامل - System Reports
    Route::prefix('system-reports')->name('system-reports.')->group(function () {
        
        // تقارير المبيعات - Sales Reports
        Route::prefix('sales')->name('sales.')->group(function () {
            Route::get('/', [App\Http\Controllers\SalesReportController::class, 'index'])->name('index');
            Route::get('/summary', [App\Http\Controllers\SalesReportController::class, 'summary'])->name('summary');
            Route::get('/by-customer', [App\Http\Controllers\SalesReportController::class, 'byCustomer'])->name('by-customer');
            Route::get('/by-product', [App\Http\Controllers\SalesReportController::class, 'byProduct'])->name('by-product');
            Route::get('/daily', [App\Http\Controllers\SalesReportController::class, 'daily'])->name('daily');
            Route::post('/export', [App\Http\Controllers\SalesReportController::class, 'export'])->name('export');
        });

        // تقارير المشتريات - Purchase Reports
        Route::prefix('purchase')->name('purchase.')->group(function () {
            Route::get('/', [App\Http\Controllers\PurchaseReportController::class, 'index'])->name('index');
            Route::get('/summary', [App\Http\Controllers\PurchaseReportController::class, 'summary'])->name('summary');
            Route::get('/by-supplier', [App\Http\Controllers\PurchaseReportController::class, 'bySupplier'])->name('by-supplier');
            Route::get('/orders', [App\Http\Controllers\PurchaseReportController::class, 'orders'])->name('orders');
            Route::get('/performance', [App\Http\Controllers\PurchaseReportController::class, 'performance'])->name('performance');
            Route::get('/trends', [App\Http\Controllers\PurchaseReportController::class, 'trends'])->name('trends');
            Route::post('/export', [App\Http\Controllers\PurchaseReportController::class, 'export'])->name('export');
        });

        // تقارير المنتجات - Product Reports
        Route::prefix('product')->name('product.')->group(function () {
            Route::get('/', [App\Http\Controllers\ProductReportController::class, 'index'])->name('index');
            Route::get('/performance', [App\Http\Controllers\ProductReportController::class, 'performance'])->name('performance');
            Route::get('/inventory', [App\Http\Controllers\ProductReportController::class, 'inventory'])->name('inventory');
            Route::get('/movements', [App\Http\Controllers\ProductReportController::class, 'movements'])->name('movements');
            Route::get('/profitability', [App\Http\Controllers\ProductReportController::class, 'profitability'])->name('profitability');
            Route::get('/category-analysis', [App\Http\Controllers\ProductReportController::class, 'categoryAnalysis'])->name('category-analysis');
            Route::get('/top-selling', [App\Http\Controllers\ProductReportController::class, 'topSelling'])->name('top-selling');
            Route::post('/export', [App\Http\Controllers\ProductReportController::class, 'export'])->name('export');
        });

        // تقارير العملاء - Customer Reports
        Route::prefix('customer')->name('customer.')->group(function () {
            Route::get('/', [App\Http\Controllers\CustomerReportController::class, 'index'])->name('index');
            Route::get('/summary', [App\Http\Controllers\CustomerReportController::class, 'summary'])->name('summary');
            Route::get('/activity', [App\Http\Controllers\CustomerReportController::class, 'activity'])->name('activity');
            Route::get('/segmentation', [App\Http\Controllers\CustomerReportController::class, 'segmentation'])->name('segmentation');
            Route::get('/lifetime-value', [App\Http\Controllers\CustomerReportController::class, 'lifetimeValue'])->name('lifetime-value');
            Route::get('/retention', [App\Http\Controllers\CustomerReportController::class, 'retention'])->name('retention');
            Route::post('/export', [App\Http\Controllers\CustomerReportController::class, 'export'])->name('export');
        });

        // تقارير الموردين - Supplier Reports
        Route::prefix('supplier')->name('supplier.')->group(function () {
            Route::get('/', [App\Http\Controllers\SupplierReportController::class, 'index'])->name('index');
            Route::get('/summary', [App\Http\Controllers\SupplierReportController::class, 'summary'])->name('summary');
            Route::get('/performance', [App\Http\Controllers\SupplierReportController::class, 'performance'])->name('performance');
            Route::get('/payment-analysis', [App\Http\Controllers\SupplierReportController::class, 'paymentAnalysis'])->name('payment-analysis');
            Route::get('/quality', [App\Http\Controllers\SupplierReportController::class, 'quality'])->name('quality');
            Route::get('/comparison', [App\Http\Controllers\SupplierReportController::class, 'comparison'])->name('comparison');
            Route::get('/geographic', [App\Http\Controllers\SupplierReportController::class, 'geographic'])->name('geographic');
            Route::get('/aging', [App\Http\Controllers\SupplierReportController::class, 'aging'])->name('aging');
            Route::post('/export', [App\Http\Controllers\SupplierReportController::class, 'export'])->name('export');
        });

        // الإقرارات الضريبية - Tax Reports
        Route::prefix('tax')->name('tax.')->group(function () {
            Route::get('/', [App\Http\Controllers\TaxReportController::class, 'index'])->name('index');
            Route::get('/vat-summary', [App\Http\Controllers\TaxReportController::class, 'vatSummary'])->name('vat-summary');
            Route::get('/vat-return', [App\Http\Controllers\TaxReportController::class, 'vatReturn'])->name('vat-return');
            Route::get('/transactions', [App\Http\Controllers\TaxReportController::class, 'transactions'])->name('transactions');
            Route::get('/by-customer', [App\Http\Controllers\TaxReportController::class, 'byCustomer'])->name('by-customer');
            Route::get('/audit-trail', [App\Http\Controllers\TaxReportController::class, 'auditTrail'])->name('audit-trail');
            Route::post('/export', [App\Http\Controllers\TaxReportController::class, 'export'])->name('export');
        });
    });

    // تقارير المطعم - Restaurant Reports
    Route::prefix('restaurant')->name('restaurant.')->group(function () {
        Route::prefix('reports')->name('reports.')->group(function () {
            Route::get('/', [RestaurantReportsController::class, 'index'])->name('index');
            Route::get('/export', [RestaurantReportsController::class, 'export'])->name('export');
            Route::get('/api/chart-data', [RestaurantReportsController::class, 'getChartData'])->name('chart-data');
        });
    });
});

// تضمين مسارات النظام المحاسبي المنفصلة
require __DIR__.'/accounting.php';

// تضمين مسارات التصحيح (للتطوير فقط)
if (app()->environment(['local', 'testing'])) {
    require __DIR__.'/debug.php';
}
