<?php

use Illuminate\Support\Facades\Route;
use App\Imports\ProductsImport;
use Maatwebsite\Excel\Facades\Excel;

// Debug route for testing product import
Route::get('/debug/test-product-import', function () {
    try {
        // Create a simple test file path
        $testFile = base_path('test_products_import.csv');
        
        if (!file_exists($testFile)) {
            return response()->json([
                'error' => 'ملف الاختبار غير موجود',
                'file_path' => $testFile
            ]);
        }
        
        $import = new ProductsImport();
        
        Excel::import($import, $testFile);
        
        return response()->json([
            'success' => true,
            'imported' => $import->getImportedCount(),
            'skipped' => $import->getSkippedCount(),
            'errors' => $import->errors(),
            'failures' => $import->failures(),
            'message' => 'تم اختبار الاستيراد بنجاح'
        ]);
        
    } catch (\Exception $e) {
        return response()->json([
            'error' => 'خطأ في الاختبار: ' . $e->getMessage(),
            'file' => $e->getFile(),
            'line' => $e->getLine(),
            'trace' => $e->getTraceAsString()
        ], 500);
    }
})->middleware('auth');

// Debug page for import troubleshooting
Route::get('/debug/import-page', function () {
    return view('products.debug-import');
})->middleware('auth');