@extends('layouts.app')

@section('title', 'إعدادات ZATCA - ' . $zatcaSetting->company->name)
@section('page-title')
    <div class="d-flex align-items-center">
        <div class="page-title-icon me-3">
            <i class="fas fa-shield-alt"></i>
        </div>
        <div>
            <h1 class="h2 mb-1">تفاصيل إعدادات ZATCA</h1>
            <small class="text-muted">{{ $zatcaSetting->company->name }}</small>
        </div>
    </div>
@endsection

@push('styles')
<style>
    .page-title-icon {
        width: 60px;
        height: 60px;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border-radius: 15px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 1.5rem;
        box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
    }
    
    .status-card {
        position: relative;
        overflow: hidden;
        transition: all 0.3s ease;
        border: none;
        border-radius: 15px;
    }
    
    .status-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 4px;
        background: linear-gradient(90deg, #667eea, #764ba2);
        z-index: 1;
    }
    
    .status-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 25px rgba(0,0,0,0.15);
    }
    
    .info-card {
        background: white;
        border-radius: 15px;
        padding: 25px;
        margin-bottom: 25px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        border: none;
        position: relative;
        overflow: hidden;
        transition: all 0.3s ease;
    }
    
    .info-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 3px;
        background: linear-gradient(90deg, #3498db, #2980b9);
    }
    
    .info-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 8px 30px rgba(0,0,0,0.12);
    }
    
    .info-card-header {
        display: flex;
        align-items: center;
        margin-bottom: 20px;
        padding-bottom: 15px;
        border-bottom: 2px solid #f8f9fa;
    }
    
    .info-card-icon {
        width: 50px;
        height: 50px;
        background: linear-gradient(135deg, #3498db, #2980b9);
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 1.2rem;
        margin-left: 15px;
        box-shadow: 0 4px 15px rgba(52, 152, 219, 0.3);
    }
    
    .info-card-title {
        font-size: 1.3rem;
        font-weight: 600;
        color: #2c3e50;
        margin: 0;
    }
    
    .info-item {
        margin-bottom: 20px;
        padding: 15px;
        background: #f8f9fa;
        border-radius: 10px;
        border-left: 4px solid #3498db;
        transition: all 0.3s ease;
    }
    
    .info-item:hover {
        background: #e9ecef;
        transform: translateX(5px);
    }
    
    .info-label {
        font-weight: 600;
        color: #555;
        font-size: 0.9rem;
        margin-bottom: 5px;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    .info-value {
        font-size: 1.1rem;
        color: #2c3e50;
        margin: 0;
    }
    
    .stats-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
        gap: 20px;
        margin-bottom: 30px;
    }
    
    .stat-card {
        background: white;
        border-radius: 15px;
        padding: 25px;
        text-align: center;
        box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        border: none;
        position: relative;
        overflow: hidden;
        transition: all 0.3s ease;
    }
    
    .stat-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 3px;
        background: var(--stat-color, #3498db);
    }
    
    .stat-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 25px rgba(0,0,0,0.15);
    }
    
    .stat-number {
        font-size: 2.5rem;
        font-weight: 700;
        margin-bottom: 5px;
        background: linear-gradient(135deg, var(--stat-color, #3498db), var(--stat-color-dark, #2980b9));
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
    }
    
    .stat-label {
        color: #666;
        font-size: 0.9rem;
        font-weight: 500;
    }
    
    .status-badge {
        padding: 8px 16px;
        border-radius: 25px;
        font-size: 0.9rem;
        font-weight: 600;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        transition: all 0.3s ease;
    }
    
    .status-badge:hover {
        transform: scale(1.05);
    }
    
    .status-badge.success {
        background: linear-gradient(135deg, #27ae60, #2ecc71);
        color: white;
    }
    
    .status-badge.warning {
        background: linear-gradient(135deg, #f39c12, #e67e22);
        color: white;
    }
    
    .status-badge.danger {
        background: linear-gradient(135deg, #e74c3c, #c0392b);
        color: white;
    }
    
    .status-badge.info {
        background: linear-gradient(135deg, #3498db, #2980b9);
        color: white;
    }
    
    .status-badge.secondary {
        background: linear-gradient(135deg, #95a5a6, #7f8c8d);
        color: white;
    }
    
    .action-buttons {
        position: sticky;
        top: 20px;
        z-index: 100;
        background: white;
        padding: 20px;
        border-radius: 15px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        margin-bottom: 25px;
    }
    
    .btn-modern {
        border-radius: 10px;
        padding: 12px 20px;
        font-weight: 600;
        border: none;
        transition: all 0.3s ease;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        margin: 0 5px;
    }
    
    .btn-modern:hover {
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(0,0,0,0.2);
    }
    
    .btn-modern.btn-primary {
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
    }
    
    .btn-modern.btn-success {
        background: linear-gradient(135deg, #27ae60, #2ecc71);
        color: white;
    }
    
    .btn-modern.btn-warning {
        background: linear-gradient(135deg, #f39c12, #e67e22);
        color: white;
    }
    
    .btn-modern.btn-secondary {
        background: linear-gradient(135deg, #95a5a6, #7f8c8d);
        color: white;
    }
    
    .connection-indicator {
        width: 12px;
        height: 12px;
        border-radius: 50%;
        display: inline-block;
        margin-left: 8px;
        animation: pulse 2s infinite;
    }
    
    .connection-indicator.connected {
        background: #27ae60;
        box-shadow: 0 0 10px rgba(39, 174, 96, 0.5);
    }
    
    .connection-indicator.disconnected {
        background: #e74c3c;
        box-shadow: 0 0 10px rgba(231, 76, 60, 0.5);
    }
    
    @keyframes pulse {
        0% { transform: scale(1); opacity: 1; }
        50% { transform: scale(1.1); opacity: 0.7; }
        100% { transform: scale(1); opacity: 1; }
    }
    
    .certificate-status {
        display: flex;
        align-items: center;
        padding: 15px;
        background: white;
        border-radius: 10px;
        margin-bottom: 15px;
        border-left: 4px solid var(--cert-color, #3498db);
        box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        transition: all 0.3s ease;
    }
    
    .certificate-status:hover {
        transform: translateX(5px);
        box-shadow: 0 4px 15px rgba(0,0,0,0.1);
    }
    
    .cert-icon {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        background: var(--cert-color, #3498db);
        color: white;
        margin-left: 15px;
        font-size: 1.1rem;
    }
    
    .dropdown-menu-modern {
        border: none;
        border-radius: 15px;
        box-shadow: 0 8px 30px rgba(0,0,0,0.15);
        padding: 10px 0;
        margin-top: 10px;
    }
    
    .dropdown-item-modern {
        padding: 12px 20px;
        border-radius: 8px;
        margin: 2px 10px;
        transition: all 0.3s ease;
        display: flex;
        align-items: center;
        gap: 10px;
    }
    
    .dropdown-item-modern:hover {
        background: linear-gradient(135deg, #f8f9fa, #e9ecef);
        transform: translateX(5px);
    }
    
    .loading-overlay {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0,0,0,0.5);
        display: none;
        align-items: center;
        justify-content: center;
        z-index: 9999;
    }
    
    .loading-spinner {
        background: white;
        padding: 30px;
        border-radius: 15px;
        text-align: center;
        box-shadow: 0 10px 30px rgba(0,0,0,0.3);
    }
    
    .spinner {
        width: 50px;
        height: 50px;
        border: 4px solid #f3f3f3;
        border-top: 4px solid #3498db;
        border-radius: 50%;
        animation: spin 1s linear infinite;
        margin: 0 auto 15px;
    }
    
    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
</style>
@endpush

@section('page-actions')
<div class="action-buttons">
    <div class="d-flex flex-wrap gap-2 justify-content-end">
        <a href="{{ route('zatca-settings.edit', $zatcaSetting) }}" class="btn btn-modern btn-warning">
            <i class="fas fa-edit"></i>
            تعديل الإعدادات
        </a>
        
        @if($zatcaSetting->is_active)
            <button type="button" class="btn btn-modern btn-success" onclick="testConnection()">
                <i class="fas fa-plug"></i>
                اختبار الاتصال
            </button>
        @endif
        
        <a href="{{ route('zatca-settings.index') }}" class="btn btn-modern btn-secondary">
            <i class="fas fa-arrow-left"></i>
            العودة للقائمة
        </a>
        
        <div class="dropdown">
            <button type="button" class="btn btn-modern btn-primary dropdown-toggle" data-bs-toggle="dropdown">
                <i class="fas fa-ellipsis-v"></i>
                المزيد
            </button>
            <ul class="dropdown-menu dropdown-menu-modern">
                @if($zatcaSetting->access_token && $zatcaSetting->token_expires_at && $zatcaSetting->token_expires_at->isPast())
                    <li>
                        <form method="POST" action="{{ route('zatca-settings.refresh-token', $zatcaSetting) }}" style="display: inline;" class="w-100">
                            @csrf
                            <button type="submit" class="dropdown-item dropdown-item-modern">
                                <i class="fas fa-sync text-success"></i>
                                تجديد الرمز المميز
                            </button>
                        </form>
                    </li>
                @endif
                <li>
                    <form method="POST" action="{{ route('zatca-settings.reset-counter', $zatcaSetting) }}" style="display: inline;" class="w-100">
                        @csrf
                        <button type="submit" class="dropdown-item dropdown-item-modern"
                                onclick="return confirm('هل تريد إعادة تعيين عداد الفواتير؟')">
                            <i class="fas fa-undo text-warning"></i>
                            إعادة تعيين العداد
                        </button>
                    </form>
                </li>
                <li>
                    <a class="dropdown-item dropdown-item-modern" href="{{ route('zatca-settings.export', $zatcaSetting) }}">
                        <i class="fas fa-download text-info"></i>
                        تصدير الإعدادات
                    </a>
                </li>
                <li><hr class="dropdown-divider"></li>
                <li>
                    <form method="POST" action="{{ route('zatca-settings.destroy', $zatcaSetting) }}" style="display: inline;" class="w-100">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="dropdown-item dropdown-item-modern text-danger"
                                onclick="return confirm('هل تريد حذف هذه الإعدادات؟')">
                            <i class="fas fa-trash text-danger"></i>
                            حذف الإعدادات
                        </button>
                    </form>
                </li>
            </ul>
        </div>
    </div>
</div>
@endsection

@section('content')
<!-- Loading Overlay -->
<div class="loading-overlay" id="loadingOverlay">
    <div class="loading-spinner">
        <div class="spinner"></div>
        <p class="mb-0">جاري اختبار الاتصال...</p>
    </div>
</div>

<div class="row">
    <!-- الشريط الجانبي - إحصائيات سريعة -->
    <div class="col-lg-4 order-lg-2">
        <!-- إحصائيات الاستخدام -->
        <div class="stats-grid">
            <div class="stat-card" style="--stat-color: #3498db; --stat-color-dark: #2980b9;">
                <div class="stat-number">{{ number_format($zatcaSetting->invoice_counter) }}</div>
                <div class="stat-label">عداد الفواتير</div>
            </div>
            
            <div class="stat-card" style="--stat-color: #27ae60; --stat-color-dark: #2ecc71;">
                <div class="stat-number">{{ $zatcaSetting->company->invoices->where('zatca_status', 'sent')->count() }}</div>
                <div class="stat-label">فواتير مُرسلة</div>
            </div>
            
            <div class="stat-card" style="--stat-color: #f39c12; --stat-color-dark: #e67e22;">
                <div class="stat-number">{{ $zatcaSetting->company->invoices->where('zatca_status', 'pending')->count() }}</div>
                <div class="stat-label">في الانتظار</div>
            </div>
            
            <div class="stat-card" style="--stat-color: #e74c3c; --stat-color-dark: #c0392b;">
                <div class="stat-number">{{ $zatcaSetting->company->invoices->where('zatca_status', 'failed')->count() }}</div>
                <div class="stat-label">فشل الإرسال</div>
            </div>
        </div>
        
        <!-- حالة النظام -->
        <div class="info-card">
            <div class="info-card-header">
                <div class="info-card-icon">
                    <i class="fas fa-heartbeat"></i>
                </div>
                <h3 class="info-card-title">حالة النظام</h3>
            </div>
            
            <div class="certificate-status" style="--cert-color: {{ $zatcaSetting->is_active ? '#27ae60' : '#95a5a6' }};">
                <div class="cert-icon">
                    <i class="fas fa-{{ $zatcaSetting->is_active ? 'check' : 'pause' }}"></i>
                </div>
                <div>
                    <div class="fw-bold">الإعدادات</div>
                    <small class="text-muted">{{ $zatcaSetting->is_active ? 'نشط' : 'غير نشط' }}</small>
                </div>
            </div>
            
            <div class="certificate-status" style="--cert-color: {{ ($zatcaSetting->client_id && $zatcaSetting->client_secret) ? '#27ae60' : '#f39c12' }};">
                <div class="cert-icon">
                    <i class="fas fa-{{ ($zatcaSetting->client_id && $zatcaSetting->client_secret) ? 'check' : 'exclamation-triangle' }}"></i>
                </div>
                <div>
                    <div class="fw-bold">بيانات الاعتماد</div>
                    <small class="text-muted">{{ ($zatcaSetting->client_id && $zatcaSetting->client_secret) ? 'مكتملة' : 'ناقصة' }}</small>
                </div>
            </div>
            
            <div class="certificate-status" style="--cert-color: {{ ($zatcaSetting->certificate_content && $zatcaSetting->private_key_content && (!$zatcaSetting->certificate_expires_at || !$zatcaSetting->certificate_expires_at->isPast())) ? '#27ae60' : ($zatcaSetting->certificate_expires_at && $zatcaSetting->certificate_expires_at->isPast() ? '#e74c3c' : '#f39c12') }};">
                <div class="cert-icon">
                    <i class="fas fa-certificate"></i>
                </div>
                <div>
                    <div class="fw-bold">الشهادة الرقمية</div>
                    <small class="text-muted">
                        @if($zatcaSetting->certificate_content && $zatcaSetting->private_key_content)
                            @if($zatcaSetting->certificate_expires_at && $zatcaSetting->certificate_expires_at->isPast())
                                منتهية الصلاحية
                            @else
                                صالحة
                            @endif
                        @else
                            غير مُحمّلة
                        @endif
                    </small>
                </div>
            </div>
            
            <div class="certificate-status" style="--cert-color: {{ $zatcaSetting->connection_status == 'connected' ? '#27ae60' : ($zatcaSetting->connection_status == 'failed' ? '#e74c3c' : '#95a5a6') }};">
                <div class="cert-icon">
                    <i class="fas fa-wifi"></i>
                </div>
                <div class="d-flex align-items-center justify-content-between w-100">
                    <div>
                        <div class="fw-bold">الاتصال</div>
                        <small class="text-muted">
                            @switch($zatcaSetting->connection_status)
                                @case('connected')
                                    متصل
                                    @break
                                @case('failed')
                                    فشل
                                    @break
                                @default
                                    غير مختبر
                            @endswitch
                        </small>
                    </div>
                    <span class="connection-indicator {{ $zatcaSetting->connection_status == 'connected' ? 'connected' : 'disconnected' }}"></span>
                </div>
            </div>
        </div>
        
        <!-- إجراءات سريعة -->
        <div class="info-card">
            <div class="info-card-header">
                <div class="info-card-icon" style="background: linear-gradient(135deg, #f39c12, #e67e22);">
                    <i class="fas fa-bolt"></i>
                </div>
                <h3 class="info-card-title">إجراءات سريعة</h3>
            </div>
            
            <div class="d-grid gap-3">
                @if($zatcaSetting->is_active)
                    <button type="button" class="btn btn-modern btn-success" onclick="testConnection()">
                        <i class="fas fa-plug"></i>
                        اختبار الاتصال
                    </button>
                @endif
                
                <a href="{{ route('invoices.create', ['company_id' => $zatcaSetting->company_id]) }}" class="btn btn-modern btn-primary">
                    <i class="fas fa-file-invoice"></i>
                    إنشاء فاتورة جديدة
                </a>
                
                <a href="{{ route('invoices.index', ['company_id' => $zatcaSetting->company_id]) }}" class="btn btn-modern btn-secondary">
                    <i class="fas fa-list"></i>
                    عرض جميع الفواتير
                </a>
            </div>
        </div>
        
        <!-- معلومات إضافية -->
        <div class="info-card">
            <div class="info-card-header">
                <div class="info-card-icon" style="background: linear-gradient(135deg, #9b59b6, #8e44ad);">
                    <i class="fas fa-info-circle"></i>
                </div>
                <h3 class="info-card-title">معلومات إضافية</h3>
            </div>
            
            <div class="info-item">
                <div class="info-label">تاريخ الإنشاء</div>
                <div class="info-value">{{ $zatcaSetting->created_at->format('Y-m-d H:i') }}</div>
            </div>
            
            @if($zatcaSetting->updated_at != $zatcaSetting->created_at)
                <div class="info-item">
                    <div class="info-label">آخر تحديث</div>
                    <div class="info-value">{{ $zatcaSetting->updated_at->diffForHumans() }}</div>
                </div>
            @endif
            
            <div class="info-item">
                <div class="info-label">معرف الإعدادات</div>
                <div class="info-value">#{{ $zatcaSetting->id }}</div>
            </div>
        </div>
    </div>
    
    <!-- المعلومات الرئيسية -->
    <div class="col-lg-8 order-lg-1">
        <!-- معلومات الشركة -->
        <div class="info-card">
            <div class="info-card-header">
                <div class="info-card-icon">
                    <i class="fas fa-building"></i>
                </div>
                <h3 class="info-card-title">معلومات الشركة</h3>
            </div>
            
            <div class="row">
                <div class="col-md-6">
                    <div class="info-item">
                        <div class="info-label">اسم الشركة</div>
                        <div class="info-value fw-bold">{{ $zatcaSetting->company->name }}</div>
                    </div>
                    
                    <div class="info-item">
                        <div class="info-label">الرقم الضريبي</div>
                        <div class="info-value"><code>{{ $zatcaSetting->company->vat_number }}</code></div>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="info-item">
                        <div class="info-label">رقم السجل التجاري</div>
                        <div class="info-value"><code>{{ $zatcaSetting->company->cr_number }}</code></div>
                    </div>
                    
                    <div class="info-item">
                        <div class="info-label">العنوان</div>
                        <div class="info-value">{{ $zatcaSetting->company->getFullAddressAttribute() }}</div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- إعدادات الربط -->
        <div class="info-card">
            <div class="info-card-header">
                <div class="info-card-icon" style="background: linear-gradient(135deg, #e67e22, #d35400);">
                    <i class="fas fa-cog"></i>
                </div>
                <h3 class="info-card-title">إعدادات الربط</h3>
            </div>
            
            <div class="row">
                <div class="col-md-6">
                    <div class="info-item">
                        <div class="info-label">نوع الربط</div>
                        <div class="info-value">
                            @if($zatcaSetting->connection_type == 'clearance')
                                <span class="status-badge info">
                                    <i class="fas fa-shield-alt"></i>
                                    Clearance (B2B)
                                </span>
                                <br><small class="text-muted mt-2 d-block">للفواتير المعيارية - يتطلب موافقة مسبقة</small>
                            @else
                                <span class="status-badge secondary">
                                    <i class="fas fa-file-alt"></i>
                                    Reporting (B2C)
                                </span>
                                <br><small class="text-muted mt-2 d-block">للفواتير المبسطة - إرسال للإبلاغ</small>
                            @endif
                        </div>
                    </div>
                    
                    <div class="info-item">
                        <div class="info-label">البيئة</div>
                        <div class="info-value">
                            @if($zatcaSetting->environment == 'sandbox')
                                <span class="status-badge warning">
                                    <i class="fas fa-flask"></i>
                                    Sandbox (تجريبية)
                                </span>
                                <br><small class="text-muted mt-2 d-block">للاختبار والتطوير</small>
                            @else
                                <span class="status-badge success">
                                    <i class="fas fa-globe"></i>
                                    Production (إنتاج)
                                </span>
                                <br><small class="text-muted mt-2 d-block">للاستخدام الفعلي</small>
                            @endif
                        </div>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="info-item">
                        <div class="info-label">حالة الإعدادات</div>
                        <div class="info-value">
                            @if($zatcaSetting->is_active)
                                <span class="status-badge success">
                                    <i class="fas fa-check-circle"></i>
                                    نشط
                                </span>
                            @else
                                <span class="status-badge secondary">
                                    <i class="fas fa-pause-circle"></i>
                                    غير نشط
                                </span>
                            @endif
                        </div>
                    </div>
                    
                    <div class="info-item">
                        <div class="info-label">حالة الاتصال</div>
                        <div class="info-value">
                            @switch($zatcaSetting->connection_status)
                                @case('connected')
                                    <span class="status-badge success">
                                        <i class="fas fa-check-circle"></i>
                                        متصل
                                        <span class="connection-indicator connected"></span>
                                    </span>
                                    @break
                                @case('failed')
                                    <span class="status-badge danger">
                                        <i class="fas fa-times-circle"></i>
                                        فشل الاتصال
                                        <span class="connection-indicator disconnected"></span>
                                    </span>
                                    @break
                                @default
                                    <span class="status-badge secondary">
                                        <i class="fas fa-plug"></i>
                                        غير متصل
                                        <span class="connection-indicator disconnected"></span>
                                    </span>
                            @endswitch
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- بيانات الاعتماد -->
        <div class="info-card">
            <div class="info-card-header">
                <div class="info-card-icon" style="background: linear-gradient(135deg, #16a085, #27ae60);">
                    <i class="fas fa-key"></i>
                </div>
                <h3 class="info-card-title">بيانات الاعتماد</h3>
            </div>
            
            <div class="row">
                <div class="col-md-6">
                    <div class="info-item">
                        <div class="info-label">Client ID</div>
                        <div class="info-value">
                            @if($zatcaSetting->client_id)
                                <code>{{ Str::mask($zatcaSetting->client_id, '*', 4, -4) }}</code>
                            @else
                                <span class="text-muted">غير محدد</span>
                            @endif
                        </div>
                    </div>
                    
                    <div class="info-item">
                        <div class="info-label">Username</div>
                        <div class="info-value">
                            @if($zatcaSetting->username)
                                <code>{{ $zatcaSetting->username }}</code>
                            @else
                                <span class="text-muted">غير محدد</span>
                            @endif
                        </div>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="info-item">
                        <div class="info-label">Client Secret</div>
                        <div class="info-value">
                            @if($zatcaSetting->client_secret)
                                <code>{{ Str::mask($zatcaSetting->client_secret, '*', 2, -2) }}</code>
                            @else
                                <span class="text-muted">غير محدد</span>
                            @endif
                        </div>
                    </div>
                    
                    <div class="info-item">
                        <div class="info-label">Password</div>
                        <div class="info-value">
                            @if($zatcaSetting->password)
                                <code>********</code>
                            @else
                                <span class="text-muted">غير محدد</span>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- الشهادات الرقمية -->
        <div class="info-card">
            <div class="info-card-header">
                <div class="info-card-icon" style="background: linear-gradient(135deg, #8e44ad, #9b59b6);">
                    <i class="fas fa-certificate"></i>
                </div>
                <h3 class="info-card-title">الشهادات الرقمية</h3>
            </div>
            
            <div class="row">
                <div class="col-md-6">
                    <div class="certificate-status" style="--cert-color: {{ $zatcaSetting->certificate_content ? '#27ae60' : '#f39c12' }};">
                        <div class="cert-icon">
                            <i class="fas fa-{{ $zatcaSetting->certificate_content ? 'check' : 'exclamation-triangle' }}"></i>
                        </div>
                        <div>
                            <div class="fw-bold">الشهادة الرقمية</div>
                            <small class="text-muted">{{ $zatcaSetting->certificate_content ? 'مُحمّلة' : 'غير مُحمّلة' }}</small>
                        </div>
                    </div>
                    
                    <div class="certificate-status" style="--cert-color: {{ $zatcaSetting->private_key_content ? '#27ae60' : '#f39c12' }};">
                        <div class="cert-icon">
                            <i class="fas fa-{{ $zatcaSetting->private_key_content ? 'key' : 'exclamation-triangle' }}"></i>
                        </div>
                        <div>
                            <div class="fw-bold">المفتاح الخاص</div>
                            <small class="text-muted">{{ $zatcaSetting->private_key_content ? 'مُحمّل' : 'غير مُحمّل' }}</small>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-6">
                    @if($zatcaSetting->certificate_expires_at)
                        @php
                            $daysToExpiry = now()->diffInDays($zatcaSetting->certificate_expires_at, false);
                        @endphp
                        <div class="info-item">
                            <div class="info-label">انتهاء صلاحية الشهادة</div>
                            <div class="info-value">
                                @if($daysToExpiry <= 0)
                                    <span class="status-badge danger">
                                        <i class="fas fa-times-circle"></i>
                                        منتهية الصلاحية
                                    </span>
                                    <br><small class="text-danger mt-2 d-block">انتهت في {{ $zatcaSetting->certificate_expires_at->format('Y-m-d') }}</small>
                                @elseif($daysToExpiry <= 30)
                                    <span class="status-badge warning">
                                        <i class="fas fa-exclamation-triangle"></i>
                                        {{ $daysToExpiry }} يوم متبقي
                                    </span>
                                    <br><small class="text-warning mt-2 d-block">تنتهي في {{ $zatcaSetting->certificate_expires_at->format('Y-m-d') }}</small>
                                @else
                                    <span class="status-badge success">
                                        <i class="fas fa-check-circle"></i>
                                        صالحة
                                    </span>
                                    <br><small class="text-success mt-2 d-block">تنتهي في {{ $zatcaSetting->certificate_expires_at->format('Y-m-d') }}</small>
                                @endif
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
        
   
        
        <!-- تاريخ الاتصال والأخطاء -->
        @if($zatcaSetting->last_connection_test || $zatcaSetting->last_error)
        <div class="info-card">
            <div class="info-card-header">
                <div class="info-card-icon" style="background: linear-gradient(135deg, #34495e, #2c3e50);">
                    <i class="fas fa-history"></i>
                </div>
                <h3 class="info-card-title">سجل الاتصال</h3>
            </div>
            
            @if($zatcaSetting->last_connection_test)
                <div class="info-item">
                    <div class="info-label">آخر اختبار اتصال</div>
                    <div class="info-value">
                        {{ $zatcaSetting->last_connection_test->format('Y-m-d H:i:s') }}
                        <br><small class="text-muted">{{ $zatcaSetting->last_connection_test->diffForHumans() }}</small>
                    </div>
                </div>
            @endif
            
            @if($zatcaSetting->last_error)
                <div class="alert alert-danger" style="border-radius: 10px; border: none; box-shadow: 0 2px 10px rgba(231, 76, 60, 0.2);">
                    <div class="d-flex align-items-start">
                        <i class="fas fa-exclamation-triangle me-3 mt-1 text-danger"></i>
                        <div>
                            <h6 class="alert-heading mb-2">آخر خطأ مُسجّل:</h6>
                            <p class="mb-0">{{ $zatcaSetting->last_error }}</p>
                        </div>
                    </div>
                </div>
            @endif
        </div>
        @endif
    </div>
</div>
@endsection

@push('scripts')
<script>
function testConnection() {
    const button = event.target;
    const originalText = button.innerHTML;
    const loadingOverlay = document.getElementById('loadingOverlay');
    
    // Show loading overlay
    loadingOverlay.style.display = 'flex';
    
    // Disable button and show loading state
    button.disabled = true;
    button.innerHTML = '<i class="fas fa-spinner fa-spin me-1"></i>جاري الاختبار...';
    
    fetch('{{ route("zatca-settings.test-connection") }}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        },
        body: JSON.stringify({
            zatca_settings_id: {{ $zatcaSetting->id }}
        })
    })
    .then(response => response.json())
    .then(data => {
        // Hide loading overlay
        loadingOverlay.style.display = 'none';
        
        if (data.success) {
            showNotification('✅ ' + data.message, 'success');
            setTimeout(() => {
                location.reload();
            }, 2000);
        } else {
            showNotification('❌ ' + data.message, 'error');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        loadingOverlay.style.display = 'none';
        showNotification('❌ حدث خطأ أثناء اختبار الاتصال', 'error');
    })
    .finally(() => {
        button.disabled = false;
        button.innerHTML = originalText;
    });
}

function showNotification(message, type) {
    // Create notification element
    const notification = document.createElement('div');
    notification.className = `alert alert-${type === 'success' ? 'success' : 'danger'} alert-dismissible fade show position-fixed`;
    notification.style.cssText = `
        top: 20px;
        right: 20px;
        z-index: 10000;
        min-width: 300px;
        border-radius: 10px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.15);
        border: none;
    `;
    
    notification.innerHTML = `
        <div class="d-flex align-items-center">
            <i class="fas fa-${type === 'success' ? 'check-circle' : 'exclamation-circle'} me-2"></i>
            <span>${message}</span>
        </div>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    `;
    
    document.body.appendChild(notification);
    
    // Auto remove after 5 seconds
    setTimeout(() => {
        if (notification.parentNode) {
            notification.remove();
        }
    }, 5000);
}

// Add some smooth animations on page load
document.addEventListener('DOMContentLoaded', function() {
    // Animate cards on scroll
    const observerOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
    };
    
    const observer = new IntersectionObserver(function(entries) {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.style.animation = 'slideInUp 0.6s ease-out forwards';
            }
        });
    }, observerOptions);
    
    // Observe all info cards
    document.querySelectorAll('.info-card, .stat-card').forEach(card => {
        card.style.opacity = '0';
        card.style.transform = 'translateY(20px)';
        observer.observe(card);
    });
    
    // Add CSS for animations
    const style = document.createElement('style');
    style.textContent = `
        @keyframes slideInUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .info-card, .stat-card {
            transition: all 0.3s ease;
        }
        
        .status-badge {
            transition: all 0.3s ease;
        }
        
        .connection-indicator {
            transition: all 0.3s ease;
        }
        
        .certificate-status {
            transition: all 0.3s ease;
        }
        
        .btn-modern {
            transition: all 0.3s ease;
        }
        
        .dropdown-item-modern {
            transition: all 0.3s ease;
        }
    `;
    document.head.appendChild(style);
});
</script>
@endpush