@extends('layouts.app')

@section('title', 'سجلات تهيئة الأجهزة')
@section('page-title', 'سجلات تهيئة الأجهزة للربط مع ZATCA')

@section('page-actions')
<div class="d-flex gap-2">
    <a href="{{ route('zatca-settings.device-initialization') }}" class="btn btn-success">
        <i class="fas fa-laptop me-2"></i>
        تهيئة جهاز جديد
    </a>
    <a href="{{ route('zatca-settings.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left me-2"></i>
        العودة لإعدادات ZATCA
    </a>
</div>
@endsection

@section('content')
<div class="row">
    <div class="col-12">
        <!-- إحصائيات سريعة -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card bg-success text-white">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <h6 class="card-title mb-1">تم التحقق بنجاح</h6>
                                <h3 class="mb-0">{{ $stats['verified'] ?? 0 }}</h3>
                            </div>
                            <div class="ms-3">
                                <i class="fas fa-check-circle fa-2x"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-warning text-white">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <h6 class="card-title mb-1">قيد الانتظار</h6>
                                <h3 class="mb-0">{{ $stats['pending'] ?? 0 }}</h3>
                            </div>
                            <div class="ms-3">
                                <i class="fas fa-clock fa-2x"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-danger text-white">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <h6 class="card-title mb-1">فشل التحقق</h6>
                                <h3 class="mb-0">{{ $stats['failed'] ?? 0 }}</h3>
                            </div>
                            <div class="ms-3">
                                <i class="fas fa-times-circle fa-2x"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-secondary text-white">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <h6 class="card-title mb-1">انتهت الصلاحية</h6>
                                <h3 class="mb-0">{{ $stats['expired'] ?? 0 }}</h3>
                            </div>
                            <div class="ms-3">
                                <i class="fas fa-hourglass-end fa-2x"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- جدول السجلات -->
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-list me-2"></i>
                    سجلات تهيئة الأجهزة
                </h5>
            </div>
            <div class="card-body">
                @if($logs->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-striped">
                                <tr>
                                    <th>الشركة</th>
                                    <th>رقم الشهادة</th>
                                    <th>وقت الطلب</th>
                                    <th>وقت التحقق</th>
                                    <th>الحالة</th>
                                    <th>عنوان IP</th>
                                    <th>الإجراءات</th>
                                </tr>
                            <tbody>
                                @foreach($logs as $log)
                                <tr>
                                    <td>
                                        <strong>{{ $log->company->name }}</strong>
                                        <br>
                                        <small class="text-muted">{{ $log->company->vat_number }}</small>
                                    </td>
                                    <td>
                                        <code class="text-primary">{{ Str::limit($log->csid_number, 20) }}</code>
                                    </td>
                                    <td>
                                        @if($log->otp_requested_at)
                                            <span class="text-nowrap">{{ $log->otp_requested_at->format('Y-m-d H:i') }}</span>
                                            <br>
                                            <small class="text-muted">{{ $log->otp_requested_at->diffForHumans() }}</small>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($log->otp_verified_at)
                                            <span class="text-nowrap">{{ $log->otp_verified_at->format('Y-m-d H:i') }}</span>
                                            <br>
                                            <small class="text-muted">{{ $log->otp_verified_at->diffForHumans() }}</small>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        @switch($log->verification_status)
                                            @case('verified')
                                                <span class="badge bg-success">
                                                    <i class="fas fa-check-circle me-1"></i>
                                                    تم التحقق
                                                </span>
                                                @break
                                            @case('pending')
                                                <span class="badge bg-warning">
                                                    <i class="fas fa-clock me-1"></i>
                                                    قيد الانتظار
                                                </span>
                                                @break
                                            @case('failed')
                                                <span class="badge bg-danger">
                                                    <i class="fas fa-times-circle me-1"></i>
                                                    فشل
                                                </span>
                                                @break
                                            @case('expired')
                                                <span class="badge bg-secondary">
                                                    <i class="fas fa-hourglass-end me-1"></i>
                                                    انتهت الصلاحية
                                                </span>
                                                @break
                                            @default
                                                <span class="badge bg-light text-dark">{{ $log->verification_status }}</span>
                                        @endswitch
                                    </td>
                                    <td>
                                        <code>{{ $log->ip_address }}</code>
                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            <button type="button" class="btn btn-sm btn-outline-primary" 
                                                    onclick="showLogDetails({{ $log->id }})">
                                                <i class="fas fa-eye"></i>
                                                التفاصيل
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="d-flex justify-content-center">
                        {{ $logs->links() }}
                    </div>
                @else
                    <div class="text-center py-5">
                        <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                        <h5 class="text-muted">لا توجد سجلات تهيئة</h5>
                        <p class="text-muted">لم يتم تسجيل أي محاولات تهيئة أجهزة حتى الآن</p>
                        <a href="{{ route('zatca-settings.device-initialization') }}" class="btn btn-primary">
                            <i class="fas fa-plus me-2"></i>
                            ابدأ تهيئة جهاز جديد
                        </a>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>

<!-- Modal لعرض تفاصيل السجل -->
<div class="modal fade" id="logDetailsModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">تفاصيل سجل التهيئة</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="logDetailsContent">
                <!-- سيتم تحميل المحتوى هنا -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إغلاق</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function showLogDetails(logId) {
    // إظهار modal مع محتوى تحميل
    const modal = new bootstrap.Modal(document.getElementById('logDetailsModal'));
    const content = document.getElementById('logDetailsContent');
    
    content.innerHTML = `
        <div class="text-center">
            <div class="spinner-border text-primary" role="status">
                <span class="visually-hidden">جاري التحميل...</span>
            </div>
            <p class="mt-2">جاري تحميل التفاصيل...</p>
        </div>
    `;
    
    modal.show();
    
    // استدعاء API لجلب تفاصيل السجل
    fetch(`{{ url('/zatca-settings/initialization-logs') }}/${logId}`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                const log = data.data;
                content.innerHTML = `
                    <div class="row">
                        <div class="col-md-6">
                            <h6>معلومات أساسية:</h6>
                            <table class="table table-sm">
                                <tr><th>معرف السجل:</th><td>${log.id}</td></tr>
                                <tr><th>الشركة:</th><td>${log.company.name}</td></tr>
                                <tr><th>الرقم الضريبي:</th><td>${log.company.vat_number}</td></tr>
                                <tr><th>الحالة:</th><td><span class="badge bg-${getStatusColor(log.verification_status)}">${getStatusText(log.verification_status)}</span></td></tr>
                                <tr><th>عنوان IP:</th><td>${log.ip_address || '-'}</td></tr>
                                <tr><th>وقت الإنشاء:</th><td>${log.created_at}</td></tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <h6>الأوقات المهمة:</h6>
                            <table class="table table-sm">
                                <tr><th>طلب OTP:</th><td>${log.otp_requested_at || '-'}</td></tr>
                                <tr><th>انتهاء OTP:</th><td>${log.otp_expires_at || '-'}</td></tr>
                                <tr><th>تحقق OTP:</th><td>${log.otp_verified_at || '-'}</td></tr>
                            </table>
                        </div>
                    </div>
                    <div class="row mt-3">
                        <div class="col-md-6">
                            <h6>بيانات الطلب:</h6>
                            <pre class="bg-light p-2 rounded small"><code>${JSON.stringify(log.request_data, null, 2)}</code></pre>
                        </div>
                        <div class="col-md-6">
                            <h6>بيانات الاستجابة:</h6>
                            <pre class="bg-light p-2 rounded small"><code>${JSON.stringify(log.response_data, null, 2)}</code></pre>
                        </div>
                    </div>
                    ${log.error_message ? `
                    <div class="row mt-3">
                        <div class="col-12">
                            <h6>رسالة الخطأ:</h6>
                            <div class="alert alert-danger">
                                ${log.error_message}
                            </div>
                        </div>
                    </div>
                    ` : ''}
                    <div class="row mt-3">
                        <div class="col-12">
                            <h6>معلومات المتصفح:</h6>
                            <small class="text-muted">${log.user_agent || 'غير متوفر'}</small>
                        </div>
                    </div>
                `;
            } else {
                content.innerHTML = `
                    <div class="alert alert-danger">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        حدث خطأ أثناء تحميل تفاصيل السجل
                    </div>
                `;
            }
        })
        .catch(error => {
            console.error('Error:', error);
            content.innerHTML = `
                <div class="alert alert-danger">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    حدث خطأ أثناء تحميل البيانات
                </div>
            `;
        });
}

function getStatusColor(status) {
    switch(status) {
        case 'verified': return 'success';
        case 'pending': return 'warning';
        case 'failed': return 'danger';
        case 'expired': return 'secondary';
        default: return 'light';
    }
}

function getStatusText(status) {
    switch(status) {
        case 'verified': return 'تم التحقق';
        case 'pending': return 'قيد الانتظار';
        case 'failed': return 'فشل';
        case 'expired': return 'انتهت الصلاحية';
        default: return status;
    }
}
</script>
@endpush