@extends('layouts.app')

@section('title', 'إعدادات ZATCA')
@section('page-title', 'إعدادات الربط الإلكتروني مع ZATCA')

@section('page-actions')
@if($companies->count() > 0)
    <div class="d-flex gap-2">
        <a href="{{ route('zatca-settings.device-initialization') }}" class="btn btn-success btn-enhanced">
            <i class="fas fa-laptop me-2"></i>
            تهيئة جهاز جديد
        </a>
        <a href="{{ route('zatca-settings.initialization-logs') }}" class="btn btn-info btn-enhanced">
            <i class="fas fa-history me-2"></i>
            سجلات التهيئة
        </a>
        <a href="{{ route('zatca-settings.create') }}" class="btn btn-primary btn-enhanced">
            <i class="fas fa-plus me-2"></i>
            إضافة إعدادات جديدة
        </a>
    </div>
@endif
@endsection

@push('styles')
<style>
    .zatca-settings-container {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        min-height: 200px;
        border-radius: 20px;
        position: relative;
        overflow: hidden;
        margin-bottom: 30px;
    }

    .zatca-settings-container::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><circle cx="20" cy="20" r="2" fill="rgba(255,255,255,0.1)"/><circle cx="80" cy="80" r="2" fill="rgba(255,255,255,0.1)"/><circle cx="40" cy="60" r="1" fill="rgba(255,255,255,0.1)"/><circle cx="70" cy="30" r="1.5" fill="rgba(255,255,255,0.1)"/></svg>');
        animation: float 20s infinite linear;
    }

    @keyframes float {
        0% { transform: translateY(0px) rotate(0deg); }
        100% { transform: translateY(-100px) rotate(360deg); }
    }

    .zatca-card {
        background: #fff;
        border-radius: 20px;
        box-shadow: 0 10px 40px rgba(0,0,0,0.1);
        transition: all 0.3s ease;
        border: none;
        overflow: hidden;
        position: relative;
    }

    .zatca-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: linear-gradient(90deg, #3498db, #2980b9, #27ae60, #f39c12);
        animation: colorShift 3s infinite;
    }

    @keyframes colorShift {
        0% { background: linear-gradient(90deg, #3498db, #2980b9); }
        50% { background: linear-gradient(90deg, #27ae60, #2ecc71); }
        100% { background: linear-gradient(90deg, #3498db, #2980b9); }
    }

    .zatca-card:hover {
        transform: translateY(-10px);
        box-shadow: 0 20px 60px rgba(0,0,0,0.15);
    }

    .connection-status {
        position: relative;
        padding: 12px 20px;
        border-radius: 30px;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 1px;
        font-size: 0.85rem;
        display: inline-flex;
        align-items: center;
        gap: 8px;
    }

    .status-connected {
        background: linear-gradient(135deg, #27ae60, #2ecc71);
        color: white;
        box-shadow: 0 4px 15px rgba(39, 174, 96, 0.3);
    }

    .status-connected .status-pulse {
        width: 8px;
        height: 8px;
        border-radius: 50%;
        background: #fff;
        animation: pulse 2s infinite;
    }

    .status-failed {
        background: linear-gradient(135deg, #e74c3c, #c0392b);
        color: white;
        box-shadow: 0 4px 15px rgba(231, 76, 60, 0.3);
    }

    .status-disconnected {
        background: linear-gradient(135deg, #95a5a6, #7f8c8d);
        color: white;
        box-shadow: 0 4px 15px rgba(149, 165, 166, 0.3);
    }

    @keyframes pulse {
        0% { opacity: 1; transform: scale(1); }
        50% { opacity: 0.7; transform: scale(1.2); }
        100% { opacity: 1; transform: scale(1); }
    }

    .info-badge {
        background: linear-gradient(135deg, #3498db, #2980b9);
        color: white;
        padding: 8px 16px;
        border-radius: 20px;
        font-size: 0.85rem;
        font-weight: 600;
        display: inline-flex;
        align-items: center;
        gap: 6px;
        box-shadow: 0 3px 10px rgba(52, 152, 219, 0.3);
    }

    .info-badge.warning {
        background: linear-gradient(135deg, #f39c12, #e67e22);
        box-shadow: 0 3px 10px rgba(243, 156, 18, 0.3);
    }

    .info-badge.success {
        background: linear-gradient(135deg, #27ae60, #2ecc71);
        box-shadow: 0 3px 10px rgba(39, 174, 96, 0.3);
    }

    .info-badge.secondary {
        background: linear-gradient(135deg, #95a5a6, #7f8c8d);
        box-shadow: 0 3px 10px rgba(149, 165, 166, 0.3);
    }

    .company-header {
        background: linear-gradient(135deg, #2c3e50, #34495e);
        color: white;
        padding: 25px;
        border-radius: 20px 20px 0 0;
        position: relative;
        overflow: hidden;
    }

    .company-header::after {
        content: '';
        position: absolute;
        top: -50%;
        right: -50%;
        width: 200%;
        height: 200%;
        background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
        animation: shimmer 4s infinite;
    }

    @keyframes shimmer {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }

    .company-title {
        font-size: 1.4rem;
        font-weight: 700;
        margin: 0;
        position: relative;
        z-index: 2;
    }

    .card-content {
        padding: 30px;
    }

    .info-row {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 20px;
        margin-bottom: 25px;
    }

    .info-item {
        background: #f8f9fa;
        padding: 20px;
        border-radius: 15px;
        border-left: 4px solid #3498db;
        transition: all 0.3s ease;
    }

    .info-item:hover {
        background: #e9ecef;
        transform: translateX(-5px);
    }

    .info-label {
        font-weight: 600;
        color: #2c3e50;
        margin-bottom: 8px;
        display: block;
    }

    .counter-display {
        font-size: 2rem;
        font-weight: 800;
        background: linear-gradient(135deg, #3498db, #2980b9);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
    }

    .btn-enhanced {
        padding: 12px 24px;
        border-radius: 25px;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 1px;
        transition: all 0.3s ease;
        position: relative;
        overflow: hidden;
    }

    .btn-enhanced::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
        transition: left 0.5s;
    }

    .btn-enhanced:hover::before {
        left: 100%;
    }

    .action-buttons {
        display: flex;
        gap: 10px;
        flex-wrap: wrap;
        padding: 20px 30px 30px;
        background: #f8f9fa;
        border-radius: 0 0 20px 20px;
    }

    .action-btn {
        flex: 1;
        min-width: 120px;
        padding: 12px 16px;
        border-radius: 25px;
        font-weight: 600;
        font-size: 0.85rem;
        transition: all 0.3s ease;
        border: none;
        text-decoration: none;
        text-align: center;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
    }

    .action-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(0,0,0,0.2);
    }

    .empty-state {
        text-align: center;
        padding: 80px 40px;
        background: #fff;
        border-radius: 20px;
        box-shadow: 0 10px 40px rgba(0,0,0,0.1);
    }

    .empty-icon {
        font-size: 4rem;
        color: #bdc3c7;
        margin-bottom: 30px;
        animation: bounce 2s infinite;
    }

    @keyframes bounce {
        0%, 20%, 50%, 80%, 100% { transform: translateY(0); }
        40% { transform: translateY(-10px); }
        60% { transform: translateY(-5px); }
    }

    .info-section {
        background: #fff;
        border-radius: 20px;
        box-shadow: 0 10px 40px rgba(0,0,0,0.1);
        overflow: hidden;
        margin-top: 40px;
    }

    .info-header {
        background: linear-gradient(135deg, #34495e, #2c3e50);
        color: white;
        padding: 25px 30px;
        position: relative;
    }

    .info-header::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><polygon points="0,0 100,0 85,100 0,100" fill="rgba(255,255,255,0.05)"/></svg>');
    }

    .info-grid {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 40px;
        padding: 40px;
    }

    .feature-list {
        list-style: none;
        padding: 0;
    }

    .feature-item {
        display: flex;
        align-items: center;
        gap: 15px;
        padding: 15px 0;
        border-bottom: 1px solid #ecf0f1;
        transition: all 0.3s ease;
    }

    .feature-item:hover {
        background: #f8f9fa;
        padding-left: 10px;
        border-radius: 10px;
    }

    .feature-icon {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        background: linear-gradient(135deg, #3498db, #2980b9);
        color: white;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.1rem;
    }

    .feature-text {
        font-weight: 500;
        color: #2c3e50;
    }

    .certificate-warning {
        background: linear-gradient(135deg, #f39c12, #e67e22);
        color: white;
        padding: 15px 20px;
        border-radius: 15px;
        margin: 15px 0;
        border: none;
        box-shadow: 0 5px 15px rgba(243, 156, 18, 0.3);
    }

    .certificate-expired {
        background: linear-gradient(135deg, #e74c3c, #c0392b);
        box-shadow: 0 5px 15px rgba(231, 76, 60, 0.3);
    }

    .certificate-valid {
        background: linear-gradient(135deg, #27ae60, #2ecc71);
        box-shadow: 0 5px 15px rgba(39, 174, 96, 0.3);
    }

    .error-alert {
        background: linear-gradient(135deg, #e74c3c, #c0392b);
        color: white;
        padding: 20px;
        border-radius: 15px;
        margin: 20px 0;
        border: none;
        box-shadow: 0 5px 15px rgba(231, 76, 60, 0.3);
    }

    .dropdown-menu {
        border-radius: 15px;
        box-shadow: 0 10px 40px rgba(0,0,0,0.15);
        border: none;
        padding: 10px;
    }

    .dropdown-item {
        border-radius: 10px;
        padding: 12px 16px;
        transition: all 0.3s ease;
    }

    .dropdown-item:hover {
        background: #f8f9fa;
        transform: translateX(-5px);
    }

    @media (max-width: 768px) {
        .info-row {
            grid-template-columns: 1fr;
            gap: 15px;
        }
        
        .info-grid {
            grid-template-columns: 1fr;
            gap: 30px;
            padding: 30px 20px;
        }
        
        .action-buttons {
            flex-direction: column;
            gap: 15px;
        }
        
        .action-btn {
            min-width: auto;
        }
    }
</style>
@endpush

@section('content')
<!-- Header Section -->
<div class="zatca-settings-container d-flex align-items-center justify-content-center">
    <div class="text-center text-white position-relative" style="z-index: 2;">
        <h2 class="display-6 fw-bold mb-3">
            <i class="fas fa-shield-alt me-3"></i>
            إدارة إعدادات ZATCA
        </h2>
        <p class="lead mb-0">نظام متقدم للربط الإلكتروني مع هيئة الزكاة والضريبة والجمارك</p>
    </div>
</div>

<div class="row">
    @forelse($zatcaSettings as $setting)
    <div class="col-lg-6 mb-4">
        <div class="zatca-card h-100">
            <div class="company-header">
                <div class="d-flex justify-content-between align-items-center">
                    <h5 class="company-title">
                        <i class="fas fa-building me-3"></i>
                        {{ $setting->company ? $setting->company->name : 'شركة غير محددة' }}
                    </h5>
                    
                    <!-- حالة الاتصال -->
                    <div class="connection-status {{ $setting->connection_status == 'connected' ? 'status-connected' : ($setting->connection_status == 'failed' ? 'status-failed' : 'status-disconnected') }}">
                        @switch($setting->connection_status)
                            @case('connected')
                                <span class="status-pulse"></span>
                                متصل
                                @break
                            @case('failed')
                                <i class="fas fa-times-circle"></i>
                                فشل الاتصال
                                @break
                            @default
                                <i class="fas fa-plug"></i>
                                غير متصل
                        @endswitch
                    </div>
                </div>
            </div>
            
            <div class="card-content">
                <div class="info-row">
                    <div class="info-item">
                        <span class="info-label">نوع الربط</span>
                        @if($setting->connection_type == 'clearance')
                            <span class="info-badge">
                                <i class="fas fa-exchange-alt"></i>
                                Clearance
                            </span>
                        @else
                            <span class="info-badge success">
                                <i class="fas fa-file-alt"></i>
                                Reporting
                            </span>
                        @endif
                    </div>
                    <div class="info-item">
                        <span class="info-label">البيئة</span>
                        @if($setting->environment == 'sandbox')
                            <span class="info-badge warning">
                                <i class="fas fa-flask"></i>
                                تجريبية
                            </span>
                        @else
                            <span class="info-badge success">
                                <i class="fas fa-rocket"></i>
                                إنتاج
                            </span>
                        @endif
                    </div>
                </div>
                
                <div class="info-row">
                    <div class="info-item">
                        <span class="info-label">حالة النشاط</span>
                        @if($setting->is_active)
                            <span class="info-badge success">
                                <i class="fas fa-check-circle"></i>
                                نشط
                            </span>
                        @else
                            <span class="info-badge secondary">
                                <i class="fas fa-pause-circle"></i>
                                غير نشط
                            </span>
                        @endif
                    </div>
                    <div class="info-item">
                        <span class="info-label">عداد الفواتير</span>
                        <div class="counter-display">{{ number_format($setting->invoice_counter) }}</div>
                    </div>
                </div>
                
                @if($setting->last_connection_test)
                    <div class="info-item">
                        <span class="info-label">
                            <i class="fas fa-clock me-2"></i>
                            آخر اختبار اتصال
                        </span>
                        <small class="text-muted fw-bold">{{ $setting->last_connection_test->diffForHumans() }}</small>
                    </div>
                @endif
                
                @if($setting->certificate_expires_at)
                    <div class="info-item">
                        <span class="info-label">
                            <i class="fas fa-certificate me-2"></i>
                            حالة الشهادة
                        </span>
                        @php
                            $daysToExpiry = now()->diffInDays($setting->certificate_expires_at, false);
                        @endphp
                        @if($daysToExpiry <= 0)
                            <div class="certificate-warning certificate-expired">
                                <i class="fas fa-exclamation-triangle me-2"></i>
                                منتهية الصلاحية
                            </div>
                        @elseif($daysToExpiry <= 30)
                            <div class="certificate-warning">
                                <i class="fas fa-clock me-2"></i>
                                {{ $daysToExpiry }} يوم متبقي
                            </div>
                        @else
                            <div class="certificate-warning certificate-valid">
                                <i class="fas fa-check-circle me-2"></i>
                                صالحة حتى {{ $setting->certificate_expires_at->format('Y-m-d') }}
                            </div>
                        @endif
                    </div>
                @endif
                
                @if($setting->last_error)
                    <div class="error-alert">
                        <div class="d-flex align-items-start">
                            <i class="fas fa-exclamation-circle me-3 mt-1"></i>
                            <div>
                                <strong>آخر خطأ مسجل:</strong>
                                <p class="mb-0 mt-2">{{ Str::limit($setting->last_error, 120) }}</p>
                            </div>
                        </div>
                    </div>
                @endif
            </div>
            
            <div class="action-buttons">
                <a href="{{ route('zatca-settings.show', $setting) }}"
                   class="action-btn btn-outline-primary">
                    <i class="fas fa-eye"></i>
                    عرض التفاصيل
                </a>
                
                <a href="{{ route('zatca-settings.edit', $setting) }}"
                   class="action-btn btn-outline-warning">
                    <i class="fas fa-edit"></i>
                    تعديل
                </a>
                
                @if($setting->is_active)
                    <button type="button" class="action-btn btn-outline-success"
                            onclick="testConnection({{ $setting->id }})">
                        <i class="fas fa-plug"></i>
                        اختبار الاتصال
                    </button>
                @endif
                
                <div class="btn-group">
                    <button type="button" class="action-btn btn-outline-secondary dropdown-toggle"
                            data-bs-toggle="dropdown">
                        <i class="fas fa-ellipsis-v"></i>
                        المزيد
                    </button>
                    <ul class="dropdown-menu">
                        @if($setting->access_token && $setting->token_expires_at && $setting->token_expires_at->isPast())
                            <li>
                                <form method="POST" action="{{ route('zatca-settings.refresh-token', $setting) }}" style="display: inline;">
                                    @csrf
                                    <button type="submit" class="dropdown-item">
                                        <i class="fas fa-sync me-2"></i>
                                        تجديد الرمز المميز
                                    </button>
                                </form>
                            </li>
                        @endif
                        <li>
                            <form method="POST" action="{{ route('zatca-settings.reset-counter', $setting) }}" style="display: inline;">
                                @csrf
                                <button type="submit" class="dropdown-item"
                                        onclick="return confirm('هل تريد إعادة تعيين عداد الفواتير؟')">
                                    <i class="fas fa-undo me-2"></i>
                                    إعادة تعيين العداد
                                </button>
                            </form>
                        </li>
                        <li>
                            <a class="dropdown-item" href="{{ route('zatca-settings.export', $setting) }}">
                                <i class="fas fa-download me-2"></i>
                                تصدير الإعدادات
                            </a>
                        </li>
                        <li><hr class="dropdown-divider"></li>
                        <li>
                            <form method="POST" action="{{ route('zatca-settings.destroy', $setting) }}" style="display: inline;">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="dropdown-item text-danger"
                                        onclick="return confirm('هل تريد حذف هذه الإعدادات؟')">
                                    <i class="fas fa-trash me-2"></i>
                                    حذف الإعدادات
                                </button>
                            </form>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    @empty
    <div class="col-12">
        <div class="empty-state">
            <div class="empty-icon">
                <i class="fas fa-cog"></i>
            </div>
            <h3 class="text-muted mb-3">لا توجد إعدادات ZATCA</h3>
            <p class="text-muted mb-4">ابدأ بإنشاء إعدادات ZATCA للتمكن من إرسال الفواتير الإلكترونية وضمان التوافق مع متطلبات هيئة الزكاة والضريبة والجمارك</p>
            
            @if($companies->count() > 0)
                <div class="d-flex gap-3 justify-content-center flex-wrap">
                    <a href="{{ route('zatca-settings.device-initialization') }}" class="btn btn-success btn-enhanced">
                        <i class="fas fa-laptop me-2"></i>
                        تهيئة جهاز جديد
                    </a>
                    <a href="{{ route('zatca-settings.create') }}" class="btn btn-primary btn-enhanced">
                        <i class="fas fa-plus me-2"></i>
                        إنشاء إعدادات ZATCA الأولى
                    </a>
                </div>
            @else
                <div class="alert alert-warning d-inline-block" style="border: none; border-radius: 15px; background: linear-gradient(135deg, #f39c12, #e67e22); color: white; box-shadow: 0 5px 15px rgba(243, 156, 18, 0.3);">
                    <div class="d-flex align-items-center">
                        <i class="fas fa-exclamation-triangle me-3 fa-2x"></i>
                        <div>
                            <strong>تنبيه مهم:</strong>
                            <p class="mb-2">يجب إنشاء شركة أولاً قبل إعداد ZATCA</p>
                            <a href="{{ route('companies.create') }}" class="btn btn-light btn-sm">
                                <i class="fas fa-building me-2"></i>
                                إنشاء شركة جديدة
                            </a>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
    @endforelse
</div>

<!-- معلومات عامة عن ZATCA -->
<div class="info-section">
    <div class="info-header">
        <h3 class="mb-0 position-relative" style="z-index: 2;">
            <i class="fas fa-info-circle me-3"></i>
            معلومات مهمة حول ZATCA
        </h3>
        <p class="mb-0 mt-2 position-relative" style="z-index: 2; opacity: 0.9;">
            تعرف على المتطلبات والمواصفات الفنية للمرحلة الثانية من الفاتورة الإلكترونية
        </p>
    </div>
    <div class="info-grid">
        <div>
            <h5 class="mb-4" style="color: #2c3e50; font-weight: 700;">
                <i class="fas fa-rocket me-2" style="color: #3498db;"></i>
                المرحلة الثانية - التكامل
            </h5>
            <ul class="feature-list">
                <li class="feature-item">
                    <div class="feature-icon">
                        <i class="fas fa-clock"></i>
                    </div>
                    <span class="feature-text">إرسال الفواتير في الوقت الفعلي</span>
                </li>
                <li class="feature-item">
                    <div class="feature-icon">
                        <i class="fas fa-signature"></i>
                    </div>
                    <span class="feature-text">التوقيع الرقمي للفواتير</span>
                </li>
                <li class="feature-item">
                    <div class="feature-icon" style="background: linear-gradient(135deg, #27ae60, #2ecc71);">
                        <i class="fas fa-qrcode"></i>
                    </div>
                    <span class="feature-text">QR Code متطور ومشفر</span>
                </li>
                <li class="feature-item">
                    <div class="feature-icon" style="background: linear-gradient(135deg, #f39c12, #e67e22);">
                        <i class="fas fa-plug"></i>
                    </div>
                    <span class="feature-text">تكامل مع APIs ZATCA</span>
                </li>
            </ul>
        </div>
        <div>
            <h5 class="mb-4" style="color: #2c3e50; font-weight: 700;">
                <i class="fas fa-cogs me-2" style="color: #e74c3c;"></i>
                أنواع الربط والبيئات
            </h5>
            
            <div class="mb-4">
                <h6 class="mb-3" style="color: #34495e; font-weight: 600;">أنواع الربط:</h6>
                <ul class="feature-list">
                    <li class="feature-item">
                        <div class="feature-icon">
                            <i class="fas fa-exchange-alt"></i>
                        </div>
                        <span class="feature-text"><strong>Clearance:</strong> للفواتير المعيارية (B2B)</span>
                    </li>
                    <li class="feature-item">
                        <div class="feature-icon" style="background: linear-gradient(135deg, #17a2b8, #138496);">
                            <i class="fas fa-file-alt"></i>
                        </div>
                        <span class="feature-text"><strong>Reporting:</strong> للفواتير المبسطة (B2C)</span>
                    </li>
                </ul>
            </div>
            
            <div>
                <h6 class="mb-3" style="color: #34495e; font-weight: 600;">البيئات:</h6>
                <ul class="feature-list">
                    <li class="feature-item">
                        <div class="feature-icon" style="background: linear-gradient(135deg, #f39c12, #e67e22);">
                            <i class="fas fa-flask"></i>
                        </div>
                        <span class="feature-text"><strong>Sandbox:</strong> للاختبار والتطوير</span>
                    </li>
                    <li class="feature-item">
                        <div class="feature-icon" style="background: linear-gradient(135deg, #27ae60, #2ecc71);">
                            <i class="fas fa-rocket"></i>
                        </div>
                        <span class="feature-text"><strong>Production:</strong> للاستخدام الفعلي</span>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>

<!-- Alert Modal -->
<div class="modal fade" id="connectionAlertModal" tabindex="-1" aria-labelledby="connectionAlertModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content" style="border: none; border-radius: 20px; overflow: hidden;">
            <div class="modal-header text-white text-center" id="modalHeader" style="background: linear-gradient(135deg, #27ae60, #2ecc71); border: none; padding: 25px;">
                <h5 class="modal-title w-100" id="connectionAlertModalLabel" style="font-weight: 700;">
                    <i class="fas fa-check-circle me-2" id="modalIcon"></i>
                    <span id="modalTitle">حالة الاتصال</span>
                </h5>
            </div>
            <div class="modal-body text-center" style="padding: 30px;">
                <div id="modalMessage" style="font-size: 1.1rem; font-weight: 500; color: #2c3e50;">
                    <!-- سيتم عرض الرسالة هنا -->
                </div>
            </div>
            <div class="modal-footer justify-content-center" style="border: none; padding: 20px 30px 30px;">
                <button type="button" class="btn btn-primary btn-enhanced" data-bs-dismiss="modal" style="min-width: 120px;">
                    <i class="fas fa-check me-2"></i>
                    حسناً
                </button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function testConnection(settingsId) {
    const button = event.target;
    const originalText = button.innerHTML;
    
    button.disabled = true;
    button.innerHTML = '<i class="fas fa-spinner fa-spin me-1"></i>جاري الاختبار...';
    
    fetch('{{ route("zatca-settings.test-connection") }}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        },
        body: JSON.stringify({
            zatca_settings_id: settingsId
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showConnectionModal('✅ تم الاتصال بنجاح مع ZATCA', 'success');
            setTimeout(() => {
                location.reload(); // إعادة تحميل الصفحة لعرض الحالة المحدثة
            }, 2000);
        } else {
            showConnectionModal('❌ ' + data.message, 'error');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showConnectionModal('❌ حدث خطأ أثناء اختبار الاتصال', 'error');
    })
    .finally(() => {
        button.disabled = false;
        button.innerHTML = originalText;
    });
}

function showConnectionModal(message, type) {
    const modal = document.getElementById('connectionAlertModal');
    const modalHeader = document.getElementById('modalHeader');
    const modalIcon = document.getElementById('modalIcon');
    const modalTitle = document.getElementById('modalTitle');
    const modalMessage = document.getElementById('modalMessage');
    
    // تحديد لون وأيقونة الـ modal حسب نوع الرسالة
    if (type === 'success') {
        modalHeader.style.background = 'linear-gradient(135deg, #27ae60, #2ecc71)';
        modalIcon.className = 'fas fa-check-circle me-2';
        modalTitle.textContent = 'نجح الاتصال';
    } else {
        modalHeader.style.background = 'linear-gradient(135deg, #e74c3c, #c0392b)';
        modalIcon.className = 'fas fa-times-circle me-2';
        modalTitle.textContent = 'فشل الاتصال';
    }
    
    modalMessage.textContent = message;
    
    // عرض الـ modal
    const bsModal = new bootstrap.Modal(modal);
    bsModal.show();
}

// تحديث الصفحة كل 5 دقائق لعرض أحدث حالة
setTimeout(function() {
    location.reload();
}, 300000);
</script>
@endpush