@extends('layouts.app')

@section('title', 'تعديل إعدادات ZATCA - ' . $zatcaSetting->company->name)
@section('page-title', 'تعديل إعدادات ZATCA')

@section('page-actions')
<div class="btn-group">
    <a href="{{ route('zatca-settings.show', $zatcaSetting) }}" class="btn btn-secondary">
        <i class="fas fa-eye me-2"></i>
        عرض الإعدادات
    </a>
    <a href="{{ route('zatca-settings.index') }}" class="btn btn-outline-secondary">
        <i class="fas fa-arrow-left me-2"></i>
        العودة للقائمة
    </a>
</div>
@endsection

@section('content')
<form method="POST" action="{{ route('zatca-settings.update', $zatcaSetting) }}" id="zatca-form">
    @csrf
    @method('PUT')
    
    <div class="row">
        <div class="col-lg-8">
            <!-- معلومات الشركة (للعرض فقط) -->
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-building me-2"></i>
                        معلومات الشركة
                    </h5>
                </div>
                <div class="card-body">
                    <div class="alert alert-info">
                        <h6><i class="fas fa-info-circle me-2"></i>الشركة المرتبطة:</h6>
                        <p class="mb-1"><strong>{{ $zatcaSetting->company->name }}</strong></p>
                        <p class="mb-1">الرقم الضريبي: {{ $zatcaSetting->company->vat_number }}</p>
                        <p class="mb-0">السجل التجاري: {{ $zatcaSetting->company->cr_number }}</p>
                    </div>
                    <small class="text-muted">لا يمكن تغيير الشركة المرتبطة بعد إنشاء الإعدادات</small>
                </div>
            </div>
            
            <!-- نوع الربط -->
            <div class="card mt-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-link me-2"></i>
                        نوع الربط مع ZATCA
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-check form-check-card">
                                <input type="radio" name="connection_type" value="clearance" class="form-check-input" 
                                       id="clearance" {{ old('connection_type', $zatcaSetting->connection_type) == 'clearance' ? 'checked' : '' }} 
                                       onchange="updateConnectionType()">
                                <label class="form-check-label w-100" for="clearance">
                                    <div class="card h-100">
                                        <div class="card-body text-center">
                                            <i class="fas fa-shield-alt fa-3x text-primary mb-3"></i>
                                            <h5>Clearance</h5>
                                            <p class="text-muted mb-0">للفواتير المعيارية (B2B)</p>
                                            <small class="text-muted">يتطلب موافقة ZATCA قبل الإصدار</small>
                                        </div>
                                    </div>
                                </label>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-check form-check-card">
                                <input type="radio" name="connection_type" value="reporting" class="form-check-input" 
                                       id="reporting" {{ old('connection_type', $zatcaSetting->connection_type) == 'reporting' ? 'checked' : '' }} 
                                       onchange="updateConnectionType()">
                                <label class="form-check-label w-100" for="reporting">
                                    <div class="card h-100">
                                        <div class="card-body text-center">
                                            <i class="fas fa-file-alt fa-3x text-info mb-3"></i>
                                            <h5>Reporting</h5>
                                            <p class="text-muted mb-0">للفواتير المبسطة (B2C)</p>
                                            <small class="text-muted">إرسال للإبلاغ بعد الإصدار</small>
                                        </div>
                                    </div>
                                </label>
                            </div>
                        </div>
                    </div>
                    @error('connection_type')
                        <div class="text-danger mt-2">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            
            <!-- البيئة -->
            <div class="card mt-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-server me-2"></i>
                        بيئة التشغيل
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-check form-check-card">
                                <input type="radio" name="environment" value="sandbox" class="form-check-input" 
                                       id="sandbox" {{ old('environment', $zatcaSetting->environment) == 'sandbox' ? 'checked' : '' }}>
                                <label class="form-check-label w-100" for="sandbox">
                                    <div class="card h-100">
                                        <div class="card-body text-center">
                                            <i class="fas fa-flask fa-3x text-warning mb-3"></i>
                                            <h5>Sandbox</h5>
                                            <p class="text-muted mb-0">بيئة تجريبية</p>
                                            <small class="text-muted">للاختبار والتطوير فقط</small>
                                        </div>
                                    </div>
                                </label>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-check form-check-card">
                                <input type="radio" name="environment" value="production" class="form-check-input" 
                                       id="production" {{ old('environment', $zatcaSetting->environment) == 'production' ? 'checked' : '' }}>
                                <label class="form-check-label w-100" for="production">
                                    <div class="card h-100">
                                        <div class="card-body text-center">
                                            <i class="fas fa-globe fa-3x text-success mb-3"></i>
                                            <h5>Production</h5>
                                            <p class="text-muted mb-0">بيئة الإنتاج</p>
                                            <small class="text-muted">للاستخدام الفعلي</small>
                                        </div>
                                    </div>
                                </label>
                            </div>
                        </div>
                    </div>
                    @error('environment')
                        <div class="text-danger mt-2">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            
            <!-- بيانات الاعتماد -->
            <div class="card mt-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-key me-2"></i>
                        بيانات الاعتماد
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <label class="form-label">Client ID</label>
                            <input type="text" name="client_id" class="form-control @error('client_id') is-invalid @enderror" 
                                   value="{{ old('client_id', $zatcaSetting->client_id) }}" placeholder="معرف العميل من ZATCA">
                            @error('client_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="col-md-6">
                            <label class="form-label">Client Secret</label>
                            <input type="password" name="client_secret" class="form-control @error('client_secret') is-invalid @enderror" 
                                   value="{{ old('client_secret', $zatcaSetting->client_secret) }}" placeholder="كلمة المرور السرية">
                            <small class="form-text text-muted">اتركه فارغاً للاحتفاظ بالقيمة الحالية</small>
                            @error('client_secret')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="row mt-3">
                        <div class="col-md-6">
                            <label class="form-label">Username</label>
                            <input type="text" name="username" class="form-control @error('username') is-invalid @enderror" 
                                   value="{{ old('username', $zatcaSetting->username) }}" placeholder="اسم المستخدم">
                            @error('username')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="col-md-6">
                            <label class="form-label">Password</label>
                            <input type="password" name="password" class="form-control @error('password') is-invalid @enderror" 
                                   value="{{ old('password', $zatcaSetting->password) }}" placeholder="كلمة المرور">
                            <small class="form-text text-muted">اتركه فارغاً للاحتفاظ بالقيمة الحالية</small>
                            @error('password')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- الشهادات الرقمية -->
            <div class="card mt-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-certificate me-2"></i>
                        الشهادات الرقمية
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <label class="form-label">محتوى الشهادة (Certificate)</label>
                            <textarea name="certificate_content" class="form-control @error('certificate_content') is-invalid @enderror" 
                                      rows="5" placeholder="-----BEGIN CERTIFICATE-----&#10;...&#10;-----END CERTIFICATE-----">{{ old('certificate_content', $zatcaSetting->certificate_content) }}</textarea>
                            <small class="form-text text-muted">اتركه فارغاً للاحتفاظ بالشهادة الحالية</small>
                            @error('certificate_content')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="row mt-3">
                        <div class="col-12">
                            <label class="form-label">المفتاح الخاص (Private Key)</label>
                            <textarea name="private_key_content" class="form-control @error('private_key_content') is-invalid @enderror" 
                                      rows="5" placeholder="-----BEGIN PRIVATE KEY-----&#10;...&#10;-----END PRIVATE KEY-----">{{ old('private_key_content', $zatcaSetting->private_key_content) }}</textarea>
                            <small class="form-text text-muted">اتركه فارغاً للاحتفاظ بالمفتاح الحالي</small>
                            @error('private_key_content')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="row mt-3">
                        <div class="col-md-6">
                            <label class="form-label">تاريخ انتهاء الشهادة</label>
                            <input type="date" name="certificate_expires_at" class="form-control @error('certificate_expires_at') is-invalid @enderror" 
                                   value="{{ old('certificate_expires_at', $zatcaSetting->certificate_expires_at?->format('Y-m-d')) }}">
                            @error('certificate_expires_at')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- الإعدادات المتقدمة -->
            <div class="card mt-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-cogs me-2"></i>
                        الإعدادات المتقدمة
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <label class="form-label">عداد الفواتير</label>
                            <input type="number" name="invoice_counter" class="form-control @error('invoice_counter') is-invalid @enderror" 
                                   value="{{ old('invoice_counter', $zatcaSetting->invoice_counter) }}" min="0">
                            <small class="form-text text-muted">رقم تسلسلي للفواتير</small>
                            @error('invoice_counter')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-check mt-4">
                                <input type="checkbox" name="is_active" class="form-check-input" 
                                       value="1" {{ old('is_active', $zatcaSetting->is_active) ? 'checked' : '' }}>
                                <label class="form-check-label">
                                    إعدادات نشطة
                                </label>
                                <div class="form-text">يجب تفعيل الإعدادات لاستخدامها</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- معاينة الإعدادات -->
        <div class="col-lg-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-eye me-2"></i>
                        معاينة الإعدادات
                    </h5>
                </div>
                <div class="card-body">
                    <div id="settings-preview">
                        <div class="text-center mb-3">
                            <div class="bg-light p-3 rounded">
                                <i class="fas fa-cog fa-2x text-primary mb-2"></i>
                                <h6>{{ $zatcaSetting->company->name }}</h6>
                            </div>
                        </div>
                        
                        <div class="mb-2">
                            <strong>نوع الربط:</strong>
                            <span id="preview-connection-type" class="badge {{ $zatcaSetting->connection_type == 'clearance' ? 'bg-primary' : 'bg-info' }}">
                                {{ $zatcaSetting->connection_type == 'clearance' ? 'Clearance' : 'Reporting' }}
                            </span>
                        </div>
                        
                        <div class="mb-2">
                            <strong>البيئة:</strong>
                            <span id="preview-environment" class="badge {{ $zatcaSetting->environment == 'sandbox' ? 'bg-warning' : 'bg-success' }}">
                                {{ $zatcaSetting->environment == 'sandbox' ? 'تجريبية' : 'إنتاج' }}
                            </span>
                        </div>
                        
                        <div class="mb-2">
                            <strong>الحالة:</strong>
                            <span id="preview-status" class="badge {{ $zatcaSetting->is_active ? 'bg-success' : 'bg-secondary' }}">
                                {{ $zatcaSetting->is_active ? 'نشط' : 'غير نشط' }}
                            </span>
                        </div>
                        
                        <div class="mb-2">
                            <strong>عداد الفواتير:</strong>
                            <span id="preview-counter">{{ number_format($zatcaSetting->invoice_counter) }}</span>
                        </div>
                    </div>
                    
                    <div class="d-grid mt-3">
                        <button type="submit" class="btn btn-success">
                            <i class="fas fa-save me-2"></i>
                            حفظ التعديلات
                        </button>
                    </div>
                </div>
            </div>
            
            <!-- الحالة الحالية -->
            <div class="card mt-3">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-info-circle me-2"></i>
                        الحالة الحالية
                    </h6>
                </div>
                <div class="card-body">
                    <div class="list-group list-group-flush">
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            حالة الاتصال
                            @switch($zatcaSetting->connection_status)
                                @case('connected')
                                    <span class="badge bg-success">متصل</span>
                                    @break
                                @case('failed')
                                    <span class="badge bg-danger">فشل</span>
                                    @break
                                @default
                                    <span class="badge bg-secondary">غير مختبر</span>
                            @endswitch
                        </div>
                        
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            الشهادة الرقمية
                            @if($zatcaSetting->certificate_content)
                                @if($zatcaSetting->certificate_expires_at && $zatcaSetting->certificate_expires_at->isPast())
                                    <span class="badge bg-danger">منتهية</span>
                                @else
                                    <span class="badge bg-success">صالحة</span>
                                @endif
                            @else
                                <span class="badge bg-warning">غير مُحمّلة</span>
                            @endif
                        </div>
                        
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            الرمز المميز
                            @if($zatcaSetting->access_token)
                                @if($zatcaSetting->token_expires_at && $zatcaSetting->token_expires_at->isPast())
                                    <span class="badge bg-danger">منتهي</span>
                                @else
                                    <span class="badge bg-success">صالح</span>
                                @endif
                            @else
                                <span class="badge bg-secondary">غير متوفر</span>
                            @endif
                        </div>
                    </div>
                    
                    @if($zatcaSetting->last_connection_test)
                        <hr>
                        <div class="text-center">
                            <small class="text-muted">
                                آخر اختبار: {{ $zatcaSetting->last_connection_test->diffForHumans() }}
                            </small>
                        </div>
                    @endif
                </div>
            </div>
            
            <!-- تحذيرات -->
            <div class="card mt-3">
                <div class="card-header">
                    <h6 class="card-title mb-0 text-warning">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        تنبيهات مهمة
                    </h6>
                </div>
                <div class="card-body">
                    <div class="alert alert-warning">
                        <h6>تأكد من:</h6>
                        <ul class="mb-0 small">
                            <li>صحة بيانات الاعتماد</li>
                            <li>تطابق الشهادة مع البيئة المختارة</li>
                            <li>صلاحية الشهادة الرقمية</li>
                            <li>اختبار الاتصال بعد الحفظ</li>
                        </ul>
                    </div>
                    
                    @if($zatcaSetting->company->invoices->count() > 0)
                        <div class="alert alert-info">
                            <small>
                                هذه الشركة لديها {{ $zatcaSetting->company->invoices->count() }} فاتورة.
                                تأكد من عدم تأثير التعديلات على الفواتير الموجودة.
                            </small>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</form>
@endsection

@push('styles')
<style>
.form-check-card .form-check-input {
    position: absolute;
    top: 10px;
    right: 10px;
}

.form-check-card .card {
    cursor: pointer;
    transition: all 0.3s ease;
    border: 2px solid #e9ecef;
}

.form-check-card .form-check-input:checked + .form-check-label .card {
    border-color: #007bff;
    background-color: #f8f9ff;
}

.form-check-card .card:hover {
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
}
</style>
@endpush

@push('scripts')
<script>
function updateConnectionType() {
    updatePreview();
}

function updatePreview() {
    const connectionType = document.querySelector('input[name="connection_type"]:checked');
    const environment = document.querySelector('input[name="environment"]:checked');
    const isActive = document.querySelector('input[name="is_active"]').checked;
    const counter = document.querySelector('input[name="invoice_counter"]').value;
    
    // تحديث نوع الربط
    if (connectionType) {
        const connectionBadge = document.getElementById('preview-connection-type');
        connectionBadge.textContent = connectionType.value === 'clearance' ? 'Clearance' : 'Reporting';
        connectionBadge.className = connectionType.value === 'clearance' ? 'badge bg-primary' : 'badge bg-info';
    }
    
    // تحديث البيئة
    if (environment) {
        const environmentBadge = document.getElementById('preview-environment');
        environmentBadge.textContent = environment.value === 'sandbox' ? 'تجريبية' : 'إنتاج';
        environmentBadge.className = environment.value === 'sandbox' ? 'badge bg-warning' : 'badge bg-success';
    }
    
    // تحديث الحالة
    const statusBadge = document.getElementById('preview-status');
    statusBadge.textContent = isActive ? 'نشط' : 'غير نشط';
    statusBadge.className = isActive ? 'badge bg-success' : 'badge bg-secondary';
    
    // تحديث العداد
    document.getElementById('preview-counter').textContent = counter ? parseInt(counter).toLocaleString() : '0';
}

// ربط الأحداث
document.addEventListener('DOMContentLoaded', function() {
    // ربط أحداث الراديو والتشيك بوكس
    document.querySelectorAll('input[type="radio"], input[type="checkbox"]').forEach(input => {
        input.addEventListener('change', updatePreview);
    });
    
    // ربط حدث تغيير العداد
    document.querySelector('input[name="invoice_counter"]').addEventListener('input', updatePreview);
    
    // تحديث المعاينة عند التحميل
    updatePreview();
});

// التحقق من البيانات قبل الإرسال
document.getElementById('zatca-form').addEventListener('submit', function(e) {
    const connectionType = document.querySelector('input[name="connection_type"]:checked');
    const environment = document.querySelector('input[name="environment"]:checked');
    
    if (!connectionType || !environment) {
        e.preventDefault();
        alert('يجب اختيار نوع الربط والبيئة');
    }
});
</script>
@endpush