@extends('layouts.app')

@section('title', 'تهيئة جهاز جديد للربط مع هيئة الزكاة')
@section('page-title', 'تهيئة جهاز جديد للربط مع هيئة الزكاة والضريبة والجمارك')

@push('meta')
<meta name="csrf-token" content="{{ csrf_token() }}">
@endpush

@section('page-actions')
<a href="{{ route('zatca-settings.index') }}" class="btn btn-secondary">
    <i class="fas fa-arrow-left me-2"></i>
    العودة للقائمة
</a>
@endsection

@section('content')
<div class="row justify-content-center">
    <div class="col-lg-8">
        <!-- معلومات تمهيدية -->
        <div class="card border-info mb-4">
            <div class="card-header bg-info text-white">
                <h5 class="card-title mb-0 text-center">
                    <i class="fas fa-shield-alt me-2"></i>
                    المرحلة الثانية - مرحلة التكامل
                </h5>
            </div>
            <div class="card-body">
                <div class="alert alert-info mb-0">
                    <div class="row text-center">
                        <div class="col-md-4">
                            <i class="fas fa-certificate fa-2x text-primary mb-2"></i>
                            <h6>إدخال رقم الشهادة</h6>
                            <small>CSID Certificate Number</small>
                        </div>
                        <div class="col-md-4">
                            <i class="fas fa-mobile-alt fa-2x text-warning mb-2"></i>
                            <h6>طلب رمز التفعيل</h6>
                            <small>OTP Request</small>
                        </div>
                        <div class="col-md-4">
                            <i class="fas fa-check-circle fa-2x text-success mb-2"></i>
                            <h6>تأكيد المصادقة</h6>
                            <small>Authentication Confirmation</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- نموذج تهيئة الجهاز -->
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-laptop me-2"></i>
                    تهيئة جهاز جديد
                </h5>
            </div>
            <div class="card-body">
                <form id="device-initialization-form">
                    @csrf

                    <!-- اختيار الشركة -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <label class="form-label">الشركة <span class="text-danger">*</span></label>
                            <select name="company_id" id="company_id" class="form-select" required>
                                <option value="">اختر الشركة</option>
                                @if(isset($companies))
                                    @foreach($companies as $company)
                                        <option value="{{ $company->id }}" data-vat="{{ $company->vat_number }}">
                                            {{ $company->name }} ({{ $company->vat_number }})
                                        </option>
                                    @endforeach
                                @endif
                            </select>
                            <div class="invalid-feedback"></div>
                        </div>
                    </div>

                    <!-- المرحلة الأولى: إدخال رقم شهادة CSID -->
                    <div id="step-1" class="initialization-step d-none">
                        <div class="row">
                            <div class="col-12">
                                <div class="card border-primary">
                                    <div class="card-header bg-primary text-white">
                                        <h6 class="card-title mb-0">
                                            <span class="badge bg-light text-primary me-2">1</span>
                                            إدخال رقم شهادة CSID
                                        </h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="alert alert-info">
                                            <i class="fas fa-info-circle me-2"></i>
                                            <strong>تحقّق من صحة رقم الشهادة قبل طلب الرمز</strong>
                                            <br>
                                            <small>يجب إدخال رقم شهادة CSID الصحيح الذي حصلت عليه من هيئة الزكاة والضريبة والجمارك</small>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-8">
                                                <label class="form-label">رقم شهادة CSID <span class="text-danger">*</span></label>
                                                <input type="text" name="csid_number" id="csid_number"
                                                       class="form-control form-control-lg"
                                                       placeholder="أدخل رقم شهادة CSID"
                                                       required>
                                                <div class="invalid-feedback"></div>
                                                <small class="form-text text-muted">
                                                    مثال: TUlJQ2lqQ0NBakNnQXdJQkFnSUNBVEF3Q2dZSUtvWklK
                                                </small>
                                            </div>
                                            <div class="col-md-4 d-flex align-items-end">
                                                <button type="button" id="request-otp-btn" class="btn btn-warning btn-lg w-100">
                                                    <i class="fas fa-paper-plane me-2"></i>
                                                    طلب رمز التفعيل
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- المرحلة الثانية: إدخال رمز OTP -->
                    <div id="step-2" class="initialization-step">
                        <div class="row mt-4">
                            <div class="col-12">
                                <div class="card border-warning">
                                    <div class="card-header bg-warning text-dark">
                                        <h6 class="card-title mb-0">
                                            <span class="badge bg-light text-warning me-2">1</span>
                                            إدخال رمز التفعيل (OTP)
                                        </h6>
                                    </div>
                                    <div class="card-body">
{{--                                        <div class="alert alert-warning">--}}
{{--                                            <i class="fas fa-clock me-2"></i>--}}
{{--                                            <strong>رمز التفعيل صالح لمدة 5 دقائق فقط</strong>--}}
{{--                                            <br>--}}
{{--                                            <small>تم إرسال رمز التفعيل إلى الرقم المسجل لديكم في هيئة الزكاة والضريبة والجمارك</small>--}}
{{--                                        </div>--}}

                                        <div class="row">
                                            <div class="col-md-6">
                                                <label class="form-label">رمز التفعيل (OTP) <span class="text-danger">*</span></label>
                                                <input type="text" name="otp_code" id="otp_code"
                                                       class="form-control form-control-lg text-center"
                                                       placeholder="أدخل رمز التفعيل"
                                                       maxlength="6" pattern="[0-9]{6}"
                                                       style="letter-spacing: 0.5em; font-size: 1.5rem;">
                                                <div class="invalid-feedback"></div>
                                            </div>
                                            <div class="col-md-3 d-flex align-items-center" style="display: none !important;">
                                                <div class="text-center w-100">
                                                    <div id="countdown-timer" class="h4 text-danger mb-0">05:00</div>
                                                    <small class="text-muted">الوقت المتبقي</small>
                                                </div>
                                            </div>
                                            <div class="col-md-3 d-flex align-items-end">
                                                <div class="d-grid w-100 gap-2">
                                                    <button type="button" id="verify-otp-btn" class="btn btn-success btn-lg">
                                                        <i class="fas fa-check me-2"></i>
                                                        تسجيل الجهاز
                                                    </button>
                                                    <button type="button" id="resend-otp-btn" class="btn btn-outline-secondary btn-sm" style="display: none !important;">
                                                        <i class="fas fa-redo me-2"></i>
                                                        إعادة الإرسال
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- عرض حالة المصادقة -->
                    <div id="authentication-status" class="mt-4 d-none">
                        <div id="success-message" class="card border-success d-none">
                            <div class="card-header bg-success text-white">
                                <h6 class="card-title mb-0">
                                    <i class="fas fa-check-circle me-2"></i>
                                    تم تسجيل الجهاز بنجاح
                                </h6>
                            </div>
                            <div class="card-body">
                                <div class="alert alert-success mb-0">
                                    <h6><i class="fas fa-thumbs-up me-2"></i>تمت المصادقة بنجاح!</h6>
                                    <p class="mb-2">تم ربط الجهاز بنجاح مع هيئة الزكاة والضريبة والجمارك</p>
                                    <ul class="mb-0">
                                        <li>تم التحقق من صحة شهادة CSID</li>
                                        <li>تم تأكيد رمز التفعيل OTP</li>
                                        <li>الجهاز جاهز لإرسال الفواتير الإلكترونية</li>
                                    </ul>
                                </div>
                                <div class="d-grid">
                                    <a href="{{ route('zatca-settings.index') }}" class="btn btn-success btn-lg">
                                        <i class="fas fa-arrow-right me-2"></i>
                                        الانتقال إلى إعدادات ZATCA
                                    </a>
                                </div>
                            </div>
                        </div>

                        <div id="error-message" class="card border-danger d-none">
                            <div class="card-header bg-danger text-white">
                                <h6 class="card-title mb-0">
                                    <i class="fas fa-exclamation-triangle me-2"></i>
                                    خطأ في المصادقة
                                </h6>
                            </div>
                            <div class="card-body">
                                <div class="alert alert-danger mb-3">
                                    <h6><i class="fas fa-times-circle me-2"></i>فشلت عملية المصادقة</h6>
                                    <p id="error-details" class="mb-0">حدث خطأ أثناء عملية المصادقة</p>
                                </div>
                                <div class="d-grid">
                                    <button type="button" id="retry-btn" class="btn btn-outline-danger">
                                        <i class="fas fa-redo me-2"></i>
                                        إعادة المحاولة
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- معلومات إضافية -->
        <div class="card mt-4">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-question-circle me-2"></i>
                    معلومات مهمة
                </h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="alert alert-info">
                            <h6><i class="fas fa-info-circle me-2"></i>خطوات التهيئة:</h6>
                            <ol class="mb-0 small">
                                <li>تأكد من صحة رقم شهادة CSID</li>
                                <li>اطلب رمز التفعيل من النظام</li>
                                <li>أدخل رمز OTP المستلم خلال 5 دقائق</li>
                                <li>أكمل عملية المصادقة</li>
                            </ol>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="alert alert-warning">
                            <h6><i class="fas fa-exclamation-triangle me-2"></i>في حالة المشاكل:</h6>
                            <ul class="mb-0 small">
                                <li>تحقق من صحة رقم الشهادة</li>
                                <li>تأكد من اتصال الإنترنت</li>
                                <li>انتظر انتهاء المهلة الزمنية للرمز السابق</li>
                                <li>اتصل بالدعم الفني إذا استمرت المشكلة</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Loading Modal -->
<div class="modal fade" id="loadingModal" tabindex="-1" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body text-center py-4">
                <div class="spinner-border text-primary mb-3" role="status" style="width: 3rem; height: 3rem;">
                    <span class="visually-hidden">جاري التحميل...</span>
                </div>
                <h5 id="loading-text">جاري المعالجة...</h5>
                <p class="text-muted mb-0" id="loading-description">يرجى الانتظار</p>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
.initialization-step {
    transition: all 0.3s ease;
}

.form-control-lg {
    border-radius: 0.5rem;
}

.card {
    box-shadow: 0 2px 10px rgba(0,0,0,0.08);
    border-radius: 0.75rem;
}

.card-header {
    border-radius: 0.75rem 0.75rem 0 0 !important;
}

.btn-lg {
    border-radius: 0.5rem;
    font-weight: 600;
}

#otp_code {
    font-family: 'Courier New', monospace;
    direction: ltr;
}

.countdown-expired {
    animation: pulse 1s infinite;
}

@keyframes pulse {
    0% { opacity: 1; }
    50% { opacity: 0.5; }
    100% { opacity: 1; }
}

.was-validated .form-control:invalid {
    border-color: #dc3545;
    padding-right: calc(1.5em + 0.75rem);
    background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 12 12' width='12' height='12' fill='none' stroke='%23dc3545'%3e%3ccircle cx='6' cy='6' r='4.5'/%3e%3cpath d='m5.8 3.6h.4L6 6.5z'/%3e%3ccircle cx='6' cy='8.2' r='.6' fill='%23dc3545' stroke='none'/%3e%3c/svg%3e");
    background-repeat: no-repeat;
    background-position: left calc(0.375em + 0.1875rem) center;
    background-size: calc(0.75em + 0.375rem) calc(0.75em + 0.375rem);
}

.was-validated .form-control:valid {
    border-color: #198754;
    padding-right: calc(1.5em + 0.75rem);
    background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 8 8'%3e%3cpath fill='%23198754' d='m2.3 6.73.94-.94 1.94 1.94 3.55-3.55.94.94L4.12 9.66z'/%3e%3c/svg%3e");
    background-repeat: no-repeat;
    background-position: left calc(0.375em + 0.1875rem) center;
    background-size: calc(0.75em + 0.375rem) calc(0.75em + 0.375rem);
}

/* RTL Adjustments */
[dir="rtl"] .was-validated .form-control:invalid,
[dir="rtl"] .was-validated .form-control:valid {
    background-position: right calc(0.375em + 0.1875rem) center;
    padding-left: calc(1.5em + 0.75rem);
    padding-right: 0.75rem;
}

/* Responsive design */
@media (max-width: 768px) {
    .col-md-3, .col-md-4, .col-md-6, .col-md-8 {
        margin-bottom: 1rem;
    }

    #countdown-timer {
        font-size: 1.5rem !important;
    }

    .btn-lg {
        padding: 0.75rem 1rem;
        font-size: 1rem;
    }
}
</style>
@endpush

@push('scripts')
<script>
class DeviceInitialization {
    constructor() {
        this.currentStep = 1;
        this.countdownTimer = null;
        this.otpExpired = false;
        this.timeRemaining = 300; // 5 minutes in seconds
        this.initializeEvents();
    }

    initializeEvents() {
        // طلب رمز OTP
        document.getElementById('request-otp-btn').addEventListener('click', () => {
            this.requestOTP();
        });

        // تأكيد رمز OTP
        document.getElementById('verify-otp-btn').addEventListener('click', () => {
            this.verifyOTP();
        });

        // إعادة إرسال OTP
        document.getElementById('resend-otp-btn').addEventListener('click', () => {
            this.resendOTP();
        });

        // إعادة المحاولة
        document.getElementById('retry-btn').addEventListener('click', () => {
            this.resetForm();
        });

        // تنسيق إدخال OTP
        document.getElementById('otp_code').addEventListener('input', (e) => {
            this.formatOTPInput(e.target);
        });

        // التحقق من صحة CSID عند الكتابة
        document.getElementById('csid_number').addEventListener('input', (e) => {
            this.validateCSID(e.target);
        });

        // Enter key support
        document.getElementById('csid_number').addEventListener('keypress', (e) => {
            if (e.key === 'Enter') {
                this.requestOTP();
            }
        });

        document.getElementById('otp_code').addEventListener('keypress', (e) => {
            if (e.key === 'Enter') {
                this.verifyOTP();
            }
        });
    }

    async requestOTP() {
        const companyId = document.getElementById('company_id').value;
        const csidNumber = document.getElementById('csid_number').value;

        // التحقق من البيانات المطلوبة
        if (!companyId) {
            this.showValidationError('company_id', 'يجب اختيار الشركة أولاً');
            document.getElementById('company_id').focus();
            return;
        }

        if (!csidNumber || csidNumber.length < 10) {
            this.showValidationError('csid_number', 'يجب إدخال رقم شهادة CSID صحيح (لا يقل عن 10 أحرف)');
            document.getElementById('csid_number').focus();
            return;
        }

        // إزالة رسائل الخطأ السابقة
        this.clearValidationErrors();

        this.showLoading('جاري طلب رمز التفعيل...', 'يتم الاتصال بهيئة الزكاة والضريبة والجمارك');

        try {
            const response = await fetch('{{ route("zatca-settings.request-otp") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: JSON.stringify({
                    company_id: companyId,
                    csid_number: csidNumber
                })
            });

            const result = await response.json();

            // إخفاء Loading
            this.hideLoading();

            if (result.success) {
                // الانتقال للخطوة التالية
                this.moveToStep(2);
                this.startCountdown();

                // إظهار رسالة نجاح
                this.showToast('success', result.message);
            } else {
                this.showToast('error', result.message);
            }

        } catch (error) {
            this.hideLoading();
            this.showToast('error', 'حدث خطأ أثناء طلب رمز التفعيل. يرجى المحاولة مرة أخرى.');
            console.error('OTP Request Error:', error);
        }
    }

    async verifyOTP() {
        const companyId = document.getElementById('company_id').value;
        const otpCode = document.getElementById('otp_code').value;
// التحقق من البيانات المطلوبة
        if (!companyId) {
            this.showValidationError('company_id', 'يجب اختيار الشركة أولاً');
            document.getElementById('company_id').focus();
            return;
        }
        if (!otpCode || otpCode.length !== 6) {
            this.showValidationError('otp_code', 'يجب إدخال رمز التفعيل المكون من 6 أرقام');
            document.getElementById('otp_code').focus();
            return;
        }

        if (!/^\d{6}$/.test(otpCode)) {
            this.showValidationError('otp_code', 'رمز التفعيل يجب أن يكون أرقاماً فقط');
            document.getElementById('otp_code').focus();
            return;
        }

        // if (this.otpExpired) {
        //     this.showValidationError('otp_code', 'انتهت صلاحية رمز التفعيل. يرجى طلب رمز جديد');
        //     return;
        // }

        this.clearValidationErrors();
        this.showLoading('جاري تسجيل الجهاز لدى الهيئة...', 'تسجيل الجهاز');

        try {
            const response = await fetch('{{ route("zatca-settings.verify-otp") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: JSON.stringify({
                    otp_code: otpCode,
                    company_id: companyId,
                })
            });

            const result = await response.json();
            console.log(result.success);

            this.hideLoading();

            if (result.success) {
                this.showAuthenticationSuccess(result.data);
                this.stopCountdown();
            } else {
                this.showAuthenticationError(result.message);
            }

        } catch (error) {
            console.log(error);
            this.hideLoading();
            this.showAuthenticationError('حدث خطأ أثناء التحقق من الرمز. يرجى المحاولة مرة أخرى.');
            console.error('OTP Verification Error:', error);
        }
    }

    async resendOTP() {
        const companyId = document.getElementById('company_id').value;
        const csidNumber = document.getElementById('csid_number').value;

        this.showLoading('جاري إعادة إرسال رمز التفعيل...', 'يرجى الانتظار');

        try {
            const response = await fetch('{{ route("zatca-settings.request-otp") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: JSON.stringify({
                    company_id: companyId,
                    csid_number: csidNumber
                })
            });

            const result = await response.json();

            this.hideLoading();

            if (result.success) {
                this.resetCountdown();
                this.startCountdown();
                document.getElementById('otp_code').value = '';
                this.clearValidationErrors();
                this.showToast('success', 'تم إعادة إرسال رمز التفعيل بنجاح');
            } else {
                this.showToast('error', result.message);
            }
        } catch (error) {
            this.hideLoading();
            this.showToast('error', 'حدث خطأ أثناء إعادة الإرسال. يرجى المحاولة مرة أخرى.');
            console.error('Resend OTP Error:', error);
        }
    }

    moveToStep(step) {
        // إخفاء جميع الخطوات
        document.querySelectorAll('.initialization-step').forEach(el => {
            el.classList.add('d-none');
        });

        // إظهار الخطوة المطلوبة
        if (step <= 2) {
            for (let i = 1; i <= step; i++) {
                document.getElementById(`step-${i}`).classList.remove('d-none');
            }
        }

        this.currentStep = step;

        // تركيز على الحقل المناسب
        if (step === 2) {
            setTimeout(() => {
                document.getElementById('otp_code').focus();
            }, 300);
        }
    }

    startCountdown() {
        this.timeRemaining = 300; // 5 minutes
        this.otpExpired = false;

        const timerElement = document.getElementById('countdown-timer');
        timerElement.classList.remove('countdown-expired');

        this.countdownTimer = setInterval(() => {
            this.timeRemaining--;

            const minutes = Math.floor(this.timeRemaining / 60);
            const seconds = this.timeRemaining % 60;

            timerElement.textContent = `${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`;

            if (this.timeRemaining <= 60) {
                timerElement.classList.add('countdown-expired');
            }

            if (this.timeRemaining <= 0) {
                this.stopCountdown();
                this.otpExpired = true;
                timerElement.textContent = '00:00';
                this.showToast('warning', 'انتهت صلاحية رمز التفعيل. يرجى طلب رمز جديد.');
            }
        }, 1000);
    }

    stopCountdown() {
        if (this.countdownTimer) {
            clearInterval(this.countdownTimer);
            this.countdownTimer = null;
        }
    }

    resetCountdown() {
        this.stopCountdown();
        this.timeRemaining = 300;
        this.otpExpired = false;
        document.getElementById('countdown-timer').textContent = '05:00';
        document.getElementById('countdown-timer').classList.remove('countdown-expired');
    }

    formatOTPInput(input) {
        // إزالة أي شيء غير رقمي
        input.value = input.value.replace(/\D/g, '');

        // تحديد الطول الأقصى
        if (input.value.length > 6) {
            input.value = input.value.substring(0, 6);
        }
    }

    validateCSID(input) {
        const value = input.value.trim();
        const isValid = value.length >= 10;

        if (value.length > 0) {
            if (isValid) {
                input.classList.remove('is-invalid');
                input.classList.add('is-valid');
            } else {
                input.classList.remove('is-valid');
                input.classList.add('is-invalid');
            }
        } else {
            input.classList.remove('is-valid', 'is-invalid');
        }
    }

    showAuthenticationSuccess(data = null) {
        document.getElementById('authentication-status').classList.remove('d-none');
        document.getElementById('success-message').classList.remove('d-none');
        document.getElementById('error-message').classList.add('d-none');

        // إضافة معلومات إضافية إذا توفرت
        // if (data && data.company_name) {
        //     const successAlert = document.querySelector('#success-message .alert-success');
        //     console.log(successAlert);
        //     const additionalInfo = document.createElement('div');
        //     additionalInfo.innerHTML = `
        //         <hr class="my-2">
        //         <small class="text-muted">
        //             <strong>الشركة:</strong> ${data.company_name}<br>
        //             ${data.certificate_expires_at ? `<strong>تنتهي الشهادة في:</strong> ${new Date(data.certificate_expires_at).toLocaleDateString('ar-SA')}` : ''}
        //         </small>
        //     `;
        //     successAlert.appendChild(additionalInfo);
        // }

        // تمرير الصفحة للرسالة
        document.getElementById('authentication-status').scrollIntoView({
            behavior: 'smooth',
            block: 'center'
        });
    }

    showAuthenticationError(message) {
        document.getElementById('authentication-status').classList.remove('d-none');
        document.getElementById('error-message').classList.remove('d-none');
        document.getElementById('success-message').classList.add('d-none');
        document.getElementById('error-details').textContent = message;

        // تمرير الصفحة للرسالة
        document.getElementById('authentication-status').scrollIntoView({
            behavior: 'smooth',
            block: 'center'
        });
    }

    resetForm() {
        // إعادة تعيين النموذج
        document.getElementById('device-initialization-form').reset();

        // إخفاء الخطوات والرسائل
        document.getElementById('step-2').classList.add('d-none');
        document.getElementById('authentication-status').classList.add('d-none');

        // إعادة تعيين المؤقت
        this.resetCountdown();

        // إزالة فئات التحقق
        this.clearValidationErrors();

        // العودة للخطوة الأولى
        this.currentStep = 1;

        // تركيز على حقل CSID
        document.getElementById('csid_number').focus();
    }

    showValidationError(fieldId, message) {
        const field = document.getElementById(fieldId);
        const feedback = field.nextElementSibling;

        field.classList.add('is-invalid');
        field.classList.remove('is-valid');

        if (feedback && feedback.classList.contains('invalid-feedback')) {
            feedback.textContent = message;
        }
    }

    clearValidationErrors() {
        document.querySelectorAll('.form-control').forEach(field => {
            field.classList.remove('is-invalid', 'is-valid');
        });

        document.querySelectorAll('.invalid-feedback').forEach(feedback => {
            feedback.textContent = '';
        });
    }

    showLoading(title, description) {
        document.getElementById('loading-text').textContent = title;
        document.getElementById('loading-description').textContent = description;

        const modal = new bootstrap.Modal(document.getElementById('loadingModal'));
        modal.show();
    }

    hideLoading() {
        const modal = bootstrap.Modal.getInstance(document.getElementById('loadingModal'));
        if (modal) {
            modal.hide();
        }
    }

    showToast(type, message) {
        // إنشاء عنصر Toast
        const toastContainer = document.querySelector('.toast-container') || this.createToastContainer();

        const toast = document.createElement('div');
        toast.className = `toast align-items-center text-white bg-${type === 'success' ? 'success' : type === 'error' ? 'danger' : 'warning'} border-0`;
        toast.setAttribute('role', 'alert');
        toast.setAttribute('aria-live', 'assertive');
        toast.setAttribute('aria-atomic', 'true');

        toast.innerHTML = `
            <div class="d-flex">
                <div class="toast-body">
                    <i class="fas fa-${type === 'success' ? 'check-circle' : type === 'error' ? 'exclamation-circle' : 'exclamation-triangle'} me-2"></i>
                    ${message}
                </div>
                <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
            </div>
        `;

        toastContainer.appendChild(toast);

        const bsToast = new bootstrap.Toast(toast);
        bsToast.show();

        // إزالة Toast بعد الإخفاء
        toast.addEventListener('hidden.bs.toast', () => {
            toast.remove();
        });
    }

    createToastContainer() {
        const container = document.createElement('div');
        container.className = 'toast-container position-fixed top-0 end-0 p-3';
        container.style.zIndex = '9999';
        document.body.appendChild(container);
        return container;
    }

}

// تهيئة الفئة عند تحميل الصفحة
document.addEventListener('DOMContentLoaded', function() {
    new DeviceInitialization();
});
</script>
@endpush
