@extends('layouts.app')

@section('title', 'لوحة تحكم ZATCA')
@section('page-title', 'لوحة تحكم هيئة الزكاة والضريبة والجمارك')

@section('page-actions')
<div class="d-flex gap-2">
    <a href="{{ route('zatca-settings.device-initialization') }}" class="btn btn-success">
        <i class="fas fa-laptop me-2"></i>
        تهيئة جهاز جديد
    </a>
    <a href="{{ route('zatca-settings.index') }}" class="btn btn-primary">
        <i class="fas fa-cog me-2"></i>
        إدارة الإعدادات
    </a>
</div>
@endsection

@push('styles')
<style>
    .dashboard-card {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border-radius: 20px;
        padding: 30px;
        color: white;
        margin-bottom: 30px;
        position: relative;
        overflow: hidden;
    }

    .dashboard-card::before {
        content: '';
        position: absolute;
        top: -50%;
        right: -50%;
        width: 200%;
        height: 200%;
        background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
        animation: rotate 20s linear infinite;
    }

    @keyframes rotate {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }

    .stat-card {
        background: white;
        border-radius: 15px;
        padding: 25px;
        box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        transition: transform 0.3s ease;
        border-left: 4px solid #3498db;
    }

    .stat-card:hover {
        transform: translateY(-5px);
    }

    .stat-icon {
        width: 60px;
        height: 60px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.5rem;
        color: white;
        margin-bottom: 15px;
    }

    .stat-number {
        font-size: 2.5rem;
        font-weight: 800;
        color: #2c3e50;
        margin-bottom: 5px;
    }

    .stat-label {
        color: #7f8c8d;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 1px;
        font-size: 0.9rem;
    }

    .chart-container {
        background: white;
        border-radius: 15px;
        padding: 25px;
        box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        margin-bottom: 30px;
    }

    .recent-activity {
        background: white;
        border-radius: 15px;
        padding: 25px;
        box-shadow: 0 5px 20px rgba(0,0,0,0.1);
    }

    .activity-item {
        display: flex;
        align-items: center;
        padding: 15px 0;
        border-bottom: 1px solid #ecf0f1;
    }

    .activity-icon {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-left: 15px;
        color: white;
    }

    .activity-content {
        flex: 1;
    }

    .activity-time {
        color: #95a5a6;
        font-size: 0.85rem;
    }

    .progress-ring {
        width: 120px;
        height: 120px;
        position: relative;
    }

    .progress-ring svg {
        transform: rotate(-90deg);
    }

    .progress-ring-circle {
        fill: transparent;
        stroke-width: 8;
        stroke-linecap: round;
    }

    .alert-warning {
        background: linear-gradient(135deg, #f39c12, #e67e22);
        border: none;
        color: white;
        border-radius: 15px;
    }

    .alert-success {
        background: linear-gradient(135deg, #27ae60, #2ecc71);
        border: none;
        color: white;
        border-radius: 15px;
    }
</style>
@endpush

@section('content')
<!-- Header Dashboard -->
<div class="dashboard-card">
    <div class="row align-items-center position-relative" style="z-index: 2;">
        <div class="col-md-8">
            <h2 class="mb-3">
                <i class="fas fa-shield-alt me-3"></i>
                نظام ZATCA المتكامل
            </h2>
            <p class="mb-0 fs-5 opacity-90">
                مراقبة وإدارة شاملة للربط الإلكتروني مع هيئة الزكاة والضريبة والجمارك
            </p>
        </div>
        <div class="col-md-4 text-center">
            <div class="progress-ring">
                <svg width="120" height="120">
                    <circle class="progress-ring-circle" 
                            stroke="rgba(255,255,255,0.3)" 
                            r="52" cx="60" cy="60"/>
                    <circle class="progress-ring-circle" 
                            stroke="white" 
                            r="52" cx="60" cy="60"
                            stroke-dasharray="327"
                            stroke-dashoffset="{{ 327 - (327 * ($successRate ?? 75) / 100) }}"/>
                </svg>
                <div class="position-absolute top-50 start-50 translate-middle text-center">
                    <div class="h3 mb-0">{{ $successRate ?? 75 }}%</div>
                    <small>معدل النجاح</small>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Statistics Cards -->
<div class="row mb-4">
    <div class="col-lg-3 col-md-6 mb-4">
        <div class="stat-card">
            <div class="stat-icon" style="background: linear-gradient(135deg, #3498db, #2980b9);">
                <i class="fas fa-building"></i>
            </div>
            <div class="stat-number">{{ $stats['companies']['total'] ?? 0 }}</div>
            <div class="stat-label">إجمالي الشركات</div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-4">
        <div class="stat-card">
            <div class="stat-icon" style="background: linear-gradient(135deg, #27ae60, #2ecc71);">
                <i class="fas fa-check-circle"></i>
            </div>
            <div class="stat-number">{{ $stats['zatca_settings']['connected'] ?? 0 }}</div>
            <div class="stat-label">اتصالات نشطة</div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-4">
        <div class="stat-card">
            <div class="stat-icon" style="background: linear-gradient(135deg, #f39c12, #e67e22);">
                <i class="fas fa-certificate"></i>
            </div>
            <div class="stat-number">{{ $stats['certificates']['valid'] ?? 0 }}</div>
            <div class="stat-label">شهادات صالحة</div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-4">
        <div class="stat-card">
            <div class="stat-icon" style="background: linear-gradient(135deg, #9b59b6, #8e44ad);">
                <i class="fas fa-sync"></i>
            </div>
            <div class="stat-number">{{ $stats['device_initialization']['verified'] ?? 0 }}</div>
            <div class="stat-label">تهيئة مكتملة</div>
        </div>
    </div>
</div>

<div class="row">
    <!-- Chart Section -->
    <div class="col-lg-8 mb-4">
        <div class="chart-container">
            <h5 class="mb-4">
                <i class="fas fa-chart-line me-2 text-primary"></i>
                إحصائيات تهيئة الأجهزة (آخر 7 أيام)
            </h5>
            <canvas id="initializationChart" height="300"></canvas>
        </div>
        
        <!-- Alerts Section -->
        @if($alerts ?? false)
        <div class="row">
            @if(($stats['certificates']['expired'] ?? 0) > 0)
            <div class="col-md-6 mb-3">
                <div class="alert alert-warning">
                    <h6><i class="fas fa-exclamation-triangle me-2"></i>تنبيه الشهادات</h6>
                    <p class="mb-0">{{ $stats['certificates']['expired'] }} شهادة منتهية الصلاحية تحتاج لتجديد</p>
                </div>
            </div>
            @endif
            
            @if(($stats['zatca_settings']['failed'] ?? 0) > 0)
            <div class="col-md-6 mb-3">
                <div class="alert alert-warning">
                    <h6><i class="fas fa-wifi me-2"></i>اتصالات فاشلة</h6>
                    <p class="mb-0">{{ $stats['zatca_settings']['failed'] }} اتصال فاشل يحتاج مراجعة</p>
                </div>
            </div>
            @endif
        </div>
        @endif
    </div>
    
    <!-- Recent Activity -->
    <div class="col-lg-4 mb-4">
        <div class="recent-activity">
            <h5 class="mb-4">
                <i class="fas fa-history me-2 text-success"></i>
                النشاط الأخير
            </h5>
            
            @forelse($recentActivities ?? [] as $activity)
            <div class="activity-item">
                <div class="activity-icon" style="background: {{ $activity['color'] ?? '#3498db' }};">
                    <i class="fas fa-{{ $activity['icon'] ?? 'info' }}"></i>
                </div>
                <div class="activity-content">
                    <div class="fw-bold">{{ $activity['title'] }}</div>
                    <div class="text-muted small">{{ $activity['description'] }}</div>
                    <div class="activity-time">{{ $activity['time'] }}</div>
                </div>
            </div>
            @empty
            <div class="text-center text-muted py-4">
                <i class="fas fa-inbox fa-2x mb-3"></i>
                <p>لا توجد أنشطة حديثة</p>
            </div>
            @endforelse
            
            <div class="text-center mt-3">
                <a href="{{ route('zatca-settings.initialization-logs') }}" class="btn btn-outline-primary btn-sm">
                    <i class="fas fa-eye me-2"></i>
                    عرض جميع السجلات
                </a>
            </div>
        </div>
    </div>
</div>

<!-- System Status -->
<div class="row">
    <div class="col-12">
        <div class="chart-container">
            <h5 class="mb-4">
                <i class="fas fa-server me-2 text-info"></i>
                حالة النظام
            </h5>
            <div class="row">
                <div class="col-md-3 text-center">
                    <div class="mb-2">
                        <i class="fas fa-toggle-{{ config('zatca.enabled') ? 'on text-success' : 'off text-danger' }} fa-2x"></i>
                    </div>
                    <h6>حالة ZATCA</h6>
                    <span class="badge bg-{{ config('zatca.enabled') ? 'success' : 'danger' }}">
                        {{ config('zatca.enabled') ? 'مفعل' : 'معطل' }}
                    </span>
                </div>
                <div class="col-md-3 text-center">
                    <div class="mb-2">
                        <i class="fas fa-flask text-warning fa-2x"></i>
                    </div>
                    <h6>البيئة الافتراضية</h6>
                    <span class="badge bg-warning">{{ config('zatca.default_environment') }}</span>
                </div>
                <div class="col-md-3 text-center">
                    <div class="mb-2">
                        <i class="fas fa-tachometer-alt text-info fa-2x"></i>
                    </div>
                    <h6>معدل الطلبات</h6>
                    <span class="badge bg-info">{{ config('zatca.device_initialization.rate_limit_per_hour') }}/ساعة</span>
                </div>
                <div class="col-md-3 text-center">
                    <div class="mb-2">
                        <i class="fas fa-clock text-primary fa-2x"></i>
                    </div>
                    <h6>صلاحية OTP</h6>
                    <span class="badge bg-primary">{{ config('zatca.device_initialization.otp_expiry_minutes') }} دقيقة</span>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// رسم بياني لإحصائيات التهيئة
const ctx = document.getElementById('initializationChart').getContext('2d');
const chart = new Chart(ctx, {
    type: 'line',
    data: {
        labels: ['الأحد', 'الاثنين', 'الثلاثاء', 'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
        datasets: [{
            label: 'محاولات ناجحة',
            data: [12, 19, 3, 5, 2, 3, 8],
            borderColor: '#27ae60',
            backgroundColor: 'rgba(39, 174, 96, 0.1)',
            tension: 0.4
        }, {
            label: 'محاولات فاشلة',
            data: [2, 3, 1, 1, 4, 2, 1],
            borderColor: '#e74c3c',
            backgroundColor: 'rgba(231, 76, 60, 0.1)',
            tension: 0.4
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                position: 'bottom'
            }
        },
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});

// تحديث الصفحة كل 5 دقائق
setTimeout(function() {
    location.reload();
}, 300000);
</script>
@endpush