@extends('layouts.app')

@section('title', 'مساعدة إعداد بيانات اعتماد ZATCA')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <!-- Header -->
            <div class="card bg-primary text-white mb-4">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col">
                            <h1 class="h3 mb-0">
                                <i class="fas fa-key me-2"></i>
                                مساعدة إعداد بيانات اعتماد ZATCA
                            </h1>
                            <p class="mt-2 mb-0">دليل سريع لحل مشكلة 401 Unauthorized</p>
                        </div>
                        <div class="col-auto">
                            <a href="{{ route('zatca-settings.index') }}" class="btn btn-light">
                                <i class="fas fa-arrow-right me-1"></i>
                                العودة للإعدادات
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- الحل السريع -->
            <div class="card mb-4">
                <div class="card-header bg-warning text-dark">
                    <h5 class="mb-0">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        المشكلة: خطأ 401 Unauthorized
                    </h5>
                </div>
                <div class="card-body">
                    <div class="alert alert-info">
                        <h6 class="alert-heading">السبب:</h6>
                        <p class="mb-0">بيانات الاعتماد للبيئة التجريبية غير صحيحة أو مفقودة.</p>
                    </div>

                    <h6 class="mt-4 mb-3">الحل السريع:</h6>
                    <ol>
                        <li>اذهب إلى <a href="{{ route('zatca-settings.index') }}" class="btn btn-sm btn-primary">إعدادات ZATCA</a></li>
                        <li>أدخل بيانات الاعتماد الصحيحة في الحقول التالية:</li>
                    </ol>

                    <div class="row mt-3">
                        <div class="col-md-6">
                            <div class="card border-primary">
                                <div class="card-header bg-primary text-white">
                                    <strong>اسم المستخدم (Username)</strong>
                                </div>
                                <div class="card-body">
                                    <code>يجب الحصول عليه من بوابة ZATCA للمطورين</code>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card border-primary">
                                <div class="card-header bg-primary text-white">
                                    <strong>كلمة المرور (Password)</strong>
                                </div>
                                <div class="card-body">
                                    <code>يجب الحصول عليها من بوابة ZATCA للمطورين</code>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- خطوات الحصول على بيانات الاعتماد -->
            <div class="card mb-4">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-user-plus me-2"></i>
                        خطوات الحصول على بيانات الاعتماد الرسمية
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="text-center mb-3">
                                <div class="bg-success text-white rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 60px; height: 60px;">
                                    <span class="h4 mb-0">1</span>
                                </div>
                                <h6 class="mt-2">التسجيل في بوابة المطورين</h6>
                                <p class="small text-muted">إنشاء حساب في بوابة ZATCA للمطورين</p>
                                <a href="https://zatca.gov.sa/ar/E-Invoicing/SystemsDevelopers/" target="_blank" class="btn btn-outline-success btn-sm">
                                    اذهب للبوابة
                                </a>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="text-center mb-3">
                                <div class="bg-info text-white rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 60px; height: 60px;">
                                    <span class="h4 mb-0">2</span>
                                </div>
                                <h6 class="mt-2">إنشاء تطبيق تجريبي</h6>
                                <p class="small text-muted">تسجيل تطبيقك والحصول على بيانات الاعتماد</p>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="text-center mb-3">
                                <div class="bg-warning text-dark rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 60px; height: 60px;">
                                    <span class="h4 mb-0">3</span>
                                </div>
                                <h6 class="mt-2">تكوين الشهادات</h6>
                                <p class="small text-muted">تحميل الشهادات الرقمية المطلوبة</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- بيانات تجريبية مؤقتة -->
            <div class="card mb-4">
                <div class="card-header bg-warning text-dark">
                    <h5 class="mb-0">
                        <i class="fas fa-flask me-2"></i>
                        بيانات اعتماد تجريبية مؤقتة (للاختبار فقط)
                    </h5>
                </div>
                <div class="card-body">
                    <div class="alert alert-warning">
                        <strong>تحذير:</strong> هذه بيانات تجريبية قد لا تعمل دائماً. استخدمها فقط للاختبار الأولي.
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <label class="form-label">اسم المستخدم:</label>
                            <div class="input-group">
                                <input type="text" class="form-control font-monospace" value="TUlJQnlqQ0NBUzRDQVFBd0RRWUpLb1pJaHZjTkFRRUJCUUFEZ2dFbkFEQ0NBUU9DQVFFQXVqelU=" readonly>
                                <button class="btn btn-outline-secondary" type="button" onclick="copyToClipboard(this.previousElementSibling)">
                                    <i class="fas fa-copy"></i>
                                </button>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">كلمة المرور:</label>
                            <div class="input-group">
                                <input type="text" class="form-control font-monospace" value="QWxhZmUyMDIx" readonly>
                                <button class="btn btn-outline-secondary" type="button" onclick="copyToClipboard(this.previousElementSibling)">
                                    <i class="fas fa-copy"></i>
                                </button>
                            </div>
                        </div>
                    </div>

                    <div class="mt-3">
                        <a href="{{ route('zatca-settings.index') }}" class="btn btn-warning">
                            <i class="fas fa-cog me-1"></i>
                            تطبيق هذه البيانات
                        </a>
                    </div>
                </div>
            </div>

            <!-- اختبار الإعدادات -->
            <div class="card mb-4">
                <div class="card-header bg-info text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-check-circle me-2"></i>
                        اختبار بيانات الاعتماد
                    </h5>
                </div>
                <div class="card-body">
                    <p>بعد إدخال بيانات الاعتماد، يمكنك اختبارها بالطرق التالية:</p>

                    <div class="row">
                        <div class="col-md-6">
                            <h6>عبر لوحة التحكم:</h6>
                            <ol>
                                <li>اذهب إلى إعدادات ZATCA</li>
                                <li>اضغط على "اختبار الاتصال"</li>
                                <li>تحقق من النتائج</li>
                            </ol>
                        </div>
                        <div class="col-md-6">
                            <h6>عبر أمر Terminal:</h6>
                            <div class="bg-dark text-light p-3 rounded">
                                <code>php artisan zatca:test --connection</code>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- روابط مفيدة -->
            <div class="card">
                <div class="card-header bg-dark text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-external-link-alt me-2"></i>
                        روابط مفيدة
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4">
                            <h6>مواقع رسمية:</h6>
                            <ul class="list-unstyled">
                                <li><a href="https://zatca.gov.sa" target="_blank">بوابة ZATCA الرئيسية</a></li>
                                <li><a href="https://zatca.gov.sa/ar/E-Invoicing/SystemsDevelopers/" target="_blank">بوابة المطورين</a></li>
                            </ul>
                        </div>
                        <div class="col-md-4">
                            <h6>الوثائق التقنية:</h6>
                            <ul class="list-unstyled">
                                <li><a href="https://zatca.gov.sa/ar/E-Invoicing/SystemsDevelopers/Pages/TechnicalRequirements.aspx" target="_blank">المتطلبات التقنية</a></li>
                                <li><a href="https://zatca.gov.sa/ar/E-Invoicing/SystemsDevelopers/Pages/SampleInvoices.aspx" target="_blank">أمثلة الفواتير</a></li>
                            </ul>
                        </div>
                        <div class="col-md-4">
                            <h6>الدعم التقني:</h6>
                            <ul class="list-unstyled">
                                <li><i class="fas fa-envelope me-1"></i> e-invoicing@zatca.gov.sa</li>
                                <li><i class="fas fa-phone me-1"></i> 19993</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function copyToClipboard(element) {
    element.select();
    element.setSelectionRange(0, 99999);
    navigator.clipboard.writeText(element.value).then(function() {
        // Show success feedback
        const button = element.nextElementSibling;
        const originalHTML = button.innerHTML;
        button.innerHTML = '<i class="fas fa-check text-success"></i>';
        setTimeout(() => {
            button.innerHTML = originalHTML;
        }, 2000);
    });
}
</script>
@endsection