@extends('layouts.app')

@section('title', 'إعداد ZATCA جديد')
@section('page-title', 'إعداد الربط الإلكتروني مع ZATCA')

@section('page-actions')
<a href="{{ route('zatca-settings.index') }}" class="btn btn-secondary">
    <i class="fas fa-arrow-left me-2"></i>
    العودة للقائمة
</a>
@endsection

@section('content')
<form method="POST" action="{{ route('zatca-settings.store') }}" id="zatca-form">
    @csrf
    
    <div class="row">
        <div class="col-lg-8">
            <!-- اختيار الشركة -->
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-building me-2"></i>
                        اختيار الشركة
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <label class="form-label">الشركة <span class="text-danger">*</span></label>
                            <select name="company_id" class="form-select @error('company_id') is-invalid @enderror" required onchange="updateCompanyInfo()">
                                <option value="">اختر الشركة</option>
                                @foreach($companies as $company)
                                    <option value="{{ $company->id }}" 
                                            data-company='@json($company)'
                                            {{ old('company_id', request('company_id')) == $company->id ? 'selected' : '' }}>
                                        {{ $company->name }} ({{ $company->vat_number }})
                                    </option>
                                @endforeach
                            </select>
                            @error('company_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    
                    <!-- معلومات الشركة المختارة -->
                    <div id="company-info" class="mt-3" style="display: none;">
                        <div class="alert alert-info">
                            <h6><i class="fas fa-info-circle me-2"></i>معلومات الشركة المختارة:</h6>
                            <div id="company-details"></div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- نوع الربط -->
            <div class="card mt-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-link me-2"></i>
                        نوع الربط مع ZATCA
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-check form-check-card">
                                <input type="radio" name="connection_type" value="clearance" class="form-check-input" 
                                       id="clearance" {{ old('connection_type', 'clearance') == 'clearance' ? 'checked' : '' }} 
                                       onchange="updateConnectionType()">
                                <label class="form-check-label w-100" for="clearance">
                                    <div class="card h-100">
                                        <div class="card-body text-center">
                                            <i class="fas fa-shield-alt fa-3x text-primary mb-3"></i>
                                            <h5>Clearance</h5>
                                            <p class="text-muted mb-0">للفواتير المعيارية (B2B)</p>
                                            <small class="text-muted">يتطلب موافقة ZATCA قبل الإصدار</small>
                                        </div>
                                    </div>
                                </label>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-check form-check-card">
                                <input type="radio" name="connection_type" value="reporting" class="form-check-input" 
                                       id="reporting" {{ old('connection_type') == 'reporting' ? 'checked' : '' }} 
                                       onchange="updateConnectionType()">
                                <label class="form-check-label w-100" for="reporting">
                                    <div class="card h-100">
                                        <div class="card-body text-center">
                                            <i class="fas fa-file-alt fa-3x text-info mb-3"></i>
                                            <h5>Reporting</h5>
                                            <p class="text-muted mb-0">للفواتير المبسطة (B2C)</p>
                                            <small class="text-muted">إرسال للإبلاغ بعد الإصدار</small>
                                        </div>
                                    </div>
                                </label>
                            </div>
                        </div>
                    </div>
                    @error('connection_type')
                        <div class="text-danger mt-2">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            
            <!-- البيئة -->
            <div class="card mt-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-server me-2"></i>
                        بيئة التشغيل
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-check form-check-card">
                                <input type="radio" name="environment" value="sandbox" class="form-check-input" 
                                       id="sandbox" {{ old('environment', 'sandbox') == 'sandbox' ? 'checked' : '' }}>
                                <label class="form-check-label w-100" for="sandbox">
                                    <div class="card h-100">
                                        <div class="card-body text-center">
                                            <i class="fas fa-flask fa-3x text-warning mb-3"></i>
                                            <h5>Sandbox</h5>
                                            <p class="text-muted mb-0">بيئة تجريبية</p>
                                            <small class="text-muted">للاختبار والتطوير فقط</small>
                                        </div>
                                    </div>
                                </label>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-check form-check-card">
                                <input type="radio" name="environment" value="production" class="form-check-input" 
                                       id="production" {{ old('environment') == 'production' ? 'checked' : '' }}>
                                <label class="form-check-label w-100" for="production">
                                    <div class="card h-100">
                                        <div class="card-body text-center">
                                            <i class="fas fa-globe fa-3x text-success mb-3"></i>
                                            <h5>Production</h5>
                                            <p class="text-muted mb-0">بيئة الإنتاج</p>
                                            <small class="text-muted">للاستخدام الفعلي</small>
                                        </div>
                                    </div>
                                </label>
                            </div>
                        </div>
                    </div>
                    @error('environment')
                        <div class="text-danger mt-2">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            
            <!-- بيانات الاعتماد -->
            <div class="card mt-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-key me-2"></i>
                        بيانات الاعتماد
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <label class="form-label">Client ID</label>
                            <input type="text" name="client_id" class="form-control @error('client_id') is-invalid @enderror" 
                                   value="{{ old('client_id') }}" placeholder="معرف العميل من ZATCA">
                            @error('client_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="col-md-6">
                            <label class="form-label">Client Secret</label>
                            <input type="password" name="client_secret" class="form-control @error('client_secret') is-invalid @enderror" 
                                   value="{{ old('client_secret') }}" placeholder="كلمة المرور السرية">
                            @error('client_secret')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="row mt-3">
                        <div class="col-md-6">
                            <label class="form-label">Username</label>
                            <input type="text" name="username" class="form-control @error('username') is-invalid @enderror" 
                                   value="{{ old('username') }}" placeholder="اسم المستخدم">
                            @error('username')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="col-md-6">
                            <label class="form-label">Password</label>
                            <input type="password" name="password" class="form-control @error('password') is-invalid @enderror" 
                                   value="{{ old('password') }}" placeholder="كلمة المرور">
                            @error('password')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- الشهادات الرقمية -->
            <div class="card mt-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-certificate me-2"></i>
                        الشهادات الرقمية
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <label class="form-label">محتوى الشهادة (Certificate)</label>
                            <textarea name="certificate_content" class="form-control @error('certificate_content') is-invalid @enderror" 
                                      rows="5" placeholder="-----BEGIN CERTIFICATE-----&#10;...&#10;-----END CERTIFICATE-----">{{ old('certificate_content') }}</textarea>
                            @error('certificate_content')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="row mt-3">
                        <div class="col-12">
                            <label class="form-label">المفتاح الخاص (Private Key)</label>
                            <textarea name="private_key_content" class="form-control @error('private_key_content') is-invalid @enderror" 
                                      rows="5" placeholder="-----BEGIN PRIVATE KEY-----&#10;...&#10;-----END PRIVATE KEY-----">{{ old('private_key_content') }}</textarea>
                            @error('private_key_content')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="row mt-3">
                        <div class="col-md-6">
                            <label class="form-label">تاريخ انتهاء الشهادة</label>
                            <input type="date" name="certificate_expires_at" class="form-control @error('certificate_expires_at') is-invalid @enderror" 
                                   value="{{ old('certificate_expires_at') }}">
                            @error('certificate_expires_at')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- معاينة الإعدادات -->
        <div class="col-lg-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-eye me-2"></i>
                        معاينة الإعدادات
                    </h5>
                </div>
                <div class="card-body">
                    <div id="settings-preview">
                        <div class="text-center text-muted py-4">
                            <i class="fas fa-cog fa-3x mb-3"></i>
                            <p>اختر الشركة ونوع الربط لعرض المعاينة</p>
                        </div>
                    </div>
                    
                    <div class="d-grid mt-3">
                        <button type="submit" class="btn btn-success">
                            <i class="fas fa-save me-2"></i>
                            حفظ الإعدادات
                        </button>
                    </div>
                </div>
            </div>
            
            <!-- معلومات مهمة -->
            <div class="card mt-3">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-info-circle me-2"></i>
                        معلومات مهمة
                    </h6>
                </div>
                <div class="card-body">
                    <div class="alert alert-info">
                        <h6>خطوات إعداد ZATCA:</h6>
                        <ol class="mb-0 small">
                            <li>احصل على الشهادة الرقمية من ZATCA</li>
                            <li>اختر نوع الربط المناسب لنشاطك</li>
                            <li>ابدأ بالبيئة التجريبية للاختبار</li>
                            <li>انتقل للبيئة الإنتاجية بعد النجاح</li>
                        </ol>
                    </div>
                    
                    <div class="alert alert-warning">
                        <h6>تنبيه:</h6>
                        <p class="mb-0 small">
                            يجب الحصول على موافقة ZATCA قبل استخدام البيئة الإنتاجية.
                            استخدم البيئة التجريبية للاختبار أولاً.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
@endsection

@push('styles')
<style>
.form-check-card .form-check-input {
    position: absolute;
    top: 10px;
    right: 10px;
}

.form-check-card .card {
    cursor: pointer;
    transition: all 0.3s ease;
    border: 2px solid #e9ecef;
}

.form-check-card .form-check-input:checked + .form-check-label .card {
    border-color: #007bff;
    background-color: #f8f9ff;
}

.form-check-card .card:hover {
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
}
</style>
@endpush

@push('scripts')
<script>
function updateCompanyInfo() {
    const companySelect = document.querySelector('select[name="company_id"]');
    const selectedOption = companySelect.options[companySelect.selectedIndex];
    const companyInfo = document.getElementById('company-info');
    const companyDetails = document.getElementById('company-details');
    
    if (selectedOption.value && selectedOption.dataset.company) {
        const company = JSON.parse(selectedOption.dataset.company);
        
        companyDetails.innerHTML = `
            <p class="mb-1"><strong>الاسم:</strong> ${company.name}</p>
            <p class="mb-1"><strong>الرقم الضريبي:</strong> ${company.vat_number}</p>
            <p class="mb-1"><strong>السجل التجاري:</strong> ${company.cr_number}</p>
            <p class="mb-0"><strong>العنوان:</strong> ${company.city}, ${company.district}</p>
        `;
        
        companyInfo.style.display = 'block';
    } else {
        companyInfo.style.display = 'none';
    }
    
    updatePreview();
}

function updateConnectionType() {
    updatePreview();
}

function updatePreview() {
    const companySelect = document.querySelector('select[name="company_id"]');
    const selectedCompany = companySelect.options[companySelect.selectedIndex];
    const connectionType = document.querySelector('input[name="connection_type"]:checked');
    const environment = document.querySelector('input[name="environment"]:checked');
    const previewDiv = document.getElementById('settings-preview');
    
    if (selectedCompany.value && connectionType && environment) {
        const company = selectedCompany.dataset.company ? JSON.parse(selectedCompany.dataset.company) : null;
        
        previewDiv.innerHTML = `
            <div class="text-center mb-3">
                <div class="bg-light p-3 rounded">
                    <i class="fas fa-cog fa-2x text-primary mb-2"></i>
                    <h6>إعدادات ZATCA</h6>
                </div>
            </div>
            
            <div class="mb-2">
                <strong>الشركة:</strong>
                <div class="text-muted small">${company ? company.name : 'غير محددة'}</div>
            </div>
            
            <div class="mb-2">
                <strong>نوع الربط:</strong>
                <span class="badge ${connectionType.value === 'clearance' ? 'bg-primary' : 'bg-info'}">
                    ${connectionType.value === 'clearance' ? 'Clearance' : 'Reporting'}
                </span>
            </div>
            
            <div class="mb-2">
                <strong>البيئة:</strong>
                <span class="badge ${environment.value === 'sandbox' ? 'bg-warning' : 'bg-success'}">
                    ${environment.value === 'sandbox' ? 'تجريبية' : 'إنتاج'}
                </span>
            </div>
            
            <div class="mb-2">
                <strong>الحالة:</strong>
                <span class="badge bg-secondary">غير نشط</span>
            </div>
        `;
    } else {
        previewDiv.innerHTML = `
            <div class="text-center text-muted py-4">
                <i class="fas fa-cog fa-3x mb-3"></i>
                <p>اختر الشركة ونوع الربط لعرض المعاينة</p>
            </div>
        `;
    }
}

// ربط الأحداث
document.addEventListener('DOMContentLoaded', function() {
    // تحديث المعاينة عند التحميل إذا كانت هناك قيم محددة مسبقاً
    updateCompanyInfo();
    
    // ربط أحداث الراديو
    document.querySelectorAll('input[type="radio"]').forEach(radio => {
        radio.addEventListener('change', updatePreview);
    });
});

// التحقق من اكتمال البيانات المطلوبة
document.getElementById('zatca-form').addEventListener('submit', function(e) {
    const companyId = document.querySelector('select[name="company_id"]').value;
    const connectionType = document.querySelector('input[name="connection_type"]:checked');
    const environment = document.querySelector('input[name="environment"]:checked');
    
    if (!companyId || !connectionType || !environment) {
        e.preventDefault();
        alert('يجب اختيار الشركة ونوع الربط والبيئة');
    }
});
</script>
@endpush