@extends('layouts.app')

@section('title', 'عرض المستخدم - ' . $user->name)
@section('page-title', 'تفاصيل المستخدم')

@section('page-actions')
    <div class="btn-group" role="group">
        <a href="{{ route('users.edit', $user) }}" class="btn btn-warning">
            <i class="fas fa-edit me-2"></i>
            تعديل
        </a>
        <a href="{{ route('users.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-right me-2"></i>
            العودة للقائمة
        </a>
    </div>
@endsection

@section('content')
<div class="row">
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-user me-2"></i>
                    معلومات المستخدم
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-4">
                        <h6 class="text-muted mb-2">
                            <i class="fas fa-user me-2"></i>
                            الاسم الكامل
                        </h6>
                        <p class="h5">{{ $user->name }}</p>
                    </div>
                    
                    <div class="col-md-6 mb-4">
                        <h6 class="text-muted mb-2">
                            <i class="fas fa-envelope me-2"></i>
                            البريد الإلكتروني
                        </h6>
                        <p class="h6">{{ $user->email }}</p>
                    </div>
                    
                    <div class="col-md-6 mb-4">
                        <h6 class="text-muted mb-2">
                            <i class="fas fa-phone me-2"></i>
                            رقم الهاتف
                        </h6>
                        <p class="h6">{{ $user->phone ?? 'غير محدد' }}</p>
                    </div>
                    
                    <div class="col-md-6 mb-4">
                        <h6 class="text-muted mb-2">
                            <i class="fas fa-user-tag me-2"></i>
                            الدور الوظيفي
                        </h6>
                        <span class="badge fs-6 
                            @if($user->role === 'admin') bg-danger
                            @elseif($user->role === 'manager') bg-warning
                            @else bg-secondary
                            @endif">
                            {{ $user->role_name }}
                        </span>
                    </div>
                    
                    <div class="col-md-6 mb-4">
                        <h6 class="text-muted mb-2">
                            <i class="fas fa-toggle-on me-2"></i>
                            حالة الحساب
                        </h6>
                        <span class="badge fs-6 {{ $user->is_active ? 'bg-success' : 'bg-secondary' }}">
                            {{ $user->status_name }}
                        </span>
                    </div>
                    
                    <div class="col-md-6 mb-4">
                        <h6 class="text-muted mb-2">
                            <i class="fas fa-calendar-plus me-2"></i>
                            تاريخ التسجيل
                        </h6>
                        <p class="h6">{{ $user->created_at->format('Y-m-d H:i') }}</p>
                        <small class="text-muted">{{ $user->created_at->diffForHumans() }}</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-4">
        <!-- User Avatar Card -->
        <div class="card mb-4">
            <div class="card-body text-center">
                <div class="user-avatar mx-auto mb-3">
                    <i class="fas fa-user"></i>
                </div>
                <h5 class="mb-1">{{ $user->name }}</h5>
                <p class="text-muted mb-3">{{ $user->role_name }}</p>
                
                @if($user->id === auth()->id())
                    <span class="badge bg-info">هذا حسابك</span>
                @endif
            </div>
        </div>
        
        <!-- Quick Actions Card -->
        <div class="card">
            <div class="card-header">
                <h6 class="mb-0">
                    <i class="fas fa-cogs me-2"></i>
                    إجراءات سريعة
                </h6>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="{{ route('users.edit', $user) }}" class="btn btn-outline-warning">
                        <i class="fas fa-edit me-2"></i>
                        تعديل البيانات
                    </a>
                    
                    @if($user->id !== auth()->id())
                        <form action="{{ route('users.toggle-status', $user) }}" method="POST">
                            @csrf
                            @method('PATCH')
                            <button type="submit" 
                                    class="btn {{ $user->is_active ? 'btn-outline-secondary' : 'btn-outline-success' }} w-100"
                                    onclick="return confirm('هل أنت متأكد من {{ $user->is_active ? 'إلغاء تفعيل' : 'تفعيل' }} هذا المستخدم؟')">
                                <i class="fas {{ $user->is_active ? 'fa-user-times' : 'fa-user-check' }} me-2"></i>
                                {{ $user->is_active ? 'إلغاء التفعيل' : 'تفعيل الحساب' }}
                            </button>
                        </form>
                        
                        <hr>
                        
                        <form action="{{ route('users.destroy', $user) }}" method="POST">
                            @csrf
                            @method('DELETE')
                            <button type="submit" 
                                    class="btn btn-outline-danger w-100"
                                    onclick="return confirm('هل أنت متأكد من حذف هذا المستخدم؟ هذا الإجراء لا يمكن التراجع عنه.')">
                                <i class="fas fa-trash me-2"></i>
                                حذف المستخدم
                            </button>
                        </form>
                    @else
                        <div class="alert alert-info mb-0">
                            <i class="fas fa-info-circle me-2"></i>
                            <small>لا يمكن حذف أو إلغاء تفعيل حسابك الخاص</small>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
    .user-avatar {
        width: 80px;
        height: 80px;
        border-radius: 50%;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 2rem;
    }
    
    .badge.fs-6 {
        font-size: 0.9rem !important;
        padding: 8px 12px;
    }
    
    .card-body h6.text-muted {
        font-weight: 600;
        text-transform: uppercase;
        font-size: 0.8rem;
        letter-spacing: 0.5px;
    }
</style>
@endpush
@endsection