@extends('layouts.app')

@section('title', 'إدارة المستخدمين')
@section('page-title', 'إدارة المستخدمين')

@section('page-actions')
    <a href="{{ route('users.create') }}" class="btn btn-primary">
        <i class="fas fa-plus me-2"></i>
        إضافة مستخدم جديد
    </a>
@endsection

@section('content')
<div class="card">
    <div class="card-header">
        <h5 class="mb-0">
            <i class="fas fa-users me-2"></i>
            قائمة المستخدمين
        </h5>
    </div>
    <div class="card-body">
        @if($users->count() > 0)
            <div class="table-responsive">
                <table class="table table-hover">
                        <tr>
                            <td>الاسم</td>
                            <td>البريد الإلكتروني</td>
                            <td>رقم الهاتف</td>
                            <td>الدور</td>
                            <td>الحالة</td>
                            <td>تاريخ التسجيل</td>
                            <td class="text-center">الإجراءات</td>
                        </tr>
    @foreach($users as $user)
        <tr>
            <td>
                <div class="d-flex align-items-center">
                    <div class="avatar-circle me-3">
                        <i class="fas fa-user"></i>
                    </div>
                    <div>
                        <strong>{{ $user->name }}</strong>
                        @if($user->id === auth()->id())
                            <span class="badge bg-info ms-2">أنت</span>
                        @endif
                    </div>
                </div>
            </td>
            <td>{{ $user->email }}</td>
            <td>{{ $user->phone ?? 'غير محدد' }}</td>
            <td>
                <span class="badge 
                    @if($user->role === 'admin') bg-danger
                    @elseif($user->role === 'manager') bg-warning
                    @else bg-secondary
                    @endif">
                    {{ $user->role_name }}
                </span>
            </td>
            <td>
                <span class="badge {{ $user->is_active ? 'bg-success' : 'bg-secondary' }}">
                    {{ $user->status_name }}
                </span>
            </td>
            <td>{{ $user->created_at->format('Y-m-d') }}</td>
            <td class="text-center">
                <div class="btn-group" role="group">
                    <a href="{{ route('users.show', $user) }}" 
                        class="btn btn-sm btn-outline-info" 
                        title="عرض">
                        <i class="fas fa-eye"></i>
                    </a>
                    
                    <a href="{{ route('users.edit', $user) }}" 
                        class="btn btn-sm btn-outline-warning" 
                        title="تعديل">
                        <i class="fas fa-edit"></i>
                    </a>
                    
                    @if($user->id !== auth()->id())
                        <form action="{{ route('users.toggle-status', $user) }}" 
                                method="POST" 
                                class="d-inline">
                            @csrf
                            @method('PATCH')
                            <button type="submit" 
                                    class="btn btn-sm {{ $user->is_active ? 'btn-outline-secondary' : 'btn-outline-success' }}" 
                                    title="{{ $user->is_active ? 'إلغاء التفعيل' : 'تفعيل' }}"
                                    data-bs-toggle="modal" data-bs-target="#confirmModal-{{ $user->id }}">
                                <i class="fas {{ $user->is_active ? 'fa-user-times' : 'fa-user-check' }}"></i>
                            </button>
                        </form>
                        
                        <form action="{{ route('users.destroy', $user) }}" 
                                method="POST" 
                                class="d-inline">
                            @csrf
                            @method('DELETE')
                            <button type="submit" 
                                    class="btn btn-sm btn-outline-danger" 
                                    title="حذف"
                                    onclick="return confirm('هل أنت متأكد من حذف هذا المستخدم؟ هذا الإجراء لا يمكن التراجع عنه.')">
                                <i class="fas fa-trash"></i>
                            </button>
                        </form>
                    @endif
                </div>
            </td>
        </tr>
    @endforeach
@foreach($users as $user)
<!-- Modal -->
<div class="modal fade" id="confirmModal-{{ $user->id }}" tabindex="-1" aria-labelledby="confirmModalLabel-{{ $user->id }}" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="confirmModalLabel-{{ $user->id }}">تأكيد الإجراء</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                هل أنت متأكد من {{ $user->is_active ? 'إلغاء تفعيل' : 'تفعيل' }} هذا المستخدم؟
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                <form action="{{ route('users.toggle-status', $user) }}" method="POST">
                    @csrf
                    @method('PATCH')
                    <button type="submit" class="btn btn-primary">تأكيد</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endforeach
</table>
            </div>
            
            <!-- Pagination -->
            <div class="d-flex justify-content-center mt-4">
                {{ $users->links() }}
            </div>
        @else
            <div class="text-center py-5">
                <i class="fas fa-users fa-3x text-muted mb-3"></i>
                <h5 class="text-muted">لا توجد مستخدمين مسجلين</h5>
                <p class="text-muted">ابدأ بإضافة مستخدم جديد</p>
                <a href="{{ route('users.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus me-2"></i>
                    إضافة مستخدم جديد
                </a>
            </div>
        @endif
    </div>
</div>

@push('styles')
<style>
    .avatar-circle {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 1.2rem;
    }
    
    .table th {
        border-top: none;
        font-weight: 600;
        color: #2c3e50;
    }
    
    .btn-group .btn {
        margin: 0 2px;
    }
    
    .badge {
        font-size: 0.8rem;
        padding: 5px 10px;
    }
</style>
@endpush
@endsection