@extends('layouts.app')

@section('title', 'ملخص ضريبة القيمة المضافة')
@section('page-title', 'ملخص ضريبة القيمة المضافة')

@section('breadcrumb')
    <span>تقارير النظام</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>الإقرارات الضريبية</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>ملخص ضريبة القيمة المضافة</span>
@endsection

@section('content')
<div class="container-fluid">
    <!-- عنوان الصفحة والمرشحات -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="mb-0">
            <i class="fas fa-receipt me-2 text-primary"></i>
            ملخص ضريبة القيمة المضافة
        </h4>
        <div class="d-flex gap-2">
            <a href="{{ route('system-reports.tax.index') }}" class="btn btn-outline-secondary btn-sm">
                <i class="fas fa-arrow-right me-2"></i>العودة للتقارير
            </a>
            <button class="btn btn-success btn-sm" onclick="exportReport()">
                <i class="fas fa-download me-2"></i>تصدير التقرير
            </button>
        </div>
    </div>

    <!-- فلاتر التاريخ -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-body">
            <form method="GET" class="row g-3">
                <div class="col-md-4">
                    <label for="start_date" class="form-label">من تاريخ</label>
                    <input type="date" class="form-control" id="start_date" name="start_date" 
                           value="{{ request('start_date', now()->startOfMonth()->format('Y-m-d')) }}">
                </div>
                <div class="col-md-4">
                    <label for="end_date" class="form-label">إلى تاريخ</label>
                    <input type="date" class="form-control" id="end_date" name="end_date" 
                           value="{{ request('end_date', now()->endOfMonth()->format('Y-m-d')) }}">
                </div>
                <div class="col-md-4 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary me-2">
                        <i class="fas fa-filter me-2"></i>تطبيق المرشح
                    </button>
                    <a href="{{ route('system-reports.tax.vat-summary') }}" class="btn btn-outline-secondary">
                        إعادة تعيين
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- نظرة عامة على الضرائب -->
    <div class="row mb-4">
        <div class="col-lg-4 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-success text-white mb-3">
                        <i class="fas fa-arrow-up"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($netVAT['output_vat'] ?? 0, 2) }}</h3>
                    <p class="text-muted mb-0">ضريبة المبيعات (المخرجات)</p>
                    <small class="text-success">ريال سعودي</small>
                </div>
            </div>
        </div>

        <div class="col-lg-4 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-info text-white mb-3">
                        <i class="fas fa-arrow-down"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($netVAT['input_vat'] ?? 0, 2) }}</h3>
                    <p class="text-muted mb-0">ضريبة المشتريات (المدخلات)</p>
                    <small class="text-info">ريال سعودي</small>
                </div>
            </div>
        </div>

        <div class="col-lg-4 col-md-12 mb-3">
            <div class="card border-0 shadow-sm stats-card {{ ($netVAT['net_vat_due'] ?? 0) >= 0 ? 'border-warning' : 'border-primary' }}">
                <div class="card-body text-center">
                    <div class="stats-icon {{ ($netVAT['net_vat_due'] ?? 0) >= 0 ? 'bg-warning' : 'bg-primary' }} text-white mb-3">
                        <i class="fas fa-balance-scale"></i>
                    </div>
                    <h3 class="mb-2 {{ ($netVAT['net_vat_due'] ?? 0) >= 0 ? 'text-warning' : 'text-primary' }}">
                        {{ number_format($netVAT['net_vat_due'] ?? 0, 2) }}
                    </h3>
                    <p class="text-muted mb-0">صافي الضريبة المستحقة</p>
                    <small class="{{ ($netVAT['net_vat_due'] ?? 0) >= 0 ? 'text-warning' : 'text-primary' }}">
                        {{ ($netVAT['net_vat_due'] ?? 0) >= 0 ? 'مستحقة للدولة' : 'مستردة من الدولة' }}
                    </small>
                </div>
            </div>
        </div>
    </div>

    <!-- تفاصيل ضريبة المبيعات والمشتريات -->
    <div class="row mb-4">
        <!-- تفاصيل المبيعات -->
        <div class="col-lg-6 mb-4">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-success text-white">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-shopping-cart me-2"></i>
                        تفاصيل ضريبة المبيعات (المخرجات)
                    </h5>
                </div>
                <div class="card-body">
                    @if($salesVAT && ($salesVAT->total_invoices ?? 0) > 0)
                        <div class="row g-3">
                            <div class="col-12">
                                <div class="d-flex justify-content-between align-items-center p-3 bg-light rounded">
                                    <span class="text-muted">عدد الفواتير:</span>
                                    <strong class="text-success">{{ number_format($salesVAT->total_invoices ?? 0) }}</strong>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="d-flex justify-content-between align-items-center p-3 bg-light rounded">
                                    <span class="text-muted">إجمالي قبل الضريبة:</span>
                                    <strong class="text-primary">{{ number_format($salesVAT->total_before_tax ?? 0, 2) }} ريال</strong>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="d-flex justify-content-between align-items-center p-3 bg-success text-white rounded">
                                    <span>ضريبة القيمة المضافة:</span>
                                    <strong>{{ number_format($salesVAT->output_vat ?? 0, 2) }} ريال</strong>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="d-flex justify-content-between align-items-center p-3 bg-light rounded">
                                    <span class="text-muted">إجمالي بعد الضريبة:</span>
                                    <strong class="text-success">{{ number_format($salesVAT->total_with_tax ?? 0, 2) }} ريال</strong>
                                </div>
                            </div>
                        </div>
                    @else
                        <div class="text-center py-4">
                            <i class="fas fa-shopping-cart fa-3x text-muted mb-3"></i>
                            <h6 class="text-muted">لا توجد فواتير مبيعات في هذه الفترة</h6>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- تفاصيل المشتريات -->
        <div class="col-lg-6 mb-4">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-info text-white">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-shopping-bag me-2"></i>
                        تفاصيل ضريبة المشتريات (المدخلات)
                    </h5>
                </div>
                <div class="card-body">
                    @if($purchaseVAT && ($purchaseVAT->total_invoices ?? 0) > 0)
                        <div class="row g-3">
                            <div class="col-12">
                                <div class="d-flex justify-content-between align-items-center p-3 bg-light rounded">
                                    <span class="text-muted">عدد الفواتير:</span>
                                    <strong class="text-info">{{ number_format($purchaseVAT->total_invoices ?? 0) }}</strong>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="d-flex justify-content-between align-items-center p-3 bg-light rounded">
                                    <span class="text-muted">إجمالي قبل الضريبة:</span>
                                    <strong class="text-primary">{{ number_format($purchaseVAT->total_before_tax ?? 0, 2) }} ريال</strong>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="d-flex justify-content-between align-items-center p-3 bg-info text-white rounded">
                                    <span>ضريبة القيمة المضافة:</span>
                                    <strong>{{ number_format($purchaseVAT->input_vat ?? 0, 2) }} ريال</strong>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="d-flex justify-content-between align-items-center p-3 bg-light rounded">
                                    <span class="text-muted">إجمالي بعد الضريبة:</span>
                                    <strong class="text-info">{{ number_format($purchaseVAT->total_with_tax ?? 0, 2) }} ريال</strong>
                                </div>
                            </div>
                        </div>
                    @else
                        <div class="text-center py-4">
                            <i class="fas fa-shopping-bag fa-3x text-muted mb-3"></i>
                            <h6 class="text-muted">لا توجد فواتير مشتريات في هذه الفترة</h6>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- حساب صافي الضريبة -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-header bg-warning text-dark">
            <h5 class="card-title mb-0">
                <i class="fas fa-calculator me-2"></i>
                حساب صافي ضريبة القيمة المضافة
            </h5>
        </div>
        <div class="card-body">
            <div class="row g-4">
                <div class="col-md-6">
                    <div class="calculation-step">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <span class="h6 mb-0">ضريبة المبيعات (المخرجات):</span>
                            <strong class="text-success h5 mb-0">{{ number_format($netVAT['output_vat'] ?? 0, 2) }} ريال</strong>
                        </div>
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <span class="h6 mb-0">ضريبة المشتريات (المدخلات):</span>
                            <strong class="text-info h5 mb-0">{{ number_format($netVAT['input_vat'] ?? 0, 2) }} ريال</strong>
                        </div>
                        <hr>
                        <div class="d-flex justify-content-between align-items-center">
                            <span class="h5 mb-0">صافي الضريبة المستحقة:</span>
                            <strong class="h4 mb-0 {{ ($netVAT['net_vat_due'] ?? 0) >= 0 ? 'text-warning' : 'text-primary' }}">
                                {{ number_format($netVAT['net_vat_due'] ?? 0, 2) }} ريال
                            </strong>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="calculation-note p-4 bg-light rounded">
                        <h6 class="text-muted mb-3">
                            <i class="fas fa-info-circle me-2"></i>
                            المعادلة المستخدمة:
                        </h6>
                        <div class="formula">
                            <p class="mb-2"><strong>صافي الضريبة المستحقة</strong> =</p>
                            <p class="mb-2">ضريبة المبيعات <span class="text-muted">-</span> ضريبة المشتريات</p>
                            <hr class="my-3">
                            <div class="result-explanation">
                                @if(($netVAT['net_vat_due'] ?? 0) > 0)
                                    <div class="alert alert-warning mb-0">
                                        <i class="fas fa-exclamation-triangle me-2"></i>
                                        <strong>مطلوب دفع:</strong> {{ number_format($netVAT['net_vat_due'], 2) }} ريال للهيئة
                                    </div>
                                @elseif(($netVAT['net_vat_due'] ?? 0) < 0)
                                    <div class="alert alert-info mb-0">
                                        <i class="fas fa-info-circle me-2"></i>
                                        <strong>مطلوب استرداد:</strong> {{ number_format(abs($netVAT['net_vat_due']), 2) }} ريال من الهيئة
                                    </div>
                                @else
                                    <div class="alert alert-success mb-0">
                                        <i class="fas fa-check-circle me-2"></i>
                                        <strong>لا توجد ضرائب مستحقة أو مستردة</strong>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- روابط سريعة -->
    <div class="row">
        <div class="col-12">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-light">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-link me-2 text-primary"></i>
                        روابط سريعة للتقارير ذات الصلة
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-3">
                            <a href="{{ route('system-reports.tax.vat-return') }}" class="btn btn-outline-success w-100">
                                <i class="fas fa-file-invoice-dollar me-2"></i>
                                إقرار ضريبة القيمة المضافة
                            </a>
                        </div>
                        <div class="col-md-3">
                            <a href="{{ route('system-reports.tax.transactions') }}" class="btn btn-outline-warning w-100">
                                <i class="fas fa-list-alt me-2"></i>
                                المعاملات الضريبية
                            </a>
                        </div>
                        <div class="col-md-3">
                            <a href="{{ route('system-reports.tax.by-customer') }}" class="btn btn-outline-info w-100">
                                <i class="fas fa-users me-2"></i>
                                الضرائب حسب العميل
                            </a>
                        </div>
                        <div class="col-md-3">
                            <a href="{{ route('system-reports.tax.audit-trail') }}" class="btn btn-outline-secondary w-100">
                                <i class="fas fa-search me-2"></i>
                                مسار المراجعة الضريبي
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- ملاحظة مهمة -->
    <div class="alert alert-info mt-4" role="alert">
        <div class="d-flex align-items-start">
            <i class="fas fa-info-circle me-2 mt-1"></i>
            <div>
                <strong>ملاحظة هامة:</strong>
                <ul class="mb-0 mt-2">
                    <li>يتم حساب الضرائب بناءً على تاريخ إصدار الفواتير في الفترة المحددة</li>
                    <li>تأكد من صحة البيانات قبل تقديم الإقرار الضريبي</li>
                    <li>يجب الاحتفاظ بجميع الوثائق المؤيدة لمدة 6 سنوات</li>
                    <li>في حالة وجود أي تعديلات، يرجى مراجعة مسار المراجعة الضريبي</li>
                </ul>
            </div>
        </div>
    </div>
</div>

<style>
.stats-card {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border-radius: 12px;
}

.stats-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.15) !important;
}

.stats-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto;
    font-size: 1.5rem;
}

.card {
    border-radius: 12px;
    animation: fadeInUp 0.6s ease forwards;
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.calculation-step {
    background: #f8f9fa;
    padding: 1.5rem;
    border-radius: 12px;
    border-left: 4px solid #ffc107;
}

.calculation-note {
    border-left: 4px solid #17a2b8;
}

.formula {
    font-family: 'Courier New', monospace;
    text-align: center;
}

.btn {
    border-radius: 8px;
    font-weight: 500;
    transition: all 0.2s ease;
}

.btn:hover {
    transform: scale(1.02);
}

.border-warning {
    border-color: #ffc107 !important;
}

.border-primary {
    border-color: #0d6efd !important;
}
</style>

@push('scripts')
<script>
function exportReport() {
    // يمكن تطوير هذه الوظيفة لاحقاً لتصدير التقرير
    alert('سيتم تطوير وظيفة التصدير قريباً');
}

// تحديث الصفحة عند تغيير التاريخ
document.addEventListener('DOMContentLoaded', function() {
    const startDate = document.getElementById('start_date');
    const endDate = document.getElementById('end_date');
    
    if (startDate && endDate) {
        startDate.addEventListener('change', function() {
            if (endDate.value && this.value > endDate.value) {
                endDate.value = this.value;
            }
        });
        
        endDate.addEventListener('change', function() {
            if (startDate.value && this.value < startDate.value) {
                startDate.value = this.value;
            }
        });
    }
});
</script>
@endpush
@endsection