@extends('layouts.app')

@section('title', 'إقرار ضريبة القيمة المضافة')
@section('page-title', 'إقرار ضريبة القيمة المضافة')

@section('breadcrumb')
    <span>تقارير النظام</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>الإقرارات الضريبية</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>إقرار ضريبة القيمة المضافة</span>
@endsection

@section('content')
<div class="container-fluid">
    <!-- عنوان الصفحة والمرشحات -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="mb-0">
            <i class="fas fa-file-invoice-dollar me-2 text-primary"></i>
            إقرار ضريبة القيمة المضافة الفصلي
        </h4>
        <div class="d-flex gap-2">
            <a href="{{ route('system-reports.tax.index') }}" class="btn btn-outline-secondary btn-sm">
                <i class="fas fa-arrow-right me-2"></i>العودة للتقارير
            </a>
            <button class="btn btn-success btn-sm" onclick="exportReturn()">
                <i class="fas fa-download me-2"></i>تصدير الإقرار
            </button>
            <button class="btn btn-primary btn-sm" onclick="printReturn()">
                <i class="fas fa-print me-2"></i>طباعة الإقرار
            </button>
        </div>
    </div>

    <!-- فلاتر الفترة الضريبية -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-body">
            <form method="GET" class="row g-3">
                <div class="col-md-4">
                    <label for="quarter" class="form-label">الربع الضريبي</label>
                    <select class="form-control" id="quarter" name="quarter">
                        <option value="1" {{ request('quarter', $quarter ?? ceil(now()->month / 3)) == 1 ? 'selected' : '' }}>الربع الأول (يناير - مارس)</option>
                        <option value="2" {{ request('quarter', $quarter ?? ceil(now()->month / 3)) == 2 ? 'selected' : '' }}>الربع الثاني (أبريل - يونيو)</option>
                        <option value="3" {{ request('quarter', $quarter ?? ceil(now()->month / 3)) == 3 ? 'selected' : '' }}>الربع الثالث (يوليو - سبتمبر)</option>
                        <option value="4" {{ request('quarter', $quarter ?? ceil(now()->month / 3)) == 4 ? 'selected' : '' }}>الربع الرابع (أكتوبر - ديسمبر)</option>
                    </select>
                </div>
                <div class="col-md-4">
                    <label for="year" class="form-label">السنة الضريبية</label>
                    <select class="form-control" id="year" name="year">
                        @for($y = now()->year; $y >= now()->year - 5; $y--)
                            <option value="{{ $y }}" {{ request('year', $year ?? now()->year) == $y ? 'selected' : '' }}>{{ $y }}</option>
                        @endfor
                    </select>
                </div>
                <div class="col-md-4 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary me-2">
                        <i class="fas fa-sync me-2"></i>تحديث الإقرار
                    </button>
                    <a href="{{ route('system-reports.tax.vat-return') }}" class="btn btn-outline-secondary">
                        الفترة الحالية
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- معلومات الفترة الضريبية -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-header bg-primary text-white">
            <h5 class="card-title mb-0">
                <i class="fas fa-calendar-alt me-2"></i>
                معلومات الفترة الضريبية
            </h5>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-3">
                    <div class="text-center p-3 bg-light rounded">
                        <i class="fas fa-calendar fa-2x text-primary mb-2"></i>
                        <h5 class="mb-1">الربع {{ $quarter ?? ceil(now()->month / 3) }}</h5>
                        <small class="text-muted">الفترة الضريبية</small>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="text-center p-3 bg-light rounded">
                        <i class="fas fa-calendar-check fa-2x text-success mb-2"></i>
                        <h5 class="mb-1">{{ $year ?? now()->year }}</h5>
                        <small class="text-muted">السنة الضريبية</small>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="text-center p-3 bg-light rounded">
                        <i class="fas fa-play fa-2x text-info mb-2"></i>
                        <h5 class="mb-1">{{ \Carbon\Carbon::parse($startDate ?? now())->format('d/m/Y') }}</h5>
                        <small class="text-muted">من تاريخ</small>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="text-center p-3 bg-light rounded">
                        <i class="fas fa-stop fa-2x text-warning mb-2"></i>
                        <h5 class="mb-1">{{ \Carbon\Carbon::parse($endDate ?? now())->format('d/m/Y') }}</h5>
                        <small class="text-muted">إلى تاريخ</small>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- إقرار ضريبة القيمة المضافة الرسمي -->
    <div class="card border-0 shadow-sm mb-4" id="vat-return-form">
        <div class="card-header bg-success text-white">
            <h5 class="card-title mb-0">
                <i class="fas fa-file-invoice-dollar me-2"></i>
                نموذج إقرار ضريبة القيمة المضافة
            </h5>
        </div>
        <div class="card-body">
            <div class="row">
                <!-- القسم الأول: التوريدات الخاضعة للضريبة بالنسبة العادية -->
                <div class="col-12 mb-4">
                    <h6 class="text-primary border-bottom pb-2 mb-3">
                        <i class="fas fa-list-ol me-2"></i>
                        القسم الأول: التوريدات الخاضعة للضريبة
                    </h6>
                    
                    <div class="row g-3">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label fw-semibold">1. قيمة التوريدات الخاضعة للضريبة بالنسبة العادية (15%)</label>
                                <div class="input-group">
                                    <input type="number" class="form-control" value="{{ number_format($vatReturnData['standard_supplies'] ?? 0, 2) }}" readonly>
                                    <span class="input-group-text">ريال</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label fw-semibold">مبلغ ضريبة القيمة المضافة المستحقة</label>
                                <div class="input-group">
                                    <input type="number" class="form-control bg-success text-white" value="{{ number_format($vatReturnData['standard_vat'] ?? 0, 2) }}" readonly>
                                    <span class="input-group-text">ريال</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- القسم الثاني: التوريدات المعفاة والخاضعة لنسبة الصفر -->
                <div class="col-12 mb-4">
                    <h6 class="text-primary border-bottom pb-2 mb-3">
                        <i class="fas fa-list-ol me-2"></i>
                        القسم الثاني: التوريدات الأخرى
                    </h6>
                    
                    <div class="row g-3">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label fw-semibold">2. قيمة التوريدات الخاضعة لنسبة الصفر</label>
                                <div class="input-group">
                                    <input type="number" class="form-control" value="{{ number_format($vatReturnData['zero_supplies'] ?? 0, 2) }}" readonly>
                                    <span class="input-group-text">ريال</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label fw-semibold">3. قيمة التوريدات المعفاة</label>
                                <div class="input-group">
                                    <input type="number" class="form-control" value="{{ number_format($vatReturnData['exempt_supplies'] ?? 0, 2) }}" readonly>
                                    <span class="input-group-text">ريال</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- القسم الثالث: إجمالي التوريدات -->
                <div class="col-12 mb-4">
                    <h6 class="text-primary border-bottom pb-2 mb-3">
                        <i class="fas fa-calculator me-2"></i>
                        القسم الثالث: إجمالي التوريدات
                    </h6>
                    
                    <div class="row g-3">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label fw-semibold">4. إجمالي قيمة التوريدات والسلع</label>
                                <div class="input-group">
                                    <input type="number" class="form-control bg-info text-white fw-bold" 
                                           value="{{ number_format($vatReturnData['total_supplies'] ?? 0, 2) }}" readonly>
                                    <span class="input-group-text">ريال</span>
                                </div>
                                <small class="text-muted">مجموع البنود 1 + 2 + 3</small>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label fw-semibold">5. إجمالي ضريبة القيمة المضافة المخرجات</label>
                                <div class="input-group">
                                    <input type="number" class="form-control bg-success text-white fw-bold" 
                                           value="{{ number_format($vatReturnData['output_vat'] ?? 0, 2) }}" readonly>
                                    <span class="input-group-text">ريال</span>
                                </div>
                                <small class="text-muted">ضريبة القيمة المضافة على المبيعات</small>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- القسم الرابع: ضريبة القيمة المضافة على المشتريات -->
                <div class="col-12 mb-4">
                    <h6 class="text-primary border-bottom pb-2 mb-3">
                        <i class="fas fa-shopping-cart me-2"></i>
                        القسم الرابع: ضريبة القيمة المضافة على المشتريات
                    </h6>
                    
                    <div class="row g-3">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label fw-semibold">6. ضريبة القيمة المضافة على المشتريات المدخلات</label>
                                <div class="input-group">
                                    <input type="number" class="form-control bg-info text-white fw-bold" 
                                           value="{{ number_format($vatReturnData['input_vat'] ?? 0, 2) }}" readonly>
                                    <span class="input-group-text">ريال</span>
                                </div>
                                <small class="text-muted">ضريبة القيمة المضافة على المشتريات</small>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label fw-semibold">7. صافي ضريبة القيمة المضافة المستحقة</label>
                                @php
                                    $netVATDue = $vatReturnData['net_vat'] ?? 0;
                                @endphp
                                <div class="input-group">
                                    <input type="number" class="form-control {{ $netVATDue >= 0 ? 'bg-warning text-dark' : 'bg-primary text-white' }} fw-bold" 
                                           value="{{ number_format($netVATDue, 2) }}" readonly>
                                    <span class="input-group-text">ريال</span>
                                </div>
                                <small class="text-muted">
                                    البند 5 - البند 6 = {{ $netVATDue >= 0 ? 'مستحقة للسداد' : 'مستردة من الهيئة' }}
                                </small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- معلومات إضافية للإقرار -->
    <div class="row mb-4">
        <!-- حالة الإقرار -->
        <div class="col-md-4">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-light">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-info-circle me-2 text-info"></i>
                        حالة الإقرار
                    </h6>
                </div>
                <div class="card-body">
                    @php
                        $netVATDue = $vatReturnData['net_vat'] ?? 0;
                        $statusClass = $netVATDue > 0 ? 'warning' : ($netVATDue < 0 ? 'primary' : 'success');
                        $statusText = $netVATDue > 0 ? 'يوجد ضريبة مستحقة' : ($netVATDue < 0 ? 'يوجد ضريبة مستردة' : 'لا توجد ضرائب مستحقة');
                        $statusIcon = $netVATDue > 0 ? 'fa-exclamation-triangle' : ($netVATDue < 0 ? 'fa-arrow-down' : 'fa-check-circle');
                    @endphp
                    
                    <div class="text-center">
                        <div class="status-icon bg-{{ $statusClass }} text-white mb-3 mx-auto">
                            <i class="fas {{ $statusIcon }}"></i>
                        </div>
                        <h6 class="text-{{ $statusClass }} mb-2">{{ $statusText }}</h6>
                        <p class="text-muted mb-0">
                            @if($netVATDue > 0)
                                يجب سداد هذا المبلغ قبل موعد الاستحقاق
                            @elseif($netVATDue < 0)
                                يمكن طلب استرداد هذا المبلغ من الهيئة
                            @else
                                الحساب متوازن لهذا الربع
                            @endif
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- مواعيد الاستحقاق -->
        <div class="col-md-4">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-light">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-calendar-times me-2 text-danger"></i>
                        مواعيد هامة
                    </h6>
                </div>
                <div class="card-body">
                    @php
                        $quarterEndDate = \Carbon\Carbon::parse($endDate ?? now());
                        $submissionDeadline = $quarterEndDate->copy()->addDays(28);
                        $paymentDeadline = $quarterEndDate->copy()->addDays(28);
                    @endphp
                    
                    <div class="mb-3">
                        <strong class="text-muted">موعد تقديم الإقرار:</strong>
                        <br>
                        <span class="text-danger">{{ $submissionDeadline->format('d/m/Y') }}</span>
                        <small class="text-muted d-block">خلال 28 يوم من انتهاء الربع</small>
                    </div>
                    
                    <div class="mb-3">
                        <strong class="text-muted">موعد سداد الضريبة:</strong>
                        <br>
                        <span class="text-warning">{{ $paymentDeadline->format('d/m/Y') }}</span>
                        <small class="text-muted d-block">مع موعد تقديم الإقرار</small>
                    </div>
                    
                    <div class="alert alert-warning py-2 px-3 mb-0">
                        <small>
                            <i class="fas fa-exclamation-triangle me-1"></i>
                            التأخير في التقديم أو السداد يؤدي إلى غرامات
                        </small>
                    </div>
                </div>
            </div>
        </div>

        <!-- إرشادات الإقرار -->
        <div class="col-md-4">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-light">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-question-circle me-2 text-success"></i>
                        إرشادات مهمة
                    </h6>
                </div>
                <div class="card-body">
                    <ul class="list-unstyled mb-0">
                        <li class="mb-2">
                            <i class="fas fa-check text-success me-2"></i>
                            <small>تأكد من دقة جميع البيانات قبل التقديم</small>
                        </li>
                        <li class="mb-2">
                            <i class="fas fa-check text-success me-2"></i>
                            <small>احتفظ بنسخة من الإقرار والوثائق المؤيدة</small>
                        </li>
                        <li class="mb-2">
                            <i class="fas fa-check text-success me-2"></i>
                            <small>راجع التطابق مع السجلات المحاسبية</small>
                        </li>
                        <li class="mb-0">
                            <i class="fas fa-check text-success me-2"></i>
                            <small>قدم الإقرار إلكترونياً عبر منصة زكاة</small>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <!-- ملاحظة هامة -->
    <div class="alert alert-info" role="alert">
        <div class="d-flex align-items-start">
            <i class="fas fa-info-circle me-2 mt-1"></i>
            <div>
                <strong>إخلاء مسؤولية:</strong>
                <p class="mb-0 mt-1">
                    هذا النموذج مخصص للمراجعة الداخلية فقط وقد لا يتطابق تماماً مع النموذج الرسمي. 
                    يجب التأكد من دقة جميع البيانات ومراجعة النموذج الرسمي في منصة زكاة قبل التقديم. 
                    الشركة غير مسؤولة عن أي أخطاء أو نقص في البيانات.
                </p>
            </div>
        </div>
    </div>
</div>

<style>
.stats-card {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border-radius: 12px;
}

.stats-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.15) !important;
}

.card {
    border-radius: 12px;
    animation: fadeInUp 0.6s ease forwards;
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.status-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
}

.form-control[readonly] {
    background-color: #f8f9fa;
    font-weight: 600;
}

.border-bottom {
    border-bottom: 1px solid #dee2e6 !important;
}

@media print {
    .btn, .card-header, .alert, .breadcrumb {
        display: none !important;
    }
    
    .card {
        border: 1px solid #000 !important;
        box-shadow: none !important;
    }
    
    .card-body {
        padding: 20px !important;
    }
    
    body {
        font-size: 12px !important;
    }
}
</style>

@push('scripts')
<script>
function exportReturn() {
    // يمكن تطوير هذه الوظيفة لاحقاً لتصدير الإقرار كـ PDF
    alert('سيتم تطوير وظيفة التصدير قريباً');
}

function printReturn() {
    window.print();
}

document.addEventListener('DOMContentLoaded', function() {
    // تحديث الصفحة عند تغيير الربع أو السنة
    const quarterSelect = document.getElementById('quarter');
    const yearSelect = document.getElementById('year');
    
    if (quarterSelect && yearSelect) {
        [quarterSelect, yearSelect].forEach(select => {
            select.addEventListener('change', function() {
                // يمكن إضافة تحديث تلقائي هنا إذا رغبت
            });
        });
    }
});
</script>
@endpush
@endsection