@extends('layouts.app')

@section('title', 'الإقرارات الضريبية')
@section('page-title', 'الإقرارات الضريبية')

@section('breadcrumb')
    <span>تقارير النظام</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>الإقرارات الضريبية</span>
@endsection

@section('content')
<div class="container-fluid">
    <!-- إحصائيات سريعة -->
    <div class="row mb-4">
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body text-center">
                    <div class="mb-3">
                        <i class="fas fa-receipt text-primary" style="font-size: 2.5rem;"></i>
                    </div>
                    <h5 class="card-title">ملخص ضريبة القيمة المضافة</h5>
                    <p class="card-text text-muted">إجمالي الضرائب المستحقة والمدفوعة</p>
                    <a href="{{ route('system-reports.tax.vat-summary') }}" class="btn btn-primary btn-sm">
                        <i class="fas fa-eye me-2"></i>عرض التقرير
                    </a>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body text-center">
                    <div class="mb-3">
                        <i class="fas fa-file-invoice-dollar text-success" style="font-size: 2.5rem;"></i>
                    </div>
                    <h5 class="card-title">إقرار ضريبة القيمة المضافة</h5>
                    <p class="card-text text-muted">تحضير الإقرار الضريبي الفصلي</p>
                    <a href="{{ route('system-reports.tax.vat-return') }}" class="btn btn-success btn-sm">
                        <i class="fas fa-eye me-2"></i>عرض التقرير
                    </a>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body text-center">
                    <div class="mb-3">
                        <i class="fas fa-list-alt text-warning" style="font-size: 2.5rem;"></i>
                    </div>
                    <h5 class="card-title">المعاملات الضريبية</h5>
                    <p class="card-text text-muted">سجل المعاملات الخاضعة للضريبة</p>
                    <a href="{{ route('system-reports.tax.transactions') }}" class="btn btn-warning btn-sm">
                        <i class="fas fa-eye me-2"></i>عرض التقرير
                    </a>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body text-center">
                    <div class="mb-3">
                        <i class="fas fa-users text-info" style="font-size: 2.5rem;"></i>
                    </div>
                    <h5 class="card-title">الضرائب حسب العميل</h5>
                    <p class="card-text text-muted">توزيع الضرائب على العملاء</p>
                    <a href="{{ route('system-reports.tax.by-customer') }}" class="btn btn-info btn-sm">
                        <i class="fas fa-eye me-2"></i>عرض التقرير
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- قائمة التقارير المتقدمة -->
    <div class="card border-0 shadow-sm">
        <div class="card-header bg-white border-bottom-0 pb-0">
            <h5 class="card-title mb-0">
                <i class="fas fa-calculator me-2 text-primary"></i>
                التقارير الضريبية المتقدمة
            </h5>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6 mb-3">
                    <div class="list-group">
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="mb-1">ملخص ضريبة القيمة المضافة</h6>
                                <p class="mb-1 text-muted">إجمالي الضرائب المستحقة والمدفوعة</p>
                            </div>
                            <a href="{{ route('system-reports.tax.vat-summary') }}" class="btn btn-outline-primary btn-sm">
                                عرض
                            </a>
                        </div>
                        
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="mb-1">إقرار ضريبة القيمة المضافة</h6>
                                <p class="mb-1 text-muted">الإقرار الضريبي الفصلي</p>
                            </div>
                            <a href="{{ route('system-reports.tax.vat-return') }}" class="btn btn-outline-success btn-sm">
                                عرض
                            </a>
                        </div>
                        
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="mb-1">المعاملات الضريبية</h6>
                                <p class="mb-1 text-muted">تفاصيل جميع المعاملات</p>
                            </div>
                            <a href="{{ route('system-reports.tax.transactions') }}" class="btn btn-outline-warning btn-sm">
                                عرض
                            </a>
                        </div>
                    </div>
                </div>

                <div class="col-md-6 mb-3">
                    <div class="list-group">
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="mb-1">الضرائب حسب العميل</h6>
                                <p class="mb-1 text-muted">توزيع الضرائب والأرقام الضريبية</p>
                            </div>
                            <a href="{{ route('system-reports.tax.by-customer') }}" class="btn btn-outline-info btn-sm">
                                عرض
                            </a>
                        </div>
                        
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="mb-1">مسار المراجعة الضريبي</h6>
                                <p class="mb-1 text-muted">سجل التغييرات والتعديلات</p>
                            </div>
                            <a href="{{ route('system-reports.tax.audit-trail') }}" class="btn btn-outline-secondary btn-sm">
                                عرض
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- معلومات هامة حول الضرائب -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="alert alert-info border-0 shadow-sm" style="border-radius: 12px;">
                <div class="d-flex align-items-center">
                    <div class="me-3">
                        <i class="fas fa-info-circle fa-2x text-info"></i>
                    </div>
                    <div>
                        <h6 class="alert-heading mb-2">معلومات مهمة حول الضرائب</h6>
                        <p class="mb-2">
                            • يجب تقديم إقرار ضريبة القيمة المضافة كل ثلاثة أشهر<br>
                            • تأكد من صحة الأرقام الضريبية للعملاء قبل إصدار الفواتير<br>
                            • احتفظ بسجلات دقيقة لجميع المعاملات الضريبية لمدة 6 سنوات
                        </p>
                        <div class="d-flex gap-2">
                            <a href="{{ route('system-reports.tax.vat-return') }}" class="btn btn-info btn-sm">
                                <i class="fas fa-file-download me-2"></i>تحضير الإقرار
                            </a>
                            <a href="{{ route('system-reports.tax.audit-trail') }}" class="btn btn-outline-info btn-sm">
                                <i class="fas fa-search me-2"></i>مراجعة السجلات
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.card {
    border-radius: 12px;
    overflow: hidden;
    transition: all 0.3s ease;
}

.card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.15) !important;
}

.list-group-item {
    border: none;
    border-radius: 8px !important;
    margin-bottom: 10px;
    background: #f8f9fa;
    transition: all 0.2s ease;
}

.list-group-item:hover {
    background: #e9ecef;
    transform: translateX(5px);
}

.btn {
    border-radius: 8px;
    font-weight: 500;
    transition: all 0.2s ease;
}

.btn:hover {
    transform: scale(1.05);
}

.alert {
    border-left: 4px solid #17a2b8;
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.card {
    animation: fadeInUp 0.6s ease forwards;
}

.card:nth-child(1) { animation-delay: 0.1s; }
.card:nth-child(2) { animation-delay: 0.2s; }
.card:nth-child(3) { animation-delay: 0.3s; }
.card:nth-child(4) { animation-delay: 0.4s; }

.alert {
    animation: fadeInUp 0.8s ease forwards;
    animation-delay: 0.5s;
}
</style>
@endsection