@extends('layouts.app')

@section('title', 'الضرائب حسب العميل')
@section('page-title', 'الضرائب حسب العميل')

@section('breadcrumb')
    <span>تقارير النظام</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>الإقرارات الضريبية</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>الضرائب حسب العميل</span>
@endsection

@section('content')
<div class="container-fluid">
    <!-- عنوان الصفحة والمرشحات -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="mb-0">
            <i class="fas fa-users me-2 text-primary"></i>
            تقرير الضرائب حسب العميل
        </h4>
        <div class="d-flex gap-2">
            <a href="{{ route('system-reports.tax.index') }}" class="btn btn-outline-secondary btn-sm">
                <i class="fas fa-arrow-right me-2"></i>العودة للتقارير
            </a>
            <button class="btn btn-success btn-sm" onclick="exportReport()">
                <i class="fas fa-download me-2"></i>تصدير التقرير
            </button>
        </div>
    </div>

    <!-- فلاتر التاريخ -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-body">
            <form method="GET" class="row g-3">
                <div class="col-md-4">
                    <label for="start_date" class="form-label">من تاريخ</label>
                    <input type="date" class="form-control" id="start_date" name="start_date" 
                           value="{{ request('start_date', $startDate ?? now()->startOfMonth()->format('Y-m-d')) }}">
                </div>
                <div class="col-md-4">
                    <label for="end_date" class="form-label">إلى تاريخ</label>
                    <input type="date" class="form-control" id="end_date" name="end_date" 
                           value="{{ request('end_date', $endDate ?? now()->endOfMonth()->format('Y-m-d')) }}">
                </div>
                <div class="col-md-4 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary me-2">
                        <i class="fas fa-filter me-2"></i>تطبيق المرشح
                    </button>
                    <a href="{{ route('system-reports.tax.by-customer') }}" class="btn btn-outline-secondary">
                        إعادة تعيين
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- إحصائيات العملاء والضرائب -->
    @php
        $totalCustomers = $customerTax->total() ?? 0;
        $totalInvoices = $customerTax->sum('total_invoices') ?? 0;
        $totalTax = $customerTax->sum('total_tax') ?? 0;
        $totalWithTax = $customerTax->sum('total_with_tax') ?? 0;
    @endphp

    <div class="row mb-4">
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-primary text-white mb-3">
                        <i class="fas fa-users"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($totalCustomers) }}</h3>
                    <p class="text-muted mb-0">عملاء لديهم معاملات ضريبية</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-info text-white mb-3">
                        <i class="fas fa-receipt"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($totalInvoices) }}</h3>
                    <p class="text-muted mb-0">إجمالي الفواتير</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-warning text-white mb-3">
                        <i class="fas fa-percentage"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($totalTax, 2) }}</h3>
                    <p class="text-muted mb-0">إجمالي الضرائب (ريال)</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-success text-white mb-3">
                        <i class="fas fa-money-bill-wave"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($totalWithTax, 2) }}</h3>
                    <p class="text-muted mb-0">إجمالي المبالغ مع الضريبة (ريال)</p>
                </div>
            </div>
        </div>
    </div>

    <!-- الرسوم البيانية والتحليلات -->
    <div class="row mb-4">
        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-light">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-chart-bar me-2 text-info"></i>
                        أعلى العملاء في دفع الضرائب
                    </h6>
                </div>
                <div class="card-body">
                    <canvas id="topCustomersTaxChart" height="200"></canvas>
                </div>
            </div>
        </div>
        
        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-light">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-chart-pie me-2 text-success"></i>
                        توزيع الضرائب حسب نوع العميل
                    </h6>
                </div>
                <div class="card-body">
                    <canvas id="customerTypeTaxChart" height="200"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- جدول تفصيل الضرائب حسب العميل -->
    <div class="card border-0 shadow-sm">
        <div class="card-header bg-white border-bottom-0">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="fas fa-table me-2 text-primary"></i>
                    تفصيل الضرائب حسب العميل
                </h5>
                <div class="d-flex align-items-center gap-2">
                    <small class="text-muted">
                        عرض {{ $customerTax->firstItem() ?? 0 }} - {{ $customerTax->lastItem() ?? 0 }} من {{ $customerTax->total() ?? 0 }} عميل
                    </small>
                </div>
            </div>
        </div>
        <div class="card-body p-0">
            @if($customerTax && $customerTax->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th class="px-4 py-3">العميل</th>
                                <th class="px-4 py-3 text-center">الرقم الضريبي</th>
                                <th class="px-4 py-3 text-center">عدد الفواتير</th>
                                <th class="px-4 py-3 text-center">المبلغ قبل الضريبة</th>
                                <th class="px-4 py-3 text-center">ضريبة القيمة المضافة</th>
                                <th class="px-4 py-3 text-center">المبلغ الإجمالي</th>
                                <th class="px-4 py-3 text-center">نسبة الضريبة</th>
                                <th class="px-4 py-3 text-center">متوسط الفاتورة</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($customerTax as $customer)
                                <tr>
                                    <td class="px-4 py-3">
                                        <div class="d-flex align-items-center">
                                            <div class="customer-avatar bg-primary text-white me-3">
                                                {{ substr($customer->name, 0, 1) }}
                                            </div>
                                            <div>
                                                <div class="fw-semibold">{{ $customer->name ?: 'عميل غير محدد' }}</div>
                                                <small class="text-muted">ID: {{ $customer->id }}</small>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="px-4 py-3 text-center">
                                        @if($customer->vat_number)
                                            <span class="badge bg-success">{{ $customer->vat_number }}</span>
                                        @else
                                            <span class="badge bg-light text-dark">غير محدد</span>
                                        @endif
                                    </td>
                                    <td class="px-4 py-3 text-center">
                                        <span class="badge bg-info">{{ number_format($customer->total_invoices) }}</span>
                                    </td>
                                    <td class="px-4 py-3 text-center">
                                        <strong class="text-primary">{{ number_format($customer->total_before_tax, 2) }} ريال</strong>
                                    </td>
                                    <td class="px-4 py-3 text-center">
                                        <strong class="text-warning">{{ number_format($customer->total_tax, 2) }} ريال</strong>
                                    </td>
                                    <td class="px-4 py-3 text-center">
                                        <strong class="text-success">{{ number_format($customer->total_with_tax, 2) }} ريال</strong>
                                    </td>
                                    <td class="px-4 py-3 text-center">
                                        @php
                                            $taxPercentage = $customer->total_before_tax > 0 
                                                ? ($customer->total_tax / $customer->total_before_tax) * 100 
                                                : 0;
                                        @endphp
                                        <div class="d-flex align-items-center justify-content-center">
                                            <div class="progress me-2" style="width: 60px; height: 8px;">
                                                <div class="progress-bar bg-warning" 
                                                     style="width: {{ min($taxPercentage, 100) }}%"></div>
                                            </div>
                                            <span class="fw-semibold">{{ number_format($taxPercentage, 1) }}%</span>
                                        </div>
                                    </td>
                                    <td class="px-4 py-3 text-center">
                                        @php
                                            $avgInvoiceValue = $customer->total_invoices > 0 
                                                ? $customer->total_with_tax / $customer->total_invoices 
                                                : 0;
                                        @endphp
                                        <span class="text-info">{{ number_format($avgInvoiceValue, 2) }} ريال</span>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                
                <!-- الصفحات -->
                @if($customerTax->hasPages())
                    <div class="d-flex justify-content-center py-3">
                        {{ $customerTax->appends(request()->query())->links() }}
                    </div>
                @endif
            @else
                <div class="text-center py-5">
                    <div class="mb-3">
                        <i class="fas fa-users fa-3x text-muted"></i>
                    </div>
                    <h5 class="text-muted">لا توجد بيانات ضريبية للعملاء</h5>
                    <p class="text-muted">لم يتم العثور على أي معاملات ضريبية للعملاء في هذه الفترة.</p>
                </div>
            @endif
        </div>
    </div>

    <!-- تحليل وتوصيات -->
    @if($customerTax && $customerTax->count() > 0)
        <div class="row mt-4">
            <!-- تحليل العملاء حسب الضرائب -->
            <div class="col-md-6">
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-light">
                        <h6 class="card-title mb-0">
                            <i class="fas fa-chart-line me-2 text-info"></i>
                            تحليل العملاء الضريبي
                        </h6>
                    </div>
                    <div class="card-body">
                        @php
                            $highTaxCustomers = $customerTax->where('total_tax', '>=', 1000)->count();
                            $mediumTaxCustomers = $customerTax->whereBetween('total_tax', [500, 999])->count();
                            $lowTaxCustomers = $customerTax->where('total_tax', '<', 500)->count();
                            $customersWithVAT = $customerTax->whereNotNull('vat_number')->count();
                        @endphp
                        
                        <div class="row g-3">
                            <div class="col-6">
                                <div class="text-center p-3 bg-danger text-white rounded">
                                    <h4 class="mb-1">{{ $highTaxCustomers }}</h4>
                                    <small>عملاء كبار (+1000 ريال ضريبة)</small>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="text-center p-3 bg-warning text-white rounded">
                                    <h4 class="mb-1">{{ $mediumTaxCustomers }}</h4>
                                    <small>عملاء متوسطين (500-999 ريال)</small>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="text-center p-3 bg-info text-white rounded">
                                    <h4 class="mb-1">{{ $lowTaxCustomers }}</h4>
                                    <small>عملاء صغار (أقل من 500 ريال)</small>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="text-center p-3 bg-success text-white rounded">
                                    <h4 class="mb-1">{{ $customersWithVAT }}</h4>
                                    <small>عملاء لديهم رقم ضريبي</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- التوصيات الضريبية -->
            <div class="col-md-6">
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-light">
                        <h6 class="card-title mb-0">
                            <i class="fas fa-lightbulb me-2 text-warning"></i>
                            التوصيات الضريبية
                        </h6>
                    </div>
                    <div class="card-body">
                        <ul class="list-unstyled mb-0">
                            @if($customersWithVAT < $totalCustomers * 0.5)
                                <li class="mb-2">
                                    <i class="fas fa-exclamation-triangle text-danger me-2"></i>
                                    تحديث الأرقام الضريبية للعملاء المؤهلين
                                </li>
                            @endif
                            @if($highTaxCustomers > 0)
                                <li class="mb-2">
                                    <i class="fas fa-star text-warning me-2"></i>
                                    مراجعة خاصة للعملاء كبار الضرائب ({{ $highTaxCustomers }})
                                </li>
                            @endif
                            <li class="mb-2">
                                <i class="fas fa-check-circle text-success me-2"></i>
                                التأكد من دقة حساب الضرائب لجميع الفواتير
                            </li>
                            <li class="mb-2">
                                <i class="fas fa-file-alt text-info me-2"></i>
                                الاحتفاظ بسجلات مفصلة للمراجعة الضريبية
                            </li>
                            <li class="mb-0">
                                <i class="fas fa-calendar-alt text-primary me-2"></i>
                                مراجعة دورية لتقارير الضرائب الشهرية
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    @endif

    <!-- ملاحظة هامة -->
    <div class="alert alert-info mt-4" role="alert">
        <div class="d-flex align-items-start">
            <i class="fas fa-info-circle me-2 mt-1"></i>
            <div>
                <strong>ملاحظة حول التقرير الضريبي للعملاء:</strong>
                <ul class="mb-0 mt-2">
                    <li><strong>الرقم الضريبي:</strong> مطلوب للشركات والأفراد المسجلين ضريبياً</li>
                    <li><strong>نسبة الضريبة:</strong> تحسب كنسبة مئوية من إجمالي المبلغ قبل الضريبة</li>
                    <li><strong>الفترة:</strong> يشمل التقرير جميع الفواتير الصادرة في الفترة المحددة</li>
                    <li><strong>متوسط الفاتورة:</strong> المبلغ الإجمالي مقسوماً على عدد الفواتير</li>
                </ul>
            </div>
        </div>
    </div>
</div>

<style>
.stats-card {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border-radius: 12px;
}

.stats-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.15) !important;
}

.stats-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto;
    font-size: 1.5rem;
}

.customer-avatar {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: bold;
    font-size: 1.1rem;
}

.card {
    border-radius: 12px;
    animation: fadeInUp 0.6s ease forwards;
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.table th {
    border-top: none;
    font-weight: 600;
    color: #495057;
    background-color: #f8f9fa !important;
}

.table tbody tr:hover {
    background-color: #f8f9fa;
}

.badge {
    font-size: 0.75rem;
    padding: 0.4rem 0.8rem;
}

.progress {
    background-color: #e9ecef;
}
</style>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
function exportReport() {
    // يمكن تطوير هذه الوظيفة لاحقاً لتصدير التقرير
    alert('سيتم تطوير وظيفة التصدير قريباً');
}

document.addEventListener('DOMContentLoaded', function() {
    const customerTaxData = @json($customerTax->items());
    
    // رسم عمودي لأعلى العملاء في دفع الضرائب
    const topCustomersCtx = document.getElementById('topCustomersTaxChart').getContext('2d');
    const topCustomers = customerTaxData.slice(0, 5);
    
    new Chart(topCustomersCtx, {
        type: 'bar',
        data: {
            labels: topCustomers.map(c => (c.name || 'عميل غير محدد').length > 12 ? (c.name || 'عميل غير محدد').substring(0, 12) + '...' : (c.name || 'عميل غير محدد')),
            datasets: [{
                label: 'ضريبة القيمة المضافة (ريال)',
                data: topCustomers.map(c => c.total_tax || 0),
                backgroundColor: 'rgba(255, 193, 7, 0.8)',
                borderColor: 'rgba(255, 193, 7, 1)',
                borderWidth: 1,
                borderRadius: 5
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                },
                tooltip: {
                    backgroundColor: 'rgba(0, 0, 0, 0.8)',
                    titleColor: '#fff',
                    bodyColor: '#fff',
                    borderColor: '#ffc107',
                    borderWidth: 1,
                    cornerRadius: 6,
                    callbacks: {
                        label: function(context) {
                            return 'الضريبة: ' + context.parsed.y.toLocaleString('ar-SA', {minimumFractionDigits: 2}) + ' ريال';
                        }
                    }
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return value.toLocaleString('ar-SA') + ' ريال';
                        }
                    }
                }
            }
        }
    });

    // رسم دائري افتراضي لتوزيع الضرائب حسب نوع العميل
    const customerTypeCtx = document.getElementById('customerTypeTaxChart').getContext('2d');
    
    // حساب التوزيع بناء على مقدار الضريبة
    let businessTax = 0;
    let individualTax = 0;
    
    customerTaxData.forEach(customer => {
        // تصنيف العملاء بناء على وجود الرقم الضريبي
        if (customer.vat_number) {
            businessTax += customer.total_tax || 0;
        } else {
            individualTax += customer.total_tax || 0;
        }
    });
    
    new Chart(customerTypeCtx, {
        type: 'doughnut',
        data: {
            labels: ['شركات', 'أفراد'],
            datasets: [{
                data: [businessTax, individualTax],
                backgroundColor: [
                    'rgba(40, 167, 69, 0.8)',
                    'rgba(23, 162, 184, 0.8)'
                ],
                borderColor: [
                    'rgba(40, 167, 69, 1)',
                    'rgba(23, 162, 184, 1)'
                ],
                borderWidth: 2
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            cutout: '50%',
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        padding: 20,
                        usePointStyle: true,
                        font: {
                            size: 12
                        }
                    }
                },
                tooltip: {
                    backgroundColor: 'rgba(0, 0, 0, 0.8)',
                    titleColor: '#fff',
                    bodyColor: '#fff',
                    borderColor: '#28a745',
                    borderWidth: 1,
                    cornerRadius: 6,
                    callbacks: {
                        label: function(context) {
                            const label = context.label || '';
                            const value = context.parsed;
                            const total = businessTax + individualTax;
                            const percentage = total > 0 ? ((value / total) * 100).toFixed(1) : 0;
                            return label + ': ' + value.toLocaleString('ar-SA', {minimumFractionDigits: 2}) + ' ريال (' + percentage + '%)';
                        }
                    }
                }
            }
        }
    });

    // تحديث الصفحة عند تغيير التاريخ
    const startDate = document.getElementById('start_date');
    const endDate = document.getElementById('end_date');
    
    if (startDate && endDate) {
        startDate.addEventListener('change', function() {
            if (endDate.value && this.value > endDate.value) {
                endDate.value = this.value;
            }
        });
        
        endDate.addEventListener('change', function() {
            if (startDate.value && this.value < startDate.value) {
                startDate.value = this.value;
            }
        });
    }
});
</script>
@endpush
@endsection