@extends('layouts.app')

@section('title', 'مسار المراجعة الضريبي')
@section('page-title', 'مسار المراجعة الضريبي')

@section('breadcrumb')
    <span>تقارير النظام</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>الإقرارات الضريبية</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>مسار المراجعة الضريبي</span>
@endsection

@section('content')
<div class="container-fluid">
    <!-- عنوان الصفحة والمرشحات -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="mb-0">
            <i class="fas fa-search me-2 text-primary"></i>
            مسار المراجعة الضريبي
        </h4>
        <div class="d-flex gap-2">
            <a href="{{ route('system-reports.tax.index') }}" class="btn btn-outline-secondary btn-sm">
                <i class="fas fa-arrow-right me-2"></i>العودة للتقارير
            </a>
            <button class="btn btn-success btn-sm" onclick="exportAuditTrail()">
                <i class="fas fa-download me-2"></i>تصدير التقرير
            </button>
        </div>
    </div>

    <!-- فلاتر التاريخ -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-body">
            <form method="GET" class="row g-3">
                <div class="col-md-4">
                    <label for="start_date" class="form-label">من تاريخ</label>
                    <input type="date" class="form-control" id="start_date" name="start_date" 
                           value="{{ request('start_date', $startDate ?? now()->startOfMonth()->format('Y-m-d')) }}">
                </div>
                <div class="col-md-4">
                    <label for="end_date" class="form-label">إلى تاريخ</label>
                    <input type="date" class="form-control" id="end_date" name="end_date" 
                           value="{{ request('end_date', $endDate ?? now()->endOfMonth()->format('Y-m-d')) }}">
                </div>
                <div class="col-md-4 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary me-2">
                        <i class="fas fa-filter me-2"></i>تطبيق المرشح
                    </button>
                    <a href="{{ route('system-reports.tax.audit-trail') }}" class="btn btn-outline-secondary">
                        إعادة تعيين
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- إحصائيات مسار المراجعة -->
    @php
        $salesAuditCount = $auditTrail->where('type', 'فاتورة مبيعات')->count();
        $purchaseAuditCount = $auditTrail->where('type', 'فاتورة مشتريات')->count();
        $totalTaxAmount = $auditTrail->sum('tax_amount');
        $totalRecords = $auditTrail->count();
        
        // حساب المعدلات
        $averageTaxPerRecord = $totalRecords > 0 ? $totalTaxAmount / $totalRecords : 0;
        $salesTaxTotal = $auditTrail->where('type', 'فاتورة مبيعات')->sum('tax_amount');
        $purchaseTaxTotal = $auditTrail->where('type', 'فاتورة مشتريات')->sum('tax_amount');
    @endphp

    <div class="row mb-4">
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-primary text-white mb-3">
                        <i class="fas fa-list-alt"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($totalRecords) }}</h3>
                    <p class="text-muted mb-0">إجمالي السجلات</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-success text-white mb-3">
                        <i class="fas fa-arrow-up"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($salesAuditCount) }}</h3>
                    <p class="text-muted mb-0">سجلات فواتير المبيعات</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-info text-white mb-3">
                        <i class="fas fa-arrow-down"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($purchaseAuditCount) }}</h3>
                    <p class="text-muted mb-0">سجلات فواتير المشتريات</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-warning text-white mb-3">
                        <i class="fas fa-percentage"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($totalTaxAmount, 2) }}</h3>
                    <p class="text-muted mb-0">إجمالي الضرائب (ريال)</p>
                </div>
            </div>
        </div>
    </div>

    <!-- تحليل مسار المراجعة -->
    <div class="row mb-4">
        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-light">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-chart-bar me-2 text-info"></i>
                        توزيع السجلات حسب النوع
                    </h6>
                </div>
                <div class="card-body">
                    <canvas id="auditTypeChart" height="200"></canvas>
                </div>
            </div>
        </div>
        
        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-light">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-calculator me-2 text-success"></i>
                        ملخص الضرائب حسب النوع
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-6">
                            <div class="text-center p-3 bg-success text-white rounded">
                                <h4 class="mb-1">{{ number_format($salesTaxTotal, 2) }}</h4>
                                <small>ضريبة مبيعات (ريال)</small>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="text-center p-3 bg-info text-white rounded">
                                <h4 class="mb-1">{{ number_format($purchaseTaxTotal, 2) }}</h4>
                                <small>ضريبة مشتريات (ريال)</small>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="text-center p-3 bg-warning text-dark rounded">
                                <h4 class="mb-1">{{ number_format($averageTaxPerRecord, 2) }}</h4>
                                <small>متوسط الضريبة لكل سجل (ريال)</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- جدول مسار المراجعة التفصيلي -->
    <div class="card border-0 shadow-sm">
        <div class="card-header bg-white border-bottom-0">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="fas fa-table me-2 text-primary"></i>
                    سجل مسار المراجعة الضريبي
                </h5>
                <div class="d-flex align-items-center gap-2">
                    <small class="text-muted">
                        عرض {{ number_format($auditTrail->count()) }} سجل مراجعة
                    </small>
                </div>
            </div>
        </div>
        <div class="card-body p-0">
            @if($auditTrail && $auditTrail->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th class="px-4 py-3">رقم المرجع</th>
                                <th class="px-4 py-3 text-center">نوع المعاملة</th>
                                <th class="px-4 py-3 text-center">تاريخ المعاملة</th>
                                <th class="px-4 py-3 text-center">مبلغ الضريبة</th>
                                <th class="px-4 py-3 text-center">تاريخ الإنشاء</th>
                                <th class="px-4 py-3 text-center">تاريخ التعديل</th>
                                <th class="px-4 py-3 text-center">حالة السجل</th>
                                <th class="px-4 py-3 text-center">الإجراء</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($auditTrail->take(50) as $record)
                                <tr>
                                    <td class="px-4 py-3">
                                        <div class="d-flex align-items-center">
                                            <div class="record-icon {{ $record['type'] === 'فاتورة مبيعات' ? 'bg-success' : 'bg-info' }} text-white me-3">
                                                <i class="fas {{ $record['type'] === 'فاتورة مبيعات' ? 'fa-arrow-up' : 'fa-arrow-down' }}"></i>
                                            </div>
                                            <div>
                                                <div class="fw-semibold">{{ $record['reference'] ?: 'غير محدد' }}</div>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="px-4 py-3 text-center">
                                        <span class="badge {{ $record['type'] === 'فاتورة مبيعات' ? 'bg-success' : 'bg-info' }}">
                                            {{ $record['type'] }}
                                        </span>
                                    </td>
                                    <td class="px-4 py-3 text-center">
                                        <span class="text-muted">{{ \Carbon\Carbon::parse($record['date'])->format('d/m/Y') }}</span>
                                        <br>
                                        <small class="text-muted">{{ \Carbon\Carbon::parse($record['date'])->format('H:i') }}</small>
                                    </td>
                                    <td class="px-4 py-3 text-center">
                                        <strong class="text-warning">{{ number_format($record['tax_amount'], 2) }} ريال</strong>
                                    </td>
                                    <td class="px-4 py-3 text-center">
                                        <span class="text-primary">{{ \Carbon\Carbon::parse($record['created_at'])->format('d/m/Y H:i') }}</span>
                                    </td>
                                    <td class="px-4 py-3 text-center">
                                        @if($record['updated_at'] != $record['created_at'])
                                            <span class="text-warning">{{ \Carbon\Carbon::parse($record['updated_at'])->format('d/m/Y H:i') }}</span>
                                            <br>
                                            <small class="badge bg-warning text-dark">تم التعديل</small>
                                        @else
                                            <span class="text-muted">لم يتم التعديل</span>
                                        @endif
                                    </td>
                                    <td class="px-4 py-3 text-center">
                                        @php
                                            $isModified = $record['updated_at'] != $record['created_at'];
                                            $daysSinceCreation = \Carbon\Carbon::parse($record['created_at'])->diffInDays(now());
                                        @endphp
                                        
                                        @if($isModified)
                                            <span class="badge bg-warning">معدل</span>
                                        @elseif($daysSinceCreation < 1)
                                            <span class="badge bg-success">جديد</span>
                                        @else
                                            <span class="badge bg-secondary">مستقر</span>
                                        @endif
                                    </td>
                                    <td class="px-4 py-3 text-center">
                                        <div class="btn-group" role="group">
                                            <button type="button" class="btn btn-outline-primary btn-sm" onclick="viewDetails('{{ $record['reference'] }}')">
                                                <i class="fas fa-eye"></i>
                                            </button>
                                            <button type="button" class="btn btn-outline-info btn-sm" onclick="viewHistory('{{ $record['reference'] }}')">
                                                <i class="fas fa-history"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                
                @if($auditTrail->count() > 50)
                    <div class="alert alert-info m-3" role="alert">
                        <i class="fas fa-info-circle me-2"></i>
                        <strong>ملاحظة:</strong> يتم عرض أول 50 سجل فقط. استخدم المرشحات لتضييق النتائج أو قم بتصدير التقرير للحصول على جميع السجلات.
                    </div>
                @endif
            @else
                <div class="text-center py-5">
                    <div class="mb-3">
                        <i class="fas fa-search fa-3x text-muted"></i>
                    </div>
                    <h5 class="text-muted">لا توجد سجلات مراجعة</h5>
                    <p class="text-muted">لم يتم العثور على أي سجلات مراجعة ضريبية في هذه الفترة.</p>
                </div>
            @endif
        </div>
    </div>

    <!-- معلومات إضافية حول المراجعة -->
    @if($auditTrail && $auditTrail->count() > 0)
        <div class="row mt-4">
            <!-- تحليل التعديلات -->
            <div class="col-md-4">
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-light">
                        <h6 class="card-title mb-0">
                            <i class="fas fa-edit me-2 text-warning"></i>
                            تحليل التعديلات
                        </h6>
                    </div>
                    <div class="card-body">
                        @php
                            $modifiedRecords = $auditTrail->filter(function($record) {
                                return $record['updated_at'] != $record['created_at'];
                            })->count();
                            $modificationRate = $totalRecords > 0 ? ($modifiedRecords / $totalRecords) * 100 : 0;
                        @endphp
                        
                        <div class="text-center">
                            <div class="modification-circle mb-3 mx-auto">
                                <span class="h4 text-warning">{{ $modifiedRecords }}</span>
                            </div>
                            <h6 class="text-warning mb-2">سجلات معدلة</h6>
                            <p class="text-muted mb-0">
                                نسبة التعديل: {{ number_format($modificationRate, 1) }}%
                                <br>
                                <small>من إجمالي {{ $totalRecords }} سجل</small>
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- نشاط المراجعة -->
            <div class="col-md-4">
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-light">
                        <h6 class="card-title mb-0">
                            <i class="fas fa-activity me-2 text-success"></i>
                            نشاط المراجعة
                        </h6>
                    </div>
                    <div class="card-body">
                        @php
                            $recentRecords = $auditTrail->filter(function($record) {
                                return \Carbon\Carbon::parse($record['created_at'])->diffInDays(now()) < 7;
                            })->count();
                        @endphp
                        
                        <div class="mb-3">
                            <div class="d-flex justify-content-between align-items-center">
                                <span class="text-muted">سجلات الأسبوع الماضي:</span>
                                <strong class="text-success">{{ $recentRecords }}</strong>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <div class="d-flex justify-content-between align-items-center">
                                <span class="text-muted">متوسط السجلات يومياً:</span>
                                <strong class="text-info">{{ number_format($totalRecords / max(\Carbon\Carbon::parse($startDate ?? now()->startOfMonth())->diffInDays(now()) + 1, 1), 1) }}</strong>
                            </div>
                        </div>
                        
                        <div class="progress">
                            <div class="progress-bar bg-success" role="progressbar" 
                                 style="width: {{ min(($recentRecords / max($totalRecords, 1)) * 100, 100) }}%">
                            </div>
                        </div>
                        <small class="text-muted">نشاط حديث</small>
                    </div>
                </div>
            </div>

            <!-- توصيات المراجعة -->
            <div class="col-md-4">
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-light">
                        <h6 class="card-title mb-0">
                            <i class="fas fa-clipboard-check me-2 text-primary"></i>
                            توصيات المراجعة
                        </h6>
                    </div>
                    <div class="card-body">
                        <ul class="list-unstyled mb-0">
                            @if($modificationRate > 20)
                                <li class="mb-2">
                                    <i class="fas fa-exclamation-triangle text-warning me-2"></i>
                                    <small>نسبة التعديلات عالية - راجع العمليات</small>
                                </li>
                            @endif
                            <li class="mb-2">
                                <i class="fas fa-shield-alt text-success me-2"></i>
                                <small>راجع السجلات المعدلة بانتظام</small>
                            </li>
                            <li class="mb-2">
                                <i class="fas fa-archive text-info me-2"></i>
                                <small>احتفظ بسجلات المراجعة لمدة 6 سنوات</small>
                            </li>
                            <li class="mb-0">
                                <i class="fas fa-clock text-primary me-2"></i>
                                <small>راجع التقرير شهرياً للمتابعة</small>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    @endif

    <!-- ملاحظة هامة -->
    <div class="alert alert-info mt-4" role="alert">
        <div class="d-flex align-items-start">
            <i class="fas fa-info-circle me-2 mt-1"></i>
            <div>
                <strong>ملاحظة حول مسار المراجعة الضريبي:</strong>
                <ul class="mb-0 mt-2">
                    <li><strong>الغرض:</strong> تتبع جميع التغييرات والأنشطة المتعلقة بالمعاملات الضريبية</li>
                    <li><strong>الاحتفاظ:</strong> يجب الاحتفاظ بسجلات المراجعة لمدة لا تقل عن 6 سنوات</li>
                    <li><strong>المراجعة:</strong> يُنصح بمراجعة هذا التقرير بانتظام لضمان سلامة البيانات</li>
                    <li><strong>الأمان:</strong> هذه المعلومات حساسة ويجب الحفاظ على سريتها</li>
                </ul>
            </div>
        </div>
    </div>
</div>

<style>
.stats-card {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border-radius: 12px;
}

.stats-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.15) !important;
}

.stats-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto;
    font-size: 1.5rem;
}

.record-icon {
    width: 35px;
    height: 35px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.9rem;
}

.modification-circle {
    width: 80px;
    height: 80px;
    border: 3px solid #ffc107;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    background-color: rgba(255, 193, 7, 0.1);
}

.card {
    border-radius: 12px;
    animation: fadeInUp 0.6s ease forwards;
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.table th {
    border-top: none;
    font-weight: 600;
    color: #495057;
    background-color: #f8f9fa !important;
}

.table tbody tr:hover {
    background-color: #f8f9fa;
}

.badge {
    font-size: 0.75rem;
    padding: 0.4rem 0.8rem;
}

.btn-group .btn {
    padding: 0.25rem 0.5rem;
}
</style>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
function exportAuditTrail() {
    // يمكن تطوير هذه الوظيفة لاحقاً لتصدير تقرير المراجعة
    alert('سيتم تطوير وظيفة التصدير قريباً');
}

function viewDetails(reference) {
    alert('عرض تفاصيل السجل: ' + reference + '\nسيتم تطوير هذه الوظيفة قريباً');
}

function viewHistory(reference) {
    alert('عرض تاريخ التعديلات للسجل: ' + reference + '\nسيتم تطوير هذه الوظيفة قريباً');
}

document.addEventListener('DOMContentLoaded', function() {
    const auditTrail = @json($auditTrail->values());
    
    // رسم دائري لتوزيع السجلات حسب النوع
    const typeCtx = document.getElementById('auditTypeChart').getContext('2d');
    
    const salesCount = auditTrail.filter(record => record.type === 'فاتورة مبيعات').length;
    const purchasesCount = auditTrail.filter(record => record.type === 'فاتورة مشتريات').length;
    
    new Chart(typeCtx, {
        type: 'doughnut',
        data: {
            labels: ['فواتير المبيعات', 'فواتير المشتريات'],
            datasets: [{
                data: [salesCount, purchasesCount],
                backgroundColor: [
                    'rgba(40, 167, 69, 0.8)',
                    'rgba(23, 162, 184, 0.8)'
                ],
                borderColor: [
                    'rgba(40, 167, 69, 1)',
                    'rgba(23, 162, 184, 1)'
                ],
                borderWidth: 2
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            cutout: '50%',
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        padding: 20,
                        usePointStyle: true,
                        font: {
                            size: 12
                        }
                    }
                },
                tooltip: {
                    backgroundColor: 'rgba(0, 0, 0, 0.8)',
                    titleColor: '#fff',
                    bodyColor: '#fff',
                    borderColor: '#28a745',
                    borderWidth: 1,
                    cornerRadius: 6,
                    callbacks: {
                        label: function(context) {
                            const label = context.label || '';
                            const value = context.parsed;
                            const total = salesCount + purchasesCount;
                            const percentage = total > 0 ? ((value / total) * 100).toFixed(1) : 0;
                            return label + ': ' + value + ' سجل (' + percentage + '%)';
                        }
                    }
                }
            }
        }
    });

    // تحديث الصفحة عند تغيير التاريخ
    const startDate = document.getElementById('start_date');
    const endDate = document.getElementById('end_date');
    
    if (startDate && endDate) {
        startDate.addEventListener('change', function() {
            if (endDate.value && this.value > endDate.value) {
                endDate.value = this.value;
            }
        });
        
        endDate.addEventListener('change', function() {
            if (startDate.value && this.value < startDate.value) {
                startDate.value = this.value;
            }
        });
    }
});
</script>
@endpush
@endsection