@extends('layouts.app')

@section('title', 'ملخص الموردين')
@section('page-title', 'ملخص الموردين')

@section('breadcrumb')
    <span>تقارير النظام</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>تقارير الموردين</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>ملخص الموردين</span>
@endsection

@section('content')
<div class="container-fluid">
    <!-- عنوان الصفحة -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="mb-0">
            <i class="fas fa-truck me-2 text-primary"></i>
            ملخص الموردين
        </h4>
        <a href="{{ route('system-reports.supplier.index') }}" class="btn btn-outline-secondary btn-sm">
            <i class="fas fa-arrow-right me-2"></i>العودة للتقارير
        </a>
    </div>

    <!-- إحصائيات سريعة للموردين -->
    <div class="row mb-4">
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-primary text-white mb-3">
                        <i class="fas fa-truck"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($supplierStats->total_suppliers) }}</h3>
                    <p class="text-muted mb-0">إجمالي الموردين</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-success text-white mb-3">
                        <i class="fas fa-check-circle"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($supplierStats->active_suppliers) }}</h3>
                    <p class="text-muted mb-0">موردين نشطين</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-warning text-white mb-3">
                        <i class="fas fa-pause-circle"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($supplierStats->inactive_suppliers) }}</h3>
                    <p class="text-muted mb-0">موردين غير نشطين</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-info text-white mb-3">
                        <i class="fas fa-percentage"></i>
                    </div>
                    <h3 class="mb-2">
                        {{ $supplierStats->total_suppliers > 0 ? number_format(($supplierStats->active_suppliers / $supplierStats->total_suppliers) * 100, 1) : 0 }}%
                    </h3>
                    <p class="text-muted mb-0">معدل النشاط</p>
                </div>
            </div>
        </div>
    </div>

    <!-- الرسوم البيانية -->
    <div class="row mb-4">
        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom-0">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-chart-pie me-2 text-info"></i>
                        توزيع حالة الموردين
                    </h6>
                </div>
                <div class="card-body">
                    <canvas id="supplierStatusChart" height="200"></canvas>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom-0">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-chart-bar me-2 text-primary"></i>
                        أعلى موردين في المشتريات
                    </h6>
                </div>
                <div class="card-body">
                    <canvas id="topSuppliersChart" height="200"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- قائمة أفضل الموردين -->
    <div class="card border-0 shadow-sm">
        <div class="card-header bg-white border-bottom-0">
            <h5 class="card-title mb-0">
                <i class="fas fa-star me-2 text-warning"></i>
                أفضل الموردين
            </h5>
        </div>
        <div class="card-body">
            @if($topSuppliers->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead class="table-light">
                            <tr>
                                <th>#</th>
                                <th>اسم المورد</th>
                                <th>معلومات الاتصال</th>
                                <th>عدد الفواتير</th>
                                <th>إجمالي المشتريات</th>
                                <th>متوسط الفاتورة</th>
                                <th>التقييم</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($topSuppliers as $index => $supplier)
                                <tr>
                                    <td>
                                        <span class="badge bg-light text-dark">{{ $index + 1 }}</span>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="supplier-avatar me-3">
                                                <i class="fas fa-truck"></i>
                                            </div>
                                            <div>
                                                <h6 class="mb-0">{{ $supplier->name ?: 'مورد غير محدد' }}</h6>
                                                <small class="text-muted">ID: {{ $supplier->id }}</small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <div>
                                            @if($supplier->email)
                                                <div class="text-info mb-1">
                                                    <i class="fas fa-envelope me-1"></i>{{ $supplier->email }}
                                                </div>
                                            @endif
                                            @if($supplier->phone)
                                                <div class="text-success">
                                                    <i class="fas fa-phone me-1"></i>{{ $supplier->phone }}
                                                </div>
                                            @endif
                                            @if(!$supplier->email && !$supplier->phone)
                                                <span class="text-muted">غير محدد</span>
                                            @endif
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge bg-primary px-3 py-2">{{ number_format($supplier->total_invoices) }}</span>
                                    </td>
                                    <td>
                                        <strong class="text-success">{{ number_format($supplier->total_purchases, 2) }} ريال</strong>
                                    </td>
                                    <td>
                                        <span class="text-info">
                                            {{ $supplier->total_invoices > 0 ? number_format($supplier->total_purchases / $supplier->total_invoices, 2) : 0 }} ريال
                                        </span>
                                    </td>
                                    <td>
                                        @php
                                            $totalSupplierPurchases = $topSuppliers->sum('total_purchases');
                                            $percentage = $totalSupplierPurchases > 0 ? ($supplier->total_purchases / $totalSupplierPurchases) * 100 : 0;
                                        @endphp
                                        
                                        @if($percentage >= 20)
                                            <span class="badge bg-danger">استراتيجي</span>
                                        @elseif($percentage >= 10)
                                            <span class="badge bg-warning">مهم</span>
                                        @elseif($percentage >= 5)
                                            <span class="badge bg-info">نشط</span>
                                        @else
                                            <span class="badge bg-secondary">عادي</span>
                                        @endif
                                        
                                        <div class="progress mt-1" style="height: 5px;">
                                            <div class="progress-bar bg-success" role="progressbar" 
                                                 style="width: {{ min($percentage, 100) }}%" 
                                                 aria-valuenow="{{ $percentage }}" 
                                                 aria-valuemin="0" aria-valuemax="100">
                                            </div>
                                        </div>
                                        <small class="text-muted">{{ number_format($percentage, 1) }}%</small>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- ملخص التصنيفات -->
                <div class="row mt-4">
                    @php
                        $totalSupplierPurchases = $topSuppliers->sum('total_purchases');
                        $strategicCount = $topSuppliers->filter(function($s) use($totalSupplierPurchases) { 
                            return $totalSupplierPurchases > 0 ? (($s->total_purchases / $totalSupplierPurchases) * 100) >= 20 : false; 
                        })->count();
                        $importantCount = $topSuppliers->filter(function($s) use($totalSupplierPurchases) { 
                            $percentage = $totalSupplierPurchases > 0 ? (($s->total_purchases / $totalSupplierPurchases) * 100) : 0;
                            return $percentage >= 10 && $percentage < 20; 
                        })->count();
                        $activeCount = $topSuppliers->filter(function($s) use($totalSupplierPurchases) { 
                            $percentage = $totalSupplierPurchases > 0 ? (($s->total_purchases / $totalSupplierPurchases) * 100) : 0;
                            return $percentage >= 5 && $percentage < 10; 
                        })->count();
                        $normalCount = $topSuppliers->count() - $strategicCount - $importantCount - $activeCount;
                    @endphp

                    <div class="col-md-3">
                        <div class="card bg-danger text-white">
                            <div class="card-body text-center">
                                <h4>{{ $strategicCount }}</h4>
                                <p class="mb-0">موردين استراتيجيين</p>
                                <small class="opacity-75">نسبة +20%</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-warning text-white">
                            <div class="card-body text-center">
                                <h4>{{ $importantCount }}</h4>
                                <p class="mb-0">موردين مهمين</p>
                                <small class="opacity-75">نسبة 10-20%</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-info text-white">
                            <div class="card-body text-center">
                                <h4>{{ $activeCount }}</h4>
                                <p class="mb-0">موردين نشطين</p>
                                <small class="opacity-75">نسبة 5-10%</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-secondary text-white">
                            <div class="card-body text-center">
                                <h4>{{ $normalCount }}</h4>
                                <p class="mb-0">موردين عاديين</p>
                                <small class="opacity-75">نسبة أقل من 5%</small>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- توصيات -->
                <div class="alert alert-info mt-4" role="alert">
                    <div class="d-flex align-items-center">
                        <i class="fas fa-lightbulb me-2"></i>
                        <div>
                            <strong>التوصيات:</strong>
                            @if($supplierStats->active_suppliers / max($supplierStats->total_suppliers, 1) < 0.8)
                                يوصى بمراجعة الموردين غير النشطين وتقييم أدائهم.
                            @endif
                            @if($strategicCount > 3)
                                يوصى بتنويع قاعدة الموردين لتقليل المخاطر.
                            @endif
                            @if($topSuppliers->count() < 5)
                                يوصى بالبحث عن موردين جدد لتوسيع خيارات الشراء.
                            @endif
                        </div>
                    </div>
                </div>
            @else
                <div class="text-center py-5">
                    <i class="fas fa-truck text-muted" style="font-size: 4rem;"></i>
                    <h5 class="mt-3 text-muted">لا توجد بيانات للموردين</h5>
                    <p class="text-muted">لم يتم العثور على أي موردين نشطين</p>
                </div>
            @endif
        </div>
    </div>
</div>

<style>
.stats-card {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border-radius: 12px;
}

.stats-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.15) !important;
}

.stats-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto;
    font-size: 1.5rem;
}

.supplier-avatar {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: linear-gradient(45deg, #17a2b8, #138496);
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.9rem;
}

.card {
    border-radius: 12px;
    animation: fadeInUp 0.6s ease forwards;
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.table th {
    border-top: none;
    font-weight: 600;
    color: #495057;
}

.progress {
    background-color: #e9ecef;
}

.table tbody tr:hover {
    background-color: #f8f9fa;
}
</style>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // رسم دائري لحالة الموردين
    const statusCtx = document.getElementById('supplierStatusChart').getContext('2d');
    const supplierStats = @json($supplierStats);
    
    new Chart(statusCtx, {
        type: 'doughnut',
        data: {
            labels: ['نشط', 'غير نشط'],
            datasets: [{
                data: [supplierStats.active_suppliers, supplierStats.inactive_suppliers],
                backgroundColor: [
                    'rgba(40, 167, 69, 0.8)',
                    'rgba(255, 193, 7, 0.8)'
                ],
                borderColor: [
                    'rgba(40, 167, 69, 1)',
                    'rgba(255, 193, 7, 1)'
                ],
                borderWidth: 2
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        padding: 20,
                        usePointStyle: true
                    }
                }
            }
        }
    });

    // رسم عمودي لأعلى الموردين
    const topSuppliersCtx = document.getElementById('topSuppliersChart').getContext('2d');
    const topSuppliers = @json($topSuppliers->take(5)->values());
    
    new Chart(topSuppliersCtx, {
        type: 'bar',
        data: {
            labels: topSuppliers.map(s => (s.name || 'مورد غير محدد').length > 10 ? (s.name || 'مورد غير محدد').substring(0, 10) + '...' : (s.name || 'مورد غير محدد')),
            datasets: [{
                label: 'إجمالي المشتريات (ريال)',
                data: topSuppliers.map(s => s.total_purchases),
                backgroundColor: 'rgba(23, 162, 184, 0.8)',
                borderColor: 'rgba(23, 162, 184, 1)',
                borderWidth: 1,
                borderRadius: 5
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return new Intl.NumberFormat('ar-SA').format(value) + ' ريال';
                        }
                    }
                }
            }
        }
    });
});
</script>
@endpush
@endsection