@extends('layouts.app')

@section('title', 'تقرير أداء الموردين')
@section('page-title', 'تقرير أداء الموردين')

@section('breadcrumb')
    <span>تقارير النظام</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>تقارير الموردين</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>تقرير أداء الموردين</span>
@endsection

@section('content')
<div class="container-fluid">
    <!-- عنوان الصفحة والمرشحات -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="mb-0">
            <i class="fas fa-chart-line me-2 text-primary"></i>
            تقرير أداء الموردين
        </h4>
        <div class="d-flex gap-2">
            <a href="{{ route('system-reports.supplier.index') }}" class="btn btn-outline-secondary btn-sm">
                <i class="fas fa-arrow-right me-2"></i>العودة للتقارير
            </a>
            <button class="btn btn-success btn-sm" onclick="exportReport()">
                <i class="fas fa-download me-2"></i>تصدير التقرير
            </button>
        </div>
    </div>

    <!-- فلاتر التاريخ -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-body">
            <form method="GET" class="row g-3">
                <div class="col-md-4">
                    <label for="start_date" class="form-label">من تاريخ</label>
                    <input type="date" class="form-control" id="start_date" name="start_date" 
                           value="{{ request('start_date', $startDate ?? now()->startOfMonth()->format('Y-m-d')) }}">
                </div>
                <div class="col-md-4">
                    <label for="end_date" class="form-label">إلى تاريخ</label>
                    <input type="date" class="form-control" id="end_date" name="end_date" 
                           value="{{ request('end_date', $endDate ?? now()->endOfMonth()->format('Y-m-d')) }}">
                </div>
                <div class="col-md-4 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary me-2">
                        <i class="fas fa-filter me-2"></i>تطبيق المرشح
                    </button>
                    <a href="{{ route('system-reports.supplier.performance') }}" class="btn btn-outline-secondary">
                        إعادة تعيين
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- إحصائيات الأداء العامة -->
    @php
        $totalSuppliers = $supplierPerformance->total() ?? 0;
        $totalOrders = $supplierPerformance->sum('total_orders') ?? 0;
        $totalPurchases = $supplierPerformance->sum('total_purchases') ?? 0;
        $avgCompletionRate = $supplierPerformance->avg('completion_rate') ?? 0;
    @endphp

    <div class="row mb-4">
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-primary text-white mb-3">
                        <i class="fas fa-truck"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($totalSuppliers) }}</h3>
                    <p class="text-muted mb-0">إجمالي الموردين</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-info text-white mb-3">
                        <i class="fas fa-shopping-cart"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($totalOrders) }}</h3>
                    <p class="text-muted mb-0">إجمالي الطلبات</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-success text-white mb-3">
                        <i class="fas fa-dollar-sign"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($totalPurchases, 2) }}</h3>
                    <p class="text-muted mb-0">إجمالي المشتريات (ريال)</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-warning text-white mb-3">
                        <i class="fas fa-percentage"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($avgCompletionRate, 1) }}%</h3>
                    <p class="text-muted mb-0">متوسط معدل الإنجاز</p>
                </div>
            </div>
        </div>
    </div>

    <!-- جدول تفصيل أداء الموردين -->
    <div class="card border-0 shadow-sm">
        <div class="card-header bg-white border-bottom-0">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="fas fa-table me-2 text-primary"></i>
                    تفصيل أداء الموردين
                </h5>
                <div class="d-flex align-items-center gap-2">
                    <small class="text-muted">
                        عرض {{ $supplierPerformance->firstItem() ?? 0 }} - {{ $supplierPerformance->lastItem() ?? 0 }} من {{ $supplierPerformance->total() ?? 0 }} مورد
                    </small>
                </div>
            </div>
        </div>
        <div class="card-body p-0">
            @if($supplierPerformance && $supplierPerformance->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th class="px-4 py-3">المورد</th>
                                <th class="px-4 py-3 text-center">تاريخ التسجيل</th>
                                <th class="px-4 py-3 text-center">عدد الطلبات</th>
                                <th class="px-4 py-3 text-center">عدد الفواتير</th>
                                <th class="px-4 py-3 text-center">إجمالي المشتريات</th>
                                <th class="px-4 py-3 text-center">متوسط قيمة الطلب</th>
                                <th class="px-4 py-3 text-center">معدل الإنجاز</th>
                                <th class="px-4 py-3 text-center">آخر شراء</th>
                                <th class="px-4 py-3 text-center">التقييم</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($supplierPerformance as $supplier)
                                <tr>
                                    <td class="px-4 py-3">
                                        <div class="d-flex align-items-center">
                                            <div class="supplier-avatar bg-primary text-white me-3">
                                                {{ substr($supplier->name, 0, 1) }}
                                            </div>
                                            <div>
                                                <div class="fw-semibold">{{ $supplier->name ?: 'مورد غير محدد' }}</div>
                                                @if($supplier->email)
                                                    <small class="text-muted">{{ $supplier->email }}</small>
                                                @endif
                                                @if($supplier->phone)
                                                    <br><small class="text-info">{{ $supplier->phone }}</small>
                                                @endif
                                            </div>
                                        </div>
                                    </td>
                                    <td class="px-4 py-3 text-center">
                                        <span class="text-muted">{{ \Carbon\Carbon::parse($supplier->registration_date)->format('d/m/Y') }}</span>
                                    </td>
                                    <td class="px-4 py-3 text-center">
                                        <span class="badge bg-info">{{ number_format($supplier->total_orders) }}</span>
                                    </td>
                                    <td class="px-4 py-3 text-center">
                                        <span class="badge bg-primary">{{ number_format($supplier->total_invoices) }}</span>
                                    </td>
                                    <td class="px-4 py-3 text-center">
                                        <strong class="text-success">{{ number_format($supplier->total_purchases, 2) }} ريال</strong>
                                    </td>
                                    <td class="px-4 py-3 text-center">
                                        <span class="text-primary">{{ number_format($supplier->avg_order_value, 2) }} ريال</span>
                                    </td>
                                    <td class="px-4 py-3 text-center">
                                        <div class="d-flex align-items-center justify-content-center">
                                            <div class="progress me-2" style="width: 60px; height: 8px;">
                                                @php
                                                    $completionRate = $supplier->completion_rate ?? 0;
                                                    $progressClass = 'bg-danger';
                                                    if ($completionRate >= 80) $progressClass = 'bg-success';
                                                    elseif ($completionRate >= 60) $progressClass = 'bg-warning';
                                                    elseif ($completionRate >= 40) $progressClass = 'bg-info';
                                                @endphp
                                                <div class="progress-bar {{ $progressClass }}" 
                                                     style="width: {{ $completionRate }}%"></div>
                                            </div>
                                            <span class="fw-semibold">{{ number_format($completionRate, 1) }}%</span>
                                        </div>
                                    </td>
                                    <td class="px-4 py-3 text-center">
                                        @if($supplier->last_purchase_date)
                                            <span class="text-muted">{{ \Carbon\Carbon::parse($supplier->last_purchase_date)->format('d/m/Y') }}</span>
                                            <br>
                                            <small class="text-warning">
                                                منذ {{ $supplier->days_since_last_purchase }} يوم
                                            </small>
                                        @else
                                            <span class="text-muted">لم يتم الشراء بعد</span>
                                        @endif
                                    </td>
                                    <td class="px-4 py-3 text-center">
                                        @php
                                            $rating = 'ضعيف';
                                            $badgeClass = 'bg-danger';
                                            $completionRate = $supplier->completion_rate ?? 0;
                                            
                                            if ($completionRate >= 90) {
                                                $rating = 'ممتاز';
                                                $badgeClass = 'bg-success';
                                            } elseif ($completionRate >= 80) {
                                                $rating = 'جيد جداً';
                                                $badgeClass = 'bg-success';
                                            } elseif ($completionRate >= 70) {
                                                $rating = 'جيد';
                                                $badgeClass = 'bg-info';
                                            } elseif ($completionRate >= 60) {
                                                $rating = 'مقبول';
                                                $badgeClass = 'bg-warning';
                                            } elseif ($completionRate >= 40) {
                                                $rating = 'ضعيف';
                                                $badgeClass = 'bg-danger';
                                            }
                                            
                                            // تقييم إضافي بناء على العوامل الأخرى
                                            $score = 0;
                                            if ($supplier->total_purchases >= 50000) $score += 2;
                                            elseif ($supplier->total_purchases >= 10000) $score += 1;
                                            
                                            if ($supplier->days_since_last_purchase <= 30) $score += 1;
                                            elseif ($supplier->days_since_last_purchase <= 90) $score += 0;
                                            else $score -= 1;
                                            
                                            if ($score >= 3) {
                                                $rating = 'استراتيجي';
                                                $badgeClass = 'bg-danger';
                                            } elseif ($score >= 2) {
                                                $rating = 'مهم';
                                                $badgeClass = 'bg-warning';
                                            }
                                        @endphp
                                        <span class="badge {{ $badgeClass }}">{{ $rating }}</span>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                
                <!-- الصفحات -->
                @if($supplierPerformance->hasPages())
                    <div class="d-flex justify-content-center py-3">
                        {{ $supplierPerformance->appends(request()->query())->links() }}
                    </div>
                @endif
            @else
                <div class="text-center py-5">
                    <div class="mb-3">
                        <i class="fas fa-truck fa-3x text-muted"></i>
                    </div>
                    <h5 class="text-muted">لا توجد بيانات أداء</h5>
                    <p class="text-muted">لم يتم العثور على أي بيانات أداء للموردين في هذه الفترة.</p>
                </div>
            @endif
        </div>
    </div>

    <!-- تحليل الأداء وتوصيات -->
    @if($supplierPerformance && $supplierPerformance->count() > 0)
        <div class="row mt-4">
            <!-- ملخص الأداء -->
            <div class="col-md-6">
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-light">
                        <h6 class="card-title mb-0">
                            <i class="fas fa-chart-pie me-2 text-info"></i>
                            ملخص الأداء
                        </h6>
                    </div>
                    <div class="card-body">
                        @php
                            $excellentCount = $supplierPerformance->where('completion_rate', '>=', 90)->count();
                            $goodCount = $supplierPerformance->whereBetween('completion_rate', [70, 89])->count();
                            $acceptableCount = $supplierPerformance->whereBetween('completion_rate', [50, 69])->count();
                            $poorCount = $supplierPerformance->where('completion_rate', '<', 50)->count();
                        @endphp
                        
                        <div class="row g-3">
                            <div class="col-6">
                                <div class="text-center p-3 bg-success text-white rounded">
                                    <h4 class="mb-1">{{ $excellentCount }}</h4>
                                    <small>ممتاز (90%+)</small>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="text-center p-3 bg-info text-white rounded">
                                    <h4 class="mb-1">{{ $goodCount }}</h4>
                                    <small>جيد (70-89%)</small>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="text-center p-3 bg-warning text-white rounded">
                                    <h4 class="mb-1">{{ $acceptableCount }}</h4>
                                    <small>مقبول (50-69%)</small>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="text-center p-3 bg-danger text-white rounded">
                                    <h4 class="mb-1">{{ $poorCount }}</h4>
                                    <small>ضعيف (أقل من 50%)</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- التوصيات -->
            <div class="col-md-6">
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-light">
                        <h6 class="card-title mb-0">
                            <i class="fas fa-lightbulb me-2 text-warning"></i>
                            توصيات لتحسين الأداء
                        </h6>
                    </div>
                    <div class="card-body">
                        <ul class="list-unstyled mb-0">
                            @if($poorCount > 0)
                                <li class="mb-2">
                                    <i class="fas fa-exclamation-triangle text-danger me-2"></i>
                                    مراجعة أداء {{ $poorCount }} مورد ضعيف الأداء
                                </li>
                            @endif
                            @if($excellentCount > 0)
                                <li class="mb-2">
                                    <i class="fas fa-star text-warning me-2"></i>
                                    تطوير شراكات استراتيجية مع {{ $excellentCount }} مورد ممتاز
                                </li>
                            @endif
                            <li class="mb-2">
                                <i class="fas fa-chart-line text-info me-2"></i>
                                تحسين معدل الإنجاز الإجمالي إلى 85%+
                            </li>
                            <li class="mb-2">
                                <i class="fas fa-handshake text-success me-2"></i>
                                وضع برامج تحفيز للموردين عالي الأداء
                            </li>
                            <li class="mb-0">
                                <i class="fas fa-clock text-primary me-2"></i>
                                متابعة الموردين الذين لم يقوموا بمشتريات مؤخراً
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    @endif

    <!-- ملاحظة هامة -->
    <div class="alert alert-info mt-4" role="alert">
        <div class="d-flex align-items-start">
            <i class="fas fa-info-circle me-2 mt-1"></i>
            <div>
                <strong>ملاحظة حول تقييم الأداء:</strong>
                <ul class="mb-0 mt-2">
                    <li><strong>معدل الإنجاز:</strong> نسبة الطلبات المكتملة من إجمالي الطلبات</li>
                    <li><strong>التقييم الاستراتيجي:</strong> يأخذ في الاعتبار قيمة المشتريات وحداثة التعامل</li>
                    <li><strong>متوسط قيمة الطلب:</strong> إجمالي المشتريات مقسوماً على عدد الفواتير</li>
                    <li><strong>آخر شراء:</strong> عدد الأيام منذ آخر عملية شراء من المورد</li>
                </ul>
            </div>
        </div>
    </div>
</div>

<style>
.stats-card {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border-radius: 12px;
}

.stats-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.15) !important;
}

.stats-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto;
    font-size: 1.5rem;
}

.supplier-avatar {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: bold;
    font-size: 1.1rem;
}

.card {
    border-radius: 12px;
    animation: fadeInUp 0.6s ease forwards;
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.table th {
    border-top: none;
    font-weight: 600;
    color: #495057;
    background-color: #f8f9fa !important;
}

.table tbody tr:hover {
    background-color: #f8f9fa;
}

.badge {
    font-size: 0.75rem;
    padding: 0.4rem 0.8rem;
}

.progress {
    background-color: #e9ecef;
}
</style>

@push('scripts')
<script>
function exportReport() {
    // يمكن تطوير هذه الوظيفة لاحقاً لتصدير التقرير
    alert('سيتم تطوير وظيفة التصدير قريباً');
}

// تحديث الصفحة عند تغيير التاريخ
document.addEventListener('DOMContentLoaded', function() {
    const startDate = document.getElementById('start_date');
    const endDate = document.getElementById('end_date');
    
    if (startDate && endDate) {
        startDate.addEventListener('change', function() {
            if (endDate.value && this.value > endDate.value) {
                endDate.value = this.value;
            }
        });
        
        endDate.addEventListener('change', function() {
            if (startDate.value && this.value < startDate.value) {
                startDate.value = this.value;
            }
        });
    }
});
</script>
@endpush
@endsection