@extends('layouts.app')

@section('title', 'ملخص المبيعات')
@section('page-title', 'ملخص المبيعات')

@section('breadcrumb')
    <span>تقارير النظام</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>تقارير المبيعات</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>ملخص المبيعات</span>
@endsection

@section('content')
<div class="container-fluid">
    <!-- فلتر التاريخ -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-header bg-white border-bottom-0">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="fas fa-filter me-2 text-primary"></i>
                    تصفية البيانات
                </h5>
                <a href="{{ route('system-reports.sales.index') }}" class="btn btn-outline-secondary btn-sm">
                    <i class="fas fa-arrow-right me-2"></i>العودة للتقارير
                </a>
            </div>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('system-reports.sales.summary') }}">
                <div class="row">
                    <div class="col-md-4">
                        <label for="start_date" class="form-label">من تاريخ</label>
                        <input type="date" class="form-control" id="start_date" name="start_date" 
                               value="{{ request('start_date', $startDate->format('Y-m-d')) }}">
                    </div>
                    <div class="col-md-4">
                        <label for="end_date" class="form-label">إلى تاريخ</label>
                        <input type="date" class="form-control" id="end_date" name="end_date" 
                               value="{{ request('end_date', $endDate->format('Y-m-d')) }}">
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">&nbsp;</label>
                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-search me-2"></i>تطبيق الفلتر
                            </button>
                            <button type="button" class="btn btn-success" onclick="exportReport()">
                                <i class="fas fa-download me-2"></i>تصدير
                            </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- إحصائيات سريعة -->
    <div class="row mb-4">
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-primary text-white mb-3">
                        <i class="fas fa-file-invoice-dollar"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($salesData->total_invoices) }}</h3>
                    <p class="text-muted mb-0">إجمالي الفواتير</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-success text-white mb-3">
                        <i class="fas fa-money-bill-wave"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($salesData->total_sales, 2) }} ريال</h3>
                    <p class="text-muted mb-0">إجمالي المبيعات</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-warning text-white mb-3">
                        <i class="fas fa-percent"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($salesData->total_tax, 2) }} ريال</h3>
                    <p class="text-muted mb-0">إجمالي الضريبة</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-info text-white mb-3">
                        <i class="fas fa-calculator"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($salesData->average_sale, 2) }} ريال</h3>
                    <p class="text-muted mb-0">متوسط الفاتورة</p>
                </div>
            </div>
        </div>
    </div>

    <!-- الرسم البياني للمبيعات الشهرية -->
    @if($monthlySales->count() > 0)
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-header bg-white border-bottom-0">
            <h5 class="card-title mb-0">
                <i class="fas fa-chart-line me-2 text-primary"></i>
                اتجاه المبيعات الشهرية
            </h5>
        </div>
        <div class="card-body">
            <canvas id="salesChart" height="100"></canvas>
        </div>
    </div>
    @endif

    <!-- تفاصيل المبيعات الشهرية -->
    <div class="card border-0 shadow-sm">
        <div class="card-header bg-white border-bottom-0">
            <h5 class="card-title mb-0">
                <i class="fas fa-table me-2 text-primary"></i>
                المبيعات الشهرية بالتفصيل
            </h5>
        </div>
        <div class="card-body">
            @if($monthlySales->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead class="table-light">
                            <tr>
                                <th>الشهر</th>
                                <th>السنة</th>
                                <th>إجمالي المبيعات</th>
                                <th>النسبة من الإجمالي</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($monthlySales as $monthly)
                                <tr>
                                    <td>
                                        <span class="badge bg-primary">
                                            {{ \Carbon\Carbon::createFromDate($monthly->year, $monthly->month, 1)->format('F') }}
                                        </span>
                                    </td>
                                    <td>{{ $monthly->year }}</td>
                                    <td>
                                        <strong>{{ number_format($monthly->total, 2) }} ريال</strong>
                                    </td>
                                    <td>
                                        @php
                                            $percentage = $salesData->total_sales > 0 ? ($monthly->total / $salesData->total_sales) * 100 : 0;
                                        @endphp
                                        <div class="progress" style="height: 20px;">
                                            <div class="progress-bar" role="progressbar" 
                                                 style="width: {{ $percentage }}%" 
                                                 aria-valuenow="{{ $percentage }}" 
                                                 aria-valuemin="0" aria-valuemax="100">
                                                {{ number_format($percentage, 1) }}%
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <div class="text-center py-4">
                    <i class="fas fa-chart-line text-muted" style="font-size: 3rem;"></i>
                    <p class="text-muted mt-3">لا توجد بيانات مبيعات في الفترة المحددة</p>
                </div>
            @endif
        </div>
    </div>
</div>

<style>
.stats-card {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border-radius: 12px;
}

.stats-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.15) !important;
}

.stats-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto;
    font-size: 1.5rem;
}

.card {
    border-radius: 12px;
    animation: fadeInUp 0.6s ease forwards;
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.table th {
    border-top: none;
    font-weight: 600;
    color: #495057;
}

.progress {
    background-color: #e9ecef;
}
</style>

@push('scripts')
@if($monthlySales->count() > 0)
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const ctx = document.getElementById('salesChart').getContext('2d');
    const chart = new Chart(ctx, {
        type: 'line',
        data: {
            labels: [
                @foreach($monthlySales as $monthly)
                    '{{ \Carbon\Carbon::createFromDate($monthly->year, $monthly->month, 1)->format('M Y') }}',
                @endforeach
            ],
            datasets: [{
                label: 'المبيعات (ريال)',
                data: [
                    @foreach($monthlySales as $monthly)
                        {{ $monthly->total }},
                    @endforeach
                ],
                borderColor: '#007bff',
                backgroundColor: 'rgba(0, 123, 255, 0.1)',
                borderWidth: 3,
                fill: true,
                tension: 0.4
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    display: true,
                    position: 'top'
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return new Intl.NumberFormat('ar-SA').format(value) + ' ريال';
                        }
                    }
                }
            }
        }
    });
});

function exportReport() {
    const startDate = document.getElementById('start_date').value;
    const endDate = document.getElementById('end_date').value;
    
    const url = `{{ route('system-reports.sales.export') }}?type=summary&format=excel&start_date=${startDate}&end_date=${endDate}`;
    window.open(url, '_blank');
}
</script>
@endif
@endpush
@endsection