@extends('layouts.app')

@section('title', 'تقارير المبيعات')
@section('page-title', 'تقارير المبيعات')

@section('breadcrumb')
    <span>تقارير النظام</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>تقارير المبيعات</span>
@endsection

@section('content')
<div class="container-fluid">
    <!-- إحصائيات سريعة -->
    <div class="row mb-4">
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body text-center">
                    <div class="mb-3">
                        <i class="fas fa-chart-line text-primary" style="font-size: 2.5rem;"></i>
                    </div>
                    <h5 class="card-title">ملخص المبيعات</h5>
                    <p class="card-text text-muted">عرض إجمالي المبيعات والإحصائيات</p>
                    <a href="{{ route('system-reports.sales.summary') }}" class="btn btn-primary btn-sm">
                        <i class="fas fa-eye me-2"></i>عرض التقرير
                    </a>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body text-center">
                    <div class="mb-3">
                        <i class="fas fa-users text-success" style="font-size: 2.5rem;"></i>
                    </div>
                    <h5 class="card-title">المبيعات حسب العميل</h5>
                    <p class="card-text text-muted">تحليل مبيعات كل عميل</p>
                    <a href="{{ route('system-reports.sales.by-customer') }}" class="btn btn-success btn-sm">
                        <i class="fas fa-eye me-2"></i>عرض التقرير
                    </a>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body text-center">
                    <div class="mb-3">
                        <i class="fas fa-boxes text-warning" style="font-size: 2.5rem;"></i>
                    </div>
                    <h5 class="card-title">المبيعات حسب المنتج</h5>
                    <p class="card-text text-muted">أداء المنتجات في المبيعات</p>
                    <a href="{{ route('system-reports.sales.by-product') }}" class="btn btn-warning btn-sm">
                        <i class="fas fa-eye me-2"></i>عرض التقرير
                    </a>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body text-center">
                    <div class="mb-3">
                        <i class="fas fa-calendar-day text-info" style="font-size: 2.5rem;"></i>
                    </div>
                    <h5 class="card-title">المبيعات اليومية</h5>
                    <p class="card-text text-muted">تقرير المبيعات لكل يوم</p>
                    <a href="{{ route('system-reports.sales.daily') }}" class="btn btn-info btn-sm">
                        <i class="fas fa-eye me-2"></i>عرض التقرير
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- قائمة التقارير المتقدمة -->
    <div class="card border-0 shadow-sm">
        <div class="card-header bg-white border-bottom-0 pb-0">
            <h5 class="card-title mb-0">
                <i class="fas fa-chart-pie me-2 text-primary"></i>
                تقارير المبيعات المتقدمة
            </h5>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6 mb-3">
                    <div class="list-group">
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="mb-1">ملخص شامل للمبيعات</h6>
                                <p class="mb-1 text-muted">عرض الإجماليات والاتجاهات</p>
                            </div>
                            <a href="{{ route('system-reports.sales.summary') }}" class="btn btn-outline-primary btn-sm">
                                عرض
                            </a>
                        </div>
                        
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="mb-1">تحليل العملاء</h6>
                                <p class="mb-1 text-muted">مبيعات وأداء كل عميل</p>
                            </div>
                            <a href="{{ route('system-reports.sales.by-customer') }}" class="btn btn-outline-success btn-sm">
                                عرض
                            </a>
                        </div>
                    </div>
                </div>

                <div class="col-md-6 mb-3">
                    <div class="list-group">
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="mb-1">تحليل المنتجات</h6>
                                <p class="mb-1 text-muted">أداء وربحية المنتجات</p>
                            </div>
                            <a href="{{ route('system-reports.sales.by-product') }}" class="btn btn-outline-warning btn-sm">
                                عرض
                            </a>
                        </div>
                        
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="mb-1">التقرير اليومي</h6>
                                <p class="mb-1 text-muted">مبيعات اليوم بالتفصيل</p>
                            </div>
                            <a href="{{ route('system-reports.sales.daily') }}" class="btn btn-outline-info btn-sm">
                                عرض
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.card {
    border-radius: 12px;
    overflow: hidden;
    transition: all 0.3s ease;
}

.card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.15) !important;
}

.list-group-item {
    border: none;
    border-radius: 8px !important;
    margin-bottom: 10px;
    background: #f8f9fa;
    transition: all 0.2s ease;
}

.list-group-item:hover {
    background: #e9ecef;
    transform: translateX(5px);
}

.btn {
    border-radius: 8px;
    font-weight: 500;
    transition: all 0.2s ease;
}

.btn:hover {
    transform: scale(1.05);
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.card {
    animation: fadeInUp 0.6s ease forwards;
}

.card:nth-child(1) { animation-delay: 0.1s; }
.card:nth-child(2) { animation-delay: 0.2s; }
.card:nth-child(3) { animation-delay: 0.3s; }
.card:nth-child(4) { animation-delay: 0.4s; }
</style>
@endsection