@extends('layouts.app')

@section('title', 'المبيعات اليومية')
@section('page-title', 'المبيعات اليومية')

@section('breadcrumb')
    <span>تقارير النظام</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>تقارير المبيعات</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>المبيعات اليومية</span>
@endsection

@section('content')
<div class="container-fluid">
    <!-- فلتر التاريخ -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-header bg-white border-bottom-0">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="fas fa-calendar-day me-2 text-primary"></i>
                    اختر التاريخ
                </h5>
                <a href="{{ route('system-reports.sales.index') }}" class="btn btn-outline-secondary btn-sm">
                    <i class="fas fa-arrow-right me-2"></i>العودة للتقارير
                </a>
            </div>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('system-reports.sales.daily') }}">
                <div class="row align-items-end">
                    <div class="col-md-4">
                        <label for="date" class="form-label">التاريخ</label>
                        <input type="date" class="form-control" id="date" name="date" 
                               value="{{ request('date', $date) }}">
                    </div>
                    <div class="col-md-4">
                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-search me-2"></i>عرض التقرير
                            </button>
                            <button type="button" class="btn btn-success" onclick="exportReport()">
                                <i class="fas fa-download me-2"></i>تصدير
                            </button>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="text-end">
                            <h6 class="mb-0 text-muted">التاريخ المحدد:</h6>
                            <p class="mb-0 fw-bold">{{ \Carbon\Carbon::parse($date)->format('l, F j, Y') }}</p>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- إجمالي اليوم -->
    <div class="row mb-4">
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card bg-primary text-white">
                <div class="card-body text-center">
                    <div class="stats-icon mb-3">
                        <i class="fas fa-file-invoice-dollar"></i>
                    </div>
                    <h3 class="mb-2">{{ $totalDaily->total_invoices ?? 0 }}</h3>
                    <p class="mb-0 opacity-75">إجمالي الفواتير</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card bg-success text-white">
                <div class="card-body text-center">
                    <div class="stats-icon mb-3">
                        <i class="fas fa-money-bill-wave"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($totalDaily->total_sales ?? 0, 2) }} ريال</h3>
                    <p class="mb-0 opacity-75">إجمالي المبيعات</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card bg-warning text-white">
                <div class="card-body text-center">
                    <div class="stats-icon mb-3">
                        <i class="fas fa-percent"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($totalDaily->total_tax ?? 0, 2) }} ريال</h3>
                    <p class="mb-0 opacity-75">إجمالي الضريبة</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card bg-info text-white">
                <div class="card-body text-center">
                    <div class="stats-icon mb-3">
                        <i class="fas fa-calculator"></i>
                    </div>
                    <h3 class="mb-2">
                        {{ $totalDaily->total_invoices > 0 ? number_format($totalDaily->total_sales / $totalDaily->total_invoices, 2) : 0 }} ريال
                    </h3>
                    <p class="mb-0 opacity-75">متوسط الفاتورة</p>
                </div>
            </div>
        </div>
    </div>

    <!-- الرسم البياني للمبيعات حسب الساعة -->
    @if($dailySales->count() > 0)
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-header bg-white border-bottom-0">
            <h5 class="card-title mb-0">
                <i class="fas fa-chart-bar me-2 text-primary"></i>
                المبيعات حسب الساعة
            </h5>
        </div>
        <div class="card-body">
            <canvas id="hourlyChart" height="100"></canvas>
        </div>
    </div>
    @endif

    <!-- تفاصيل المبيعات حسب الساعة -->
    <div class="card border-0 shadow-sm">
        <div class="card-header bg-white border-bottom-0">
            <h5 class="card-title mb-0">
                <i class="fas fa-clock me-2 text-primary"></i>
                تفاصيل المبيعات حسب الساعة
            </h5>
        </div>
        <div class="card-body">
            @if($dailySales->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead class="table-light">
                            <tr>
                                <th>الساعة</th>
                                <th>عدد الفواتير</th>
                                <th>إجمالي المبيعات</th>
                                <th>الضريبة</th>
                                <th>متوسط الفاتورة</th>
                                <th>النسبة من الإجمالي</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($dailySales as $hourly)
                                <tr>
                                    <td>
                                        <span class="badge bg-primary px-3 py-2">
                                            {{ str_pad($hourly->hour, 2, '0', STR_PAD_LEFT) }}:00 - {{ str_pad($hourly->hour + 1, 2, '0', STR_PAD_LEFT) }}:00
                                        </span>
                                    </td>
                                    <td>
                                        <strong>{{ number_format($hourly->total_invoices) }}</strong>
                                    </td>
                                    <td>
                                        <strong class="text-success">{{ number_format($hourly->total_sales, 2) }} ريال</strong>
                                    </td>
                                    <td>
                                        <span class="text-warning">{{ number_format($hourly->total_tax, 2) }} ريال</span>
                                    </td>
                                    <td>
                                        <span class="text-info">{{ number_format($hourly->average_sale, 2) }} ريال</span>
                                    </td>
                                    <td>
                                        @php
                                            $percentage = $totalDaily->total_sales > 0 ? ($hourly->total_sales / $totalDaily->total_sales) * 100 : 0;
                                        @endphp
                                        <div class="progress" style="height: 20px;">
                                            <div class="progress-bar bg-gradient" role="progressbar" 
                                                 style="width: {{ $percentage }}%" 
                                                 aria-valuenow="{{ $percentage }}" 
                                                 aria-valuemin="0" aria-valuemax="100">
                                                {{ number_format($percentage, 1) }}%
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot class="table-light">
                            <tr>
                                <th>الإجمالي</th>
                                <th>{{ number_format($totalDaily->total_invoices) }}</th>
                                <th>{{ number_format($totalDaily->total_sales, 2) }} ريال</th>
                                <th>{{ number_format($totalDaily->total_tax, 2) }} ريال</th>
                                <th>
                                    {{ $totalDaily->total_invoices > 0 ? number_format($totalDaily->total_sales / $totalDaily->total_invoices, 2) : 0 }} ريال
                                </th>
                                <th>100.0%</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>

                <!-- إحصائيات إضافية -->
                <div class="row mt-4">
                    <div class="col-md-4">
                        <div class="card bg-light">
                            <div class="card-body text-center">
                                <h6 class="card-title">أفضل ساعة في المبيعات</h6>
                                @php
                                    $bestHour = $dailySales->sortByDesc('total_sales')->first();
                                @endphp
                                @if($bestHour)
                                    <p class="mb-0">
                                        <span class="badge bg-success px-3 py-2">
                                            {{ str_pad($bestHour->hour, 2, '0', STR_PAD_LEFT) }}:00 - {{ str_pad($bestHour->hour + 1, 2, '0', STR_PAD_LEFT) }}:00
                                        </span>
                                    </p>
                                    <small class="text-muted">{{ number_format($bestHour->total_sales, 2) }} ريال</small>
                                @endif
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="card bg-light">
                            <div class="card-body text-center">
                                <h6 class="card-title">أكثر ساعة نشاطاً</h6>
                                @php
                                    $busyHour = $dailySales->sortByDesc('total_invoices')->first();
                                @endphp
                                @if($busyHour)
                                    <p class="mb-0">
                                        <span class="badge bg-primary px-3 py-2">
                                            {{ str_pad($busyHour->hour, 2, '0', STR_PAD_LEFT) }}:00 - {{ str_pad($busyHour->hour + 1, 2, '0', STR_PAD_LEFT) }}:00
                                        </span>
                                    </p>
                                    <small class="text-muted">{{ number_format($busyHour->total_invoices) }} فاتورة</small>
                                @endif
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="card bg-light">
                            <div class="card-body text-center">
                                <h6 class="card-title">أعلى متوسط فاتورة</h6>
                                @php
                                    $avgHour = $dailySales->sortByDesc('average_sale')->first();
                                @endphp
                                @if($avgHour)
                                    <p class="mb-0">
                                        <span class="badge bg-info px-3 py-2">
                                            {{ str_pad($avgHour->hour, 2, '0', STR_PAD_LEFT) }}:00 - {{ str_pad($avgHour->hour + 1, 2, '0', STR_PAD_LEFT) }}:00
                                        </span>
                                    </p>
                                    <small class="text-muted">{{ number_format($avgHour->average_sale, 2) }} ريال</small>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            @else
                <div class="text-center py-5">
                    <i class="fas fa-calendar-times text-muted" style="font-size: 4rem;"></i>
                    <h5 class="mt-3 text-muted">لا توجد مبيعات في هذا اليوم</h5>
                    <p class="text-muted">لم يتم تسجيل أي فواتير في {{ \Carbon\Carbon::parse($date)->format('Y/m/d') }}</p>
                </div>
            @endif
        </div>
    </div>
</div>

<style>
.stats-card {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border-radius: 12px;
}

.stats-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 12px 35px rgba(0,0,0,0.2) !important;
}

.stats-icon {
    font-size: 2rem;
    opacity: 0.9;
}

.card {
    border-radius: 12px;
    animation: fadeInUp 0.6s ease forwards;
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.table th {
    border-top: none;
    font-weight: 600;
    color: #495057;
}

.progress {
    background-color: #e9ecef;
}

.bg-gradient {
    background: linear-gradient(45deg, #007bff, #0056b3) !important;
}
</style>

@push('scripts')
@if($dailySales->count() > 0)
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const ctx = document.getElementById('hourlyChart').getContext('2d');
    const chart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: [
                @foreach($dailySales as $hourly)
                    '{{ str_pad($hourly->hour, 2, '0', STR_PAD_LEFT) }}:00',
                @endforeach
            ],
            datasets: [{
                label: 'المبيعات (ريال)',
                data: [
                    @foreach($dailySales as $hourly)
                        {{ $hourly->total_sales }},
                    @endforeach
                ],
                backgroundColor: 'rgba(0, 123, 255, 0.8)',
                borderColor: '#007bff',
                borderWidth: 1,
                borderRadius: 5
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    display: true,
                    position: 'top'
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return new Intl.NumberFormat('ar-SA').format(value) + ' ريال';
                        }
                    }
                },
                x: {
                    title: {
                        display: true,
                        text: 'الساعة'
                    }
                }
            }
        }
    });
});

function exportReport() {
    const date = document.getElementById('date').value;
    
    const url = `{{ route('system-reports.sales.export') }}?type=daily&format=excel&date=${date}`;
    window.open(url, '_blank');
}
</script>
@endif
@endpush
@endsection