@extends('layouts.app')

@section('title', 'المبيعات حسب المنتج')
@section('page-title', 'المبيعات حسب المنتج')

@section('breadcrumb')
    <span>تقارير النظام</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>تقارير المبيعات</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>المبيعات حسب المنتج</span>
@endsection

@section('content')
<div class="container-fluid">
    <!-- فلتر التاريخ -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-header bg-white border-bottom-0">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="fas fa-filter me-2 text-primary"></i>
                    تصفية البيانات
                </h5>
                <a href="{{ route('system-reports.sales.index') }}" class="btn btn-outline-secondary btn-sm">
                    <i class="fas fa-arrow-right me-2"></i>العودة للتقارير
                </a>
            </div>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('system-reports.sales.by-product') }}">
                <div class="row">
                    <div class="col-md-4">
                        <label for="start_date" class="form-label">من تاريخ</label>
                        <input type="date" class="form-control" id="start_date" name="start_date" 
                               value="{{ request('start_date', $startDate->format('Y-m-d')) }}">
                    </div>
                    <div class="col-md-4">
                        <label for="end_date" class="form-label">إلى تاريخ</label>
                        <input type="date" class="form-control" id="end_date" name="end_date" 
                               value="{{ request('end_date', $endDate->format('Y-m-d')) }}">
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">&nbsp;</label>
                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-search me-2"></i>تطبيق الفلتر
                            </button>
                            <button type="button" class="btn btn-success" onclick="exportReport()">
                                <i class="fas fa-download me-2"></i>تصدير
                            </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- إحصائيات سريعة -->
    @php
        $totalProducts = $productSales->total();
        $totalQuantitySold = $productSales->sum('total_quantity');
        $totalSalesValue = $productSales->sum('total_sales');
        $averageSalePerProduct = $totalProducts > 0 ? $totalSalesValue / $totalProducts : 0;
    @endphp

    <div class="row mb-4">
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-primary text-white mb-3">
                        <i class="fas fa-boxes"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($totalProducts) }}</h3>
                    <p class="text-muted mb-0">المنتجات المباعة</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-success text-white mb-3">
                        <i class="fas fa-sort-numeric-up"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($totalQuantitySold) }}</h3>
                    <p class="text-muted mb-0">إجمالي الكمية</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-warning text-white mb-3">
                        <i class="fas fa-money-bill-wave"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($totalSalesValue, 2) }} ريال</h3>
                    <p class="text-muted mb-0">إجمالي المبيعات</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-info text-white mb-3">
                        <i class="fas fa-calculator"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($averageSalePerProduct, 2) }} ريال</h3>
                    <p class="text-muted mb-0">متوسط المبيعات</p>
                </div>
            </div>
        </div>
    </div>

    <!-- أفضل المنتجات -->
    @if($productSales->count() > 0)
    <div class="row mb-4">
        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom-0">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-trophy me-2 text-warning"></i>
                        أعلى منتجات في المبيعات
                    </h6>
                </div>
                <div class="card-body">
                    <canvas id="topProductsChart" height="200"></canvas>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom-0">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-chart-pie me-2 text-info"></i>
                        أكثر منتجات مبيعاً
                    </h6>
                </div>
                <div class="card-body">
                    <canvas id="quantityChart" height="200"></canvas>
                </div>
            </div>
        </div>
    </div>
    @endif

    <!-- جدول تفصيلي للمنتجات -->
    <div class="card border-0 shadow-sm">
        <div class="card-header bg-white border-bottom-0">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="fas fa-table me-2 text-primary"></i>
                    تفاصيل مبيعات المنتجات
                </h5>
                <div class="d-flex gap-2">
                    <input type="text" class="form-control form-control-sm" 
                           id="searchProduct" placeholder="البحث في المنتجات..." 
                           style="width: 200px;">
                </div>
            </div>
        </div>
        <div class="card-body">
            @if($productSales->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover" id="productsTable">
                        <thead class="table-light">
                            <tr>
                                <th>#</th>
                                <th>اسم المنتج</th>
                                <th>سعر الوحدة</th>
                                <th>الكمية المباعة</th>
                                <th>إجمالي المبيعات</th>
                                <th>النسبة من الإجمالي</th>
                                <th>الأداء</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($productSales as $index => $product)
                                <tr>
                                    <td>
                                        <span class="badge bg-light text-dark">{{ $productSales->firstItem() + $index }}</span>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="product-avatar bg-primary text-white me-3">
                                                <i class="fas fa-box"></i>
                                            </div>
                                            <div>
                                                <h6 class="mb-0">{{ $product->name }}</h6>
                                                <small class="text-muted">ID: {{ $product->id }}</small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge bg-info">{{ number_format($product->price, 2) }} ريال</span>
                                    </td>
                                    <td>
                                        <strong class="text-success">{{ number_format($product->total_quantity) }}</strong>
                                    </td>
                                    <td>
                                        <strong class="text-primary">{{ number_format($product->total_sales, 2) }} ريال</strong>
                                    </td>
                                    <td>
                                        @php
                                            $percentage = $totalSalesValue > 0 ? ($product->total_sales / $totalSalesValue) * 100 : 0;
                                        @endphp
                                        <div class="progress" style="height: 20px;">
                                            <div class="progress-bar" role="progressbar" 
                                                 style="width: {{ $percentage }}%; background: linear-gradient(45deg, #28a745, #20c997);" 
                                                 aria-valuenow="{{ $percentage }}" 
                                                 aria-valuemin="0" aria-valuemax="100">
                                                {{ number_format($percentage, 1) }}%
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        @if($percentage >= 10)
                                            <span class="badge bg-success">ممتاز</span>
                                        @elseif($percentage >= 5)
                                            <span class="badge bg-warning">جيد</span>
                                        @else
                                            <span class="badge bg-secondary">متوسط</span>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- التنقل بين الصفحات -->
                <div class="d-flex justify-content-between align-items-center mt-3">
                    <div class="text-muted">
                        عرض {{ $productSales->firstItem() }} إلى {{ $productSales->lastItem() }} من إجمالي {{ $productSales->total() }} منتج
                    </div>
                    {{ $productSales->appends(request()->query())->links() }}
                </div>
            @else
                <div class="text-center py-5">
                    <i class="fas fa-box-open text-muted" style="font-size: 4rem;"></i>
                    <h5 class="mt-3 text-muted">لا توجد بيانات للمنتجات</h5>
                    <p class="text-muted">لم يتم تسجيل أي مبيعات للمنتجات في الفترة المحددة</p>
                </div>
            @endif
        </div>
    </div>
</div>

<style>
.stats-card {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border-radius: 12px;
}

.stats-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.15) !important;
}

.stats-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto;
    font-size: 1.5rem;
}

.product-avatar {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.9rem;
}

.card {
    border-radius: 12px;
    animation: fadeInUp 0.6s ease forwards;
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.table th {
    border-top: none;
    font-weight: 600;
    color: #495057;
}

.progress {
    background-color: #e9ecef;
    border-radius: 10px;
}

.table tbody tr:hover {
    background-color: #f8f9fa;
}
</style>

@push('scripts')
@if($productSales->count() > 0)
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // أعلى 5 منتجات في المبيعات
    const topProductsCtx = document.getElementById('topProductsChart').getContext('2d');
    const topProducts = @json($productSales->take(5)->values());
    
    new Chart(topProductsCtx, {
        type: 'bar',
        data: {
            labels: topProducts.map(p => p.name.length > 15 ? p.name.substring(0, 15) + '...' : p.name),
            datasets: [{
                label: 'المبيعات (ريال)',
                data: topProducts.map(p => p.total_sales),
                backgroundColor: [
                    'rgba(255, 99, 132, 0.8)',
                    'rgba(54, 162, 235, 0.8)',
                    'rgba(255, 205, 86, 0.8)',
                    'rgba(75, 192, 192, 0.8)',
                    'rgba(153, 102, 255, 0.8)'
                ],
                borderColor: [
                    'rgba(255, 99, 132, 1)',
                    'rgba(54, 162, 235, 1)',
                    'rgba(255, 205, 86, 1)',
                    'rgba(75, 192, 192, 1)',
                    'rgba(153, 102, 255, 1)'
                ],
                borderWidth: 1,
                borderRadius: 5
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return new Intl.NumberFormat('ar-SA').format(value) + ' ريال';
                        }
                    }
                }
            }
        }
    });

    // أكثر منتجات مبيعاً (الكمية)
    const quantityCtx = document.getElementById('quantityChart').getContext('2d');
    
    new Chart(quantityCtx, {
        type: 'doughnut',
        data: {
            labels: topProducts.map(p => p.name.length > 15 ? p.name.substring(0, 15) + '...' : p.name),
            datasets: [{
                data: topProducts.map(p => p.total_quantity),
                backgroundColor: [
                    'rgba(255, 99, 132, 0.8)',
                    'rgba(54, 162, 235, 0.8)',
                    'rgba(255, 205, 86, 0.8)',
                    'rgba(75, 192, 192, 0.8)',
                    'rgba(153, 102, 255, 0.8)'
                ],
                borderWidth: 2,
                borderColor: '#fff'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        padding: 20,
                        usePointStyle: true
                    }
                }
            }
        }
    });
});

// البحث في الجدول
document.getElementById('searchProduct').addEventListener('keyup', function() {
    const filter = this.value.toLowerCase();
    const table = document.getElementById('productsTable');
    const rows = table.getElementsByTagName('tbody')[0].getElementsByTagName('tr');

    for (let i = 0; i < rows.length; i++) {
        const productName = rows[i].getElementsByTagName('td')[1].textContent.toLowerCase();
        if (productName.includes(filter)) {
            rows[i].style.display = '';
        } else {
            rows[i].style.display = 'none';
        }
    }
});

function exportReport() {
    const startDate = document.getElementById('start_date').value;
    const endDate = document.getElementById('end_date').value;
    
    const url = `{{ route('system-reports.sales.export') }}?type=by-product&format=excel&start_date=${startDate}&end_date=${endDate}`;
    window.open(url, '_blank');
}
</script>
@endif
@endpush
@endsection