@extends('layouts.app')

@section('title', 'اتجاهات المشتريات')
@section('page-title', 'اتجاهات المشتريات')

@section('breadcrumb')
    <span>تقارير النظام</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>تقارير المشتريات</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>اتجاهات المشتريات</span>
@endsection

@section('content')
<div class="container-fluid">
    <!-- فلتر الفترة -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-header bg-white border-bottom-0">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="fas fa-chart-line me-2 text-primary"></i>
                    فترة التحليل
                </h5>
                <a href="{{ route('system-reports.purchase.index') }}" class="btn btn-outline-secondary btn-sm">
                    <i class="fas fa-arrow-right me-2"></i>العودة للتقارير
                </a>
            </div>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('system-reports.purchase.trends') }}">
                <div class="row">
                    <div class="col-md-4">
                        <label for="months" class="form-label">عدد الأشهر للتحليل</label>
                        <select class="form-select" id="months" name="months">
                            <option value="6" {{ request('months') == 6 ? 'selected' : '' }}>آخر 6 أشهر</option>
                            <option value="12" {{ request('months', 12) == 12 ? 'selected' : '' }}>آخر 12 شهر</option>
                            <option value="18" {{ request('months') == 18 ? 'selected' : '' }}>آخر 18 شهر</option>
                            <option value="24" {{ request('months') == 24 ? 'selected' : '' }}>آخر سنتان</option>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">&nbsp;</label>
                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-chart-line me-2"></i>تحليل الاتجاهات
                            </button>
                            <button type="button" class="btn btn-success" onclick="exportReport()">
                                <i class="fas fa-download me-2"></i>تصدير
                            </button>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="text-end">
                            <small class="text-muted">فترة التحليل:</small>
                            <p class="mb-0 fw-bold">{{ $months }} شهر الماضية</p>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- الاتجاه الزمني للمشتريات -->
    @if($monthlyTrends->count() > 0)
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-header bg-white border-bottom-0">
            <h5 class="card-title mb-0">
                <i class="fas fa-chart-area me-2 text-primary"></i>
                الاتجاه الزمني للمشتريات
            </h5>
        </div>
        <div class="card-body">
            <canvas id="trendsChart" height="120"></canvas>
        </div>
    </div>
    @endif

    <!-- إحصائيات الاتجاهات -->
    @php
        $totalAmount = $monthlyTrends->sum('total_amount');
        $totalInvoices = $monthlyTrends->sum('total_invoices');
        $averageMonthly = $monthlyTrends->count() > 0 ? $totalAmount / $monthlyTrends->count() : 0;
        $highestMonth = $monthlyTrends->sortByDesc('total_amount')->first();
        $lowestMonth = $monthlyTrends->sortBy('total_amount')->first();
        
        // حساب معدل النمو
        $firstMonth = $monthlyTrends->first();
        $lastMonth = $monthlyTrends->last();
        $growthRate = $firstMonth && $firstMonth->total_amount > 0 ? 
            (($lastMonth->total_amount - $firstMonth->total_amount) / $firstMonth->total_amount) * 100 : 0;
    @endphp

    <div class="row mb-4">
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-primary text-white mb-3">
                        <i class="fas fa-chart-line"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($averageMonthly, 2) }} ريال</h3>
                    <p class="text-muted mb-0">متوسط شهري</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon 
                        @if($growthRate > 0) bg-success
                        @elseif($growthRate < 0) bg-danger
                        @else bg-secondary
                        @endif
                        text-white mb-3">
                        @if($growthRate > 0)
                            <i class="fas fa-arrow-up"></i>
                        @elseif($growthRate < 0)
                            <i class="fas fa-arrow-down"></i>
                        @else
                            <i class="fas fa-minus"></i>
                        @endif
                    </div>
                    <h3 class="mb-2 
                        @if($growthRate > 0) text-success
                        @elseif($growthRate < 0) text-danger
                        @else text-secondary
                        @endif
                    ">
                        {{ number_format($growthRate, 1) }}%
                    </h3>
                    <p class="text-muted mb-0">معدل النمو</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-success text-white mb-3">
                        <i class="fas fa-trophy"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($highestMonth->total_amount ?? 0, 2) }} ريال</h3>
                    <p class="text-muted mb-0">أعلى شهر</p>
                    @if($highestMonth)
                        <small class="text-muted">{{ \Carbon\Carbon::createFromDate($highestMonth->year, $highestMonth->month, 1)->format('M Y') }}</small>
                    @endif
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-warning text-white mb-3">
                        <i class="fas fa-chart-line-down"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($lowestMonth->total_amount ?? 0, 2) }} ريال</h3>
                    <p class="text-muted mb-0">أقل شهر</p>
                    @if($lowestMonth)
                        <small class="text-muted">{{ \Carbon\Carbon::createFromDate($lowestMonth->year, $lowestMonth->month, 1)->format('M Y') }}</small>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- تحليل التصنيفات -->
    @if($categoryTrends->count() > 0)
    <div class="row mb-4">
        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom-0">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-chart-pie me-2 text-info"></i>
                        توزيع المشتريات حسب التصنيف
                    </h6>
                </div>
                <div class="card-body">
                    <canvas id="categoryChart" height="200"></canvas>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom-0">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-list me-2 text-primary"></i>
                        أهم التصنيفات
                    </h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead class="table-light">
                                <tr>
                                    <th>التصنيف</th>
                                    <th>الكمية</th>
                                    <th>المبلغ</th>
                                    <th>%</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($categoryTrends->take(5) as $category)
                                    <tr>
                                        <td>
                                            <span class="badge bg-secondary">{{ $category->category ?: 'غير محدد' }}</span>
                                        </td>
                                        <td>{{ number_format($category->total_quantity) }}</td>
                                        <td>{{ number_format($category->total_amount, 2) }} ريال</td>
                                        <td>
                                            @php
                                                $percentage = $categoryTrends->sum('total_amount') > 0 ? 
                                                    ($category->total_amount / $categoryTrends->sum('total_amount')) * 100 : 0;
                                            @endphp
                                            <span class="text-info">{{ number_format($percentage, 1) }}%</span>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif

    <!-- جدول تفصيلي للاتجاهات الشهرية -->
    <div class="card border-0 shadow-sm">
        <div class="card-header bg-white border-bottom-0">
            <h5 class="card-title mb-0">
                <i class="fas fa-table me-2 text-primary"></i>
                تفاصيل الاتجاهات الشهرية
            </h5>
        </div>
        <div class="card-body">
            @if($monthlyTrends->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead class="table-light">
                            <tr>
                                <th>الشهر/السنة</th>
                                <th>عدد الفواتير</th>
                                <th>إجمالي المبلغ</th>
                                <th>متوسط الفاتورة</th>
                                <th>التغيير من الشهر السابق</th>
                                <th>الاتجاه</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($monthlyTrends as $index => $trend)
                                <tr>
                                    <td>
                                        <span class="badge bg-primary px-3 py-2">
                                            {{ \Carbon\Carbon::createFromDate($trend->year, $trend->month, 1)->format('F Y') }}
                                        </span>
                                    </td>
                                    <td>
                                        <strong>{{ number_format($trend->total_invoices) }}</strong>
                                    </td>
                                    <td>
                                        <strong class="text-success">{{ number_format($trend->total_amount, 2) }} ريال</strong>
                                    </td>
                                    <td>
                                        <span class="text-info">
                                            {{ $trend->total_invoices > 0 ? number_format($trend->total_amount / $trend->total_invoices, 2) : 0 }} ريال
                                        </span>
                                    </td>
                                    <td>
                                        @if($index > 0)
                                            @php
                                                $previousTrend = $monthlyTrends[$index - 1];
                                                $change = $previousTrend->total_amount > 0 ? 
                                                    (($trend->total_amount - $previousTrend->total_amount) / $previousTrend->total_amount) * 100 : 0;
                                            @endphp
                                            @if($change > 0)
                                                <span class="badge bg-success">
                                                    <i class="fas fa-arrow-up me-1"></i>+{{ number_format($change, 1) }}%
                                                </span>
                                            @elseif($change < 0)
                                                <span class="badge bg-danger">
                                                    <i class="fas fa-arrow-down me-1"></i>{{ number_format($change, 1) }}%
                                                </span>
                                            @else
                                                <span class="badge bg-secondary">
                                                    <i class="fas fa-minus me-1"></i>0%
                                                </span>
                                            @endif
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($index > 0)
                                            @if($change > 5)
                                                <i class="fas fa-arrow-trend-up text-success" title="اتجاه صاعد"></i>
                                            @elseif($change < -5)
                                                <i class="fas fa-arrow-trend-down text-danger" title="اتجاه هابط"></i>
                                            @else
                                                <i class="fas fa-arrows-left-right text-warning" title="مستقر"></i>
                                            @endif
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- تحليل الأداء -->
                <div class="alert alert-info mt-4" role="alert">
                    <div class="d-flex align-items-center">
                        <i class="fas fa-info-circle me-2"></i>
                        <div>
                            <strong>تحليل الأداء:</strong>
                            @if($growthRate > 10)
                                نمو ممتاز في المشتريات خلال الفترة المحددة.
                            @elseif($growthRate > 0)
                                نمو إيجابي في المشتريات.
                            @elseif($growthRate < -10)
                                انخفاض كبير في المشتريات يستدعي المراجعة.
                            @elseif($growthRate < 0)
                                انخفاض طفيف في المشتريات.
                            @else
                                مستوى مشتريات مستقر.
                            @endif
                        </div>
                    </div>
                </div>
            @else
                <div class="text-center py-5">
                    <i class="fas fa-chart-line text-muted" style="font-size: 4rem;"></i>
                    <h5 class="mt-3 text-muted">لا توجد بيانات للتحليل</h5>
                    <p class="text-muted">لم يتم العثور على بيانات مشتريات في الفترة المحددة</p>
                </div>
            @endif
        </div>
    </div>
</div>

<style>
.stats-card {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border-radius: 12px;
}

.stats-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.15) !important;
}

.stats-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto;
    font-size: 1.5rem;
}

.card {
    border-radius: 12px;
    animation: fadeInUp 0.6s ease forwards;
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.table th {
    border-top: none;
    font-weight: 600;
    color: #495057;
}

.table tbody tr:hover {
    background-color: #f8f9fa;
}
</style>

@push('scripts')
@if($monthlyTrends->count() > 0)
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // رسم الاتجاه الزمني
    const trendsCtx = document.getElementById('trendsChart').getContext('2d');
    const monthlyTrends = @json($monthlyTrends->values());
    
    new Chart(trendsCtx, {
        type: 'line',
        data: {
            labels: monthlyTrends.map(trend => {
                const date = new Date(trend.year, trend.month - 1);
                return date.toLocaleDateString('ar-SA', { year: 'numeric', month: 'short' });
            }),
            datasets: [{
                label: 'إجمالي المشتريات (ريال)',
                data: monthlyTrends.map(trend => trend.total_amount),
                borderColor: '#007bff',
                backgroundColor: 'rgba(0, 123, 255, 0.1)',
                borderWidth: 3,
                fill: true,
                tension: 0.4
            }, {
                label: 'عدد الفواتير',
                data: monthlyTrends.map(trend => trend.total_invoices),
                borderColor: '#28a745',
                backgroundColor: 'rgba(40, 167, 69, 0.1)',
                borderWidth: 2,
                yAxisID: 'y1',
                tension: 0.4
            }]
        },
        options: {
            responsive: true,
            interaction: {
                mode: 'index',
                intersect: false,
            },
            scales: {
                y: {
                    type: 'linear',
                    display: true,
                    position: 'left',
                    title: {
                        display: true,
                        text: 'المبلغ (ريال)'
                    },
                    ticks: {
                        callback: function(value) {
                            return new Intl.NumberFormat('ar-SA').format(value) + ' ريال';
                        }
                    }
                },
                y1: {
                    type: 'linear',
                    display: true,
                    position: 'right',
                    title: {
                        display: true,
                        text: 'عدد الفواتير'
                    },
                    grid: {
                        drawOnChartArea: false,
                    },
                }
            }
        }
    });

    // رسم التصنيفات
    @if($categoryTrends->count() > 0)
    const categoryCtx = document.getElementById('categoryChart').getContext('2d');
    const categoryTrends = @json($categoryTrends->values());
    
    new Chart(categoryCtx, {
        type: 'doughnut',
        data: {
            labels: categoryTrends.map(cat => cat.category || 'غير محدد'),
            datasets: [{
                data: categoryTrends.map(cat => cat.total_amount),
                backgroundColor: [
                    'rgba(255, 99, 132, 0.8)',
                    'rgba(54, 162, 235, 0.8)',
                    'rgba(255, 205, 86, 0.8)',
                    'rgba(75, 192, 192, 0.8)',
                    'rgba(153, 102, 255, 0.8)',
                    'rgba(255, 159, 64, 0.8)',
                    'rgba(199, 199, 199, 0.8)',
                    'rgba(83, 102, 255, 0.8)'
                ],
                borderWidth: 2,
                borderColor: '#fff'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        padding: 20,
                        usePointStyle: true
                    }
                }
            }
        }
    });
    @endif
});

function exportReport() {
    const months = document.getElementById('months').value;
    
    const url = `{{ route('system-reports.purchase.export') }}?type=trends&format=excel&months=${months}`;
    window.open(url, '_blank');
}
</script>
@endif
@endpush
@endsection