@extends('layouts.app')

@section('title', 'تقييم أداء الموردين')
@section('page-title', 'تقييم أداء الموردين')

@section('breadcrumb')
    <span>تقارير النظام</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>تقارير المشتريات</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>تقييم أداء الموردين</span>
@endsection

@section('content')
<div class="container-fluid">
    <!-- مؤشرات الأداء الرئيسية -->
    <div class="row mb-4">
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm text-center">
                <div class="card-body">
                    <div class="mb-2">
                        <i class="fas fa-star text-warning" style="font-size: 2rem;"></i>
                    </div>
                    <h5 class="card-title mb-1">4.2</h5>
                    <p class="text-muted mb-0 small">متوسط التقييم</p>
                </div>
            </div>
        </div>
        
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm text-center">
                <div class="card-body">
                    <div class="mb-2">
                        <i class="fas fa-clock text-primary" style="font-size: 2rem;"></i>
                    </div>
                    <h5 class="card-title mb-1">3.5 أيام</h5>
                    <p class="text-muted mb-0 small">متوسط وقت التوريد</p>
                </div>
            </div>
        </div>
        
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm text-center">
                <div class="card-body">
                    <div class="mb-2">
                        <i class="fas fa-check-circle text-success" style="font-size: 2rem;"></i>
                    </div>
                    <h5 class="card-title mb-1">95%</h5>
                    <p class="text-muted mb-0 small">معدل الجودة</p>
                </div>
            </div>
        </div>
        
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm text-center">
                <div class="card-body">
                    <div class="mb-2">
                        <i class="fas fa-shipping-fast text-info" style="font-size: 2rem;"></i>
                    </div>
                    <h5 class="card-title mb-1">88%</h5>
                    <p class="text-muted mb-0 small">التسليم في الوقت المحدد</p>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- فلاتر التقرير -->
        <div class="col-12 mb-4">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-filter me-2 text-primary"></i>
                        فلاتر التقرير
                    </h5>
                </div>
                <div class="card-body">
                    <form id="performanceFilterForm">
                        <div class="row">
                            <div class="col-md-3 mb-3">
                                <label class="form-label">من تاريخ</label>
                                <input type="date" class="form-control" id="start_date" name="start_date">
                            </div>
                            <div class="col-md-3 mb-3">
                                <label class="form-label">إلى تاريخ</label>
                                <input type="date" class="form-control" id="end_date" name="end_date">
                            </div>
                            <div class="col-md-3 mb-3">
                                <label class="form-label">المورد</label>
                                <select class="form-select" id="supplier_id" name="supplier_id">
                                    <option value="">جميع الموردين</option>
                                    <!-- يتم ملء الخيارات من قاعدة البيانات -->
                                </select>
                            </div>
                            <div class="col-md-3 mb-3">
                                <label class="form-label">معايير التقييم</label>
                                <select class="form-select" id="criteria" name="criteria">
                                    <option value="all">جميع المعايير</option>
                                    <option value="quality">الجودة</option>
                                    <option value="delivery">التسليم</option>
                                    <option value="price">السعر</option>
                                    <option value="service">الخدمة</option>
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-search me-2"></i>تطبيق الفلاتر
                                </button>
                                <button type="button" class="btn btn-secondary ms-2" id="resetFilters">
                                    <i class="fas fa-undo me-2"></i>إعادة تعيين
                                </button>
                                <button type="button" class="btn btn-success ms-2" id="exportReport">
                                    <i class="fas fa-download me-2"></i>تصدير التقرير
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- تقييم أداء الموردين -->
        <div class="col-12 mb-4">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-chart-bar me-2 text-primary"></i>
                        تقييم أداء الموردين
                    </h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover" id="performanceTable">
                            <thead class="table-light">
                                <tr>
                                    <th>المورد</th>
                                    <th>التقييم الإجمالي</th>
                                    <th>الجودة</th>
                                    <th>التسليم في الوقت</th>
                                    <th>السعر التنافسي</th>
                                    <th>خدمة العملاء</th>
                                    <th>إجمالي الطلبات</th>
                                    <th>متوسط وقت التوريد</th>
                                    <th>الحالة</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="avatar-sm bg-primary rounded-circle me-2 d-flex align-items-center justify-content-center">
                                                <i class="fas fa-truck text-white"></i>
                                            </div>
                                            <div>
                                                <h6 class="mb-0">شركة الإمدادات المتقدمة</h6>
                                                <small class="text-muted">SUP-001</small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="rating me-2">
                                                <i class="fas fa-star text-warning"></i>
                                                <i class="fas fa-star text-warning"></i>
                                                <i class="fas fa-star text-warning"></i>
                                                <i class="fas fa-star text-warning"></i>
                                                <i class="fas fa-star text-muted"></i>
                                            </div>
                                            <span class="fw-bold">4.2</span>
                                        </div>
                                    </td>
                                    <td><span class="badge bg-success">95%</span></td>
                                    <td><span class="badge bg-warning">88%</span></td>
                                    <td><span class="badge bg-info">92%</span></td>
                                    <td><span class="badge bg-primary">90%</span></td>
                                    <td>156</td>
                                    <td>3.2 أيام</td>
                                    <td><span class="badge bg-success">ممتاز</span></td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="avatar-sm bg-success rounded-circle me-2 d-flex align-items-center justify-content-center">
                                                <i class="fas fa-boxes text-white"></i>
                                            </div>
                                            <div>
                                                <h6 class="mb-0">مؤسسة التوريد السريع</h6>
                                                <small class="text-muted">SUP-002</small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="rating me-2">
                                                <i class="fas fa-star text-warning"></i>
                                                <i class="fas fa-star text-warning"></i>
                                                <i class="fas fa-star text-warning"></i>
                                                <i class="fas fa-star text-warning"></i>
                                                <i class="fas fa-star-half-alt text-warning"></i>
                                            </div>
                                            <span class="fw-bold">4.5</span>
                                        </div>
                                    </td>
                                    <td><span class="badge bg-success">98%</span></td>
                                    <td><span class="badge bg-success">95%</span></td>
                                    <td><span class="badge bg-warning">85%</span></td>
                                    <td><span class="badge bg-success">96%</span></td>
                                    <td>203</td>
                                    <td>2.8 أيام</td>
                                    <td><span class="badge bg-success">ممتاز</span></td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="avatar-sm bg-info rounded-circle me-2 d-flex align-items-center justify-content-center">
                                                <i class="fas fa-industry text-white"></i>
                                            </div>
                                            <div>
                                                <h6 class="mb-0">شركة الصناعات الحديثة</h6>
                                                <small class="text-muted">SUP-003</small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="rating me-2">
                                                <i class="fas fa-star text-warning"></i>
                                                <i class="fas fa-star text-warning"></i>
                                                <i class="fas fa-star text-warning"></i>
                                                <i class="fas fa-star text-muted"></i>
                                                <i class="fas fa-star text-muted"></i>
                                            </div>
                                            <span class="fw-bold">3.8</span>
                                        </div>
                                    </td>
                                    <td><span class="badge bg-warning">82%</span></td>
                                    <td><span class="badge bg-warning">78%</span></td>
                                    <td><span class="badge bg-success">94%</span></td>
                                    <td><span class="badge bg-warning">85%</span></td>
                                    <td>89</td>
                                    <td>4.5 أيام</td>
                                    <td><span class="badge bg-warning">جيد</span></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- رسوم بيانية للأداء -->
        <div class="col-lg-6 mb-4">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-chart-pie me-2 text-primary"></i>
                        توزيع تقييمات الموردين
                    </h5>
                </div>
                <div class="card-body">
                    <canvas id="supplierRatingChart" height="300"></canvas>
                </div>
            </div>
        </div>

        <div class="col-lg-6 mb-4">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-chart-line me-2 text-primary"></i>
                        تطور الأداء عبر الوقت
                    </h5>
                </div>
                <div class="card-body">
                    <canvas id="performanceTrendChart" height="300"></canvas>
                </div>
            </div>
        </div>

        <!-- تفاصيل إضافية -->
        <div class="col-12">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-info-circle me-2 text-primary"></i>
                        معايير التقييم
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h6><i class="fas fa-star text-warning me-2"></i>معايير الجودة</h6>
                            <ul class="list-unstyled ms-3">
                                <li><i class="fas fa-check text-success me-2"></i>جودة المنتجات المستلمة</li>
                                <li><i class="fas fa-check text-success me-2"></i>مطابقة المواصفات المطلوبة</li>
                                <li><i class="fas fa-check text-success me-2"></i>معدل المرتجعات</li>
                            </ul>
                        </div>
                        <div class="col-md-6">
                            <h6><i class="fas fa-clock text-primary me-2"></i>معايير التسليم</h6>
                            <ul class="list-unstyled ms-3">
                                <li><i class="fas fa-check text-success me-2"></i>الالتزام بمواعيد التسليم</li>
                                <li><i class="fas fa-check text-success me-2"></i>سرعة الاستجابة للطلبات</li>
                                <li><i class="fas fa-check text-success me-2"></i>سلامة التغليف والشحن</li>
                            </ul>
                        </div>
                    </div>
                    
                    <div class="row mt-3">
                        <div class="col-md-6">
                            <h6><i class="fas fa-dollar-sign text-success me-2"></i>معايير السعر</h6>
                            <ul class="list-unstyled ms-3">
                                <li><i class="fas fa-check text-success me-2"></i>تنافسية الأسعار</li>
                                <li><i class="fas fa-check text-success me-2"></i>شروط الدفع المرونة</li>
                                <li><i class="fas fa-check text-success me-2"></i>الخصومات والعروض</li>
                            </ul>
                        </div>
                        <div class="col-md-6">
                            <h6><i class="fas fa-headset text-info me-2"></i>معايير الخدمة</h6>
                            <ul class="list-unstyled ms-3">
                                <li><i class="fas fa-check text-success me-2"></i>جودة التواصل</li>
                                <li><i class="fas fa-check text-success me-2"></i>حل المشاكل والشكاوى</li>
                                <li><i class="fas fa-check text-success me-2"></i>الدعم الفني</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.card {
    border-radius: 12px;
    overflow: hidden;
    transition: all 0.3s ease;
}

.card:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.15) !important;
}

.avatar-sm {
    width: 40px;
    height: 40px;
    font-size: 1rem;
}

.rating i {
    font-size: 0.9rem;
}

.badge {
    font-size: 0.75rem;
    padding: 0.375rem 0.75rem;
}

.table th {
    font-weight: 600;
    font-size: 0.875rem;
    border-bottom: 2px solid #dee2e6;
}

.btn {
    border-radius: 8px;
    font-weight: 500;
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.card {
    animation: fadeInUp 0.6s ease forwards;
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // إعداد المخطط الدائري لتوزيع التقييمات
    const ctx1 = document.getElementById('supplierRatingChart').getContext('2d');
    new Chart(ctx1, {
        type: 'doughnut',
        data: {
            labels: ['ممتاز (4.5-5)', 'جيد جداً (4-4.4)', 'جيد (3.5-3.9)', 'مقبول (3-3.4)', 'ضعيف (<3)'],
            datasets: [{
                data: [35, 28, 22, 10, 5],
                backgroundColor: [
                    '#28a745',
                    '#17a2b8',
                    '#ffc107',
                    '#fd7e14',
                    '#dc3545'
                ],
                borderWidth: 2,
                borderColor: '#fff'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        padding: 20,
                        font: {
                            size: 12
                        }
                    }
                }
            }
        }
    });

    // إعداد مخطط تطور الأداء
    const ctx2 = document.getElementById('performanceTrendChart').getContext('2d');
    new Chart(ctx2, {
        type: 'line',
        data: {
            labels: ['يناير', 'فبراير', 'مارس', 'أبريل', 'مايو', 'يونيو'],
            datasets: [{
                label: 'متوسط التقييم',
                data: [3.8, 4.0, 4.2, 4.1, 4.3, 4.2],
                borderColor: '#007bff',
                backgroundColor: 'rgba(0, 123, 255, 0.1)',
                borderWidth: 3,
                fill: true,
                tension: 0.4
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: false,
                    min: 3,
                    max: 5,
                    grid: {
                        color: 'rgba(0,0,0,0.1)'
                    }
                },
                x: {
                    grid: {
                        color: 'rgba(0,0,0,0.1)'
                    }
                }
            },
            plugins: {
                legend: {
                    display: false
                }
            }
        }
    });

    // معالج إرسال النموذج
    document.getElementById('performanceFilterForm').addEventListener('submit', function(e) {
        e.preventDefault();
        // هنا يمكن إضافة كود لتطبيق الفلاتر
        console.log('تطبيق الفلاتر...');
    });

    // إعادة تعيين الفلاتر
    document.getElementById('resetFilters').addEventListener('click', function() {
        document.getElementById('performanceFilterForm').reset();
    });

    // تصدير التقرير
    document.getElementById('exportReport').addEventListener('click', function() {
        // هنا يمكن إضافة كود لتصدير التقرير
        alert('جاري تصدير التقرير...');
    });
});
</script>

<!-- Chart.js -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
@endsection