@extends('layouts.app')

@section('title', 'تقرير أوامر الشراء')
@section('page-title', 'تقرير أوامر الشراء')

@section('breadcrumb')
    <span>تقارير النظام</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>تقارير المشتريات</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>تقرير أوامر الشراء</span>
@endsection

@section('content')
<div class="container-fluid">
    <!-- فلتر البيانات -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-header bg-white border-bottom-0">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="fas fa-filter me-2 text-primary"></i>
                    تصفية البيانات
                </h5>
                <a href="{{ route('system-reports.purchase.index') }}" class="btn btn-outline-secondary btn-sm">
                    <i class="fas fa-arrow-right me-2"></i>العودة للتقارير
                </a>
            </div>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('system-reports.purchase.orders') }}">
                <div class="row">
                    <div class="col-md-3">
                        <label for="start_date" class="form-label">من تاريخ</label>
                        <input type="date" class="form-control" id="start_date" name="start_date" 
                               value="{{ request('start_date', $startDate->format('Y-m-d')) }}">
                    </div>
                    <div class="col-md-3">
                        <label for="end_date" class="form-label">إلى تاريخ</label>
                        <input type="date" class="form-control" id="end_date" name="end_date" 
                               value="{{ request('end_date', $endDate->format('Y-m-d')) }}">
                    </div>
                    <div class="col-md-3">
                        <label for="status" class="form-label">الحالة</label>
                        <select class="form-select" id="status" name="status">
                            <option value="all" {{ request('status') === 'all' ? 'selected' : '' }}>جميع الحالات</option>
                            <option value="pending" {{ request('status') === 'pending' ? 'selected' : '' }}>في الانتظار</option>
                            <option value="approved" {{ request('status') === 'approved' ? 'selected' : '' }}>معتمد</option>
                            <option value="completed" {{ request('status') === 'completed' ? 'selected' : '' }}>مكتمل</option>
                            <option value="cancelled" {{ request('status') === 'cancelled' ? 'selected' : '' }}>ملغي</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">&nbsp;</label>
                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-search me-2"></i>تطبيق الفلتر
                            </button>
                            <button type="button" class="btn btn-success" onclick="exportReport()">
                                <i class="fas fa-download me-2"></i>تصدير
                            </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- إحصائيات أوامر الشراء -->
    <div class="row mb-4">
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-primary text-white mb-3">
                        <i class="fas fa-shopping-cart"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($orderStats->total_orders) }}</h3>
                    <p class="text-muted mb-0">إجمالي الأوامر</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-warning text-white mb-3">
                        <i class="fas fa-clock"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($orderStats->pending_orders) }}</h3>
                    <p class="text-muted mb-0">في الانتظار</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-success text-white mb-3">
                        <i class="fas fa-check-circle"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($orderStats->completed_orders) }}</h3>
                    <p class="text-muted mb-0">مكتملة</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-info text-white mb-3">
                        <i class="fas fa-money-bill-wave"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($orderStats->total_amount, 2) }} ريال</h3>
                    <p class="text-muted mb-0">القيمة الإجمالية</p>
                </div>
            </div>
        </div>
    </div>

    <!-- الرسوم البيانية -->
    <div class="row mb-4">
        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom-0">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-chart-pie me-2 text-info"></i>
                        توزيع حالات الأوامر
                    </h6>
                </div>
                <div class="card-body">
                    <canvas id="orderStatusChart" height="200"></canvas>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom-0">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-chart-bar me-2 text-primary"></i>
                        أداء معدل الإنجاز
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-6 mb-3">
                            <div class="border-end">
                                <h4 class="text-success">
                                    {{ $orderStats->total_orders > 0 ? number_format(($orderStats->completed_orders / $orderStats->total_orders) * 100, 1) : 0 }}%
                                </h4>
                                <small class="text-muted">معدل الإنجاز</small>
                            </div>
                        </div>
                        <div class="col-6 mb-3">
                            <h4 class="text-warning">
                                {{ $orderStats->total_orders > 0 ? number_format(($orderStats->pending_orders / $orderStats->total_orders) * 100, 1) : 0 }}%
                            </h4>
                            <small class="text-muted">نسبة الانتظار</small>
                        </div>
                        <div class="col-6">
                            <div class="border-end">
                                <h4 class="text-info">
                                    {{ $orderStats->total_orders > 0 ? number_format(($orderStats->approved_orders / $orderStats->total_orders) * 100, 1) : 0 }}%
                                </h4>
                                <small class="text-muted">نسبة الموافقة</small>
                            </div>
                        </div>
                        <div class="col-6">
                            <h4 class="text-danger">
                                {{ $orderStats->total_orders > 0 ? number_format(($orderStats->cancelled_orders / $orderStats->total_orders) * 100, 1) : 0 }}%
                            </h4>
                            <small class="text-muted">نسبة الإلغاء</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- جدول تفصيلي لأوامر الشراء -->
    <div class="card border-0 shadow-sm">
        <div class="card-header bg-white border-bottom-0">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="fas fa-table me-2 text-primary"></i>
                    تفاصيل أوامر الشراء
                </h5>
                <div class="d-flex gap-2">
                    <input type="text" class="form-control form-control-sm" 
                           id="searchOrder" placeholder="البحث في الأوامر..." 
                           style="width: 200px;">
                </div>
            </div>
        </div>
        <div class="card-body">
            @if($purchaseOrders->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover" id="ordersTable">
                        <thead class="table-light">
                            <tr>
                                <th>#</th>
                                <th>رقم الأمر</th>
                                <th>تاريخ الأمر</th>
                                <th>المورد</th>
                                <th>القيمة الإجمالية</th>
                                <th>الحالة</th>
                                <th>تاريخ التسليم المتوقع</th>
                                <th>الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($purchaseOrders as $index => $order)
                                <tr>
                                    <td>
                                        <span class="badge bg-light text-dark">{{ $purchaseOrders->firstItem() + $index }}</span>
                                    </td>
                                    <td>
                                        <div>
                                            <strong class="text-primary">{{ $order->order_number ?? 'PO-' . str_pad($order->id, 5, '0', STR_PAD_LEFT) }}</strong>
                                            <br>
                                            <small class="text-muted">ID: {{ $order->id }}</small>
                                        </div>
                                    </td>
                                    <td>
                                        <div>
                                            <span class="fw-bold">{{ \Carbon\Carbon::parse($order->order_date)->format('Y/m/d') }}</span>
                                            <br>
                                            <small class="text-muted">{{ \Carbon\Carbon::parse($order->created_at)->format('H:i') }}</small>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="supplier-avatar me-2">
                                                <i class="fas fa-truck"></i>
                                            </div>
                                            <div>
                                                <h6 class="mb-0">{{ $order->supplier->name ?? 'مورد غير محدد' }}</h6>
                                                <small class="text-muted">{{ $order->supplier->phone ?? '' }}</small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <strong class="text-success">{{ number_format($order->total_amount, 2) }} ريال</strong>
                                    </td>
                                    <td>
                                        @if($order->status == 'pending')
                                            <span class="badge bg-warning">
                                                <i class="fas fa-clock me-1"></i>في الانتظار
                                            </span>
                                        @elseif($order->status == 'approved')
                                            <span class="badge bg-info">
                                                <i class="fas fa-check me-1"></i>معتمد
                                            </span>
                                        @elseif($order->status == 'completed')
                                            <span class="badge bg-success">
                                                <i class="fas fa-check-circle me-1"></i>مكتمل
                                            </span>
                                        @elseif($order->status == 'cancelled')
                                            <span class="badge bg-danger">
                                                <i class="fas fa-times me-1"></i>ملغي
                                            </span>
                                        @else
                                            <span class="badge bg-secondary">{{ $order->status }}</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($order->expected_delivery_date)
                                            @php
                                                $deliveryDate = \Carbon\Carbon::parse($order->expected_delivery_date);
                                                $isOverdue = $deliveryDate->isPast() && $order->status !== 'completed';
                                            @endphp
                                            <div class="{{ $isOverdue ? 'text-danger' : 'text-info' }}">
                                                {{ $deliveryDate->format('Y/m/d') }}
                                                @if($isOverdue)
                                                    <br><small class="badge bg-danger">متأخر</small>
                                                @endif
                                            </div>
                                        @else
                                            <span class="text-muted">غير محدد</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <button type="button" class="btn btn-sm btn-outline-primary" 
                                                    title="تفاصيل الأمر">
                                                <i class="fas fa-eye"></i>
                                            </button>
                                            @if($order->status == 'pending')
                                                <button type="button" class="btn btn-sm btn-outline-success" 
                                                        title="اعتماد الأمر">
                                                    <i class="fas fa-check"></i>
                                                </button>
                                            @endif
                                            <button type="button" class="btn btn-sm btn-outline-secondary" 
                                                    title="طباعة الأمر">
                                                <i class="fas fa-print"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- التنقل بين الصفحات -->
                <div class="d-flex justify-content-between align-items-center mt-3">
                    <div class="text-muted">
                        عرض {{ $purchaseOrders->firstItem() }} إلى {{ $purchaseOrders->lastItem() }} من إجمالي {{ $purchaseOrders->total() }} أمر
                    </div>
                    {{ $purchaseOrders->appends(request()->query())->links() }}
                </div>
            @else
                <div class="text-center py-5">
                    <i class="fas fa-shopping-cart text-muted" style="font-size: 4rem;"></i>
                    <h5 class="mt-3 text-muted">لا توجد أوامر شراء</h5>
                    <p class="text-muted">لم يتم العثور على أي أوامر شراء في الفترة المحددة أو بالحالة المحددة</p>
                </div>
            @endif
        </div>
    </div>
</div>

<style>
.stats-card {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border-radius: 12px;
}

.stats-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.15) !important;
}

.stats-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto;
    font-size: 1.5rem;
}

.supplier-avatar {
    width: 35px;
    height: 35px;
    border-radius: 50%;
    background: linear-gradient(45deg, #17a2b8, #138496);
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.8rem;
}

.card {
    border-radius: 12px;
    animation: fadeInUp 0.6s ease forwards;
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.table th {
    border-top: none;
    font-weight: 600;
    color: #495057;
}

.table tbody tr:hover {
    background-color: #f8f9fa;
}

.btn-group .btn {
    margin-right: 2px;
}
</style>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // رسم دائري لحالات الأوامر
    const ctx = document.getElementById('orderStatusChart').getContext('2d');
    const orderStats = @json($orderStats);
    
    const data = [
        orderStats.pending_orders,
        orderStats.approved_orders,
        orderStats.completed_orders,
        orderStats.cancelled_orders
    ];
    
    const labels = ['في الانتظار', 'معتمد', 'مكتمل', 'ملغي'];
    const colors = [
        'rgba(255, 193, 7, 0.8)',   // warning
        'rgba(23, 162, 184, 0.8)',  // info
        'rgba(40, 167, 69, 0.8)',   // success
        'rgba(220, 53, 69, 0.8)'    // danger
    ];
    
    new Chart(ctx, {
        type: 'doughnut',
        data: {
            labels: labels,
            datasets: [{
                data: data,
                backgroundColor: colors,
                borderColor: colors.map(c => c.replace('0.8', '1')),
                borderWidth: 2
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        padding: 20,
                        usePointStyle: true
                    }
                }
            }
        }
    });
});

// البحث في الجدول
document.getElementById('searchOrder').addEventListener('keyup', function() {
    const filter = this.value.toLowerCase();
    const table = document.getElementById('ordersTable');
    const rows = table.getElementsByTagName('tbody')[0].getElementsByTagName('tr');

    for (let i = 0; i < rows.length; i++) {
        const orderNumber = rows[i].getElementsByTagName('td')[1].textContent.toLowerCase();
        const supplier = rows[i].getElementsByTagName('td')[3].textContent.toLowerCase();
        
        if (orderNumber.includes(filter) || supplier.includes(filter)) {
            rows[i].style.display = '';
        } else {
            rows[i].style.display = 'none';
        }
    }
});

function exportReport() {
    const startDate = document.getElementById('start_date').value;
    const endDate = document.getElementById('end_date').value;
    const status = document.getElementById('status').value;
    
    const url = `{{ route('system-reports.purchase.export') }}?type=orders&format=excel&start_date=${startDate}&end_date=${endDate}&status=${status}`;
    window.open(url, '_blank');
}
</script>
@endpush
@endsection