@extends('layouts.app')

@section('title', 'تقارير المشتريات')
@section('page-title', 'تقارير المشتريات')

@section('breadcrumb')
    <span>تقارير النظام</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>تقارير المشتريات</span>
@endsection

@section('content')
<div class="container-fluid">
    <!-- إحصائيات سريعة -->
    <div class="row mb-4">
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body text-center">
                    <div class="mb-3">
                        <i class="fas fa-shopping-cart text-primary" style="font-size: 2.5rem;"></i>
                    </div>
                    <h5 class="card-title">ملخص المشتريات</h5>
                    <p class="card-text text-muted">عرض إجمالي المشتريات والإحصائيات</p>
                    <a href="{{ route('system-reports.purchase.summary') }}" class="btn btn-primary btn-sm">
                        <i class="fas fa-eye me-2"></i>عرض التقرير
                    </a>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body text-center">
                    <div class="mb-3">
                        <i class="fas fa-truck text-success" style="font-size: 2.5rem;"></i>
                    </div>
                    <h5 class="card-title">المشتريات حسب المورد</h5>
                    <p class="card-text text-muted">تحليل مشتريات كل مورد</p>
                    <a href="{{ route('system-reports.purchase.by-supplier') }}" class="btn btn-success btn-sm">
                        <i class="fas fa-eye me-2"></i>عرض التقرير
                    </a>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body text-center">
                    <div class="mb-3">
                        <i class="fas fa-clipboard-list text-warning" style="font-size: 2.5rem;"></i>
                    </div>
                    <h5 class="card-title">أوامر الشراء</h5>
                    <p class="card-text text-muted">حالة وتتبع أوامر الشراء</p>
                    <a href="{{ route('system-reports.purchase.orders') }}" class="btn btn-warning btn-sm">
                        <i class="fas fa-eye me-2"></i>عرض التقرير
                    </a>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body text-center">
                    <div class="mb-3">
                        <i class="fas fa-chart-line text-info" style="font-size: 2.5rem;"></i>
                    </div>
                    <h5 class="card-title">اتجاهات المشتريات</h5>
                    <p class="card-text text-muted">تحليل اتجاهات المشتريات</p>
                    <a href="{{ route('system-reports.purchase.trends') }}" class="btn btn-info btn-sm">
                        <i class="fas fa-eye me-2"></i>عرض التقرير
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- قائمة التقارير المتقدمة -->
    <div class="card border-0 shadow-sm">
        <div class="card-header bg-white border-bottom-0 pb-0">
            <h5 class="card-title mb-0">
                <i class="fas fa-chart-pie me-2 text-primary"></i>
                تقارير المشتريات المتقدمة
            </h5>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6 mb-3">
                    <div class="list-group">
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="mb-1">ملخص شامل للمشتريات</h6>
                                <p class="mb-1 text-muted">عرض الإجماليات والاتجاهات</p>
                            </div>
                            <a href="{{ route('system-reports.purchase.summary') }}" class="btn btn-outline-primary btn-sm">
                                عرض
                            </a>
                        </div>
                        
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="mb-1">تحليل الموردين</h6>
                                <p class="mb-1 text-muted">مشتريات وأداء كل مورد</p>
                            </div>
                            <a href="{{ route('system-reports.purchase.by-supplier') }}" class="btn btn-outline-success btn-sm">
                                عرض
                            </a>
                        </div>
                        
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="mb-1">إدارة أوامر الشراء</h6>
                                <p class="mb-1 text-muted">حالة ومتابعة الأوامر</p>
                            </div>
                            <a href="{{ route('system-reports.purchase.orders') }}" class="btn btn-outline-warning btn-sm">
                                عرض
                            </a>
                        </div>
                    </div>
                </div>

                <div class="col-md-6 mb-3">
                    <div class="list-group">
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="mb-1">تقييم أداء الموردين</h6>
                                <p class="mb-1 text-muted">جودة الخدمة وسرعة التوريد</p>
                            </div>
                            <a href="{{ route('system-reports.purchase.performance') }}" class="btn btn-outline-info btn-sm">
                                عرض
                            </a>
                        </div>
                        
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="mb-1">اتجاهات المشتريات</h6>
                                <p class="mb-1 text-muted">تحليل النمو والتوقعات</p>
                            </div>
                            <a href="{{ route('system-reports.purchase.trends') }}" class="btn btn-outline-secondary btn-sm">
                                عرض
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.card {
    border-radius: 12px;
    overflow: hidden;
    transition: all 0.3s ease;
}

.card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.15) !important;
}

.list-group-item {
    border: none;
    border-radius: 8px !important;
    margin-bottom: 10px;
    background: #f8f9fa;
    transition: all 0.2s ease;
}

.list-group-item:hover {
    background: #e9ecef;
    transform: translateX(5px);
}

.btn {
    border-radius: 8px;
    font-weight: 500;
    transition: all 0.2s ease;
}

.btn:hover {
    transform: scale(1.05);
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.card {
    animation: fadeInUp 0.6s ease forwards;
}

.card:nth-child(1) { animation-delay: 0.1s; }
.card:nth-child(2) { animation-delay: 0.2s; }
.card:nth-child(3) { animation-delay: 0.3s; }
.card:nth-child(4) { animation-delay: 0.4s; }
</style>
@endsection