@extends('layouts.app')

@section('title', 'المشتريات حسب المورد')
@section('page-title', 'المشتريات حسب المورد')

@section('breadcrumb')
    <span>تقارير النظام</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>تقارير المشتريات</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>المشتريات حسب المورد</span>
@endsection

@section('content')
<div class="container-fluid">
    <!-- فلتر التاريخ -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-header bg-white border-bottom-0">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="fas fa-filter me-2 text-primary"></i>
                    تصفية البيانات
                </h5>
                <a href="{{ route('system-reports.purchase.index') }}" class="btn btn-outline-secondary btn-sm">
                    <i class="fas fa-arrow-right me-2"></i>العودة للتقارير
                </a>
            </div>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('system-reports.purchase.by-supplier') }}">
                <div class="row">
                    <div class="col-md-4">
                        <label for="start_date" class="form-label">من تاريخ</label>
                        <input type="date" class="form-control" id="start_date" name="start_date" 
                               value="{{ request('start_date', $startDate->format('Y-m-d')) }}">
                    </div>
                    <div class="col-md-4">
                        <label for="end_date" class="form-label">إلى تاريخ</label>
                        <input type="date" class="form-control" id="end_date" name="end_date" 
                               value="{{ request('end_date', $endDate->format('Y-m-d')) }}">
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">&nbsp;</label>
                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-search me-2"></i>تطبيق الفلتر
                            </button>
                            <button type="button" class="btn btn-success" onclick="exportReport()">
                                <i class="fas fa-download me-2"></i>تصدير
                            </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- إحصائيات سريعة -->
    @php
        $totalSuppliers = $supplierPurchases->total();
        $totalInvoices = $supplierPurchases->sum('total_invoices');
        $totalPurchasesValue = $supplierPurchases->sum('total_purchases');
        $averagePurchasePerSupplier = $totalSuppliers > 0 ? $totalPurchasesValue / $totalSuppliers : 0;
    @endphp

    <div class="row mb-4">
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-primary text-white mb-3">
                        <i class="fas fa-truck"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($totalSuppliers) }}</h3>
                    <p class="text-muted mb-0">إجمالي الموردين</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-info text-white mb-3">
                        <i class="fas fa-file-invoice-dollar"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($totalInvoices) }}</h3>
                    <p class="text-muted mb-0">إجمالي الفواتير</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-success text-white mb-3">
                        <i class="fas fa-money-bill-wave"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($totalPurchasesValue, 2) }} ريال</h3>
                    <p class="text-muted mb-0">إجمالي المشتريات</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-warning text-white mb-3">
                        <i class="fas fa-calculator"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($averagePurchasePerSupplier, 2) }} ريال</h3>
                    <p class="text-muted mb-0">متوسط المورد</p>
                </div>
            </div>
        </div>
    </div>

    <!-- أفضل الموردين -->
    @if($supplierPurchases->count() > 0)
    <div class="row mb-4">
        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom-0">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-crown me-2 text-warning"></i>
                        أعلى موردين في المشتريات
                    </h6>
                </div>
                <div class="card-body">
                    <canvas id="topSuppliersChart" height="200"></canvas>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom-0">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-chart-pie me-2 text-info"></i>
                        توزيع المشتريات
                    </h6>
                </div>
                <div class="card-body">
                    <canvas id="distributionChart" height="200"></canvas>
                </div>
            </div>
        </div>
    </div>
    @endif

    <!-- جدول تفصيلي للموردين -->
    <div class="card border-0 shadow-sm">
        <div class="card-header bg-white border-bottom-0">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="fas fa-table me-2 text-primary"></i>
                    تفاصيل مشتريات الموردين
                </h5>
                <div class="d-flex gap-2">
                    <input type="text" class="form-control form-control-sm" 
                           id="searchSupplier" placeholder="البحث في الموردين..." 
                           style="width: 200px;">
                </div>
            </div>
        </div>
        <div class="card-body">
            @if($supplierPurchases->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover" id="suppliersTable">
                        <thead class="table-light">
                            <tr>
                                <th>#</th>
                                <th>اسم المورد</th>
                                <th>معلومات الاتصال</th>
                                <th>عدد الفواتير</th>
                                <th>إجمالي المشتريات</th>
                                <th>متوسط الفاتورة</th>
                                <th>النسبة من الإجمالي</th>
                                <th>تصنيف المورد</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($supplierPurchases as $index => $supplier)
                                <tr>
                                    <td>
                                        <span class="badge bg-light text-dark">{{ $supplierPurchases->firstItem() + $index }}</span>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="supplier-avatar me-3">
                                                <i class="fas fa-truck"></i>
                                            </div>
                                            <div>
                                                <h6 class="mb-0">{{ $supplier->name ?: 'مورد غير محدد' }}</h6>
                                                <small class="text-muted">ID: {{ $supplier->id }}</small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <div>
                                            @if($supplier->email)
                                                <div class="text-info mb-1">
                                                    <i class="fas fa-envelope me-1"></i>{{ $supplier->email }}
                                                </div>
                                            @endif
                                            @if($supplier->phone)
                                                <div class="text-success">
                                                    <i class="fas fa-phone me-1"></i>{{ $supplier->phone }}
                                                </div>
                                            @endif
                                            @if(!$supplier->email && !$supplier->phone)
                                                <span class="text-muted">غير محدد</span>
                                            @endif
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge bg-primary px-3 py-2">{{ number_format($supplier->total_invoices) }}</span>
                                    </td>
                                    <td>
                                        <strong class="text-success">{{ number_format($supplier->total_purchases, 2) }} ريال</strong>
                                    </td>
                                    <td>
                                        <span class="text-info">
                                            {{ $supplier->total_invoices > 0 ? number_format($supplier->total_purchases / $supplier->total_invoices, 2) : 0 }} ريال
                                        </span>
                                    </td>
                                    <td>
                                        @php
                                            $percentage = $totalPurchasesValue > 0 ? ($supplier->total_purchases / $totalPurchasesValue) * 100 : 0;
                                        @endphp
                                        <div class="progress" style="height: 20px;">
                                            <div class="progress-bar" role="progressbar" 
                                                 style="width: {{ $percentage }}%; background: linear-gradient(45deg, #28a745, #20c997);" 
                                                 aria-valuenow="{{ $percentage }}" 
                                                 aria-valuemin="0" aria-valuemax="100">
                                                {{ number_format($percentage, 1) }}%
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        @if($percentage >= 20)
                                            <span class="badge bg-danger">استراتيجي</span>
                                        @elseif($percentage >= 10)
                                            <span class="badge bg-warning">مهم</span>
                                        @elseif($percentage >= 5)
                                            <span class="badge bg-info">نشط</span>
                                        @else
                                            <span class="badge bg-secondary">عادي</span>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- التنقل بين الصفحات -->
                <div class="d-flex justify-content-between align-items-center mt-3">
                    <div class="text-muted">
                        عرض {{ $supplierPurchases->firstItem() }} إلى {{ $supplierPurchases->lastItem() }} من إجمالي {{ $supplierPurchases->total() }} مورد
                    </div>
                    {{ $supplierPurchases->appends(request()->query())->links() }}
                </div>

                <!-- ملخص تصنيف الموردين -->
                <div class="row mt-4">
                    @php
                        $strategicCount = $supplierPurchases->filter(function($s) use($totalPurchasesValue) { 
                            return $totalPurchasesValue > 0 ? (($s->total_purchases / $totalPurchasesValue) * 100) >= 20 : false; 
                        })->count();
                        $importantCount = $supplierPurchases->filter(function($s) use($totalPurchasesValue) { 
                            $percentage = $totalPurchasesValue > 0 ? (($s->total_purchases / $totalPurchasesValue) * 100) : 0;
                            return $percentage >= 10 && $percentage < 20; 
                        })->count();
                        $activeCount = $supplierPurchases->filter(function($s) use($totalPurchasesValue) { 
                            $percentage = $totalPurchasesValue > 0 ? (($s->total_purchases / $totalPurchasesValue) * 100) : 0;
                            return $percentage >= 5 && $percentage < 10; 
                        })->count();
                        $normalCount = $totalSuppliers - $strategicCount - $importantCount - $activeCount;
                    @endphp

                    <div class="col-md-3">
                        <div class="card bg-danger text-white">
                            <div class="card-body text-center">
                                <h4>{{ $strategicCount }}</h4>
                                <p class="mb-0">موردين استراتيجيين</p>
                                <small class="opacity-75">نسبة +20%</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-warning text-white">
                            <div class="card-body text-center">
                                <h4>{{ $importantCount }}</h4>
                                <p class="mb-0">موردين مهمين</p>
                                <small class="opacity-75">نسبة 10-20%</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-info text-white">
                            <div class="card-body text-center">
                                <h4>{{ $activeCount }}</h4>
                                <p class="mb-0">موردين نشطين</p>
                                <small class="opacity-75">نسبة 5-10%</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-secondary text-white">
                            <div class="card-body text-center">
                                <h4>{{ $normalCount }}</h4>
                                <p class="mb-0">موردين عاديين</p>
                                <small class="opacity-75">نسبة أقل من 5%</small>
                            </div>
                        </div>
                    </div>
                </div>
            @else
                <div class="text-center py-5">
                    <i class="fas fa-truck text-muted" style="font-size: 4rem;"></i>
                    <h5 class="mt-3 text-muted">لا توجد بيانات للموردين</h5>
                    <p class="text-muted">لم يتم تسجيل أي مشتريات للموردين في الفترة المحددة</p>
                </div>
            @endif
        </div>
    </div>
</div>

<style>
.stats-card {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border-radius: 12px;
}

.stats-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.15) !important;
}

.stats-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto;
    font-size: 1.5rem;
}

.supplier-avatar {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: linear-gradient(45deg, #17a2b8, #138496);
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.9rem;
}

.card {
    border-radius: 12px;
    animation: fadeInUp 0.6s ease forwards;
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.table th {
    border-top: none;
    font-weight: 600;
    color: #495057;
}

.progress {
    background-color: #e9ecef;
    border-radius: 10px;
}

.table tbody tr:hover {
    background-color: #f8f9fa;
}
</style>

@push('scripts')
@if($supplierPurchases->count() > 0)
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // أعلى 5 موردين في المشتريات
    const topSuppliersCtx = document.getElementById('topSuppliersChart').getContext('2d');
    const topSuppliers = @json($supplierPurchases->take(5)->values());
    
    new Chart(topSuppliersCtx, {
        type: 'bar',
        data: {
            labels: topSuppliers.map(s => (s.name || 'مورد غير محدد').length > 15 ? (s.name || 'مورد غير محدد').substring(0, 15) + '...' : (s.name || 'مورد غير محدد')),
            datasets: [{
                label: 'المشتريات (ريال)',
                data: topSuppliers.map(s => s.total_purchases),
                backgroundColor: [
                    'rgba(220, 53, 69, 0.8)',
                    'rgba(255, 193, 7, 0.8)',
                    'rgba(23, 162, 184, 0.8)',
                    'rgba(40, 167, 69, 0.8)',
                    'rgba(108, 117, 125, 0.8)'
                ],
                borderColor: [
                    'rgba(220, 53, 69, 1)',
                    'rgba(255, 193, 7, 1)',
                    'rgba(23, 162, 184, 1)',
                    'rgba(40, 167, 69, 1)',
                    'rgba(108, 117, 125, 1)'
                ],
                borderWidth: 1,
                borderRadius: 5
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return new Intl.NumberFormat('ar-SA').format(value) + ' ريال';
                        }
                    }
                }
            }
        }
    });

    // توزيع المشتريات
    const distributionCtx = document.getElementById('distributionChart').getContext('2d');
    
    new Chart(distributionCtx, {
        type: 'doughnut',
        data: {
            labels: topSuppliers.map(s => (s.name || 'مورد غير محدد').length > 15 ? (s.name || 'مورد غير محدد').substring(0, 15) + '...' : (s.name || 'مورد غير محدد')),
            datasets: [{
                data: topSuppliers.map(s => s.total_purchases),
                backgroundColor: [
                    'rgba(220, 53, 69, 0.8)',
                    'rgba(255, 193, 7, 0.8)',
                    'rgba(23, 162, 184, 0.8)',
                    'rgba(40, 167, 69, 0.8)',
                    'rgba(108, 117, 125, 0.8)'
                ],
                borderWidth: 2,
                borderColor: '#fff'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        padding: 20,
                        usePointStyle: true
                    }
                }
            }
        }
    });
});

// البحث في الجدول
document.getElementById('searchSupplier').addEventListener('keyup', function() {
    const filter = this.value.toLowerCase();
    const table = document.getElementById('suppliersTable');
    const rows = table.getElementsByTagName('tbody')[0].getElementsByTagName('tr');

    for (let i = 0; i < rows.length; i++) {
        const supplierName = rows[i].getElementsByTagName('td')[1].textContent.toLowerCase();
        const contactInfo = rows[i].getElementsByTagName('td')[2].textContent.toLowerCase();
        if (supplierName.includes(filter) || contactInfo.includes(filter)) {
            rows[i].style.display = '';
        } else {
            rows[i].style.display = 'none';
        }
    }
});

function exportReport() {
    const startDate = document.getElementById('start_date').value;
    const endDate = document.getElementById('end_date').value;
    
    const url = `{{ route('system-reports.purchase.export') }}?type=by-supplier&format=excel&start_date=${startDate}&end_date=${endDate}`;
    window.open(url, '_blank');
}
</script>
@endif
@endpush
@endsection