@extends('layouts.app')

@section('title', 'تقرير الربحية')
@section('page-title', 'تقرير الربحية')

@section('breadcrumb')
    <span>تقارير النظام</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>تقارير المنتجات</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>تقرير الربحية</span>
@endsection

@section('content')
<div class="container-fluid">
    <!-- فلتر التاريخ -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-header bg-white border-bottom-0">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="fas fa-filter me-2 text-primary"></i>
                    تصفية البيانات
                </h5>
                <a href="{{ route('system-reports.product.index') }}" class="btn btn-outline-secondary btn-sm">
                    <i class="fas fa-arrow-right me-2"></i>العودة للتقارير
                </a>
            </div>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('system-reports.product.profitability') }}">
                <div class="row">
                    <div class="col-md-4">
                        <label for="start_date" class="form-label">من تاريخ</label>
                        <input type="date" class="form-control" id="start_date" name="start_date" 
                               value="{{ request('start_date', $startDate->format('Y-m-d')) }}">
                    </div>
                    <div class="col-md-4">
                        <label for="end_date" class="form-label">إلى تاريخ</label>
                        <input type="date" class="form-control" id="end_date" name="end_date" 
                               value="{{ request('end_date', $endDate->format('Y-m-d')) }}">
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">&nbsp;</label>
                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-search me-2"></i>تطبيق الفلتر
                            </button>
                            <button type="button" class="btn btn-success" onclick="exportReport()">
                                <i class="fas fa-download me-2"></i>تصدير
                            </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- إحصائيات سريعة للربحية -->
    @php
        $totalProducts = $productProfitability->total();
        $totalSold = $productProfitability->sum('total_sold');
        $totalRevenue = $productProfitability->sum('total_revenue');
        $totalCost = $productProfitability->sum('total_cost');
        $totalProfit = $productProfitability->sum('total_profit');
        $overallMargin = $totalRevenue > 0 ? ($totalProfit / $totalRevenue) * 100 : 0;
    @endphp

    <div class="row mb-4">
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-primary text-white mb-3">
                        <i class="fas fa-chart-line"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($totalProducts) }}</h3>
                    <p class="text-muted mb-0">المنتجات المباعة</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-info text-white mb-3">
                        <i class="fas fa-money-bill-wave"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($totalRevenue, 2) }} ريال</h3>
                    <p class="text-muted mb-0">إجمالي الإيرادات</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-success text-white mb-3">
                        <i class="fas fa-hand-holding-usd"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($totalProfit, 2) }} ريال</h3>
                    <p class="text-muted mb-0">إجمالي الربح</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-warning text-white mb-3">
                        <i class="fas fa-percent"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($overallMargin, 1) }}%</h3>
                    <p class="text-muted mb-0">هامش الربح الإجمالي</p>
                </div>
            </div>
        </div>
    </div>

    <!-- الرسوم البيانية -->
    @if($productProfitability->count() > 0)
    <div class="row mb-4">
        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom-0">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-chart-bar me-2 text-success"></i>
                        أعلى منتجات في الربح
                    </h6>
                </div>
                <div class="card-body">
                    <canvas id="profitChart" height="200"></canvas>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom-0">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-chart-line me-2 text-warning"></i>
                        هامش الربح مقابل الحجم
                    </h6>
                </div>
                <div class="card-body">
                    <canvas id="marginChart" height="200"></canvas>
                </div>
            </div>
        </div>
    </div>
    @endif

    <!-- جدول تفصيلي للربحية -->
    <div class="card border-0 shadow-sm">
        <div class="card-header bg-white border-bottom-0">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="fas fa-table me-2 text-primary"></i>
                    تفاصيل ربحية المنتجات
                </h5>
                <div class="d-flex gap-2">
                    <input type="text" class="form-control form-control-sm" 
                           id="searchProduct" placeholder="البحث في المنتجات..." 
                           style="width: 200px;">
                </div>
            </div>
        </div>
        <div class="card-body">
            @if($productProfitability->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover" id="profitabilityTable">
                        <thead class="table-light">
                            <tr>
                                <th>#</th>
                                <th>اسم المنتج</th>
                                <th>سعر التكلفة</th>
                                <th>الكمية المباعة</th>
                                <th>إجمالي الإيرادات</th>
                                <th>إجمالي التكلفة</th>
                                <th>إجمالي الربح</th>
                                <th>هامش الربح</th>
                                <th>تصنيف الربحية</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($productProfitability as $index => $product)
                                <tr>
                                    <td>
                                        <span class="badge bg-light text-dark">{{ $productProfitability->firstItem() + $index }}</span>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="product-avatar bg-primary text-white me-3">
                                                <i class="fas fa-box"></i>
                                            </div>
                                            <div>
                                                <h6 class="mb-0">{{ $product->name }}</h6>
                                                <small class="text-muted">ID: {{ $product->id }}</small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="text-muted">{{ number_format($product->cost_price, 2) }} ريال</span>
                                    </td>
                                    <td>
                                        <strong class="text-info">{{ number_format($product->total_sold) }}</strong>
                                    </td>
                                    <td>
                                        <strong class="text-primary">{{ number_format($product->total_revenue, 2) }} ريال</strong>
                                    </td>
                                    <td>
                                        <span class="text-warning">{{ number_format($product->total_cost, 2) }} ريال</span>
                                    </td>
                                    <td>
                                        <strong class="
                                            @if($product->total_profit > 0) text-success
                                            @elseif($product->total_profit < 0) text-danger
                                            @else text-muted
                                            @endif
                                        ">
                                            {{ number_format($product->total_profit, 2) }} ريال
                                        </strong>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <span class="
                                                @if($product->profit_margin >= 30) text-success
                                                @elseif($product->profit_margin >= 15) text-warning
                                                @elseif($product->profit_margin > 0) text-info
                                                @else text-danger
                                                @endif
                                                me-2
                                            ">
                                                {{ number_format($product->profit_margin, 1) }}%
                                            </span>
                                            <div class="progress" style="height: 8px; width: 60px;">
                                                <div class="progress-bar
                                                    @if($product->profit_margin >= 30) bg-success
                                                    @elseif($product->profit_margin >= 15) bg-warning
                                                    @elseif($product->profit_margin > 0) bg-info
                                                    @else bg-danger
                                                    @endif
                                                " role="progressbar" 
                                                     style="width: {{ min(abs($product->profit_margin), 100) }}%" 
                                                     aria-valuenow="{{ $product->profit_margin }}" 
                                                     aria-valuemin="0" aria-valuemax="100">
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        @if($product->profit_margin >= 30)
                                            <span class="badge bg-success">ممتاز</span>
                                        @elseif($product->profit_margin >= 15)
                                            <span class="badge bg-warning">جيد</span>
                                        @elseif($product->profit_margin > 0)
                                            <span class="badge bg-info">مقبول</span>
                                        @else
                                            <span class="badge bg-danger">خسارة</span>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- التنقل بين الصفحات -->
                <div class="d-flex justify-content-between align-items-center mt-3">
                    <div class="text-muted">
                        عرض {{ $productProfitability->firstItem() }} إلى {{ $productProfitability->lastItem() }} من إجمالي {{ $productProfitability->total() }} منتج
                    </div>
                    {{ $productProfitability->appends(request()->query())->links() }}
                </div>

                <!-- تحليل الربحية -->
                <div class="row mt-4">
                    @php
                        $excellentCount = $productProfitability->filter(function($p) { return $p->profit_margin >= 30; })->count();
                        $goodCount = $productProfitability->filter(function($p) { return $p->profit_margin >= 15 && $p->profit_margin < 30; })->count();
                        $acceptableCount = $productProfitability->filter(function($p) { return $p->profit_margin > 0 && $p->profit_margin < 15; })->count();
                        $lossCount = $productProfitability->filter(function($p) { return $p->profit_margin <= 0; })->count();
                    @endphp

                    <div class="col-md-3">
                        <div class="card bg-success text-white">
                            <div class="card-body text-center">
                                <h4>{{ $excellentCount }}</h4>
                                <p class="mb-0">منتجات ممتازة</p>
                                <small class="opacity-75">هامش +30%</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-warning text-white">
                            <div class="card-body text-center">
                                <h4>{{ $goodCount }}</h4>
                                <p class="mb-0">منتجات جيدة</p>
                                <small class="opacity-75">هامش 15-30%</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-info text-white">
                            <div class="card-body text-center">
                                <h4>{{ $acceptableCount }}</h4>
                                <p class="mb-0">منتجات مقبولة</p>
                                <small class="opacity-75">هامش 0-15%</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-danger text-white">
                            <div class="card-body text-center">
                                <h4>{{ $lossCount }}</h4>
                                <p class="mb-0">منتجات خاسرة</p>
                                <small class="opacity-75">هامش سالب</small>
                            </div>
                        </div>
                    </div>
                </div>
            @else
                <div class="text-center py-5">
                    <i class="fas fa-chart-line text-muted" style="font-size: 4rem;"></i>
                    <h5 class="mt-3 text-muted">لا توجد بيانات ربحية</h5>
                    <p class="text-muted">لم يتم تسجيل أي مبيعات للمنتجات في الفترة المحددة</p>
                </div>
            @endif
        </div>
    </div>
</div>

<style>
.stats-card {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border-radius: 12px;
}

.stats-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.15) !important;
}

.stats-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto;
    font-size: 1.5rem;
}

.product-avatar {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.9rem;
}

.card {
    border-radius: 12px;
    animation: fadeInUp 0.6s ease forwards;
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.table th {
    border-top: none;
    font-weight: 600;
    color: #495057;
}

.progress {
    background-color: #e9ecef;
}

.table tbody tr:hover {
    background-color: #f8f9fa;
}
</style>

@push('scripts')
@if($productProfitability->count() > 0)
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // أعلى 5 منتجات في الربح
    const profitCtx = document.getElementById('profitChart').getContext('2d');
    const topProfitable = @json($productProfitability->take(5)->values());
    
    new Chart(profitCtx, {
        type: 'bar',
        data: {
            labels: topProfitable.map(p => p.name.length > 15 ? p.name.substring(0, 15) + '...' : p.name),
            datasets: [{
                label: 'الربح (ريال)',
                data: topProfitable.map(p => p.total_profit),
                backgroundColor: topProfitable.map(p => 
                    p.total_profit > 0 ? 'rgba(40, 167, 69, 0.8)' : 'rgba(220, 53, 69, 0.8)'
                ),
                borderColor: topProfitable.map(p => 
                    p.total_profit > 0 ? 'rgba(40, 167, 69, 1)' : 'rgba(220, 53, 69, 1)'
                ),
                borderWidth: 1,
                borderRadius: 5
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return new Intl.NumberFormat('ar-SA').format(value) + ' ريال';
                        }
                    }
                }
            }
        }
    });

    // هامش الربح مقابل حجم المبيعات
    const marginCtx = document.getElementById('marginChart').getContext('2d');
    
    new Chart(marginCtx, {
        type: 'scatter',
        data: {
            datasets: [{
                label: 'المنتجات',
                data: topProfitable.map(p => ({
                    x: p.total_sold,
                    y: p.profit_margin
                })),
                backgroundColor: 'rgba(54, 162, 235, 0.6)',
                borderColor: 'rgba(54, 162, 235, 1)',
                borderWidth: 2
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                x: {
                    title: {
                        display: true,
                        text: 'الكمية المباعة'
                    }
                },
                y: {
                    title: {
                        display: true,
                        text: 'هامش الربح (%)'
                    },
                    ticks: {
                        callback: function(value) {
                            return value + '%';
                        }
                    }
                }
            }
        }
    });
});

// البحث في الجدول
document.getElementById('searchProduct').addEventListener('keyup', function() {
    const filter = this.value.toLowerCase();
    const table = document.getElementById('profitabilityTable');
    const rows = table.getElementsByTagName('tbody')[0].getElementsByTagName('tr');

    for (let i = 0; i < rows.length; i++) {
        const productName = rows[i].getElementsByTagName('td')[1].textContent.toLowerCase();
        if (productName.includes(filter)) {
            rows[i].style.display = '';
        } else {
            rows[i].style.display = 'none';
        }
    }
});

function exportReport() {
    const startDate = document.getElementById('start_date').value;
    const endDate = document.getElementById('end_date').value;
    
    const url = `{{ route('system-reports.product.export') }}?type=profitability&format=excel&start_date=${startDate}&end_date=${endDate}`;
    window.open(url, '_blank');
}
</script>
@endif
@endpush
@endsection