@extends('layouts.app')

@section('title', 'أداء المنتجات')
@section('page-title', 'أداء المنتجات')

@section('breadcrumb')
    <span>تقارير النظام</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>تقارير المنتجات</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>أداء المنتجات</span>
@endsection

@section('content')
<div class="container-fluid">
    <!-- فلتر التاريخ -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-header bg-white border-bottom-0">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="fas fa-filter me-2 text-primary"></i>
                    تصفية البيانات
                </h5>
                <a href="{{ route('system-reports.product.index') }}" class="btn btn-outline-secondary btn-sm">
                    <i class="fas fa-arrow-right me-2"></i>العودة للتقارير
                </a>
            </div>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('system-reports.product.performance') }}">
                <div class="row">
                    <div class="col-md-4">
                        <label for="start_date" class="form-label">من تاريخ</label>
                        <input type="date" class="form-control" id="start_date" name="start_date" 
                               value="{{ request('start_date', $startDate->format('Y-m-d')) }}">
                    </div>
                    <div class="col-md-4">
                        <label for="end_date" class="form-label">إلى تاريخ</label>
                        <input type="date" class="form-control" id="end_date" name="end_date" 
                               value="{{ request('end_date', $endDate->format('Y-m-d')) }}">
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">&nbsp;</label>
                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-search me-2"></i>تطبيق الفلتر
                            </button>
                            <button type="button" class="btn btn-success" onclick="exportReport()">
                                <i class="fas fa-download me-2"></i>تصدير
                            </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- إحصائيات سريعة -->
    @php
        $totalProducts = $productPerformance->total();
        $totalSold = $productPerformance->sum('total_sold');
        $totalRevenue = $productPerformance->sum('total_revenue');
        $totalOrders = $productPerformance->sum('orders_count');
    @endphp

    <div class="row mb-4">
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-primary text-white mb-3">
                        <i class="fas fa-boxes"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($totalProducts) }}</h3>
                    <p class="text-muted mb-0">إجمالي المنتجات</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-success text-white mb-3">
                        <i class="fas fa-sort-numeric-up"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($totalSold) }}</h3>
                    <p class="text-muted mb-0">إجمالي المباع</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-warning text-white mb-3">
                        <i class="fas fa-money-bill-wave"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($totalRevenue, 2) }} ريال</h3>
                    <p class="text-muted mb-0">إجمالي الإيرادات</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-info text-white mb-3">
                        <i class="fas fa-shopping-cart"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($totalOrders) }}</h3>
                    <p class="text-muted mb-0">إجمالي الطلبات</p>
                </div>
            </div>
        </div>
    </div>

    <!-- أفضل المنتجات -->
    @if($productPerformance->count() > 0)
    <div class="row mb-4">
        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom-0">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-chart-bar me-2 text-primary"></i>
                        أعلى منتجات في الإيرادات
                    </h6>
                </div>
                <div class="card-body">
                    <canvas id="revenueChart" height="200"></canvas>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom-0">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-chart-line me-2 text-success"></i>
                        أكثر منتجات مبيعاً
                    </h6>
                </div>
                <div class="card-body">
                    <canvas id="salesChart" height="200"></canvas>
                </div>
            </div>
        </div>
    </div>
    @endif

    <!-- جدول تفصيلي لأداء المنتجات -->
    <div class="card border-0 shadow-sm">
        <div class="card-header bg-white border-bottom-0">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="fas fa-table me-2 text-primary"></i>
                    تفاصيل أداء المنتجات
                </h5>
                <div class="d-flex gap-2">
                    <input type="text" class="form-control form-control-sm" 
                           id="searchProduct" placeholder="البحث في المنتجات..." 
                           style="width: 200px;">
                </div>
            </div>
        </div>
        <div class="card-body">
            @if($productPerformance->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover" id="performanceTable">
                        <thead class="table-light">
                            <tr>
                                <th>#</th>
                                <th>اسم المنتج</th>
                                <th>التصنيف</th>
                                <th>السعر</th>
                                <th>الكمية المباعة</th>
                                <th>إجمالي الإيرادات</th>
                                <th>متوسط سعر البيع</th>
                                <th>عدد الطلبات</th>
                                <th>الأداء</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($productPerformance as $index => $product)
                                <tr>
                                    <td>
                                        <span class="badge bg-light text-dark">{{ $productPerformance->firstItem() + $index }}</span>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="product-avatar bg-primary text-white me-3">
                                                <i class="fas fa-box"></i>
                                            </div>
                                            <div>
                                                <h6 class="mb-0">{{ $product->name }}</h6>
                                                <small class="text-muted">ID: {{ $product->id }}</small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge bg-secondary">{{ $product->category ?: 'غير محدد' }}</span>
                                    </td>
                                    <td>
                                        <span class="text-info">{{ number_format($product->price, 2) }} ريال</span>
                                    </td>
                                    <td>
                                        <strong class="text-success">{{ number_format($product->total_sold) }}</strong>
                                    </td>
                                    <td>
                                        <strong class="text-primary">{{ number_format($product->total_revenue, 2) }} ريال</strong>
                                    </td>
                                    <td>
                                        <span class="text-warning">{{ number_format($product->avg_selling_price, 2) }} ريال</span>
                                    </td>
                                    <td>
                                        <span class="badge bg-info px-3 py-2">{{ number_format($product->orders_count) }}</span>
                                    </td>
                                    <td>
                                        @php
                                            $revenuePercentage = $totalRevenue > 0 ? ($product->total_revenue / $totalRevenue) * 100 : 0;
                                        @endphp
                                        
                                        @if($revenuePercentage >= 10)
                                            <span class="badge bg-success">ممتاز</span>
                                        @elseif($revenuePercentage >= 5)
                                            <span class="badge bg-warning">جيد</span>
                                        @elseif($revenuePercentage >= 2)
                                            <span class="badge bg-info">متوسط</span>
                                        @else
                                            <span class="badge bg-secondary">ضعيف</span>
                                        @endif
                                        
                                        <div class="progress mt-1" style="height: 5px;">
                                            <div class="progress-bar" role="progressbar" 
                                                 style="width: {{ min($revenuePercentage, 100) }}%" 
                                                 aria-valuenow="{{ $revenuePercentage }}" 
                                                 aria-valuemin="0" aria-valuemax="100">
                                            </div>
                                        </div>
                                        <small class="text-muted">{{ number_format($revenuePercentage, 1) }}%</small>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- التنقل بين الصفحات -->
                <div class="d-flex justify-content-between align-items-center mt-3">
                    <div class="text-muted">
                        عرض {{ $productPerformance->firstItem() }} إلى {{ $productPerformance->lastItem() }} من إجمالي {{ $productPerformance->total() }} منتج
                    </div>
                    {{ $productPerformance->appends(request()->query())->links() }}
                </div>

                <!-- تحليل الأداء -->
                <div class="row mt-4">
                    @php
                        $excellentCount = $productPerformance->filter(function($p) use($totalRevenue) { 
                            return $totalRevenue > 0 ? (($p->total_revenue / $totalRevenue) * 100) >= 10 : false; 
                        })->count();
                        $goodCount = $productPerformance->filter(function($p) use($totalRevenue) { 
                            $percentage = $totalRevenue > 0 ? (($p->total_revenue / $totalRevenue) * 100) : 0;
                            return $percentage >= 5 && $percentage < 10; 
                        })->count();
                        $averageCount = $productPerformance->filter(function($p) use($totalRevenue) { 
                            $percentage = $totalRevenue > 0 ? (($p->total_revenue / $totalRevenue) * 100) : 0;
                            return $percentage >= 2 && $percentage < 5; 
                        })->count();
                        $weakCount = $totalProducts - $excellentCount - $goodCount - $averageCount;
                    @endphp

                    <div class="col-md-3">
                        <div class="card bg-success text-white">
                            <div class="card-body text-center">
                                <h4>{{ $excellentCount }}</h4>
                                <p class="mb-0">منتجات ممتازة</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-warning text-white">
                            <div class="card-body text-center">
                                <h4>{{ $goodCount }}</h4>
                                <p class="mb-0">منتجات جيدة</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-info text-white">
                            <div class="card-body text-center">
                                <h4>{{ $averageCount }}</h4>
                                <p class="mb-0">منتجات متوسطة</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-secondary text-white">
                            <div class="card-body text-center">
                                <h4>{{ $weakCount }}</h4>
                                <p class="mb-0">منتجات ضعيفة</p>
                            </div>
                        </div>
                    </div>
                </div>
            @else
                <div class="text-center py-5">
                    <i class="fas fa-chart-line text-muted" style="font-size: 4rem;"></i>
                    <h5 class="mt-3 text-muted">لا توجد بيانات أداء</h5>
                    <p class="text-muted">لم يتم تسجيل أي مبيعات للمنتجات في الفترة المحددة</p>
                </div>
            @endif
        </div>
    </div>
</div>

<style>
.stats-card {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border-radius: 12px;
}

.stats-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.15) !important;
}

.stats-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto;
    font-size: 1.5rem;
}

.product-avatar {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.9rem;
}

.card {
    border-radius: 12px;
    animation: fadeInUp 0.6s ease forwards;
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.table th {
    border-top: none;
    font-weight: 600;
    color: #495057;
}

.progress {
    background-color: #e9ecef;
}

.table tbody tr:hover {
    background-color: #f8f9fa;
}
</style>

@push('scripts')
@if($productPerformance->count() > 0)
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // أعلى 5 منتجات في الإيرادات
    const revenueCtx = document.getElementById('revenueChart').getContext('2d');
    const topProducts = @json($productPerformance->take(5)->values());
    
    new Chart(revenueCtx, {
        type: 'bar',
        data: {
            labels: topProducts.map(p => p.name.length > 15 ? p.name.substring(0, 15) + '...' : p.name),
            datasets: [{
                label: 'الإيرادات (ريال)',
                data: topProducts.map(p => p.total_revenue),
                backgroundColor: 'rgba(54, 162, 235, 0.8)',
                borderColor: 'rgba(54, 162, 235, 1)',
                borderWidth: 1,
                borderRadius: 5
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return new Intl.NumberFormat('ar-SA').format(value) + ' ريال';
                        }
                    }
                }
            }
        }
    });

    // أكثر منتجات مبيعاً
    const salesCtx = document.getElementById('salesChart').getContext('2d');
    
    new Chart(salesCtx, {
        type: 'line',
        data: {
            labels: topProducts.map(p => p.name.length > 15 ? p.name.substring(0, 15) + '...' : p.name),
            datasets: [{
                label: 'الكمية المباعة',
                data: topProducts.map(p => p.total_sold),
                borderColor: 'rgba(40, 167, 69, 1)',
                backgroundColor: 'rgba(40, 167, 69, 0.1)',
                borderWidth: 3,
                fill: true,
                tension: 0.4
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return new Intl.NumberFormat('ar-SA').format(value);
                        }
                    }
                }
            }
        }
    });
});

// البحث في الجدول
document.getElementById('searchProduct').addEventListener('keyup', function() {
    const filter = this.value.toLowerCase();
    const table = document.getElementById('performanceTable');
    const rows = table.getElementsByTagName('tbody')[0].getElementsByTagName('tr');

    for (let i = 0; i < rows.length; i++) {
        const productName = rows[i].getElementsByTagName('td')[1].textContent.toLowerCase();
        const category = rows[i].getElementsByTagName('td')[2].textContent.toLowerCase();
        if (productName.includes(filter) || category.includes(filter)) {
            rows[i].style.display = '';
        } else {
            rows[i].style.display = 'none';
        }
    }
});

function exportReport() {
    const startDate = document.getElementById('start_date').value;
    const endDate = document.getElementById('end_date').value;
    
    const url = `{{ route('system-reports.product.export') }}?type=performance&format=excel&start_date=${startDate}&end_date=${endDate}`;
    window.open(url, '_blank');
}
</script>
@endif
@endpush
@endsection