@extends('layouts.app')

@section('title', 'حركات المخزون')
@section('page-title', 'حركات المخزون')

@section('breadcrumb')
    <span>تقارير النظام</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>تقارير المنتجات</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>حركات المخزون</span>
@endsection

@section('content')
<div class="container-fluid">
    <!-- فلتر البيانات -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-header bg-white border-bottom-0">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="fas fa-filter me-2 text-primary"></i>
                    تصفية البيانات
                </h5>
                <a href="{{ route('system-reports.product.index') }}" class="btn btn-outline-secondary btn-sm">
                    <i class="fas fa-arrow-right me-2"></i>العودة للتقارير
                </a>
            </div>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('system-reports.product.movements') }}">
                <div class="row">
                    <div class="col-md-3">
                        <label for="start_date" class="form-label">من تاريخ</label>
                        <input type="date" class="form-control" id="start_date" name="start_date" 
                               value="{{ request('start_date', $startDate->format('Y-m-d')) }}">
                    </div>
                    <div class="col-md-3">
                        <label for="end_date" class="form-label">إلى تاريخ</label>
                        <input type="date" class="form-control" id="end_date" name="end_date" 
                               value="{{ request('end_date', $endDate->format('Y-m-d')) }}">
                    </div>
                    <div class="col-md-3">
                        <label for="product_id" class="form-label">المنتج</label>
                        <select class="form-select" id="product_id" name="product_id">
                            <option value="">جميع المنتجات</option>
                            @foreach($products as $product)
                                <option value="{{ $product->id }}" 
                                    {{ request('product_id') == $product->id ? 'selected' : '' }}>
                                    {{ $product->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">&nbsp;</label>
                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-search me-2"></i>تطبيق الفلتر
                            </button>
                            <button type="button" class="btn btn-success" onclick="exportReport()">
                                <i class="fas fa-download me-2"></i>تصدير
                            </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- إحصائيات الحركات -->
    <div class="row mb-4">
        @foreach($movementStats as $stat)
            <div class="col-lg-3 col-md-6 mb-3">
                <div class="card border-0 shadow-sm stats-card">
                    <div class="card-body text-center">
                        <div class="stats-icon 
                            @if($stat->movement_type == 'purchase') bg-success
                            @elseif($stat->movement_type == 'sale') bg-primary
                            @elseif($stat->movement_type == 'adjustment_in') bg-info
                            @elseif($stat->movement_type == 'adjustment_out') bg-warning
                            @else bg-secondary
                            @endif
                            text-white mb-3">
                            @if($stat->movement_type == 'purchase')
                                <i class="fas fa-plus"></i>
                            @elseif($stat->movement_type == 'sale')
                                <i class="fas fa-minus"></i>
                            @elseif(in_array($stat->movement_type, ['adjustment_in', 'adjustment_out']))
                                <i class="fas fa-edit"></i>
                            @elseif(in_array($stat->movement_type, ['return_in', 'return_out']))
                                <i class="fas fa-undo"></i>
                            @else
                                <i class="fas fa-exchange-alt"></i>
                            @endif
                        </div>
                        <h3 class="mb-1">{{ number_format($stat->count) }}</h3>
                        <p class="text-muted mb-1 small">حركة</p>
                        <h5 class="mb-2">
                            @if($stat->movement_type == 'purchase')
                                مشتريات
                            @elseif($stat->movement_type == 'sale')
                                مبيعات
                            @elseif($stat->movement_type == 'adjustment_in')
                                تسوية دخول
                            @elseif($stat->movement_type == 'adjustment_out')
                                تسوية خروج
                            @elseif($stat->movement_type == 'return_in')
                                مرتجع دخول
                            @elseif($stat->movement_type == 'return_out')
                                مرتجع خروج
                            @elseif($stat->movement_type == 'transfer_in')
                                تحويل دخول
                            @elseif($stat->movement_type == 'transfer_out')
                                تحويل خروج
                            @else
                                {{ $stat->movement_type }}
                            @endif
                        </h5>
                        <p class="text-muted mb-0 small">الكمية: {{ number_format(abs($stat->total_quantity)) }}</p>
                    </div>
                </div>
            </div>
        @endforeach
    </div>

    <!-- الرسم البياني للحركات -->
    @if($movementStats->count() > 0)
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-header bg-white border-bottom-0">
            <h5 class="card-title mb-0">
                <i class="fas fa-chart-bar me-2 text-primary"></i>
                توزيع حركات المخزون
            </h5>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <canvas id="movementTypesChart" height="200"></canvas>
                </div>
                <div class="col-md-6">
                    <canvas id="quantityChart" height="200"></canvas>
                </div>
            </div>
        </div>
    </div>
    @endif

    <!-- جدول تفصيلي للحركات -->
    <div class="card border-0 shadow-sm">
        <div class="card-header bg-white border-bottom-0">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="fas fa-table me-2 text-primary"></i>
                    تفاصيل حركات المخزون
                </h5>
                <div class="d-flex gap-2">
                    <input type="text" class="form-control form-control-sm" 
                           id="searchMovement" placeholder="البحث..." 
                           style="width: 200px;">
                </div>
            </div>
        </div>
        <div class="card-body">
            @if($movements->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover" id="movementsTable">
                        <thead class="table-light">
                            <tr>
                                <th>#</th>
                                <th>التاريخ</th>
                                <th>المنتج</th>
                                <th>نوع الحركة</th>
                                <th>الكمية</th>
                                <th>الاتجاه</th>
                                <th>المرجع</th>
                                <th>المستخدم</th>
                                <th>الملاحظات</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($movements as $index => $movement)
                                <tr>
                                    <td>
                                        <span class="badge bg-light text-dark">{{ $movements->firstItem() + $index }}</span>
                                    </td>
                                    <td>
                                        <div>
                                            <span class="fw-bold">{{ $movement->movement_date->format('Y/m/d') }}</span>
                                            <br>
                                            <small class="text-muted">{{ $movement->created_at->format('H:i') }}</small>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="product-avatar bg-primary text-white me-2">
                                                <i class="fas fa-box"></i>
                                            </div>
                                            <div>
                                                <h6 class="mb-0">{{ $movement->product->name ?? 'غير محدد' }}</h6>
                                                <small class="text-muted">ID: {{ $movement->product_id }}</small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge 
                                            @if($movement->type == 'purchase') bg-success
                                            @elseif($movement->type == 'sale') bg-primary
                                            @elseif($movement->type == 'adjustment_in') bg-info
                                            @elseif($movement->type == 'adjustment_out') bg-warning
                                            @elseif(in_array($movement->type, ['return_in', 'return_out'])) bg-secondary
                                            @else bg-light text-dark
                                            @endif
                                        ">
                                            @if($movement->type == 'purchase')
                                                مشتريات
                                            @elseif($movement->type == 'sale')
                                                مبيعات
                                            @elseif($movement->type == 'adjustment_in')
                                                تسوية دخول
                                            @elseif($movement->type == 'adjustment_out')
                                                تسوية خروج
                                            @elseif($movement->type == 'return_in')
                                                مرتجع دخول
                                            @elseif($movement->type == 'return_out')
                                                مرتجع خروج
                                            @elseif($movement->type == 'transfer_in')
                                                تحويل دخول
                                            @elseif($movement->type == 'transfer_out')
                                                تحويل خروج
                                            @else
                                                {{ $movement->type }}
                                            @endif
                                        </span>
                                    </td>
                                    <td>
                                        <strong class="
                                            @if($movement->quantity > 0) text-success
                                            @elseif($movement->quantity < 0) text-danger
                                            @else text-muted
                                            @endif
                                        ">
                                            {{ number_format($movement->quantity) }}
                                        </strong>
                                    </td>
                                    <td>
                                        @if($movement->quantity > 0)
                                            <span class="badge bg-success">
                                                <i class="fas fa-arrow-up me-1"></i>دخول
                                            </span>
                                        @elseif($movement->quantity < 0)
                                            <span class="badge bg-danger">
                                                <i class="fas fa-arrow-down me-1"></i>خروج
                                            </span>
                                        @else
                                            <span class="badge bg-secondary">
                                                <i class="fas fa-minus me-1"></i>ثابت
                                            </span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($movement->reference_type && $movement->reference_id)
                                            <span class="text-info">
                                                {{ $movement->reference_type }} #{{ $movement->reference_id }}
                                            </span>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        <span class="text-secondary">{{ $movement->user->name ?? 'النظام' }}</span>
                                    </td>
                                    <td>
                                        @if($movement->notes)
                                            <span class="text-muted">{{ Str::limit($movement->notes, 30) }}</span>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- التنقل بين الصفحات -->
                <div class="d-flex justify-content-between align-items-center mt-3">
                    <div class="text-muted">
                        عرض {{ $movements->firstItem() }} إلى {{ $movements->lastItem() }} من إجمالي {{ $movements->total() }} حركة
                    </div>
                    {{ $movements->appends(request()->query())->links() }}
                </div>
            @else
                <div class="text-center py-5">
                    <i class="fas fa-exchange-alt text-muted" style="font-size: 4rem;"></i>
                    <h5 class="mt-3 text-muted">لا توجد حركات مخزون</h5>
                    <p class="text-muted">لم يتم تسجيل أي حركات للمخزون في الفترة المحددة</p>
                </div>
            @endif
        </div>
    </div>
</div>

<style>
.stats-card {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border-radius: 12px;
}

.stats-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.15) !important;
}

.stats-icon {
    width: 50px;
    height: 50px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto;
    font-size: 1.2rem;
}

.product-avatar {
    width: 35px;
    height: 35px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.8rem;
}

.card {
    border-radius: 12px;
    animation: fadeInUp 0.6s ease forwards;
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.table th {
    border-top: none;
    font-weight: 600;
    color: #495057;
}

.table tbody tr:hover {
    background-color: #f8f9fa;
}
</style>

@push('scripts')
@if($movementStats->count() > 0)
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // رسم دائري لأنواع الحركات
    const typesCtx = document.getElementById('movementTypesChart').getContext('2d');
    const movementStats = @json($movementStats);
    
    const labels = movementStats.map(stat => {
        const types = {
            'purchase': 'مشتريات',
            'sale': 'مبيعات',
            'adjustment_in': 'تسوية دخول',
            'adjustment_out': 'تسوية خروج',
            'return_in': 'مرتجع دخول',
            'return_out': 'مرتجع خروج',
            'transfer_in': 'تحويل دخول',
            'transfer_out': 'تحويل خروج'
        };
        return types[stat.movement_type] || stat.movement_type;
    });
    
    const colors = [
        'rgba(40, 167, 69, 0.8)',   // green
        'rgba(0, 123, 255, 0.8)',   // blue
        'rgba(23, 162, 184, 0.8)',  // cyan
        'rgba(255, 193, 7, 0.8)',   // yellow
        'rgba(108, 117, 125, 0.8)', // gray
        'rgba(220, 53, 69, 0.8)',   // red
        'rgba(102, 16, 242, 0.8)',  // purple
        'rgba(253, 126, 20, 0.8)'   // orange
    ];
    
    new Chart(typesCtx, {
        type: 'doughnut',
        data: {
            labels: labels,
            datasets: [{
                data: movementStats.map(stat => stat.count),
                backgroundColor: colors.slice(0, movementStats.length),
                borderWidth: 2,
                borderColor: '#fff'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        padding: 20,
                        usePointStyle: true
                    }
                }
            }
        }
    });

    // رسم عمودي للكميات
    const quantityCtx = document.getElementById('quantityChart').getContext('2d');
    
    new Chart(quantityCtx, {
        type: 'bar',
        data: {
            labels: labels,
            datasets: [{
                label: 'الكمية',
                data: movementStats.map(stat => Math.abs(stat.total_quantity)),
                backgroundColor: colors.slice(0, movementStats.length),
                borderColor: colors.slice(0, movementStats.length).map(c => c.replace('0.8', '1')),
                borderWidth: 1,
                borderRadius: 5
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return new Intl.NumberFormat('ar-SA').format(value);
                        }
                    }
                }
            }
        }
    });
});

// البحث في الجدول
document.getElementById('searchMovement').addEventListener('keyup', function() {
    const filter = this.value.toLowerCase();
    const table = document.getElementById('movementsTable');
    const rows = table.getElementsByTagName('tbody')[0].getElementsByTagName('tr');

    for (let i = 0; i < rows.length; i++) {
        const product = rows[i].getElementsByTagName('td')[2].textContent.toLowerCase();
        const type = rows[i].getElementsByTagName('td')[3].textContent.toLowerCase();
        const reference = rows[i].getElementsByTagName('td')[6].textContent.toLowerCase();
        const notes = rows[i].getElementsByTagName('td')[8].textContent.toLowerCase();
        
        if (product.includes(filter) || type.includes(filter) || reference.includes(filter) || notes.includes(filter)) {
            rows[i].style.display = '';
        } else {
            rows[i].style.display = 'none';
        }
    }
});

function exportReport() {
    const startDate = document.getElementById('start_date').value;
    const endDate = document.getElementById('end_date').value;
    const productId = document.getElementById('product_id').value;
    
    const url = `{{ route('system-reports.product.export') }}?type=movements&format=excel&start_date=${startDate}&end_date=${endDate}&product_id=${productId}`;
    window.open(url, '_blank');
}
</script>
@endif
@endpush
@endsection