@extends('layouts.app')

@section('title', 'تقرير المخزون')
@section('page-title', 'تقرير المخزون')

@section('breadcrumb')
    <span>تقارير النظام</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>تقارير المنتجات</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>تقرير المخزون</span>
@endsection

@section('content')
<div class="container-fluid">
    <!-- عنوان الصفحة -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="mb-0">
            <i class="fas fa-warehouse me-2 text-primary"></i>
            تقرير المخزون
        </h4>
        <a href="{{ route('system-reports.product.index') }}" class="btn btn-outline-secondary btn-sm">
            <i class="fas fa-arrow-right me-2"></i>العودة للتقارير
        </a>
    </div>

    <!-- إحصائيات سريعة للمخزون -->
    <div class="row mb-4">
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-primary text-white mb-3">
                        <i class="fas fa-boxes"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($inventoryStats->total_products) }}</h3>
                    <p class="text-muted mb-0">إجمالي المنتجات</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-danger text-white mb-3">
                        <i class="fas fa-exclamation-triangle"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($inventoryStats->out_of_stock) }}</h3>
                    <p class="text-muted mb-0">المنتجات المنتهية</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-warning text-white mb-3">
                        <i class="fas fa-arrow-down"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($inventoryStats->low_stock) }}</h3>
                    <p class="text-muted mb-0">المنتجات المنخفضة</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-success text-white mb-3">
                        <i class="fas fa-dollar-sign"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($inventoryStats->total_inventory_value, 2) }} ريال</h3>
                    <p class="text-muted mb-0">قيمة المخزون الإجمالية</p>
                </div>
            </div>
        </div>
    </div>

    <!-- الرسوم البيانية -->
    <div class="row mb-4">
        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom-0">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-chart-pie me-2 text-info"></i>
                        توزيع حالة المخزون
                    </h6>
                </div>
                <div class="card-body">
                    <canvas id="stockStatusChart" height="200"></canvas>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom-0">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-chart-bar me-2 text-primary"></i>
                        إحصائيات المخزون
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-6 mb-3">
                            <div class="border-end">
                                <h5 class="text-success">{{ number_format($inventoryStats->avg_stock_level, 2) }}</h5>
                                <small class="text-muted">متوسط المخزون</small>
                            </div>
                        </div>
                        <div class="col-6 mb-3">
                            <h5 class="text-info">{{ number_format(($inventoryStats->out_of_stock / max($inventoryStats->total_products, 1)) * 100, 1) }}%</h5>
                            <small class="text-muted">نسبة النفاد</small>
                        </div>
                        <div class="col-6">
                            <div class="border-end">
                                <h5 class="text-warning">{{ number_format(($inventoryStats->low_stock / max($inventoryStats->total_products, 1)) * 100, 1) }}%</h5>
                                <small class="text-muted">نسبة الانخفاض</small>
                            </div>
                        </div>
                        <div class="col-6">
                            <h5 class="text-primary">{{ number_format($inventoryStats->total_inventory_value / max($inventoryStats->total_products, 1), 2) }} ريال</h5>
                            <small class="text-muted">متوسط قيمة المنتج</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- جدول تفصيلي للمخزون -->
    <div class="card border-0 shadow-sm">
        <div class="card-header bg-white border-bottom-0">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="fas fa-table me-2 text-primary"></i>
                    تفاصيل المخزون
                </h5>
                <div class="d-flex gap-2">
                    <input type="text" class="form-control form-control-sm" 
                           id="searchProduct" placeholder="البحث في المنتجات..." 
                           style="width: 200px;">
                    <select class="form-select form-select-sm" id="filterStatus" style="width: 150px;">
                        <option value="">جميع الحالات</option>
                        <option value="نفذ">نفذ</option>
                        <option value="منخفض">منخفض</option>
                        <option value="متوسط">متوسط</option>
                        <option value="جيد">جيد</option>
                    </select>
                </div>
            </div>
        </div>
        <div class="card-body">
            @if($products->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover" id="inventoryTable">
                        <thead class="table-light">
                            <tr>
                                <th>#</th>
                                <th>اسم المنتج</th>
                                <th>التصنيف</th>
                                <th>السعر</th>
                                <th>المخزون الحالي</th>
                                <th>الحد الأدنى</th>
                                <th>الحالة</th>
                                <th>قيمة المخزون</th>
                                <th>الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($products as $index => $product)
                                <tr class="product-row" data-status="{{ $product->stock_status }}">
                                    <td>
                                        <span class="badge bg-light text-dark">{{ $products->firstItem() + $index }}</span>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="product-avatar bg-primary text-white me-3">
                                                <i class="fas fa-box"></i>
                                            </div>
                                            <div>
                                                <h6 class="mb-0">{{ $product->name }}</h6>
                                                <small class="text-muted">ID: {{ $product->id }}</small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge bg-secondary">{{ $product->category ?: 'غير محدد' }}</span>
                                    </td>
                                    <td>
                                        <span class="text-info">{{ number_format($product->price, 2) }} ريال</span>
                                    </td>
                                    <td>
                                        <strong class="
                                            @if($product->stock_quantity <= 0) text-danger
                                            @elseif($product->stock_quantity <= ($product->min_stock ?? 0)) text-warning
                                            @else text-success
                                            @endif
                                        ">
                                            {{ number_format($product->stock_quantity) }}
                                        </strong>
                                    </td>
                                    <td>
                                        <span class="text-muted">{{ number_format($product->min_stock ?? 0) }}</span>
                                    </td>
                                    <td>
                                        @if($product->stock_status == 'نفذ')
                                            <span class="badge bg-danger">{{ $product->stock_status }}</span>
                                        @elseif($product->stock_status == 'منخفض')
                                            <span class="badge bg-warning">{{ $product->stock_status }}</span>
                                        @elseif($product->stock_status == 'متوسط')
                                            <span class="badge bg-info">{{ $product->stock_status }}</span>
                                        @else
                                            <span class="badge bg-success">{{ $product->stock_status }}</span>
                                        @endif
                                    </td>
                                    <td>
                                        <strong class="text-primary">
                                            {{ number_format($product->stock_quantity * $product->price, 2) }} ريال
                                        </strong>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <button type="button" class="btn btn-sm btn-outline-primary" 
                                                    title="تفاصيل المنتج">
                                                <i class="fas fa-eye"></i>
                                            </button>
                                            <button type="button" class="btn btn-sm btn-outline-warning" 
                                                    title="تسوية المخزون">
                                                <i class="fas fa-edit"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- التنقل بين الصفحات -->
                <div class="d-flex justify-content-between align-items-center mt-3">
                    <div class="text-muted">
                        عرض {{ $products->firstItem() }} إلى {{ $products->lastItem() }} من إجمالي {{ $products->total() }} منتج
                    </div>
                    {{ $products->appends(request()->query())->links() }}
                </div>
            @else
                <div class="text-center py-5">
                    <i class="fas fa-boxes text-muted" style="font-size: 4rem;"></i>
                    <h5 class="mt-3 text-muted">لا توجد منتجات</h5>
                    <p class="text-muted">لم يتم العثور على أي منتجات في المخزون</p>
                </div>
            @endif
        </div>
    </div>

    <!-- تنبيهات المخزون -->
    @if($inventoryStats->out_of_stock > 0 || $inventoryStats->low_stock > 0)
    <div class="alert alert-warning mt-4" role="alert">
        <div class="d-flex align-items-center">
            <i class="fas fa-exclamation-triangle me-2"></i>
            <div>
                <strong>تنبيهات المخزون:</strong>
                @if($inventoryStats->out_of_stock > 0)
                    يوجد {{ number_format($inventoryStats->out_of_stock) }} منتج منتهي من المخزون.
                @endif
                @if($inventoryStats->low_stock > 0)
                    يوجد {{ number_format($inventoryStats->low_stock) }} منتج منخفض المخزون.
                @endif
            </div>
        </div>
    </div>
    @endif
</div>

<style>
.stats-card {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border-radius: 12px;
}

.stats-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.15) !important;
}

.stats-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto;
    font-size: 1.5rem;
}

.product-avatar {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.9rem;
}

.card {
    border-radius: 12px;
    animation: fadeInUp 0.6s ease forwards;
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.table th {
    border-top: none;
    font-weight: 600;
    color: #495057;
}

.table tbody tr:hover {
    background-color: #f8f9fa;
}

.btn-group .btn {
    margin-right: 2px;
}
</style>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // رسم دائري لحالة المخزون
    const ctx = document.getElementById('stockStatusChart').getContext('2d');
    const inventoryStats = @json($inventoryStats);
    
    const outOfStock = inventoryStats.out_of_stock;
    const lowStock = inventoryStats.low_stock - outOfStock; // منخفض فقط (بدون المنتهي)
    const goodStock = inventoryStats.total_products - inventoryStats.low_stock;
    
    new Chart(ctx, {
        type: 'doughnut',
        data: {
            labels: ['نفذ', 'منخفض', 'جيد'],
            datasets: [{
                data: [outOfStock, lowStock, goodStock],
                backgroundColor: [
                    'rgba(220, 53, 69, 0.8)',
                    'rgba(255, 193, 7, 0.8)', 
                    'rgba(40, 167, 69, 0.8)'
                ],
                borderColor: [
                    'rgba(220, 53, 69, 1)',
                    'rgba(255, 193, 7, 1)',
                    'rgba(40, 167, 69, 1)'
                ],
                borderWidth: 2
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        padding: 20,
                        usePointStyle: true
                    }
                }
            }
        }
    });
});

// البحث والفلترة
document.getElementById('searchProduct').addEventListener('keyup', function() {
    filterTable();
});

document.getElementById('filterStatus').addEventListener('change', function() {
    filterTable();
});

function filterTable() {
    const searchFilter = document.getElementById('searchProduct').value.toLowerCase();
    const statusFilter = document.getElementById('filterStatus').value;
    const rows = document.querySelectorAll('.product-row');

    rows.forEach(row => {
        const productName = row.querySelector('td:nth-child(2)').textContent.toLowerCase();
        const category = row.querySelector('td:nth-child(3)').textContent.toLowerCase();
        const status = row.dataset.status;

        const matchesSearch = productName.includes(searchFilter) || category.includes(searchFilter);
        const matchesStatus = !statusFilter || status === statusFilter;

        if (matchesSearch && matchesStatus) {
            row.style.display = '';
        } else {
            row.style.display = 'none';
        }
    });
}
</script>
@endpush
@endsection