@extends('layouts.app')

@section('title', 'تقارير المنتجات')
@section('page-title', 'تقارير المنتجات')

@section('breadcrumb')
    <span>تقارير النظام</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>تقارير المنتجات</span>
@endsection

@section('content')
<div class="container-fluid">
    <!-- إحصائيات سريعة -->
    <div class="row mb-4">
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body text-center">
                    <div class="mb-3">
                        <i class="fas fa-chart-bar text-primary" style="font-size: 2.5rem;"></i>
                    </div>
                    <h5 class="card-title">أداء المنتجات</h5>
                    <p class="card-text text-muted">تحليل مبيعات وأداء المنتجات</p>
                    <a href="{{ route('system-reports.product.performance') }}" class="btn btn-primary btn-sm">
                        <i class="fas fa-eye me-2"></i>عرض التقرير
                    </a>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body text-center">
                    <div class="mb-3">
                        <i class="fas fa-warehouse text-success" style="font-size: 2.5rem;"></i>
                    </div>
                    <h5 class="card-title">حالة المخزون</h5>
                    <p class="card-text text-muted">مستويات المخزون والتنبيهات</p>
                    <a href="{{ route('system-reports.product.inventory') }}" class="btn btn-success btn-sm">
                        <i class="fas fa-eye me-2"></i>عرض التقرير
                    </a>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body text-center">
                    <div class="mb-3">
                        <i class="fas fa-exchange-alt text-warning" style="font-size: 2.5rem;"></i>
                    </div>
                    <h5 class="card-title">حركات المخزون</h5>
                    <p class="card-text text-muted">تتبع حركات الدخول والخروج</p>
                    <a href="{{ route('system-reports.product.movements') }}" class="btn btn-warning btn-sm">
                        <i class="fas fa-eye me-2"></i>عرض التقرير
                    </a>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body text-center">
                    <div class="mb-3">
                        <i class="fas fa-dollar-sign text-info" style="font-size: 2.5rem;"></i>
                    </div>
                    <h5 class="card-title">تحليل الربحية</h5>
                    <p class="card-text text-muted">هامش الربح لكل منتج</p>
                    <a href="{{ route('system-reports.product.profitability') }}" class="btn btn-info btn-sm">
                        <i class="fas fa-eye me-2"></i>عرض التقرير
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- قائمة التقارير المتقدمة -->
    <div class="card border-0 shadow-sm">
        <div class="card-header bg-white border-bottom-0 pb-0">
            <h5 class="card-title mb-0">
                <i class="fas fa-boxes me-2 text-primary"></i>
                تقارير المنتجات المتقدمة
            </h5>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6 mb-3">
                    <div class="list-group">
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="mb-1">تحليل أداء المنتجات</h6>
                                <p class="mb-1 text-muted">مبيعات وإيرادات كل منتج</p>
                            </div>
                            <a href="{{ route('system-reports.product.performance') }}" class="btn btn-outline-primary btn-sm">
                                عرض
                            </a>
                        </div>
                        
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="mb-1">تقرير المخزون</h6>
                                <p class="mb-1 text-muted">حالة ومستويات المخزون</p>
                            </div>
                            <a href="{{ route('system-reports.product.inventory') }}" class="btn btn-outline-success btn-sm">
                                عرض
                            </a>
                        </div>
                        
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="mb-1">حركات المخزون</h6>
                                <p class="mb-1 text-muted">سجل الحركات والتغييرات</p>
                            </div>
                            <a href="{{ route('system-reports.product.movements') }}" class="btn btn-outline-warning btn-sm">
                                عرض
                            </a>
                        </div>
                        
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="mb-1">تحليل الربحية</h6>
                                <p class="mb-1 text-muted">هوامش الربح والتكلفة</p>
                            </div>
                            <a href="{{ route('system-reports.product.profitability') }}" class="btn btn-outline-info btn-sm">
                                عرض
                            </a>
                        </div>
                    </div>
                </div>

                <div class="col-md-6 mb-3">
                    <div class="list-group">
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="mb-1">تحليل الفئات</h6>
                                <p class="mb-1 text-muted">أداء فئات المنتجات</p>
                            </div>
                            <a href="{{ route('system-reports.product.category-analysis') }}" class="btn btn-outline-secondary btn-sm">
                                عرض
                            </a>
                        </div>
                        
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="mb-1">الأكثر مبيعاً</h6>
                                <p class="mb-1 text-muted">المنتجات الأعلى في المبيعات</p>
                            </div>
                            <a href="{{ route('system-reports.product.top-selling') }}" class="btn btn-outline-danger btn-sm">
                                عرض
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.card {
    border-radius: 12px;
    overflow: hidden;
    transition: all 0.3s ease;
}

.card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.15) !important;
}

.list-group-item {
    border: none;
    border-radius: 8px !important;
    margin-bottom: 10px;
    background: #f8f9fa;
    transition: all 0.2s ease;
}

.list-group-item:hover {
    background: #e9ecef;
    transform: translateX(5px);
}

.btn {
    border-radius: 8px;
    font-weight: 500;
    transition: all 0.2s ease;
}

.btn:hover {
    transform: scale(1.05);
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.card {
    animation: fadeInUp 0.6s ease forwards;
}

.card:nth-child(1) { animation-delay: 0.1s; }
.card:nth-child(2) { animation-delay: 0.2s; }
.card:nth-child(3) { animation-delay: 0.3s; }
.card:nth-child(4) { animation-delay: 0.4s; }
</style>
@endsection