@extends('layouts.app')

@section('title', 'تجمع العملاء')
@section('page-title', 'تجمع العملاء')

@section('breadcrumb')
    <span>تقارير النظام</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>تقارير العملاء</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>تجمع العملاء</span>
@endsection

@section('content')
<div class="container-fluid">
    <!-- عنوان الصفحة -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="mb-0">
            <i class="fas fa-users me-2 text-primary"></i>
            تجمع العملاء
        </h4>
        <a href="{{ route('system-reports.customer.index') }}" class="btn btn-outline-secondary btn-sm">
            <i class="fas fa-arrow-right me-2"></i>العودة للتقارير
        </a>
    </div>

    <!-- إحصائيات التجمع -->
    <div class="row mb-4">
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-danger text-white mb-3">
                        <i class="fas fa-crown"></i>
                    </div>
                    <h3 class="mb-2">0</h3>
                    <p class="text-muted mb-0">عملاء VIP</p>
                    <small class="text-muted">أكثر من 50,000 ريال</small>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-warning text-white mb-3">
                        <i class="fas fa-medal"></i>
                    </div>
                    <h3 class="mb-2">0</h3>
                    <p class="text-muted mb-0">عملاء ذهبي</p>
                    <small class="text-muted">20,000 - 50,000 ريال</small>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-info text-white mb-3">
                        <i class="fas fa-star"></i>
                    </div>
                    <h3 class="mb-2">0</h3>
                    <p class="text-muted mb-0">عملاء فضي</p>
                    <small class="text-muted">5,000 - 20,000 ريال</small>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-secondary text-white mb-3">
                        <i class="fas fa-user"></i>
                    </div>
                    <h3 class="mb-2">0</h3>
                    <p class="text-muted mb-0">عملاء عادي</p>
                    <small class="text-muted">أقل من 5,000 ريال</small>
                </div>
            </div>
        </div>
    </div>

    <!-- الرسوم البيانية -->
    <div class="row mb-4">
        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom-0">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-chart-pie me-2 text-info"></i>
                        توزيع تجمعات العملاء
                    </h6>
                </div>
                <div class="card-body">
                    <canvas id="segmentationChart" height="200"></canvas>
                    <div class="text-center mt-3">
                        <small class="text-muted">لا توجد بيانات للعرض حالياً</small>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom-0">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-chart-bar me-2 text-primary"></i>
                        مساهمة كل تجمع في الإيرادات
                    </h6>
                </div>
                <div class="card-body">
                    <canvas id="revenueContributionChart" height="200"></canvas>
                    <div class="text-center mt-3">
                        <small class="text-muted">لا توجد بيانات للعرض حالياً</small>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- تحليل تفصيلي للتجمعات -->
    <div class="card border-0 shadow-sm">
        <div class="card-header bg-white border-bottom-0">
            <h5 class="card-title mb-0">
                <i class="fas fa-table me-2 text-primary"></i>
                تحليل تفصيلي للتجمعات
            </h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead class="table-light">
                        <tr>
                            <th>التجمع</th>
                            <th>معايير التصنيف</th>
                            <th>عدد العملاء</th>
                            <th>النسبة</th>
                            <th>إجمالي الإنفاق</th>
                            <th>متوسط الإنفاق</th>
                            <th>الخصائص</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="segment-icon bg-danger text-white me-2">
                                        <i class="fas fa-crown"></i>
                                    </div>
                                    <strong>عملاء VIP</strong>
                                </div>
                            </td>
                            <td>
                                <span class="badge bg-danger">أكثر من 50,000 ريال</span>
                            </td>
                            <td><strong>0</strong></td>
                            <td>0.0%</td>
                            <td>0.00 ريال</td>
                            <td>0.00 ريال</td>
                            <td>
                                <small class="text-muted">
                                    • أولوية عالية<br>
                                    • خدمة مميزة<br>
                                    • عروض حصرية
                                </small>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="segment-icon bg-warning text-white me-2">
                                        <i class="fas fa-medal"></i>
                                    </div>
                                    <strong>عملاء ذهبي</strong>
                                </div>
                            </td>
                            <td>
                                <span class="badge bg-warning">20,000 - 50,000 ريال</span>
                            </td>
                            <td><strong>0</strong></td>
                            <td>0.0%</td>
                            <td>0.00 ريال</td>
                            <td>0.00 ريال</td>
                            <td>
                                <small class="text-muted">
                                    • خدمة متقدمة<br>
                                    • خصومات خاصة<br>
                                    • برامج ولاء
                                </small>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="segment-icon bg-info text-white me-2">
                                        <i class="fas fa-star"></i>
                                    </div>
                                    <strong>عملاء فضي</strong>
                                </div>
                            </td>
                            <td>
                                <span class="badge bg-info">5,000 - 20,000 ريال</span>
                            </td>
                            <td><strong>0</strong></td>
                            <td>0.0%</td>
                            <td>0.00 ريال</td>
                            <td>0.00 ريال</td>
                            <td>
                                <small class="text-muted">
                                    • خدمة جيدة<br>
                                    • عروض دورية<br>
                                    • فرص ترقية
                                </small>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="segment-icon bg-secondary text-white me-2">
                                        <i class="fas fa-user"></i>
                                    </div>
                                    <strong>عملاء عادي</strong>
                                </div>
                            </td>
                            <td>
                                <span class="badge bg-secondary">أقل من 5,000 ريال</span>
                            </td>
                            <td><strong>0</strong></td>
                            <td>0.0%</td>
                            <td>0.00 ريال</td>
                            <td>0.00 ريال</td>
                            <td>
                                <small class="text-muted">
                                    • خدمة أساسية<br>
                                    • عروض عامة<br>
                                    • تحفيز النمو
                                </small>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <!-- رؤى واستراتيجيات -->
            <div class="row mt-4">
                <div class="col-md-6">
                    <div class="card bg-light">
                        <div class="card-header">
                            <h6 class="card-title mb-0">
                                <i class="fas fa-lightbulb me-2 text-warning"></i>
                                رؤى التجمع
                            </h6>
                        </div>
                        <div class="card-body">
                            <ul class="list-unstyled">
                                <li class="mb-2">
                                    <i class="fas fa-check text-success me-2"></i>
                                    يتم تحديث التجمعات تلقائياً بناءً على سلوك الشراء
                                </li>
                                <li class="mb-2">
                                    <i class="fas fa-check text-success me-2"></i>
                                    التركيز على الاحتفاظ بالعملاء المتميزين
                                </li>
                                <li class="mb-2">
                                    <i class="fas fa-check text-success me-2"></i>
                                    استراتيجيات مختلفة لكل تجمع
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card bg-light">
                        <div class="card-header">
                            <h6 class="card-title mb-0">
                                <i class="fas fa-bullseye me-2 text-primary"></i>
                                الاستراتيجيات المقترحة
                            </h6>
                        </div>
                        <div class="card-body">
                            <ul class="list-unstyled">
                                <li class="mb-2">
                                    <i class="fas fa-arrow-up text-info me-2"></i>
                                    ترقية العملاء الفضي إلى ذهبي
                                </li>
                                <li class="mb-2">
                                    <i class="fas fa-gift text-warning me-2"></i>
                                    برامج ولاء مخصصة لكل تجمع
                                </li>
                                <li class="mb-2">
                                    <i class="fas fa-heart text-danger me-2"></i>
                                    الاحتفاظ بعملاء VIP والذهبي
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <!-- ملاحظة -->
            <div class="alert alert-info mt-4" role="alert">
                <div class="d-flex align-items-center">
                    <i class="fas fa-info-circle me-2"></i>
                    <div>
                        <strong>ملاحظة:</strong>
                        سيتم عرض بيانات التجمع الفعلية بمجرد توفر بيانات العملاء والمبيعات. 
                        التجمعات تُحدث تلقائياً بناءً على إجمالي مشتريات العملاء خلال آخر 12 شهر.
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.stats-card {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border-radius: 12px;
}

.stats-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.15) !important;
}

.stats-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto;
    font-size: 1.5rem;
}

.segment-icon {
    width: 35px;
    height: 35px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.9rem;
}

.card {
    border-radius: 12px;
    animation: fadeInUp 0.6s ease forwards;
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.table th {
    border-top: none;
    font-weight: 600;
    color: #495057;
}

.table tbody tr:hover {
    background-color: #f8f9fa;
}
</style>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // رسم دائري للتجمعات (حاليا فارغ)
    const segmentationCtx = document.getElementById('segmentationChart').getContext('2d');
    
    new Chart(segmentationCtx, {
        type: 'doughnut',
        data: {
            labels: ['VIP', 'ذهبي', 'فضي', 'عادي'],
            datasets: [{
                data: [0, 0, 0, 0], // سيتم تحديثها عندما تتوفر البيانات
                backgroundColor: [
                    'rgba(220, 53, 69, 0.8)',
                    'rgba(255, 193, 7, 0.8)',
                    'rgba(23, 162, 184, 0.8)',
                    'rgba(108, 117, 125, 0.8)'
                ],
                borderWidth: 2,
                borderColor: '#fff'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        padding: 20,
                        usePointStyle: true
                    }
                }
            }
        }
    });

    // رسم عمودي لمساهمة الإيرادات (حاليا فارغ)
    const revenueCtx = document.getElementById('revenueContributionChart').getContext('2d');
    
    new Chart(revenueCtx, {
        type: 'bar',
        data: {
            labels: ['VIP', 'ذهبي', 'فضي', 'عادي'],
            datasets: [{
                label: 'مساهمة الإيرادات (ريال)',
                data: [0, 0, 0, 0], // سيتم تحديثها عندما تتوفر البيانات
                backgroundColor: [
                    'rgba(220, 53, 69, 0.8)',
                    'rgba(255, 193, 7, 0.8)',
                    'rgba(23, 162, 184, 0.8)',
                    'rgba(108, 117, 125, 0.8)'
                ],
                borderWidth: 1,
                borderRadius: 5
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return new Intl.NumberFormat('ar-SA').format(value) + ' ريال';
                        }
                    }
                }
            }
        }
    });
});
</script>
@endpush
@endsection