@extends('layouts.app')

@section('title', 'القيمة الدائمة للعملاء')
@section('page-title', 'القيمة الدائمة للعملاء')

@section('breadcrumb')
    <span>تقارير النظام</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>تقارير العملاء</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>القيمة الدائمة للعملاء</span>
@endsection

@section('content')
<div class="container-fluid">
    <!-- عنوان الصفحة -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="mb-0">
            <i class="fas fa-chart-line me-2 text-primary"></i>
            القيمة الدائمة للعملاء (CLV)
        </h4>
        <div class="d-flex gap-2">
            <a href="{{ route('system-reports.customer.index') }}" class="btn btn-outline-secondary btn-sm">
                <i class="fas fa-arrow-right me-2"></i>العودة للتقارير
            </a>
            <button class="btn btn-success btn-sm" onclick="exportReport()">
                <i class="fas fa-download me-2"></i>تصدير التقرير
            </button>
        </div>
    </div>

    <!-- إحصائيات عامة لقيمة العملاء الدائمة -->
    <div class="row mb-4">
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-primary text-white mb-3">
                        <i class="fas fa-users"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($ltvStats->total_customers ?? 0) }}</h3>
                    <p class="text-muted mb-0">إجمالي العملاء</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-success text-white mb-3">
                        <i class="fas fa-dollar-sign"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($ltvStats->avg_ltv ?? 0, 2) }}</h3>
                    <p class="text-muted mb-0">متوسط القيمة الدائمة (ريال)</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-info text-white mb-3">
                        <i class="fas fa-arrow-up"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($ltvStats->max_ltv ?? 0, 2) }}</h3>
                    <p class="text-muted mb-0">أعلى قيمة دائمة (ريال)</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-warning text-white mb-3">
                        <i class="fas fa-shopping-cart"></i>
                    </div>
                    <h3 class="mb-2">{{ number_format($ltvStats->avg_orders_per_customer ?? 0, 1) }}</h3>
                    <p class="text-muted mb-0">متوسط الطلبات لكل عميل</p>
                </div>
            </div>
        </div>
    </div>

    <!-- مؤشرات إضافية -->
    <div class="row mb-4">
        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-light">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-chart-bar me-2 text-primary"></i>
                        إحصائيات متقدمة
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-6">
                            <div class="text-center p-3 border-end">
                                <h5 class="text-success mb-1">{{ number_format($ltvStats->overall_avg_order_value ?? 0, 2) }}</h5>
                                <small class="text-muted">متوسط قيمة الطلب (ريال)</small>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="text-center p-3">
                                <h5 class="text-info mb-1">{{ number_format($ltvStats->min_ltv ?? 0, 2) }}</h5>
                                <small class="text-muted">أقل قيمة دائمة (ريال)</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-light">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-lightbulb me-2 text-warning"></i>
                        نصائح وتوصيات
                    </h6>
                </div>
                <div class="card-body">
                    <ul class="list-unstyled mb-0">
                        <li class="mb-2">
                            <i class="fas fa-check-circle text-success me-2"></i>
                            ركز على العملاء ذوي القيمة الدائمة العالية
                        </li>
                        <li class="mb-2">
                            <i class="fas fa-check-circle text-success me-2"></i>
                            طور برامج ولاء لزيادة القيمة الشهرية
                        </li>
                        <li class="mb-0">
                            <i class="fas fa-check-circle text-success me-2"></i>
                            استهدف العملاء بقيمة دائمة منخفضة للتحسين
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <!-- جدول تفصيل القيمة الدائمة للعملاء -->
    <div class="card border-0 shadow-sm">
        <div class="card-header bg-white border-bottom-0">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="fas fa-table me-2 text-primary"></i>
                    تفصيل القيمة الدائمة للعملاء
                </h5>
                <div class="d-flex align-items-center gap-2">
                    <small class="text-muted">
                        عرض {{ $customerLTV->firstItem() ?? 0 }} - {{ $customerLTV->lastItem() ?? 0 }} من {{ $customerLTV->total() ?? 0 }} عميل
                    </small>
                </div>
            </div>
        </div>
        <div class="card-body p-0">
            @if($customerLTV && $customerLTV->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th class="px-4 py-3">العميل</th>
                                <th class="px-4 py-3 text-center">تاريخ التسجيل</th>
                                <th class="px-4 py-3 text-center">عدد الطلبات</th>
                                <th class="px-4 py-3 text-center">إجمالي الإنفاق</th>
                                <th class="px-4 py-3 text-center">متوسط قيمة الطلب</th>
                                <th class="px-4 py-3 text-center">عمر العميل (أيام)</th>
                                <th class="px-4 py-3 text-center">القيمة الشهرية</th>
                                <th class="px-4 py-3 text-center">التصنيف</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($customerLTV as $customer)
                                <tr>
                                    <td class="px-4 py-3">
                                        <div class="d-flex align-items-center">
                                            <div class="avatar-circle bg-primary text-white me-3">
                                                {{ substr($customer->name, 0, 1) }}
                                            </div>
                                            <div>
                                                <div class="fw-semibold">{{ $customer->name }}</div>
                                                @if($customer->email)
                                                    <small class="text-muted">{{ $customer->email }}</small>
                                                @endif
                                            </div>
                                        </div>
                                    </td>
                                    <td class="px-4 py-3 text-center">
                                        <span class="text-muted">{{ \Carbon\Carbon::parse($customer->registration_date)->format('d/m/Y') }}</span>
                                    </td>
                                    <td class="px-4 py-3 text-center">
                                        <span class="badge bg-info">{{ number_format($customer->total_orders) }}</span>
                                    </td>
                                    <td class="px-4 py-3 text-center">
                                        <strong class="text-success">{{ number_format($customer->total_spent, 2) }} ريال</strong>
                                    </td>
                                    <td class="px-4 py-3 text-center">
                                        <span class="text-primary">{{ number_format($customer->avg_order_value, 2) }} ريال</span>
                                    </td>
                                    <td class="px-4 py-3 text-center">
                                        <span class="badge bg-secondary">{{ number_format($customer->customer_age_days) }} يوم</span>
                                    </td>
                                    <td class="px-4 py-3 text-center">
                                        <span class="text-warning fw-semibold">{{ number_format($customer->monthly_value, 2) }} ريال</span>
                                    </td>
                                    <td class="px-4 py-3 text-center">
                                        @php
                                            $ltv = $customer->total_spent;
                                            $badgeClass = 'bg-secondary';
                                            $category = 'عادي';
                                            
                                            if ($ltv >= 10000) {
                                                $badgeClass = 'bg-danger';
                                                $category = 'VIP';
                                            } elseif ($ltv >= 5000) {
                                                $badgeClass = 'bg-warning';
                                                $category = 'ممتاز';
                                            } elseif ($ltv >= 1000) {
                                                $badgeClass = 'bg-success';
                                                $category = 'جيد';
                                            } elseif ($ltv > 0) {
                                                $badgeClass = 'bg-info';
                                                $category = 'جديد';
                                            } else {
                                                $badgeClass = 'bg-light text-dark';
                                                $category = 'غير نشط';
                                            }
                                        @endphp
                                        <span class="badge {{ $badgeClass }}">{{ $category }}</span>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                
                <!-- الصفحات -->
                @if($customerLTV->hasPages())
                    <div class="d-flex justify-content-center py-3">
                        {{ $customerLTV->links() }}
                    </div>
                @endif
            @else
                <div class="text-center py-5">
                    <div class="mb-3">
                        <i class="fas fa-users fa-3x text-muted"></i>
                    </div>
                    <h5 class="text-muted">لا توجد بيانات عملاء</h5>
                    <p class="text-muted">لم يتم العثور على أي بيانات لعرضها في الوقت الحالي.</p>
                </div>
            @endif
        </div>
    </div>

    <!-- ملاحظة حول الحسابات -->
    <div class="alert alert-info mt-4" role="alert">
        <div class="d-flex align-items-start">
            <i class="fas fa-info-circle me-2 mt-1"></i>
            <div>
                <strong>طريقة الحساب:</strong>
                <ul class="mb-0 mt-2">
                    <li><strong>القيمة الدائمة:</strong> مجموع كامل المبالغ التي أنفقها العميل منذ تسجيله</li>
                    <li><strong>القيمة الشهرية:</strong> القيمة الدائمة مقسومة على عمر العميل بالأشهر</li>
                    <li><strong>متوسط قيمة الطلب:</strong> إجمالي الإنفاق مقسوم على عدد الطلبات</li>
                    <li><strong>التصنيف:</strong> VIP (10,000+ ريال)، ممتاز (5,000+ ريال)، جيد (1,000+ ريال)، جديد (أقل من 1,000 ريال)</li>
                </ul>
            </div>
        </div>
    </div>
</div>

<style>
.stats-card {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border-radius: 12px;
}

.stats-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.15) !important;
}

.stats-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto;
    font-size: 1.5rem;
}

.card {
    border-radius: 12px;
    animation: fadeInUp 0.6s ease forwards;
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.table th {
    border-top: none;
    font-weight: 600;
    color: #495057;
    background-color: #f8f9fa !important;
}

.table tbody tr:hover {
    background-color: #f8f9fa;
}

.avatar-circle {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: bold;
    font-size: 1.1rem;
}

.badge {
    font-size: 0.75rem;
    padding: 0.4rem 0.8rem;
}

.border-end {
    border-right: 1px solid #dee2e6 !important;
}
</style>

@push('scripts')
<script>
function exportReport() {
    // يمكن تطوير هذه الوظيفة لاحقاً لتصدير التقرير
    alert('سيتم تطوير وظيفة التصدير قريباً');
}

// تفعيل tooltips إذا كانت موجودة
document.addEventListener('DOMContentLoaded', function () {
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
    });
});
</script>
@endpush
@endsection