@extends('layouts.app')

@section('title', 'نشاط العملاء')
@section('page-title', 'نشاط العملاء')

@section('breadcrumb')
    <span>تقارير النظام</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>تقارير العملاء</span>
    <i class="fas fa-chevron-left breadcrumb-separator"></i>
    <span>نشاط العملاء</span>
@endsection

@section('content')
<div class="container-fluid">
    <!-- فلتر البيانات -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-header bg-white border-bottom-0">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="fas fa-filter me-2 text-primary"></i>
                    تصفية النشاط
                </h5>
                <a href="{{ route('system-reports.customer.index') }}" class="btn btn-outline-secondary btn-sm">
                    <i class="fas fa-arrow-right me-2"></i>العودة للتقارير
                </a>
            </div>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('system-reports.customer.activity') }}">
                <div class="row">
                    <div class="col-md-3">
                        <label for="period" class="form-label">فترة النشاط</label>
                        <select class="form-select" id="period" name="period">
                            <option value="30" {{ request('period', 30) == 30 ? 'selected' : '' }}>آخر 30 يوم</option>
                            <option value="60" {{ request('period') == 60 ? 'selected' : '' }}>آخر 60 يوم</option>
                            <option value="90" {{ request('period') == 90 ? 'selected' : '' }}>آخر 90 يوم</option>
                            <option value="365" {{ request('period') == 365 ? 'selected' : '' }}>آخر سنة</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label for="activity_type" class="form-label">نوع النشاط</label>
                        <select class="form-select" id="activity_type" name="activity_type">
                            <option value="all" {{ request('activity_type', 'all') === 'all' ? 'selected' : '' }}>جميع الأنشطة</option>
                            <option value="active" {{ request('activity_type') === 'active' ? 'selected' : '' }}>نشط</option>
                            <option value="inactive" {{ request('activity_type') === 'inactive' ? 'selected' : '' }}>غير نشط</option>
                            <option value="new" {{ request('activity_type') === 'new' ? 'selected' : '' }}>عملاء جدد</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label for="min_orders" class="form-label">الحد الأدنى للطلبات</label>
                        <input type="number" class="form-control" id="min_orders" name="min_orders" 
                               value="{{ request('min_orders', 1) }}" min="0">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">&nbsp;</label>
                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-search me-2"></i>تحليل النشاط
                            </button>
                            <button type="button" class="btn btn-success" onclick="exportReport()">
                                <i class="fas fa-download me-2"></i>تصدير
                            </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- إحصائيات النشاط -->
    <div class="row mb-4">
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-success text-white mb-3">
                        <i class="fas fa-user-check"></i>
                    </div>
                    <h3 class="mb-2">0</h3>
                    <p class="text-muted mb-0">عملاء نشطين</p>
                    <small class="text-muted">لديهم نشاط حديث</small>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-warning text-white mb-3">
                        <i class="fas fa-user-clock"></i>
                    </div>
                    <h3 class="mb-2">0</h3>
                    <p class="text-muted mb-0">عملاء خاملين</p>
                    <small class="text-muted">لا يوجد نشاط حديث</small>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-info text-white mb-3">
                        <i class="fas fa-user-plus"></i>
                    </div>
                    <h3 class="mb-2">0</h3>
                    <p class="text-muted mb-0">عملاء جدد</p>
                    <small class="text-muted">انضموا مؤخراً</small>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm stats-card">
                <div class="card-body text-center">
                    <div class="stats-icon bg-primary text-white mb-3">
                        <i class="fas fa-chart-line"></i>
                    </div>
                    <h3 class="mb-2">0%</h3>
                    <p class="text-muted mb-0">معدل النشاط</p>
                    <small class="text-muted">نسبة العملاء النشطين</small>
                </div>
            </div>
        </div>
    </div>

    <!-- الرسوم البيانية -->
    <div class="row mb-4">
        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom-0">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-chart-area me-2 text-primary"></i>
                        اتجاه النشاط اليومي
                    </h6>
                </div>
                <div class="card-body">
                    <canvas id="activityTrendChart" height="200"></canvas>
                    <div class="text-center mt-3">
                        <small class="text-muted">سيتم عرض البيانات عند توفر نشاط العملاء</small>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom-0">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-chart-pie me-2 text-info"></i>
                        توزيع حالات النشاط
                    </h6>
                </div>
                <div class="card-body">
                    <canvas id="activityStatusChart" height="200"></canvas>
                    <div class="text-center mt-3">
                        <small class="text-muted">لا توجد بيانات للعرض حالياً</small>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- تحليل تفصيلي للنشاط -->
    <div class="card border-0 shadow-sm">
        <div class="card-header bg-white border-bottom-0">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="fas fa-table me-2 text-primary"></i>
                    تحليل نشاط العملاء
                </h5>
                <div class="d-flex gap-2">
                    <input type="text" class="form-control form-control-sm" 
                           id="searchCustomer" placeholder="البحث في العملاء..." 
                           style="width: 200px;">
                </div>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover" id="activityTable">
                    <thead class="table-light">
                        <tr>
                            <th>#</th>
                            <th>العميل</th>
                            <th>حالة النشاط</th>
                            <th>آخر طلب</th>
                            <th>عدد الطلبات</th>
                            <th>إجمالي الإنفاق</th>
                            <th>متوسط الطلب</th>
                            <th>تكرار الزيارة</th>
                            <th>التقييم</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td colspan="9" class="text-center py-5">
                                <i class="fas fa-users text-muted" style="font-size: 3rem;"></i>
                                <h5 class="mt-3 text-muted">لا توجد بيانات نشاط</h5>
                                <p class="text-muted">سيتم عرض بيانات نشاط العملاء عند توفر المعلومات</p>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- تحليل الأنماط -->
    <div class="row mt-4">
        <div class="col-md-4">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-light">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-bullseye me-2 text-success"></i>
                        العملاء النشطين
                    </h6>
                </div>
                <div class="card-body">
                    <ul class="list-unstyled">
                        <li class="mb-2">
                            <i class="fas fa-check text-success me-2"></i>
                            تفاعل منتظم مع المنتجات
                        </li>
                        <li class="mb-2">
                            <i class="fas fa-check text-success me-2"></i>
                            طلبات متكررة خلال الفترة
                        </li>
                        <li class="mb-2">
                            <i class="fas fa-check text-success me-2"></i>
                            قيمة إنفاق مستقرة أو متزايدة
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-light">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-exclamation-triangle me-2 text-warning"></i>
                        العملاء المعرضين للمخاطر
                    </h6>
                </div>
                <div class="card-body">
                    <ul class="list-unstyled">
                        <li class="mb-2">
                            <i class="fas fa-minus text-warning me-2"></i>
                            انخفاض في تكرار الطلبات
                        </li>
                        <li class="mb-2">
                            <i class="fas fa-minus text-warning me-2"></i>
                            قيمة إنفاق متناقصة
                        </li>
                        <li class="mb-2">
                            <i class="fas fa-minus text-warning me-2"></i>
                            فترات طويلة بين الطلبات
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-light">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-lightbulb me-2 text-info"></i>
                        التوصيات
                    </h6>
                </div>
                <div class="card-body">
                    <ul class="list-unstyled">
                        <li class="mb-2">
                            <i class="fas fa-arrow-up text-info me-2"></i>
                            إعادة تفعيل العملاء الخاملين
                        </li>
                        <li class="mb-2">
                            <i class="fas fa-gift text-info me-2"></i>
                            عروض خاصة للعملاء المعرضين للمخاطر
                        </li>
                        <li class="mb-2">
                            <i class="fas fa-heart text-info me-2"></i>
                            برامج ولاء للعملاء النشطين
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.stats-card {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border-radius: 12px;
}

.stats-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.15) !important;
}

.stats-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto;
    font-size: 1.5rem;
}

.card {
    border-radius: 12px;
    animation: fadeInUp 0.6s ease forwards;
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.table th {
    border-top: none;
    font-weight: 600;
    color: #495057;
}

.table tbody tr:hover {
    background-color: #f8f9fa;
}
</style>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // رسم اتجاه النشاط اليومي (فارغ حالياً)
    const trendCtx = document.getElementById('activityTrendChart').getContext('2d');
    
    new Chart(trendCtx, {
        type: 'line',
        data: {
            labels: [], // سيتم ملؤها بالبيانات الفعلية
            datasets: [{
                label: 'العملاء النشطين',
                data: [],
                borderColor: '#007bff',
                backgroundColor: 'rgba(0, 123, 255, 0.1)',
                borderWidth: 3,
                fill: true,
                tension: 0.4
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

    // رسم دائري لحالات النشاط (فارغ حالياً)
    const statusCtx = document.getElementById('activityStatusChart').getContext('2d');
    
    new Chart(statusCtx, {
        type: 'doughnut',
        data: {
            labels: ['نشط', 'خامل', 'جديد'],
            datasets: [{
                data: [0, 0, 0], // سيتم تحديثها بالبيانات الفعلية
                backgroundColor: [
                    'rgba(40, 167, 69, 0.8)',
                    'rgba(255, 193, 7, 0.8)',
                    'rgba(23, 162, 184, 0.8)'
                ],
                borderWidth: 2,
                borderColor: '#fff'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        padding: 20,
                        usePointStyle: true
                    }
                }
            }
        }
    });
});

// البحث في الجدول
document.getElementById('searchCustomer').addEventListener('keyup', function() {
    const filter = this.value.toLowerCase();
    const table = document.getElementById('activityTable');
    const rows = table.getElementsByTagName('tbody')[0].getElementsByTagName('tr');

    for (let i = 0; i < rows.length; i++) {
        const customerName = rows[i].getElementsByTagName('td')[1]?.textContent.toLowerCase() || '';
        if (customerName.includes(filter)) {
            rows[i].style.display = '';
        } else {
            rows[i].style.display = 'none';
        }
    }
});

function exportReport() {
    const period = document.getElementById('period').value;
    const activityType = document.getElementById('activity_type').value;
    const minOrders = document.getElementById('min_orders').value;
    
    const url = `{{ route('system-reports.customer.export') }}?type=activity&format=excel&period=${period}&activity_type=${activityType}&min_orders=${minOrders}`;
    window.open(url, '_blank');
}
</script>
@endpush
@endsection