@extends('layouts.app')

@section('title', 'تفاصيل المورد')
@section('page-title', 'المورد: ' . $supplier->name)

@section('page-actions')
    <div class="btn-group" role="group">
        <a href="{{ route('suppliers.edit', $supplier) }}" class="btn btn-warning">
            <i class="fas fa-edit me-2"></i>
            تعديل المورد
        </a>
        
        @if($supplier->current_balance > 0)
            <a href="{{ route('suppliers.payments.create', ['supplier_id' => $supplier->id]) }}" class="btn btn-success">
                <i class="fas fa-money-bill-wave me-2"></i>
                إضافة دفعة
            </a>
        @endif
        
        <a href="{{ route('suppliers.analytics.statement', $supplier) }}" class="btn btn-info">
            <i class="fas fa-file-invoice me-2"></i>
            كشف الحساب
        </a>
        
        <div class="btn-group" role="group">
            <button type="button" class="btn btn-outline-secondary dropdown-toggle" data-bs-toggle="dropdown">
                <i class="fas fa-chart-line me-2"></i>
                التقارير
            </button>
            <ul class="dropdown-menu">
                <li><a class="dropdown-item" href="{{ route('suppliers.analytics.performance') }}?supplier_id={{ $supplier->id }}">
                    <i class="fas fa-chart-bar me-2"></i>تقرير الأداء
                </a></li>
                <li><a class="dropdown-item" href="{{ route('suppliers.payments.supplier-report', $supplier) }}">
                    <i class="fas fa-money-bill me-2"></i>تقرير المدفوعات
                </a></li>
            </ul>
        </div>
        
        <button type="button" class="btn btn-outline-danger" onclick="toggleSupplierStatus()">
            <i class="fas fa-{{ $supplier->is_active ? 'pause' : 'play' }} me-2"></i>
            {{ $supplier->is_active ? 'إلغاء التفعيل' : 'تفعيل' }}
        </button>
        
        <a href="{{ route('suppliers.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-right me-2"></i>
            العودة للقائمة
        </a>
    </div>
@endsection

@section('content')
<div class="row">
    <!-- معلومات المورد الرئيسية -->
    <div class="col-lg-8 mb-4">
        <!-- البيانات الأساسية -->
        <div class="card mb-4">
            <div class="card-header bg-light d-flex justify-content-between align-items-center">
                <h6 class="card-title mb-0">
                    <i class="fas fa-user-tie me-2"></i>
                    البيانات الأساسية
                </h6>
                <div>
                    <span class="badge bg-{{ $supplier->is_active ? 'success' : 'danger' }}">
                        {{ $supplier->is_active ? 'نشط' : 'غير نشط' }}
                    </span>
                    @if($supplier->getRiskLevelAttribute() !== 'low')
                        <span class="badge bg-{{ $supplier->getRiskLevelAttribute() === 'critical' ? 'danger' : ($supplier->getRiskLevelAttribute() === 'high' ? 'warning' : 'info') }}">
                            @switch($supplier->getRiskLevelAttribute())
                                @case('critical') مخاطر عالية جداً @break
                                @case('high') مخاطر عالية @break  
                                @case('medium') مخاطر متوسطة @break
                                @default مخاطر منخفضة @break
                            @endswitch
                        </span>
                    @endif
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <tr>
                                <td><strong>كود المورد:</strong></td>
                                <td>{{ $supplier->code }}</td>
                            </tr>
                            <tr>
                                <td><strong>اسم المورد:</strong></td>
                                <td>{{ $supplier->name }}</td>
                            </tr>
                            @if($supplier->name_en)
                            <tr>
                                <td><strong>الاسم بالإنجليزية:</strong></td>
                                <td>{{ $supplier->name_en }}</td>
                            </tr>
                            @endif
                            @if($supplier->contact_person)
                            <tr>
                                <td><strong>الشخص المسؤول:</strong></td>
                                <td>{{ $supplier->contact_person }}</td>
                            </tr>
                            @endif
                            @if($supplier->email)
                            <tr>
                                <td><strong>البريد الإلكتروني:</strong></td>
                                <td>
                                    <a href="mailto:{{ $supplier->email }}" class="text-decoration-none">
                                        {{ $supplier->email }}
                                    </a>
                                </td>
                            </tr>
                            @endif
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            @if($supplier->phone)
                            <tr>
                                <td><strong>الهاتف:</strong></td>
                                <td>
                                    <a href="tel:{{ $supplier->phone }}" class="text-decoration-none">
                                        {{ $supplier->phone }}
                                    </a>
                                </td>
                            </tr>
                            @endif
                            @if($supplier->mobile)
                            <tr>
                                <td><strong>الجوال:</strong></td>
                                <td>
                                    <a href="tel:{{ $supplier->mobile }}" class="text-decoration-none">
                                        {{ $supplier->mobile }}
                                    </a>
                                </td>
                            </tr>
                            @endif
                            @if($supplier->tax_number)
                            <tr>
                                <td><strong>الرقم الضريبي:</strong></td>
                                <td>{{ $supplier->tax_number }}</td>
                            </tr>
                            @endif
                            @if($supplier->commercial_registration)
                            <tr>
                                <td><strong>السجل التجاري:</strong></td>
                                <td>{{ $supplier->commercial_registration }}</td>
                            </tr>
                            @endif
                            <tr>
                                <td><strong>العملة:</strong></td>
                                <td>{{ $supplier->currency ?? 'SAR' }}</td>
                            </tr>
                        </table>
                    </div>
                </div>
                
                @if($supplier->address || $supplier->city)
                <hr>
                <div class="row">
                    <div class="col-12">
                        <strong>العنوان:</strong>
                        <p class="mb-0">
                            {{ $supplier->address }}
                            @if($supplier->city), {{ $supplier->city }}@endif
                            @if($supplier->country), {{ $supplier->country }}@endif
                            @if($supplier->postal_code) - {{ $supplier->postal_code }}@endif
                        </p>
                    </div>
                </div>
                @endif
                
                @if($supplier->notes)
                <hr>
                <div class="row">
                    <div class="col-12">
                        <strong>ملاحظات:</strong>
                        <p class="mb-0">{{ $supplier->notes }}</p>
                    </div>
                </div>
                @endif
            </div>
        </div>
        
        <!-- المعاملات الأخيرة -->
        <div class="card mb-4">
            <div class="card-header bg-light">
                <h6 class="card-title mb-0">
                    <i class="fas fa-history me-2"></i>
                    آخر المعاملات
                </h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <h6 class="text-primary">آخر الفواتير</h6>
                        @if($supplier->purchaseInvoices->take(5)->count() > 0)
                            @foreach($supplier->purchaseInvoices->take(5) as $invoice)
                            <div class="d-flex justify-content-between align-items-center border-bottom py-2">
                                <div>
                                    <a href="{{ route('purchase-invoices.show', $invoice) }}" class="text-decoration-none">
                                        <strong>{{ $invoice->invoice_number }}</strong>
                                    </a>
                                    <br><small class="text-muted">{{ $invoice->invoice_date->format('d/m/Y') }}</small>
                                </div>
                                <div class="text-end">
                                    <strong>{{ number_format($invoice->total_amount, 2) }} ر.س</strong>
                                    <br>
                                    <span class="badge bg-{{ $invoice->payment_status === 'paid' ? 'success' : ($invoice->payment_status === 'partial' ? 'warning' : 'danger') }}">
                                        @switch($invoice->payment_status)
                                            @case('paid') مدفوعة @break
                                            @case('partial') جزئياً @break
                                            @case('unpaid') غير مدفوعة @break
                                            @case('overdue') متأخرة @break
                                        @endswitch
                                    </span>
                                </div>
                            </div>
                            @endforeach
                        @else
                            <p class="text-muted">لا توجد فواتير</p>
                        @endif
                    </div>
                    
                    <div class="col-md-6">
                        <h6 class="text-success">آخر المدفوعات</h6>
                        @if($supplier->paymentVouchers->take(5)->count() > 0)
                            @foreach($supplier->paymentVouchers->take(5) as $payment)
                            <div class="d-flex justify-content-between align-items-center border-bottom py-2">
                                <div>
                                    <a href="{{ route('suppliers.payments.show', $payment) }}" class="text-decoration-none">
                                        <strong>دفعة #{{ $payment->id }}</strong>
                                    </a>
                                    <br><small class="text-muted">{{ $payment->payment_date->format('d/m/Y') }}</small>
                                </div>
                                <div class="text-end">
                                    <strong class="text-success">{{ number_format($payment->amount, 2) }} ر.س</strong>
                                    <br>
                                    <span class="badge bg-info">{{ $payment->getPaymentMethodLabelAttribute() }}</span>
                                </div>
                            </div>
                            @endforeach
                        @else
                            <p class="text-muted">لا توجد مدفوعات</p>
                        @endif
                    </div>
                </div>
            </div>
        </div>
        
        <!-- الأصناف الأكثر شراءً -->
        @php
            $topItems = $supplier->getTopPurchasedItems();
        @endphp
        @if($topItems->count() > 0)
        <div class="card">
            <div class="card-header bg-light">
                <h6 class="card-title mb-0">
                    <i class="fas fa-shopping-cart me-2"></i>
                    أكثر الأصناف شراءً
                </h6>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-sm">
                        <thead>
                            <tr>
                                <th>الصنف</th>
                                <th class="text-center">إجمالي الكمية</th>
                                <th class="text-center">إجمالي المبلغ</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($topItems as $item)
                            <tr>
                                <td>
                                    <strong>{{ $item->name }}</strong>
                                    @if($item->code)
                                        <br><small class="text-muted">{{ $item->code }}</small>
                                    @endif
                                </td>
                                <td class="text-center">{{ number_format($item->total_quantity, 0) }}</td>
                                <td class="text-center">
                                    <strong>{{ number_format($item->total_amount, 2) }} ر.س</strong>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        @endif
    </div>
    
    <!-- الملخص المالي والإحصائيات -->
    <div class="col-lg-4">
        <!-- الملخص المالي -->
        <div class="card mb-4">
            <div class="card-header bg-light">
                <h6 class="card-title mb-0">
                    <i class="fas fa-calculator me-2"></i>
                    الملخص المالي
                </h6>
            </div>
            <div class="card-body">
                @php
                    $metrics = $supplier->getPerformanceMetrics();
                @endphp
                
                <div class="row text-center mb-3">
                    <div class="col-6">
                        <div class="h5 mb-0 text-{{ $supplier->current_balance > 0 ? 'danger' : 'success' }}">
                            {{ number_format($supplier->current_balance, 2) }}
                        </div>
                        <small class="text-muted">الرصيد الحالي (ر.س)</small>
                    </div>
                    <div class="col-6">
                        <div class="h5 mb-0 text-primary">{{ number_format($supplier->credit_limit, 2) }}</div>
                        <small class="text-muted">حد الائتمان (ر.س)</small>
                    </div>
                </div>
                
                <!-- مؤشر استخدام الائتمان -->
                <div class="mb-3">
                    <div class="d-flex justify-content-between mb-1">
                        <small>استخدام الائتمان</small>
                        <small>{{ number_format($supplier->getCreditUtilizationAttribute(), 1) }}%</small>
                    </div>
                    <div class="progress" style="height: 8px;">
                        @php
                            $utilization = $supplier->getCreditUtilizationAttribute();
                            $progressClass = 'bg-success';
                            if ($utilization >= 90) $progressClass = 'bg-danger';
                            elseif ($utilization >= 75) $progressClass = 'bg-warning';
                            elseif ($utilization >= 50) $progressClass = 'bg-info';
                        @endphp
                        <div class="progress-bar {{ $progressClass }}" style="width: {{ min(100, $utilization) }}%"></div>
                    </div>
                </div>
                
                <table class="table table-borderless table-sm">
                    <tr>
                        <td>الائتمان المتاح:</td>
                        <td class="text-end">
                            <strong class="text-success">{{ number_format($supplier->getAvailableCreditAttribute(), 2) }} ر.س</strong>
                        </td>
                    </tr>
                    <tr>
                        <td>إجمالي المشتريات (هذا العام):</td>
                        <td class="text-end">{{ number_format($metrics['total_purchases'], 2) }} ر.س</td>
                    </tr>
                    <tr>
                        <td>إجمالي المدفوعات (هذا العام):</td>
                        <td class="text-end">{{ number_format($metrics['total_payments'], 2) }} ر.س</td>
                    </tr>
                    @if($metrics['overdue_amount'] > 0)
                    <tr class="table-warning">
                        <td><strong>المبلغ المتأخر:</strong></td>
                        <td class="text-end">
                            <strong class="text-danger">{{ number_format($metrics['overdue_amount'], 2) }} ر.س</strong>
                        </td>
                    </tr>
                    @endif
                </table>
                
                @if($supplier->exceedsCreditLimit())
                <div class="alert alert-danger alert-sm">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    <strong>تحذير:</strong> المورد تجاوز حد الائتمان المسموح
                </div>
                @endif
            </div>
        </div>
        
        <!-- إحصائيات الأداء -->
        <div class="card mb-4">
            <div class="card-header bg-light">
                <h6 class="card-title mb-0">
                    <i class="fas fa-chart-pie me-2"></i>
                    إحصائيات الأداء
                </h6>
            </div>
            <div class="card-body">
                <div class="row text-center">
                    <div class="col-4">
                        <div class="h6 mb-0 text-primary">{{ $metrics['total_invoices'] }}</div>
                        <small class="text-muted">إجمالي الفواتير</small>
                    </div>
                    <div class="col-4">
                        <div class="h6 mb-0 text-success">{{ $metrics['paid_invoices'] }}</div>
                        <small class="text-muted">مدفوعة</small>
                    </div>
                    <div class="col-4">
                        <div class="h6 mb-0 text-danger">{{ $metrics['overdue_invoices'] }}</div>
                        <small class="text-muted">متأخرة</small>
                    </div>
                </div>
                
                <hr>
                
                <div class="mb-3">
                    <div class="d-flex justify-content-between mb-1">
                        <small>معدل السداد</small>
                        <small>{{ number_format($metrics['payment_rate'], 1) }}%</small>
                    </div>
                    <div class="progress" style="height: 6px;">
                        <div class="progress-bar bg-{{ $metrics['payment_rate'] >= 80 ? 'success' : ($metrics['payment_rate'] >= 60 ? 'warning' : 'danger') }}" 
                             style="width: {{ $metrics['payment_rate'] }}%"></div>
                    </div>
                </div>
                
                <table class="table table-borderless table-sm">
                    <tr>
                        <td>متوسط أيام السداد:</td>
                        <td class="text-end">{{ number_format($metrics['average_payment_days'], 0) }} يوم</td>
                    </tr>
                    <tr>
                        <td>شروط الدفع:</td>
                        <td class="text-end">{{ $supplier->payment_terms ?? 'غير محدد' }}</td>
                    </tr>
                </table>
            </div>
        </div>
        
        <!-- معلومات إضافية -->
        <div class="card">
            <div class="card-header bg-light">
                <h6 class="card-title mb-0">
                    <i class="fas fa-info-circle me-2"></i>
                    معلومات إضافية
                </h6>
            </div>
            <div class="card-body">
                <table class="table table-borderless table-sm">
                    <tr>
                        <td>تاريخ الإنشاء:</td>
                        <td class="text-end">{{ $supplier->created_at->format('d/m/Y') }}</td>
                    </tr>
                    <tr>
                        <td>آخر تحديث:</td>
                        <td class="text-end">{{ $supplier->updated_at->format('d/m/Y H:i') }}</td>
                    </tr>
                    @if($supplier->payment_terms_days)
                    <tr>
                        <td>أيام الدفع:</td>
                        <td class="text-end">{{ $supplier->payment_terms_days }} يوم</td>
                    </tr>
                    @endif
                    @if($supplier->payment_method)
                    <tr>
                        <td>طريقة الدفع المفضلة:</td>
                        <td class="text-end">
                            @switch($supplier->payment_method)
                                @case('cash') نقداً @break
                                @case('credit') آجل @break
                                @case('bank_transfer') تحويل بنكي @break
                                @case('check') شيك @break
                                @default {{ $supplier->payment_method }}
                            @endswitch
                        </td>
                    </tr>
                    @endif
                </table>
                
                <div class="d-grid gap-2 mt-3">
                    <a href="{{ route('purchase-invoices.create', ['supplier_id' => $supplier->id]) }}" class="btn btn-primary btn-sm">
                        <i class="fas fa-plus me-2"></i>
                        فاتورة شراء جديدة
                    </a>
                    
                    @if($supplier->current_balance > 0)
                    <a href="{{ route('suppliers.payments.create', ['supplier_id' => $supplier->id]) }}" class="btn btn-success btn-sm">
                        <i class="fas fa-money-bill-wave me-2"></i>
                        دفعة جديدة
                    </a>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    function toggleSupplierStatus() {
        const isActive = {{ $supplier->is_active ? 'true' : 'false' }};
        const action = isActive ? 'إلغاء التفعيل' : 'تفعيل';
        
        if (confirm(`هل تريد ${action} هذا المورد؟`)) {
            fetch(`/suppliers/{{ $supplier->id }}/toggle-status`, {
                method: 'PATCH',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    location.reload();
                } else {
                    alert('حدث خطأ في تغيير حالة المورد');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('حدث خطأ في تغيير حالة المورد');
            });
        }
    }
</script>
@endpush

@push('styles')
<style>
    .alert-sm {
        padding: 0.5rem 0.75rem;
        font-size: 0.875rem;
    }
    
    .progress {
        background-color: #e9ecef;
    }
    
    .table th,
    .table td {
        font-size: 0.875rem;
    }
    
    .border-bottom:last-child {
        border-bottom: none !important;
    }
</style>
@endpush