@extends('layouts.app')

@section('title', 'تفاصيل الدفعة')
@section('page-title', 'تفاصيل الدفعة #' . $payment->id)

@section('page-actions')
    <div class="btn-group" role="group">
        @if($payment->canBeDeleted())
            <button type="button" class="btn btn-danger" onclick="deletePayment()">
                <i class="fas fa-trash me-2"></i>
                حذف الدفعة
            </button>
        @endif
        
        <a href="{{ route('suppliers.payments.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-right me-2"></i>
            العودة للقائمة
        </a>
        
        <button type="button" class="btn btn-primary" onclick="printPayment()">
            <i class="fas fa-print me-2"></i>
            طباعة
        </button>
    </div>
@endsection

@section('content')
<div class="row">
    <!-- معلومات الدفعة -->
    <div class="col-lg-8 mb-4">
        <div class="card">
            <div class="card-header bg-light">
                <h6 class="card-title mb-0">
                    <i class="fas fa-money-bill-wave me-2"></i>
                    معلومات الدفعة
                </h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <tr>
                                <td><strong>رقم الدفعة:</strong></td>
                                <td>#{{ $payment->id }}</td>
                            </tr>
                            @if($payment->voucher_number)
                            <tr>
                                <td><strong>رقم السند:</strong></td>
                                <td>{{ $payment->voucher_number }}</td>
                            </tr>
                            @endif
                            <tr>
                                <td><strong>المورد:</strong></td>
                                <td>
                                    @if($payment->supplier)
                                        <a href="{{ route('suppliers.show', $payment->supplier) }}" class="text-decoration-none">
                                            {{ $payment->supplier->name }}
                                        </a>
                                    @else
                                        {{ $payment->supplier_name }}
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <td><strong>تاريخ الدفعة:</strong></td>
                                <td>{{ $payment->payment_date->format('d/m/Y') }}</td>
                            </tr>
                            <tr>
                                <td><strong>المبلغ:</strong></td>
                                <td>
                                    <strong class="text-success">{{ number_format($payment->amount, 2) }} ر.س</strong>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <tr>
                                <td><strong>طريقة الدفع:</strong></td>
                                <td>
                                    @switch($payment->payment_method)
                                        @case('cash')
                                            <span class="badge bg-success">نقداً</span>
                                            @break
                                        @case('bank_transfer')
                                            <span class="badge bg-primary">تحويل بنكي</span>
                                            @break
                                        @case('check')
                                            <span class="badge bg-info">شيك</span>
                                            @break
                                        @case('credit_card')
                                            <span class="badge bg-warning">بطاقة ائتمان</span>
                                            @break
                                        @default
                                            <span class="badge bg-secondary">{{ $payment->payment_method }}</span>
                                    @endswitch
                                </td>
                            </tr>
                            @if($payment->bankAccount)
                            <tr>
                                <td><strong>الحساب البنكي:</strong></td>
                                <td>{{ $payment->bankAccount->bank_name }} - {{ $payment->bankAccount->account_number }}</td>
                            </tr>
                            @endif
                            @if($payment->check_number)
                            <tr>
                                <td><strong>رقم الشيك:</strong></td>
                                <td>{{ $payment->check_number }}</td>
                            </tr>
                            @endif
                            @if($payment->check_date)
                            <tr>
                                <td><strong>تاريخ الشيك:</strong></td>
                                <td>{{ $payment->check_date->format('d/m/Y') }}</td>
                            </tr>
                            @endif
                            @if($payment->reference)
                            <tr>
                                <td><strong>المرجع:</strong></td>
                                <td>{{ $payment->reference }}</td>
                            </tr>
                            @endif
                            <tr>
                                <td><strong>المستخدم:</strong></td>
                                <td>{{ $payment->user->name ?? 'غير محدد' }}</td>
                            </tr>
                        </table>
                    </div>
                </div>
                
                @if($payment->description)
                <div class="row mt-3">
                    <div class="col-12">
                        <strong>الوصف:</strong>
                        <p class="mb-0">{{ $payment->description }}</p>
                    </div>
                </div>
                @endif
                
                @if($payment->notes)
                <div class="row mt-3">
                    <div class="col-12">
                        <strong>ملاحظات:</strong>
                        <p class="mb-0">{{ $payment->notes }}</p>
                    </div>
                </div>
                @endif
            </div>
        </div>
        
        <!-- توزيع الدفعة على الفواتير -->
        @if($allocatedInvoices->count() > 0)
        <div class="card mt-4">
            <div class="card-header bg-light">
                <h6 class="card-title mb-0">
                    <i class="fas fa-file-invoice-dollar me-2"></i>
                    توزيع الدفعة على الفواتير
                </h6>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>رقم الفاتورة</th>
                                <th>تاريخ الفاتورة</th>
                                <th>تاريخ الاستحقاق</th>
                                <th class="text-center">مبلغ الفاتورة</th>
                                <th class="text-center">المبلغ المخصص</th>
                                <th class="text-center">النسبة</th>
                                <th class="text-center">المتبقي</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($allocatedInvoices as $allocation)
                            @php
                                $invoice = $allocation->purchaseInvoice;
                                $percentage = ($allocation->allocated_amount / $invoice->total_amount) * 100;
                            @endphp
                            <tr>
                                <td>
                                    <a href="{{ route('purchase-invoices.show', $invoice) }}" class="text-decoration-none">
                                        <strong>{{ $invoice->invoice_number }}</strong>
                                    </a>
                                    @if($invoice->supplier_invoice_number)
                                        <br><small class="text-muted">{{ $invoice->supplier_invoice_number }}</small>
                                    @endif
                                </td>
                                <td>{{ $invoice->invoice_date->format('d/m/Y') }}</td>
                                <td>
                                    {{ $invoice->due_date->format('d/m/Y') }}
                                    @if($invoice->is_overdue)
                                        <br><small class="text-danger">متأخر {{ $invoice->days_overdue }} يوم</small>
                                    @endif
                                </td>
                                <td class="text-center">
                                    {{ number_format($invoice->total_amount, 2) }} ر.س
                                </td>
                                <td class="text-center">
                                    <strong class="text-success">{{ number_format($allocation->allocated_amount, 2) }} ر.س</strong>
                                </td>
                                <td class="text-center">
                                    <div class="d-flex align-items-center justify-content-center">
                                        <div class="progress me-2" style="width: 60px; height: 8px;">
                                            <div class="progress-bar bg-success" style="width: {{ $percentage }}%"></div>
                                        </div>
                                        <span class="small">{{ number_format($percentage, 1) }}%</span>
                                    </div>
                                </td>
                                <td class="text-center">
                                    <span class="text-{{ $invoice->remaining_amount > 0 ? 'danger' : 'success' }}">
                                        {{ number_format($invoice->remaining_amount, 2) }} ر.س
                                    </span>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                        <tfoot class="table-light">
                            <tr>
                                <th colspan="4" class="text-end">إجمالي المبلغ المخصص:</th>
                                <th class="text-center">
                                    <strong class="text-primary">{{ number_format($allocatedInvoices->sum('allocated_amount'), 2) }} ر.س</strong>
                                </th>
                                <th colspan="2"></th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
        @endif
    </div>
    
    <!-- معلومات المورد وإحصائيات -->
    <div class="col-lg-4">
        <!-- معلومات المورد -->
        @if($payment->supplier)
        <div class="card mb-4">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-user-tie me-2"></i>
                    معلومات المورد
                </h6>
            </div>
            <div class="card-body">
                <div class="text-center mb-3">
                    <h6>{{ $payment->supplier->name }}</h6>
                    @if($payment->supplier->name_en)
                        <small class="text-muted">{{ $payment->supplier->name_en }}</small>
                    @endif
                </div>
                
                <table class="table table-borderless table-sm">
                    @if($payment->supplier->contact_person)
                    <tr>
                        <td><i class="fas fa-user me-2"></i></td>
                        <td>{{ $payment->supplier->contact_person }}</td>
                    </tr>
                    @endif
                    @if($payment->supplier->email)
                    <tr>
                        <td><i class="fas fa-envelope me-2"></i></td>
                        <td>{{ $payment->supplier->email }}</td>
                    </tr>
                    @endif
                    @if($payment->supplier->phone)
                    <tr>
                        <td><i class="fas fa-phone me-2"></i></td>
                        <td>{{ $payment->supplier->phone }}</td>
                    </tr>
                    @endif
                    <tr>
                        <td><i class="fas fa-credit-card me-2"></i></td>
                        <td>
                            <strong class="text-{{ $payment->supplier->current_balance > 0 ? 'danger' : 'success' }}">
                                {{ number_format($payment->supplier->current_balance, 2) }} ر.س
                            </strong>
                            <br><small class="text-muted">الرصيد الحالي</small>
                        </td>
                    </tr>
                </table>
                
                <div class="d-grid">
                    <a href="{{ route('suppliers.show', $payment->supplier) }}" class="btn btn-outline-primary btn-sm">
                        <i class="fas fa-eye me-2"></i>
                        عرض ملف المورد
                    </a>
                </div>
            </div>
        </div>
        @endif
        
        <!-- تفاصيل الدفعة -->
        <div class="card mb-4">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-info-circle me-2"></i>
                    تفاصيل الدفعة
                </h6>
            </div>
            <div class="card-body">
                <div class="row text-center">
                    <div class="col-6">
                        <div class="h6 mb-0 text-success">{{ number_format($payment->amount, 2) }}</div>
                        <small class="text-muted">مبلغ الدفعة (ر.س)</small>
                    </div>
                    <div class="col-6">
                        <div class="h6 mb-0 text-primary">{{ $allocatedInvoices->count() }}</div>
                        <small class="text-muted">عدد الفواتير</small>
                    </div>
                </div>
                
                @if($allocatedInvoices->count() > 0)
                <hr>
                <div class="row text-center">
                    <div class="col-6">
                        <div class="h6 mb-0 text-info">{{ number_format($allocatedInvoices->sum('allocated_amount'), 2) }}</div>
                        <small class="text-muted">المبلغ المخصص (ر.س)</small>
                    </div>
                    <div class="col-6">
                        <div class="h6 mb-0 text-warning">{{ number_format($payment->amount - $allocatedInvoices->sum('allocated_amount'), 2) }}</div>
                        <small class="text-muted">غير مخصص (ر.س)</small>
                    </div>
                </div>
                @endif
                
                <hr>
                <div class="text-center">
                    <small class="text-muted">
                        <i class="fas fa-calendar me-1"></i>
                        تم إنشاؤها في {{ $payment->created_at->format('d/m/Y H:i') }}
                    </small>
                    
                    @if($payment->canBeDeleted())
                        <br><small class="text-warning">
                            <i class="fas fa-clock me-1"></i>
                            يمكن الحذف خلال {{ 24 - $payment->created_at->diffInHours(now()) }} ساعة
                        </small>
                    @endif
                </div>
            </div>
        </div>
        
        <!-- إجراءات سريعة -->
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-bolt me-2"></i>
                    إجراءات سريعة
                </h6>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    @if($payment->supplier)
                    <a href="{{ route('suppliers.payments.supplier-report', $payment->supplier) }}" class="btn btn-outline-info btn-sm">
                        <i class="fas fa-chart-line me-2"></i>
                        تقرير مدفوعات المورد
                    </a>
                    
                    <a href="{{ route('suppliers.analytics.statement', $payment->supplier) }}" class="btn btn-outline-primary btn-sm">
                        <i class="fas fa-file-invoice me-2"></i>
                        كشف حساب المورد
                    </a>
                    
                    @if($payment->supplier->current_balance > 0)
                    <a href="{{ route('suppliers.payments.create', ['supplier_id' => $payment->supplier->id]) }}" class="btn btn-outline-success btn-sm">
                        <i class="fas fa-plus me-2"></i>
                        دفعة جديدة لنفس المورد
                    </a>
                    @endif
                    @endif
                    
                    <a href="{{ route('suppliers.payments.create') }}" class="btn btn-outline-warning btn-sm">
                        <i class="fas fa-money-bill-wave me-2"></i>
                        دفعة جديدة
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    function deletePayment() {
        if (confirm('هل تريد حذف هذه الدفعة؟ لا يمكن التراجع عن هذا الإجراء.')) {
            fetch(`/suppliers/payments/{{ $payment->id }}`, {
                method: 'DELETE',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    window.location.href = '{{ route("suppliers.payments.index") }}';
                } else {
                    alert('حدث خطأ في حذف الدفعة: ' + (data.message || 'خطأ غير معروف'));
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('حدث خطأ في حذف الدفعة');
            });
        }
    }
    
    function printPayment() {
        window.print();
    }
</script>
@endpush

@push('styles')
<style>
    @media print {
        .btn, .card-header .card-tools {
            display: none !important;
        }
        
        .card {
            border: 1px solid #dee2e6 !important;
            box-shadow: none !important;
        }
        
        .table th,
        .table td {
            border: 1px solid #dee2e6 !important;
        }
        
        .page-break {
            page-break-before: always;
        }
    }
    
    .progress {
        background-color: #e9ecef;
    }
    
    .table th {
        font-weight: 600;
        font-size: 0.875rem;
    }
    
    .table td {
        font-size: 0.875rem;
    }
</style>
@endpush