@extends('layouts.app')

@section('title', 'مدفوعات الموردين')
@section('page-title', 'مدفوعات الموردين')

@section('page-actions')
    <div class="btn-group" role="group">
        <a href="{{ route('suppliers.payments.create') }}" class="btn btn-primary">
            <i class="fas fa-plus me-2"></i>
            دفعة جديدة
        </a>
        <a href="{{ route('suppliers.payments.analysis') }}" class="btn btn-info">
            <i class="fas fa-chart-bar me-2"></i>
            تحليل المدفوعات
        </a>
        <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#filterModal">
            <i class="fas fa-filter me-2"></i>
            فلترة متقدمة
        </button>
        <div class="btn-group" role="group">
            <button type="button" class="btn btn-outline-secondary dropdown-toggle" data-bs-toggle="dropdown">
                <i class="fas fa-download me-2"></i>
                تصدير
            </button>
            <ul class="dropdown-menu">
                <li><a class="dropdown-item" href="#" onclick="exportReport('excel')">
                    <i class="fas fa-file-excel me-2"></i>Excel
                </a></li>
                <li><a class="dropdown-item" href="#" onclick="exportReport('pdf')">
                    <i class="fas fa-file-pdf me-2"></i>PDF
                </a></li>
            </ul>
        </div>
    </div>
@endsection

@section('content')
<!-- إحصائيات سريعة -->
<div class="row mb-4">
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card text-white bg-primary">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <i class="fas fa-money-bill-wave fa-2x"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <div class="card-title h5 mb-1">{{ number_format($stats['total_payments']) }}</div>
                        <div class="card-text small">إجمالي المدفوعات</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card text-white bg-success">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <i class="fas fa-chart-line fa-2x"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <div class="card-title h5 mb-1">{{ number_format($stats['total_amount'], 0) }}</div>
                        <div class="card-text small">إجمالي المبالغ (ر.س)</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card text-white bg-info">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <i class="fas fa-calendar-month fa-2x"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <div class="card-title h5 mb-1">{{ number_format($stats['this_month_payments'], 0) }}</div>
                        <div class="card-text small">مدفوعات هذا الشهر (ر.س)</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card text-white bg-warning">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <i class="fas fa-exclamation-triangle fa-2x"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <div class="card-title h5 mb-1">{{ number_format($stats['pending_payments'], 0) }}</div>
                        <div class="card-text small">مدفوعات معلقة (ر.س)</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- فلاتر سريعة -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <form method="GET" action="{{ route('suppliers.payments.index') }}" class="row align-items-center">
                    <div class="col-md-3 mb-2">
                        <select name="supplier_id" class="form-select" onchange="this.form.submit()">
                            <option value="">جميع الموردين</option>
                            @foreach($suppliers as $supplier)
                                <option value="{{ $supplier->id }}" {{ request('supplier_id') == $supplier->id ? 'selected' : '' }}>
                                    {{ $supplier->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3 mb-2">
                        <select name="payment_method" class="form-select" onchange="this.form.submit()">
                            <option value="">جميع طرق الدفع</option>
                            <option value="cash" {{ request('payment_method') === 'cash' ? 'selected' : '' }}>نقداً</option>
                            <option value="bank_transfer" {{ request('payment_method') === 'bank_transfer' ? 'selected' : '' }}>تحويل بنكي</option>
                            <option value="check" {{ request('payment_method') === 'check' ? 'selected' : '' }}>شيك</option>
                            <option value="credit_card" {{ request('payment_method') === 'credit_card' ? 'selected' : '' }}>بطاقة ائتمان</option>
                        </select>
                    </div>
                    <div class="col-md-3 mb-2">
                        <input type="date" name="date_from" class="form-control" placeholder="من تاريخ" 
                               value="{{ request('date_from') }}" onchange="this.form.submit()">
                    </div>
                    <div class="col-md-3 mb-2">
                        <div class="input-group">
                            <input type="text" name="search" class="form-control" placeholder="البحث..." 
                                   value="{{ request('search') }}">
                            <button type="submit" class="btn btn-outline-primary">
                                <i class="fas fa-search"></i>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- جدول المدفوعات -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-table me-2"></i>
                    سجل المدفوعات
                </h6>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>رقم الدفعة</th>
                                <th>المورد</th>
                                <th>تاريخ الدفعة</th>
                                <th class="text-center">المبلغ</th>
                                <th class="text-center">طريقة الدفع</th>
                                <th>الوصف</th>
                                <th>المرجع</th>
                                <th class="text-center">الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($payments as $payment)
                            <tr>
                                <td>
                                    <strong>#{{ $payment->id }}</strong>
                                    <br><small class="text-muted">{{ $payment->created_at->format('d/m/Y H:i') }}</small>
                                </td>
                                <td>
                                    @if($payment->supplier)
                                        <a href="{{ route('suppliers.show', $payment->supplier) }}" class="text-decoration-none">
                                            {{ $payment->supplier->name }}
                                        </a>
                                    @else
                                        {{ $payment->supplier_name }}
                                    @endif
                                </td>
                                <td>{{ $payment->payment_date->format('d/m/Y') }}</td>
                                <td class="text-center">
                                    <strong class="text-success">{{ number_format($payment->amount, 2) }} ر.س</strong>
                                </td>
                                <td class="text-center">
                                    @switch($payment->payment_method)
                                        @case('cash')
                                            <span class="badge bg-success">نقداً</span>
                                            @break
                                        @case('bank_transfer')
                                            <span class="badge bg-primary">تحويل بنكي</span>
                                            @break
                                        @case('check')
                                            <span class="badge bg-info">شيك</span>
                                            @break
                                        @case('credit_card')
                                            <span class="badge bg-warning">بطاقة ائتمان</span>
                                            @break
                                        @default
                                            <span class="badge bg-secondary">{{ $payment->payment_method }}</span>
                                    @endswitch
                                </td>
                                <td>
                                    {{ $payment->description }}
                                    @if($payment->notes)
                                        <br><small class="text-muted">{{ Str::limit($payment->notes, 50) }}</small>
                                    @endif
                                </td>
                                <td>
                                    {{ $payment->reference ?? '-' }}
                                    @if($payment->check_number)
                                        <br><small class="text-info">شيك: {{ $payment->check_number }}</small>
                                    @endif
                                </td>
                                <td class="text-center">
                                    <div class="btn-group btn-group-sm" role="group">
                                        <a href="{{ route('suppliers.payments.show', $payment) }}" 
                                           class="btn btn-outline-info" title="عرض التفاصيل">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        
                                        @if($payment->supplier)
                                        <a href="{{ route('suppliers.payments.supplier-report', $payment->supplier) }}" 
                                           class="btn btn-outline-primary" title="تقرير المورد">
                                            <i class="fas fa-chart-line"></i>
                                        </a>
                                        @endif
                                        
                                        @if($payment->created_at->diffInHours(now()) <= 24)
                                        <button type="button" class="btn btn-outline-danger" 
                                                onclick="deletePayment({{ $payment->id }})" title="حذف">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="8" class="text-center py-4">
                                    <div class="text-muted">
                                        <i class="fas fa-info-circle fa-2x mb-3"></i>
                                        <p>لا توجد مدفوعات</p>
                                        <a href="{{ route('suppliers.payments.create') }}" class="btn btn-primary">
                                            <i class="fas fa-plus me-2"></i>
                                            إضافة دفعة جديدة
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
            
            @if($payments->hasPages())
            <div class="card-footer">
                <div class="d-flex justify-content-center">
                    {{ $payments->links() }}
                </div>
            </div>
            @endif
        </div>
    </div>
</div>

<!-- إحصائيات إضافية -->
@if($payments->count() > 0)
<div class="row mt-4">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-chart-pie me-2"></i>
                    المدفوعات حسب الطريقة
                </h6>
            </div>
            <div class="card-body">
                <canvas id="paymentMethodChart" style="height: 250px;"></canvas>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-users me-2"></i>
                    أكبر الموردين من حيث المدفوعات
                </h6>
            </div>
            <div class="card-body">
                @php
                    $topSuppliers = $payments->whereNotNull('supplier_id')
                        ->groupBy('supplier_id')
                        ->map(function($group) {
                            return [
                                'supplier' => $group->first()->supplier,
                                'total' => $group->sum('amount'),
                                'count' => $group->count()
                            ];
                        })->sortByDesc('total')->take(5);
                @endphp
                
                <div class="list-group list-group-flush">
                    @foreach($topSuppliers as $data)
                    <div class="list-group-item d-flex justify-content-between align-items-center px-0">
                        <div>
                            <strong>{{ $data['supplier']->name }}</strong>
                            <br><small class="text-muted">{{ $data['count'] }} دفعة</small>
                        </div>
                        <div class="text-end">
                            <strong class="text-success">{{ number_format($data['total'], 0) }} ر.س</strong>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
@endif
@endsection

<!-- مودال الفلترة المتقدمة -->
<div class="modal fade" id="filterModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form method="GET" action="{{ route('suppliers.payments.index') }}">
                <div class="modal-header">
                    <h5 class="modal-title">فلترة متقدمة</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="date_from" class="form-label">من تاريخ</label>
                                <input type="date" class="form-control" id="date_from" name="date_from" 
                                       value="{{ request('date_from') }}">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="date_to" class="form-label">إلى تاريخ</label>
                                <input type="date" class="form-control" id="date_to" name="date_to" 
                                       value="{{ request('date_to') }}">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="amount_from" class="form-label">من مبلغ (ر.س)</label>
                                <input type="number" class="form-control" id="amount_from" name="amount_from" 
                                       value="{{ request('amount_from') }}" step="0.01" min="0">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="amount_to" class="form-label">إلى مبلغ (ر.س)</label>
                                <input type="number" class="form-control" id="amount_to" name="amount_to" 
                                       value="{{ request('amount_to') }}" step="0.01" min="0">
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="mb-3">
                                <label for="notes_search" class="form-label">البحث في الملاحظات</label>
                                <input type="text" class="form-control" id="notes_search" name="notes_search" 
                                       value="{{ request('notes_search') }}">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <a href="{{ route('suppliers.payments.index') }}" class="btn btn-outline-warning">إعادة تعيين</a>
                    <button type="submit" class="btn btn-primary">تطبيق الفلتر</button>
                </div>
            </form>
        </div>
    </div>
</div>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    @if($payments->count() > 0)
    // رسم بياني لطرق الدفع
    const paymentMethods = @json($payments->groupBy('payment_method')->map->count());
    
    const methodCtx = document.getElementById('paymentMethodChart').getContext('2d');
    new Chart(methodCtx, {
        type: 'doughnut',
        data: {
            labels: Object.keys(paymentMethods).map(method => {
                const labels = {
                    'cash': 'نقداً',
                    'bank_transfer': 'تحويل بنكي',
                    'check': 'شيك',
                    'credit_card': 'بطاقة ائتمان'
                };
                return labels[method] || method;
            }),
            datasets: [{
                data: Object.values(paymentMethods),
                backgroundColor: [
                    'rgb(40, 167, 69)',
                    'rgb(54, 162, 235)',
                    'rgb(255, 193, 7)',
                    'rgb(220, 53, 69)'
                ]
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom'
                }
            }
        }
    });
    @endif
    
    function deletePayment(paymentId) {
        if (confirm('هل تريد حذف هذه الدفعة؟ لا يمكن التراجع عن هذا الإجراء.')) {
            fetch(`/suppliers/payments/${paymentId}`, {
                method: 'DELETE',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    location.reload();
                } else {
                    alert('حدث خطأ في حذف الدفعة: ' + (data.message || 'خطأ غير معروف'));
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('حدث خطأ في حذف الدفعة');
            });
        }
    }
    
    function exportReport(format) {
        const params = new URLSearchParams(window.location.search);
        params.set('format', format);
        
        window.open(`{{ route('suppliers.payments.index') }}?${params}&export=1`, '_blank');
    }
</script>
@endpush

@push('styles')
<style>
    .list-group-item {
        border-left: none;
        border-right: none;
    }
    
    .list-group-item:first-child {
        border-top: none;
    }
    
    .list-group-item:last-child {
        border-bottom: none;
    }
</style>
@endpush