@extends('layouts.app')

@section('title', 'إدارة الموردين')
@section('page-title', 'إدارة الموردين')

@section('page-actions')
    <div class="btn-group" role="group">
        <a href="{{ route('suppliers.create') }}" class="btn btn-primary">
            <i class="fas fa-plus me-2"></i>
            مورد جديد
        </a>
        <a href="{{ route('suppliers.analytics.dashboard') }}" class="btn btn-info">
            <i class="fas fa-chart-line me-2"></i>
            التحليلات
        </a>
        <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#filterModal">
            <i class="fas fa-filter me-2"></i>
            فلترة متقدمة
        </button>
        <div class="btn-group" role="group">
            <button type="button" class="btn btn-outline-secondary dropdown-toggle" data-bs-toggle="dropdown">
                <i class="fas fa-download me-2"></i>
                تصدير
            </button>
            <ul class="dropdown-menu">
                <li><a class="dropdown-item" href="{{ route('suppliers.export', request()->query()) }}">
                    <i class="fas fa-file-excel me-2"></i>Excel
                </a></li>
                <li><a class="dropdown-item" href="#" onclick="exportReport('pdf')">
                    <i class="fas fa-file-pdf me-2"></i>PDF
                </a></li>
            </ul>
        </div>
    </div>
@endsection

@section('content')
<!-- إحصائيات سريعة -->
<div class="row mb-4">
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card text-white bg-primary">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <i class="fas fa-users fa-2x"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <div class="card-title h5 mb-1">{{ number_format($stats['total_suppliers']) }}</div>
                        <div class="card-text small">إجمالي الموردين</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card text-white bg-success">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <i class="fas fa-user-check fa-2x"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <div class="card-title h5 mb-1">{{ number_format($stats['active_suppliers']) }}</div>
                        <div class="card-text small">موردين نشطين</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card text-white bg-warning">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <i class="fas fa-exclamation-triangle fa-2x"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <div class="card-title h5 mb-1">{{ number_format($stats['high_risk_suppliers']) }}</div>
                        <div class="card-text small">موردين عالي المخاطر</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card text-white bg-danger">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <i class="fas fa-money-bill-wave fa-2x"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <div class="card-title h5 mb-1">{{ number_format($stats['total_outstanding'], 0) }}</div>
                        <div class="card-text small">إجمالي المديونية (ر.س)</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- فلاتر سريعة -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <form method="GET" action="{{ route('suppliers.index') }}" class="row align-items-center">
                    <div class="col-md-2 mb-2">
                        <select name="status" class="form-select" onchange="this.form.submit()">
                            <option value="">جميع الحالات</option>
                            <option value="active" {{ request('status') === 'active' ? 'selected' : '' }}>نشط</option>
                            <option value="inactive" {{ request('status') === 'inactive' ? 'selected' : '' }}>غير نشط</option>
                        </select>
                    </div>
                    <div class="col-md-2 mb-2">
                        <select name="risk_level" class="form-select" onchange="this.form.submit()">
                            <option value="">جميع المخاطر</option>
                            <option value="low" {{ request('risk_level') === 'low' ? 'selected' : '' }}>منخفض</option>
                            <option value="medium" {{ request('risk_level') === 'medium' ? 'selected' : '' }}>متوسط</option>
                            <option value="high" {{ request('risk_level') === 'high' ? 'selected' : '' }}>مرتفع</option>
                            <option value="critical" {{ request('risk_level') === 'critical' ? 'selected' : '' }}>حرج</option>
                        </select>
                    </div>
                    <div class="col-md-2 mb-2">
                        <select name="has_balance" class="form-select" onchange="this.form.submit()">
                            <option value="">جميع الأرصدة</option>
                            <option value="1" {{ request('has_balance') === '1' ? 'selected' : '' }}>لديه رصيد</option>
                            <option value="0" {{ request('has_balance') === '0' ? 'selected' : '' }}>لا يوجد رصيد</option>
                        </select>
                    </div>
                    <div class="col-md-2 mb-2">
                        <select name="currency" class="form-select" onchange="this.form.submit()">
                            <option value="">جميع العملات</option>
                            <option value="SAR" {{ request('currency') === 'SAR' ? 'selected' : '' }}>ريال سعودي</option>
                            <option value="USD" {{ request('currency') === 'USD' ? 'selected' : '' }}>دولار</option>
                            <option value="EUR" {{ request('currency') === 'EUR' ? 'selected' : '' }}>يورو</option>
                        </select>
                    </div>
                    <div class="col-md-4 mb-2">
                        <div class="input-group">
                            <input type="text" name="search" class="form-control" placeholder="البحث في الموردين..." 
                                   value="{{ request('search') }}">
                            <button type="submit" class="btn btn-outline-primary">
                                <i class="fas fa-search"></i>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- جدول الموردين -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-table me-2"></i>
                    قائمة الموردين
                </h6>
                <div class="card-tools">
                    <span class="badge bg-secondary">{{ $suppliers->total() }} مورد</span>
                </div>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>
                                    <a href="{{ request()->fullUrlWithQuery(['sort' => 'code', 'direction' => request('direction') === 'asc' ? 'desc' : 'asc']) }}" 
                                       class="text-decoration-none">
                                        الكود <i class="fas fa-sort"></i>
                                    </a>
                                </th>
                                <th>
                                    <a href="{{ request()->fullUrlWithQuery(['sort' => 'name', 'direction' => request('direction') === 'asc' ? 'desc' : 'asc']) }}" 
                                       class="text-decoration-none">
                                        اسم المورد <i class="fas fa-sort"></i>
                                    </a>
                                </th>
                                <th>معلومات الاتصال</th>
                                <th class="text-center">
                                    <a href="{{ request()->fullUrlWithQuery(['sort' => 'current_balance', 'direction' => request('direction') === 'asc' ? 'desc' : 'asc']) }}" 
                                       class="text-decoration-none">
                                        الرصيد الحالي <i class="fas fa-sort"></i>
                                    </a>
                                </th>
                                <th class="text-center">حد الائتمان</th>
                                <th class="text-center">مستوى المخاطر</th>
                                <th class="text-center">الحالة</th>
                                <th class="text-center">آخر معاملة</th>
                                <th class="text-center">الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($suppliers as $supplier)
                            @php
                                $riskLevel = $supplier->getRiskLevelAttribute();
                                $utilization = $supplier->getCreditUtilizationAttribute();
                                $metrics = $supplier->getPerformanceMetrics();
                            @endphp
                            <tr>
                                <td>
                                    <strong>{{ $supplier->code }}</strong>
                                </td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="flex-shrink-0 me-3">
                                            @switch($riskLevel)
                                                @case('critical')
                                                    <i class="fas fa-exclamation-triangle text-danger fa-lg"></i>
                                                    @break
                                                @case('high')
                                                    <i class="fas fa-exclamation text-warning fa-lg"></i>
                                                    @break
                                                @case('medium')
                                                    <i class="fas fa-minus-circle text-info fa-lg"></i>
                                                    @break
                                                @default
                                                    <i class="fas fa-check-circle text-success fa-lg"></i>
                                            @endswitch
                                        </div>
                                        <div class="flex-grow-1">
                                            <a href="{{ route('suppliers.show', $supplier) }}" class="text-decoration-none">
                                                <strong>{{ $supplier->name }}</strong>
                                            </a>
                                            @if($supplier->name_en)
                                                <br><small class="text-muted">{{ $supplier->name_en }}</small>
                                            @endif
                                            @if($supplier->exceedsCreditLimit())
                                                <br><span class="badge bg-danger badge-sm">تجاوز الحد</span>
                                            @endif
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    @if($supplier->contact_person)
                                        <strong>{{ $supplier->contact_person }}</strong><br>
                                    @endif
                                    @if($supplier->email)
                                        <a href="mailto:{{ $supplier->email }}" class="text-decoration-none">
                                            <i class="fas fa-envelope me-1"></i>{{ $supplier->email }}
                                        </a><br>
                                    @endif
                                    @if($supplier->phone)
                                        <a href="tel:{{ $supplier->phone }}" class="text-decoration-none">
                                            <i class="fas fa-phone me-1"></i>{{ $supplier->phone }}
                                        </a>
                                    @endif
                                </td>
                                <td class="text-center">
                                    <strong class="text-{{ $supplier->current_balance > 0 ? 'danger' : 'success' }}">
                                        {{ number_format($supplier->current_balance, 2) }} ر.س
                                    </strong>
                                    @if($supplier->current_balance > 0)
                                        <div class="progress mt-1" style="height: 4px;">
                                            <div class="progress-bar bg-{{ $utilization >= 90 ? 'danger' : ($utilization >= 75 ? 'warning' : 'info') }}" 
                                                 style="width: {{ min(100, $utilization) }}%"></div>
                                        </div>
                                        <small class="text-muted">{{ number_format($utilization, 1) }}%</small>
                                    @endif
                                </td>
                                <td class="text-center">
                                    <strong class="text-primary">{{ number_format($supplier->credit_limit, 0) }} ر.س</strong>
                                    @if($supplier->credit_limit > 0)
                                        <br><small class="text-success">متاح: {{ number_format($supplier->getAvailableCreditAttribute(), 0) }} ر.س</small>
                                    @endif
                                </td>
                                <td class="text-center">
                                    @switch($riskLevel)
                                        @case('critical')
                                            <span class="badge bg-danger">حرج</span>
                                            @break
                                        @case('high')
                                            <span class="badge bg-warning">مرتفع</span>
                                            @break
                                        @case('medium')
                                            <span class="badge bg-info">متوسط</span>
                                            @break
                                        @default
                                            <span class="badge bg-success">منخفض</span>
                                    @endswitch
                                </td>
                                <td class="text-center">
                                    <span class="badge bg-{{ $supplier->is_active ? 'success' : 'secondary' }}">
                                        {{ $supplier->is_active ? 'نشط' : 'غير نشط' }}
                                    </span>
                                </td>
                                <td class="text-center">
                                    @php
                                        $lastInvoice = $supplier->purchaseInvoices()->latest()->first();
                                        $lastPayment = $supplier->paymentVouchers()->latest()->first();
                                        $lastTransaction = null;
                                        
                                        if ($lastInvoice && $lastPayment) {
                                            $lastTransaction = $lastInvoice->created_at > $lastPayment->created_at ? $lastInvoice : $lastPayment;
                                        } elseif ($lastInvoice) {
                                            $lastTransaction = $lastInvoice;
                                        } elseif ($lastPayment) {
                                            $lastTransaction = $lastPayment;
                                        }
                                    @endphp
                                    
                                    @if($lastTransaction)
                                        <small>{{ $lastTransaction->created_at->diffForHumans() }}</small>
                                        <br>
                                        @if($lastTransaction instanceof App\Models\PurchaseInvoice)
                                            <span class="badge bg-info badge-sm">فاتورة</span>
                                        @else
                                            <span class="badge bg-success badge-sm">دفعة</span>
                                        @endif
                                    @else
                                        <small class="text-muted">لا توجد معاملات</small>
                                    @endif
                                </td>
                                <td class="text-center">
                                    <div class="btn-group btn-group-sm" role="group">
                                        <a href="{{ route('suppliers.show', $supplier) }}" 
                                           class="btn btn-outline-info" title="عرض">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        
                                        <a href="{{ route('suppliers.edit', $supplier) }}" 
                                           class="btn btn-outline-warning" title="تعديل">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        
                                        @if($supplier->current_balance > 0)
                                            <a href="{{ route('suppliers.payments.create', ['supplier_id' => $supplier->id]) }}" 
                                               class="btn btn-outline-success" title="إضافة دفعة">
                                                <i class="fas fa-money-bill-wave"></i>
                                            </a>
                                        @endif
                                        
                                        <a href="{{ route('purchase-invoices.create', ['supplier_id' => $supplier->id]) }}" 
                                           class="btn btn-outline-primary" title="فاتورة جديدة">
                                            <i class="fas fa-file-invoice"></i>
                                        </a>
                                        
                                        <button type="button" class="btn btn-outline-{{ $supplier->is_active ? 'secondary' : 'success' }}" 
                                                onclick="toggleSupplierStatus({{ $supplier->id }}, {{ $supplier->is_active ? 'false' : 'true' }})"
                                                title="{{ $supplier->is_active ? 'إلغاء التفعيل' : 'تفعيل' }}">
                                            <i class="fas fa-{{ $supplier->is_active ? 'pause' : 'play' }}"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="9" class="text-center py-5">
                                    <div class="text-muted">
                                        <i class="fas fa-inbox fa-3x mb-3"></i>
                                        <h5>لا توجد موردين</h5>
                                        <p>لم يتم العثور على موردين يطابقون معايير البحث</p>
                                        <a href="{{ route('suppliers.create') }}" class="btn btn-primary">
                                            <i class="fas fa-plus me-2"></i>
                                            إضافة مورد جديد
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
            
            @if($suppliers->hasPages())
            <div class="card-footer">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="text-muted">
                        عرض {{ $suppliers->firstItem() }} إلى {{ $suppliers->lastItem() }} 
                        من أصل {{ $suppliers->total() }} مورد
                    </div>
                    <div>
                        {{ $suppliers->links() }}
                    </div>
                </div>
            </div>
            @endif
        </div>
    </div>
</div>
@endsection

<!-- مودال الفلترة المتقدمة -->
<div class="modal fade" id="filterModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form method="GET" action="{{ route('suppliers.index') }}">
                <div class="modal-header">
                    <h5 class="modal-title">فلترة متقدمة</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="credit_limit_from" class="form-label">حد الائتمان من (ر.س)</label>
                                <input type="number" class="form-control" id="credit_limit_from" name="credit_limit_from" 
                                       value="{{ request('credit_limit_from') }}" step="0.01" min="0">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="credit_limit_to" class="form-label">حد الائتمان إلى (ر.س)</label>
                                <input type="number" class="form-control" id="credit_limit_to" name="credit_limit_to" 
                                       value="{{ request('credit_limit_to') }}" step="0.01" min="0">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="balance_from" class="form-label">الرصيد من (ر.س)</label>
                                <input type="number" class="form-control" id="balance_from" name="balance_from" 
                                       value="{{ request('balance_from') }}" step="0.01" min="0">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="balance_to" class="form-label">الرصيد إلى (ر.س)</label>
                                <input type="number" class="form-control" id="balance_to" name="balance_to" 
                                       value="{{ request('balance_to') }}" step="0.01" min="0">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="city" class="form-label">المدينة</label>
                                <input type="text" class="form-control" id="city" name="city" 
                                       value="{{ request('city') }}">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="country" class="form-label">البلد</label>
                                <input type="text" class="form-control" id="country" name="country" 
                                       value="{{ request('country') }}">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <a href="{{ route('suppliers.index') }}" class="btn btn-outline-warning">إعادة تعيين</a>
                    <button type="submit" class="btn btn-primary">تطبيق الفلتر</button>
                </div>
            </form>
        </div>
    </div>
</div>

@push('scripts')
<script>
    function toggleSupplierStatus(supplierId, newStatus) {
        const action = newStatus === 'true' ? 'تفعيل' : 'إلغاء تفعيل';
        
        if (confirm(`هل تريد ${action} هذا المورد؟`)) {
            fetch(`/suppliers/${supplierId}/toggle-status`, {
                method: 'PATCH',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: JSON.stringify({ is_active: newStatus === 'true' })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    location.reload();
                } else {
                    alert('حدث خطأ في تغيير حالة المورد');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('حدث خطأ في تغيير حالة المورد');
            });
        }
    }
    
    function exportReport(format) {
        const params = new URLSearchParams(window.location.search);
        params.set('format', format);
        
        window.open(`{{ route('suppliers.export') }}?${params}`, '_blank');
    }
</script>
@endpush

@push('styles')
<style>
    .badge-sm {
        font-size: 0.7rem;
        padding: 0.25rem 0.4rem;
    }
    
    .progress {
        background-color: #e9ecef;
    }
    
    .table td {
        vertical-align: middle;
    }
    
    .btn-group-sm .btn {
        font-size: 0.75rem;
        padding: 0.25rem 0.5rem;
    }
    
    .card-tools {
        display: flex;
        align-items: center;
    }
    
    @media (max-width: 768px) {
        .table-responsive {
            font-size: 0.875rem;
        }
        
        .btn-group .btn {
            font-size: 0.75rem;
            padding: 0.25rem 0.5rem;
        }
    }
</style>
@endpush