@extends('layouts.app')

@section('title', 'تعديل المورد')
@section('page-title', 'تعديل المورد: ' . $supplier->name)

@section('page-actions')
    <div class="btn-group" role="group">
        <a href="{{ route('suppliers.show', $supplier) }}" class="btn btn-info">
            <i class="fas fa-eye me-2"></i>
            عرض المورد
        </a>
        <a href="{{ route('suppliers.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-right me-2"></i>
            العودة للقائمة
        </a>
    </div>
@endsection

@section('content')
<form method="POST" action="{{ route('suppliers.update', $supplier) }}">
    @csrf
    @method('PUT')
    
    <div class="row">
        <!-- البيانات الأساسية -->
        <div class="col-lg-8">
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-user-tie me-2"></i>
                        البيانات الأساسية
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="code" class="form-label">كود المورد</label>
                                <input type="text" class="form-control @error('code') is-invalid @enderror" 
                                       id="code" name="code" value="{{ old('code', $supplier->code) }}" readonly>
                                <small class="text-muted">لا يمكن تعديل الكود بعد الإنشاء</small>
                                @error('code')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="is_active" class="form-label">الحالة</label>
                                <select class="form-control @error('is_active') is-invalid @enderror" 
                                        id="is_active" name="is_active">
                                    <option value="1" {{ old('is_active', $supplier->is_active) == '1' ? 'selected' : '' }}>نشط</option>
                                    <option value="0" {{ old('is_active', $supplier->is_active) == '0' ? 'selected' : '' }}>غير نشط</option>
                                </select>
                                @error('is_active')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="name" class="form-label">اسم المورد <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('name') is-invalid @enderror" 
                                       id="name" name="name" value="{{ old('name', $supplier->name) }}" required>
                                @error('name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="name_en" class="form-label">الاسم بالإنجليزية</label>
                                <input type="text" class="form-control @error('name_en') is-invalid @enderror" 
                                       id="name_en" name="name_en" value="{{ old('name_en', $supplier->name_en) }}">
                                @error('name_en')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="contact_person" class="form-label">الشخص المسؤول</label>
                                <input type="text" class="form-control @error('contact_person') is-invalid @enderror" 
                                       id="contact_person" name="contact_person" value="{{ old('contact_person', $supplier->contact_person) }}">
                                @error('contact_person')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="email" class="form-label">البريد الإلكتروني</label>
                                <input type="email" class="form-control @error('email') is-invalid @enderror" 
                                       id="email" name="email" value="{{ old('email', $supplier->email) }}">
                                @error('email')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="phone" class="form-label">الهاتف</label>
                                <input type="tel" class="form-control @error('phone') is-invalid @enderror" 
                                       id="phone" name="phone" value="{{ old('phone', $supplier->phone) }}">
                                @error('phone')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="mobile" class="form-label">الجوال</label>
                                <input type="tel" class="form-control @error('mobile') is-invalid @enderror" 
                                       id="mobile" name="mobile" value="{{ old('mobile', $supplier->mobile) }}">
                                @error('mobile')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- بيانات العنوان والمعلومات التجارية -->
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-building me-2"></i>
                        العنوان والمعلومات التجارية
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <div class="mb-3">
                                <label for="address" class="form-label">العنوان</label>
                                <textarea class="form-control @error('address') is-invalid @enderror" 
                                          id="address" name="address" rows="3">{{ old('address', $supplier->address) }}</textarea>
                                @error('address')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="city" class="form-label">المدينة</label>
                                <input type="text" class="form-control @error('city') is-invalid @enderror" 
                                       id="city" name="city" value="{{ old('city', $supplier->city) }}">
                                @error('city')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="country" class="form-label">البلد</label>
                                <input type="text" class="form-control @error('country') is-invalid @enderror" 
                                       id="country" name="country" value="{{ old('country', $supplier->country ?? 'Saudi Arabia') }}">
                                @error('country')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="postal_code" class="form-label">الرمز البريدي</label>
                                <input type="text" class="form-control @error('postal_code') is-invalid @enderror" 
                                       id="postal_code" name="postal_code" value="{{ old('postal_code', $supplier->postal_code) }}">
                                @error('postal_code')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="tax_number" class="form-label">الرقم الضريبي</label>
                                <input type="text" class="form-control @error('tax_number') is-invalid @enderror" 
                                       id="tax_number" name="tax_number" value="{{ old('tax_number', $supplier->tax_number) }}">
                                @error('tax_number')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="commercial_registration" class="form-label">رقم السجل التجاري</label>
                                <input type="text" class="form-control @error('commercial_registration') is-invalid @enderror" 
                                       id="commercial_registration" name="commercial_registration" 
                                       value="{{ old('commercial_registration', $supplier->commercial_registration) }}">
                                @error('commercial_registration')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="currency" class="form-label">العملة</label>
                                <select class="form-control @error('currency') is-invalid @enderror" 
                                        id="currency" name="currency">
                                    <option value="SAR" {{ old('currency', $supplier->currency ?? 'SAR') == 'SAR' ? 'selected' : '' }}>ريال سعودي (SAR)</option>
                                    <option value="USD" {{ old('currency', $supplier->currency) == 'USD' ? 'selected' : '' }}>دولار أمريكي (USD)</option>
                                    <option value="EUR" {{ old('currency', $supplier->currency) == 'EUR' ? 'selected' : '' }}>يورو (EUR)</option>
                                    <option value="AED" {{ old('currency', $supplier->currency) == 'AED' ? 'selected' : '' }}>درهم إماراتي (AED)</option>
                                </select>
                                @error('currency')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- ملاحظات -->
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-sticky-note me-2"></i>
                        ملاحظات
                    </h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label for="notes" class="form-label">ملاحظات إضافية</label>
                        <textarea class="form-control @error('notes') is-invalid @enderror" 
                                  id="notes" name="notes" rows="4" 
                                  placeholder="أي ملاحظات أو معلومات إضافية عن المورد">{{ old('notes', $supplier->notes) }}</textarea>
                        @error('notes')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
        </div>
        
        <!-- الشروط المالية والدفع -->
        <div class="col-lg-4">
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-credit-card me-2"></i>
                        الشروط المالية
                    </h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label for="credit_limit" class="form-label">حد الائتمان (ر.س)</label>
                        <input type="number" class="form-control @error('credit_limit') is-invalid @enderror" 
                               id="credit_limit" name="credit_limit" value="{{ old('credit_limit', $supplier->credit_limit) }}" 
                               step="0.01" min="0">
                        <small class="text-muted">الحد الأقصى للمديونية المسموحة</small>
                        @error('credit_limit')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="mb-3">
                        <label for="current_balance" class="form-label">الرصيد الحالي (ر.س)</label>
                        <input type="number" class="form-control" 
                               id="current_balance" value="{{ $supplier->current_balance }}" 
                               step="0.01" readonly>
                        <small class="text-muted">الرصيد الحالي - للعرض فقط</small>
                    </div>
                    
                    <div class="mb-3">
                        <label for="payment_terms" class="form-label">شروط الدفع</label>
                        <input type="text" class="form-control @error('payment_terms') is-invalid @enderror" 
                               id="payment_terms" name="payment_terms" value="{{ old('payment_terms', $supplier->payment_terms) }}" 
                               placeholder="مثل: الدفع خلال 30 يوم من تاريخ الفاتورة">
                        @error('payment_terms')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="mb-3">
                        <label for="payment_terms_days" class="form-label">عدد أيام الدفع</label>
                        <input type="number" class="form-control @error('payment_terms_days') is-invalid @enderror" 
                               id="payment_terms_days" name="payment_terms_days" 
                               value="{{ old('payment_terms_days', $supplier->payment_terms_days ?? 30) }}" min="1" max="365">
                        <small class="text-muted">عدد الأيام المسموحة للدفع</small>
                        @error('payment_terms_days')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="mb-3">
                        <label for="payment_method" class="form-label">طريقة الدفع المفضلة</label>
                        <select class="form-control @error('payment_method') is-invalid @enderror" 
                                id="payment_method" name="payment_method">
                            <option value="">اختر طريقة الدفع</option>
                            <option value="cash" {{ old('payment_method', $supplier->payment_method) == 'cash' ? 'selected' : '' }}>نقداً</option>
                            <option value="credit" {{ old('payment_method', $supplier->payment_method) == 'credit' ? 'selected' : '' }}>آجل</option>
                            <option value="bank_transfer" {{ old('payment_method', $supplier->payment_method) == 'bank_transfer' ? 'selected' : '' }}>تحويل بنكي</option>
                            <option value="check" {{ old('payment_method', $supplier->payment_method) == 'check' ? 'selected' : '' }}>شيك</option>
                        </select>
                        @error('payment_method')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            
            <!-- حالة الائتمان الحالية -->
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-chart-line me-2"></i>
                        حالة الائتمان
                    </h6>
                </div>
                <div class="card-body">
                    @php
                        $utilization = $supplier->getCreditUtilizationAttribute();
                        $available = $supplier->getAvailableCreditAttribute();
                        $riskLevel = $supplier->getRiskLevelAttribute();
                    @endphp
                    
                    <div class="row text-center mb-3">
                        <div class="col-6">
                            <div class="h6 mb-0 text-{{ $supplier->current_balance > 0 ? 'danger' : 'success' }}">
                                {{ number_format($supplier->current_balance, 2) }}
                            </div>
                            <small class="text-muted">الرصيد الحالي</small>
                        </div>
                        <div class="col-6">
                            <div class="h6 mb-0 text-success">{{ number_format($available, 2) }}</div>
                            <small class="text-muted">الائتمان المتاح</small>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <div class="d-flex justify-content-between mb-1">
                            <small>استخدام الائتمان</small>
                            <small>{{ number_format($utilization, 1) }}%</small>
                        </div>
                        <div class="progress" style="height: 8px;">
                            @php
                                $progressClass = 'bg-success';
                                if ($utilization >= 90) $progressClass = 'bg-danger';
                                elseif ($utilization >= 75) $progressClass = 'bg-warning';
                                elseif ($utilization >= 50) $progressClass = 'bg-info';
                            @endphp
                            <div class="progress-bar {{ $progressClass }}" style="width: {{ min(100, $utilization) }}%"></div>
                        </div>
                    </div>
                    
                    <div class="text-center">
                        <span class="badge bg-{{ $riskLevel === 'critical' ? 'danger' : ($riskLevel === 'high' ? 'warning' : ($riskLevel === 'medium' ? 'info' : 'success')) }}">
                            @switch($riskLevel)
                                @case('critical') مخاطر عالية جداً @break
                                @case('high') مخاطر عالية @break  
                                @case('medium') مخاطر متوسطة @break
                                @default مخاطر منخفضة @break
                            @endswitch
                        </span>
                    </div>
                    
                    @if($supplier->exceedsCreditLimit())
                    <div class="alert alert-danger alert-sm mt-3">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        <strong>تحذير:</strong> المورد تجاوز حد الائتمان المسموح
                    </div>
                    @endif
                </div>
            </div>
            
            <!-- إجراءات سريعة -->
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-bolt me-2"></i>
                        إجراءات سريعة
                    </h6>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="{{ route('suppliers.show', $supplier) }}" class="btn btn-outline-info btn-sm">
                            <i class="fas fa-eye me-2"></i>
                            عرض تفاصيل المورد
                        </a>
                        
                        @if($supplier->current_balance > 0)
                        <a href="{{ route('suppliers.payments.create', ['supplier_id' => $supplier->id]) }}" class="btn btn-outline-success btn-sm">
                            <i class="fas fa-money-bill-wave me-2"></i>
                            إضافة دفعة
                        </a>
                        @endif
                        
                        <a href="{{ route('suppliers.analytics.statement', $supplier) }}" class="btn btn-outline-primary btn-sm">
                            <i class="fas fa-file-invoice me-2"></i>
                            كشف الحساب
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- أزرار الحفظ -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-end gap-2">
                        <a href="{{ route('suppliers.show', $supplier) }}" class="btn btn-secondary">
                            <i class="fas fa-times me-2"></i>
                            إلغاء
                        </a>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i>
                            حفظ التغييرات
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
@endsection

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // تحديث شروط الدفع تلقائياً عند تغيير عدد الأيام
        const paymentTermsDaysInput = document.getElementById('payment_terms_days');
        const paymentTermsInput = document.getElementById('payment_terms');
        
        paymentTermsDaysInput.addEventListener('change', function() {
            const days = this.value;
            if (days && !paymentTermsInput.value.includes(days)) {
                if (confirm('هل تريد تحديث شروط الدفع تلقائياً؟')) {
                    paymentTermsInput.value = `الدفع خلال ${days} يوم من تاريخ الفاتورة`;
                }
            }
        });
        
        // تحديث مؤشر الائتمان عند تغيير حد الائتمان
        const creditLimitInput = document.getElementById('credit_limit');
        const currentBalance = parseFloat(document.getElementById('current_balance').value);
        
        creditLimitInput.addEventListener('input', function() {
            const newLimit = parseFloat(this.value);
            if (newLimit > 0 && currentBalance > newLimit) {
                this.classList.add('border-danger');
                if (!document.getElementById('credit-warning')) {
                    const warning = document.createElement('small');
                    warning.id = 'credit-warning';
                    warning.className = 'text-danger';
                    warning.textContent = 'تحذير: الرصيد الحالي يتجاوز الحد الجديد';
                    this.parentNode.appendChild(warning);
                }
            } else {
                this.classList.remove('border-danger');
                const warning = document.getElementById('credit-warning');
                if (warning) warning.remove();
            }
        });
        
        // التحقق من صحة البريد الإلكتروني
        const emailInput = document.getElementById('email');
        emailInput.addEventListener('blur', function() {
            const email = this.value;
            if (email && !isValidEmail(email)) {
                this.classList.add('is-invalid');
            } else {
                this.classList.remove('is-invalid');
            }
        });
        
        // تنسيق رقم الهاتف
        const phoneInputs = document.querySelectorAll('input[type="tel"]');
        phoneInputs.forEach(input => {
            input.addEventListener('input', function() {
                this.value = this.value.replace(/[^\d+\-\s()]/g, '');
            });
        });
    });
    
    function isValidEmail(email) {
        const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        return emailRegex.test(email);
    }
</script>
@endpush

@push('styles')
<style>
    .alert-sm {
        padding: 0.5rem 0.75rem;
        font-size: 0.875rem;
    }
    
    .progress {
        background-color: #e9ecef;
    }
    
    .form-label {
        font-weight: 600;
        color: #333;
    }
    
    .card-title {
        font-weight: 600;
    }
    
    .border-danger {
        border-color: #dc3545 !important;
    }
</style>
@endpush