@extends('layouts.app')

@section('title', 'كشف حساب المورد - ' . $supplier->name)

@section('page-actions')
    <div class="btn-group" role="group">
        <a href="{{ route('suppliers.debt.dashboard') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-right me-2"></i>
            العودة للوحة التحكم
        </a>
        <button type="button" class="btn btn-success" onclick="exportStatement('excel')">
            <i class="fas fa-file-excel me-2"></i>
            تصدير Excel
        </button>
        <button type="button" class="btn btn-danger" onclick="exportStatement('pdf')">
            <i class="fas fa-file-pdf me-2"></i>
            تصدير PDF
        </button>
        <button type="button" class="btn btn-primary" onclick="sendStatement()">
            <i class="fas fa-envelope me-2"></i>
            إرسال بالإيميل
        </button>
    </div>
@endsection

@section('content')
<div class="container-fluid">
    <!-- معلومات المورد -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-user me-2"></i>
                        معلومات المورد
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-8">
                            <div class="row">
                                <div class="col-md-6">
                                    <table class="table table-borderless table-sm">
                                        <tr>
                                            <td><strong>اسم المورد:</strong></td>
                                            <td>{{ $supplier->name }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>كود المورد:</strong></td>
                                            <td>{{ $supplier->code }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>البريد الإلكتروني:</strong></td>
                                            <td>{{ $supplier->email ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>الهاتف:</strong></td>
                                            <td>{{ $supplier->phone ?? 'غير محدد' }}</td>
                                        </tr>
                                    </table>
                                </div>
                                <div class="col-md-6">
                                    <table class="table table-borderless table-sm">
                                        <tr>
                                            <td><strong>حد الائتمان:</strong></td>
                                            <td class="text-info">{{ number_format($supplier->credit_limit, 2) }} ر.س</td>
                                        </tr>
                                        <tr>
                                            <td><strong>أيام الدفع:</strong></td>
                                            <td>{{ $supplier->payment_terms_days }} يوم</td>
                                        </tr>
                                        <tr>
                                            <td><strong>معدل الغرامة:</strong></td>
                                            <td>{{ ($supplier->penalty_rate * 100) }}% يومياً</td>
                                        </tr>
                                        <tr>
                                            <td><strong>مستوى المخاطر:</strong></td>
                                            <td>
                                                <span class="badge badge-{{ $supplier->risk_level === 'critical' ? 'danger' : ($supplier->risk_level === 'high' ? 'warning' : 'success') }}">
                                                    {{ ucfirst($supplier->risk_level) }}
                                                </span>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="card bg-light border">
                                <div class="card-body text-center">
                                    <h5 class="card-title text-{{ $supplier->current_balance > 0 ? 'danger' : 'success' }}">
                                        الرصيد الحالي
                                    </h5>
                                    <h2 class="text-{{ $supplier->current_balance > 0 ? 'danger' : 'success' }} mb-3">
                                        {{ number_format($supplier->current_balance, 2) }} ر.س
                                    </h2>
                                    @if($supplier->credit_limit > 0)
                                        <div class="progress mb-2">
                                            <div class="progress-bar bg-{{ $supplier->credit_utilization <= 50 ? 'success' : ($supplier->credit_utilization <= 80 ? 'warning' : 'danger') }}" 
                                                 style="width: {{ min($supplier->credit_utilization, 100) }}%">
                                            </div>
                                        </div>
                                        <small class="text-muted">
                                            استخدام الائتمان: {{ round($supplier->credit_utilization, 1) }}%
                                        </small>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- فلترة الفترة -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-calendar-alt me-2"></i>
                        فلترة الفترة الزمنية
                    </h6>
                </div>
                <div class="card-body">
                    <form method="GET" class="row g-3">
                        <div class="col-md-4">
                            <label class="form-label">من تاريخ</label>
                            <input type="date" name="date_from" class="form-control" value="{{ $dateFrom }}">
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">إلى تاريخ</label>
                            <input type="date" name="date_to" class="form-control" value="{{ $dateTo }}">
                        </div>
                        <div class="col-md-4 d-flex align-items-end">
                            <button type="submit" class="btn btn-primary w-100">
                                <i class="fas fa-search me-1"></i>
                                تطبيق الفلتر
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- تحليل أعمار الديون -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-chart-pie me-2"></i>
                        تحليل أعمار الديون
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-8">
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead class="table-light">
                                        <tr>
                                            <th>الفئة العمرية</th>
                                            <th>المبلغ</th>
                                            <th>النسبة</th>
                                            <th>عدد الفواتير</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                            $total = array_sum($ageGroups);
                                        @endphp
                                        <tr>
                                            <td><span class="badge badge-success">حالية</span></td>
                                            <td>{{ number_format($ageGroups['current'], 2) }} ر.س</td>
                                            <td>{{ $total > 0 ? round(($ageGroups['current'] / $total) * 100, 1) : 0 }}%</td>
                                            <td>{{ $outstandingInvoices->where('is_overdue', false)->count() }}</td>
                                        </tr>
                                        <tr>
                                            <td><span class="badge badge-info">1-30 يوم</span></td>
                                            <td>{{ number_format($ageGroups['1_30_days'], 2) }} ر.س</td>
                                            <td>{{ $total > 0 ? round(($ageGroups['1_30_days'] / $total) * 100, 1) : 0 }}%</td>
                                            <td>{{ $outstandingInvoices->where('days_overdue', '>=', 1)->where('days_overdue', '<=', 30)->count() }}</td>
                                        </tr>
                                        <tr>
                                            <td><span class="badge badge-warning">31-60 يوم</span></td>
                                            <td>{{ number_format($ageGroups['31_60_days'], 2) }} ر.س</td>
                                            <td>{{ $total > 0 ? round(($ageGroups['31_60_days'] / $total) * 100, 1) : 0 }}%</td>
                                            <td>{{ $outstandingInvoices->where('days_overdue', '>=', 31)->where('days_overdue', '<=', 60)->count() }}</td>
                                        </tr>
                                        <tr>
                                            <td><span class="badge badge-orange">61-90 يوم</span></td>
                                            <td>{{ number_format($ageGroups['61_90_days'], 2) }} ر.س</td>
                                            <td>{{ $total > 0 ? round(($ageGroups['61_90_days'] / $total) * 100, 1) : 0 }}%</td>
                                            <td>{{ $outstandingInvoices->where('days_overdue', '>=', 61)->where('days_overdue', '<=', 90)->count() }}</td>
                                        </tr>
                                        <tr>
                                            <td><span class="badge badge-danger">أكثر من 90 يوم</span></td>
                                            <td>{{ number_format($ageGroups['over_90_days'], 2) }} ر.س</td>
                                            <td>{{ $total > 0 ? round(($ageGroups['over_90_days'] / $total) * 100, 1) : 0 }}%</td>
                                            <td>{{ $outstandingInvoices->where('days_overdue', '>', 90)->count() }}</td>
                                        </tr>
                                        <tr class="table-dark">
                                            <td><strong>الإجمالي</strong></td>
                                            <td><strong>{{ number_format($total, 2) }} ر.س</strong></td>
                                            <td><strong>100%</strong></td>
                                            <td><strong>{{ $outstandingInvoices->count() }}</strong></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <canvas id="ageDistributionChart"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- الفواتير المعلقة -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card shadow">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">الفواتير المعلقة</h6>
                    <div>
                        <button type="button" class="btn btn-sm btn-warning" onclick="sendInvoiceReminders()">
                            <i class="fas fa-bell me-1"></i>
                            إرسال تذكيرات
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>رقم الفاتورة</th>
                                    <th>تاريخ الفاتورة</th>
                                    <th>تاريخ الاستحقاق</th>
                                    <th>المبلغ الأصلي</th>
                                    <th>المبلغ المتبقي</th>
                                    <th>أيام التأخير</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($outstandingInvoices as $invoice)
                                <tr class="{{ $invoice->is_overdue ? 'table-warning' : '' }}">
                                    <td>
                                        <a href="{{ route('purchase-invoices.show', $invoice) }}" class="text-decoration-none">
                                            <strong>{{ $invoice->invoice_number }}</strong>
                                        </a>
                                    </td>
                                    <td>{{ $invoice->invoice_date->format('d/m/Y') }}</td>
                                    <td>{{ $invoice->due_date->format('d/m/Y') }}</td>
                                    <td>{{ number_format($invoice->total_amount, 2) }} ر.س</td>
                                    <td>
                                        <strong class="text-{{ $invoice->remaining_amount > 0 ? 'danger' : 'success' }}">
                                            {{ number_format($invoice->remaining_amount, 2) }} ر.س
                                        </strong>
                                    </td>
                                    <td>
                                        @if($invoice->is_overdue)
                                            <span class="badge badge-danger">
                                                {{ $invoice->days_overdue }} يوم
                                            </span>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        <span class="badge badge-{{ $invoice->payment_status === 'paid' ? 'success' : ($invoice->is_overdue ? 'danger' : 'warning') }}">
                                            {{ $invoice->payment_status_label }}
                                        </span>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <a href="{{ route('purchase-invoices.show', $invoice) }}" 
                                               class="btn btn-outline-info" title="عرض الفاتورة">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            @if($invoice->remaining_amount > 0)
                                                <a href="{{ route('suppliers.payments.create', ['supplier_id' => $supplier->id]) }}" 
                                                   class="btn btn-outline-success" title="إضافة دفعة">
                                                    <i class="fas fa-plus"></i>
                                                </a>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="8" class="text-center text-muted py-4">
                                        <i class="fas fa-check-circle fa-2x mb-2 text-success"></i>
                                        <div>لا توجد فواتير معلقة للمورد في هذه الفترة</div>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- المدفوعات -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">سجل المدفوعات</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead class="table-light">
                                <tr>
                                    <th>تاريخ الدفع</th>
                                    <th>المبلغ</th>
                                    <th>طريقة الدفع</th>
                                    <th>المرجع</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($payments as $payment)
                                <tr>
                                    <td>{{ $payment->payment_date->format('d/m/Y') }}</td>
                                    <td>
                                        <strong class="text-success">{{ number_format($payment->amount, 2) }} ر.س</strong>
                                    </td>
                                    <td>{{ $payment->getPaymentMethodText() }}</td>
                                    <td>{{ $payment->reference_number ?? '-' }}</td>
                                    <td>
                                        <a href="{{ route('suppliers.payments.show', $payment) }}" 
                                           class="btn btn-sm btn-outline-info">
                                            <i class="fas fa-eye"></i> عرض
                                        </a>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="5" class="text-center text-muted py-4">
                                        لا توجد مدفوعات في هذه الفترة
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- الجدولة النشطة -->
    <div class="row">
        <div class="col-12">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">جدولة المدفوعات النشطة</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead class="table-light">
                                <tr>
                                    <th>تاريخ الجدولة</th>
                                    <th>المبلغ</th>
                                    <th>الحالة</th>
                                    <th>أيام متبقية</th>
                                    <th>آخر تذكير</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($schedules as $schedule)
                                <tr class="{{ $schedule->is_overdue ? 'table-warning' : '' }}">
                                    <td>{{ $schedule->schedule_date->format('d/m/Y') }}</td>
                                    <td>
                                        <strong>{{ number_format($schedule->scheduled_amount, 2) }} ر.س</strong>
                                        @if($schedule->penalty_amount > 0)
                                            <br><small class="text-danger">
                                                غرامة: {{ number_format($schedule->penalty_amount, 2) }} ر.س
                                            </small>
                                        @endif
                                    </td>
                                    <td>
                                        <span class="badge badge-{{ $schedule->status === 'paid' ? 'success' : ($schedule->is_overdue ? 'danger' : 'info') }}">
                                            {{ $schedule->status_label }}
                                        </span>
                                    </td>
                                    <td>
                                        @if($schedule->is_overdue)
                                            <span class="text-danger">متأخر {{ $schedule->days_overdue }} يوم</span>
                                        @else
                                            {{ $schedule->schedule_date->diffInDays(now()) }} يوم
                                        @endif
                                    </td>
                                    <td>
                                        @if($schedule->reminder_sent_at)
                                            {{ $schedule->reminder_sent_at->format('d/m/Y') }}
                                        @else
                                            <span class="text-muted">لم يرسل</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($schedule->status !== 'paid')
                                            <button type="button" class="btn btn-sm btn-outline-primary" 
                                                    onclick="sendScheduleReminder({{ $schedule->id }})">
                                                <i class="fas fa-bell"></i>
                                            </button>
                                        @endif
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="6" class="text-center text-muted py-4">
                                        لا توجد جدولة نشطة حالياً
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// رسم توزيع أعمار الديون
const ageCtx = document.getElementById('ageDistributionChart').getContext('2d');
new Chart(ageCtx, {
    type: 'doughnut',
    data: {
        labels: ['حالية', '1-30 يوم', '31-60 يوم', '61-90 يوم', 'أكثر من 90 يوم'],
        datasets: [{
            data: [
                {{ $ageGroups['current'] }},
                {{ $ageGroups['1_30_days'] }},
                {{ $ageGroups['31_60_days'] }},
                {{ $ageGroups['61_90_days'] }},
                {{ $ageGroups['over_90_days'] }}
            ],
            backgroundColor: [
                '#28a745',
                '#17a2b8',
                '#ffc107',
                '#fd7e14',
                '#dc3545'
            ]
        }]
    },
    options: {
        responsive: true,
        plugins: {
            legend: {
                position: 'bottom'
            }
        }
    }
});

// تصدير كشف الحساب
function exportStatement(format) {
    const params = new URLSearchParams(window.location.search);
    params.set('export', format);
    window.open(`{{ route('suppliers.debt.statement', $supplier) }}?${params.toString()}`);
}

// إرسال كشف الحساب بالإيميل
function sendStatement() {
    if (confirm('هل تريد إرسال كشف الحساب إلى المورد؟')) {
        fetch(`{{ route('suppliers.debt.statement', $supplier) }}`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify({
                action: 'send_email'
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('تم إرسال كشف الحساب بنجاح');
            } else {
                alert('حدث خطأ في إرسال كشف الحساب');
            }
        });
    }
}

// إرسال تذكيرات الفواتير
function sendInvoiceReminders() {
    if (confirm('هل تريد إرسال تذكيرات لجميع الفواتير المتأخرة؟')) {
        fetch(`/suppliers/{{ $supplier->id }}/send-invoice-reminders`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('تم إرسال التذكيرات بنجاح');
            } else {
                alert('حدث خطأ في إرسال التذكيرات');
            }
        });
    }
}

// إرسال تذكير جدولة
function sendScheduleReminder(scheduleId) {
    if (confirm('هل تريد إرسال تذكير لهذه الجدولة؟')) {
        fetch(`{{ route('suppliers.debt.send-reminders') }}`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify({
                schedule_ids: [scheduleId]
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('تم إرسال التذكير بنجاح');
                location.reload();
            } else {
                alert('حدث خطأ في إرسال التذكير');
            }
        });
    }
}
</script>
@endpush

@push('styles')
<style>
.badge-orange {
    color: #fff;
    background-color: #fd7e14;
}
</style>
@endpush