@extends('layouts.app')

@section('title', 'تقرير جدولة المدفوعات')

@section('page-actions')
    <div class="btn-group" role="group">
        <a href="{{ route('suppliers.debt.dashboard') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-right me-2"></i>
            العودة للوحة التحكم
        </a>
        <button type="button" class="btn btn-success" onclick="exportReport('excel')">
            <i class="fas fa-file-excel me-2"></i>
            تصدير Excel
        </button>
        <button type="button" class="btn btn-danger" onclick="exportReport('pdf')">
            <i class="fas fa-file-pdf me-2"></i>
            تصدير PDF
        </button>
    </div>
@endsection

@section('content')
<div class="container-fluid">
    <!-- ملخص التقرير -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-chart-bar me-2"></i>
                        ملخص جدولة المدفوعات
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-xl-3 col-md-6 mb-3">
                            <div class="card border-left-primary h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                                إجمالي الجدولات
                                            </div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                                {{ $summary['total_scheduled'] }}
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-calendar-alt fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-3 col-md-6 mb-3">
                            <div class="card border-left-success h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                                إجمالي المبلغ
                                            </div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                                {{ number_format($summary['total_amount'], 2) }} ر.س
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-dollar-sign fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-3 col-md-6 mb-3">
                            <div class="card border-left-warning h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                                جدولات متأخرة
                                            </div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                                {{ $summary['overdue_count'] }}
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-exclamation-triangle fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-3 col-md-6 mb-3">
                            <div class="card border-left-danger h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                                إجمالي الغرامات
                                            </div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                                {{ number_format($summary['total_penalties'], 2) }} ر.س
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-gavel fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- فلترة التقرير -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-filter me-2"></i>
                        فلترة التقرير
                    </h6>
                </div>
                <div class="card-body">
                    <form method="GET" class="row g-3">
                        <div class="col-md-3">
                            <label class="form-label">حالة الجدولة</label>
                            <select name="status" class="form-select">
                                <option value="">جميع الحالات</option>
                                <option value="scheduled" {{ request('status') === 'scheduled' ? 'selected' : '' }}>مجدولة</option>
                                <option value="reminded" {{ request('status') === 'reminded' ? 'selected' : '' }}>تم التذكير</option>
                                <option value="overdue" {{ request('status') === 'overdue' ? 'selected' : '' }}>متأخرة</option>
                                <option value="paid" {{ request('status') === 'paid' ? 'selected' : '' }}>مدفوعة</option>
                                <option value="cancelled" {{ request('status') === 'cancelled' ? 'selected' : '' }}>ملغاة</option>
                            </select>
                        </div>

                        <div class="col-md-3">
                            <label class="form-label">من تاريخ</label>
                            <input type="date" name="date_from" class="form-control" 
                                   value="{{ request('date_from', date('Y-m-01')) }}">
                        </div>

                        <div class="col-md-3">
                            <label class="form-label">إلى تاريخ</label>
                            <input type="date" name="date_to" class="form-control" 
                                   value="{{ request('date_to', date('Y-m-d')) }}">
                        </div>

                        <div class="col-md-3 d-flex align-items-end">
                            <button type="submit" class="btn btn-primary w-100">
                                <i class="fas fa-search me-1"></i>
                                تطبيق الفلتر
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- جدول الجدولات -->
    <div class="row">
        <div class="col-12">
            <div class="card shadow">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">تفاصيل جدولة المدفوعات</h6>
                    <div>
                        <button type="button" class="btn btn-sm btn-success" onclick="sendBulkReminders()">
                            <i class="fas fa-bell me-1"></i>
                            إرسال تذكيرات مجمعة
                        </button>
                        <button type="button" class="btn btn-sm btn-warning" onclick="applyBulkPenalties()">
                            <i class="fas fa-gavel me-1"></i>
                            تطبيق غرامات
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped" id="schedulesTable" width="100%" cellspacing="0">
                            <thead>
                                <tr>
                                    <th>
                                        <input type="checkbox" id="selectAll">
                                    </th>
                                    <th>المورد</th>
                                    <th>رقم الفاتورة</th>
                                    <th>تاريخ الجدولة</th>
                                    <th>المبلغ المجدول</th>
                                    <th>أيام التأخير</th>
                                    <th>الغرامة</th>
                                    <th>الحالة</th>
                                    <th>آخر تذكير</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($schedules as $schedule)
                                <tr class="{{ $schedule->is_overdue ? 'table-warning' : '' }}">
                                    <td>
                                        <input type="checkbox" class="schedule-checkbox" value="{{ $schedule->id }}">
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="me-2">
                                                <div class="rounded-circle bg-{{ $schedule->supplier->is_active ? 'success' : 'secondary' }} 
                                                            d-flex align-items-center justify-content-center" 
                                                     style="width: 30px; height: 30px;">
                                                    <i class="fas fa-user text-white"></i>
                                                </div>
                                            </div>
                                            <div>
                                                <div class="font-weight-bold">{{ $schedule->supplier->name }}</div>
                                                <small class="text-muted">{{ $schedule->supplier->code }}</small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <a href="{{ route('purchase-invoices.show', $schedule->purchaseInvoice) }}" 
                                           class="text-decoration-none">
                                            <strong>{{ $schedule->purchaseInvoice->invoice_number }}</strong>
                                        </a>
                                        <br>
                                        <small class="text-muted">
                                            {{ $schedule->purchaseInvoice->invoice_date->format('d/m/Y') }}
                                        </small>
                                    </td>
                                    <td>
                                        <strong>{{ $schedule->schedule_date->format('d/m/Y') }}</strong>
                                        @if($schedule->payment_deadline)
                                            <br><small class="text-muted">
                                                نهائي: {{ $schedule->payment_deadline->format('d/m/Y') }}
                                            </small>
                                        @endif
                                    </td>
                                    <td>
                                        <strong class="text-primary">
                                            {{ number_format($schedule->scheduled_amount, 2) }} ر.س
                                        </strong>
                                    </td>
                                    <td>
                                        @if($schedule->is_overdue)
                                            <span class="badge badge-danger">
                                                {{ $schedule->days_overdue }} يوم
                                            </span>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($schedule->penalty_amount > 0)
                                            <span class="text-danger font-weight-bold">
                                                {{ number_format($schedule->penalty_amount, 2) }} ر.س
                                            </span>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        <span class="badge badge-{{ 
                                            $schedule->status === 'paid' ? 'success' : 
                                            ($schedule->status === 'overdue' ? 'danger' : 
                                            ($schedule->status === 'reminded' ? 'warning' : 'info')) 
                                        }}">
                                            {{ $schedule->status_label }}
                                        </span>
                                    </td>
                                    <td>
                                        @if($schedule->reminder_sent_at)
                                            {{ $schedule->reminder_sent_at->format('d/m/Y H:i') }}
                                        @else
                                            <span class="text-muted">لم يرسل</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm" role="group">
                                            @if($schedule->status !== 'paid')
                                                <button type="button" class="btn btn-outline-primary" 
                                                        onclick="sendReminder({{ $schedule->id }})" 
                                                        title="إرسال تذكير">
                                                    <i class="fas fa-bell"></i>
                                                </button>
                                            @endif
                                            
                                            @if($schedule->is_overdue && $schedule->status !== 'overdue')
                                                <button type="button" class="btn btn-outline-warning" 
                                                        onclick="applyPenalty({{ $schedule->id }})" 
                                                        title="تطبيق غرامة">
                                                    <i class="fas fa-gavel"></i>
                                                </button>
                                            @endif
                                            
                                            @if($schedule->status !== 'paid')
                                                <button type="button" class="btn btn-outline-success" 
                                                        onclick="markAsPaid({{ $schedule->id }})" 
                                                        title="تسجيل كمدفوعة">
                                                    <i class="fas fa-check"></i>
                                                </button>
                                            @endif
                                            
                                            <a href="{{ route('suppliers.debt.statement', $schedule->supplier) }}" 
                                               class="btn btn-outline-info" title="كشف حساب المورد">
                                                <i class="fas fa-file-alt"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="10" class="text-center text-muted py-5">
                                        <i class="fas fa-calendar-times fa-3x mb-3"></i>
                                        <div>لا توجد جدولات تطابق معايير البحث</div>
                                        <div class="mt-2">
                                            <a href="{{ route('suppliers.debt.create-schedule') }}" class="btn btn-primary">
                                                <i class="fas fa-plus me-1"></i>
                                                إنشاء جدولة جديدة
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    
                    @if($schedules->hasPages())
                        <div class="d-flex justify-content-center mt-4">
                            {{ $schedules->withQueryString()->links() }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
// تحديد/إلغاء تحديد الكل
document.getElementById('selectAll').addEventListener('change', function() {
    const checkboxes = document.querySelectorAll('.schedule-checkbox');
    checkboxes.forEach(checkbox => {
        checkbox.checked = this.checked;
    });
});

// إرسال تذكير فردي
function sendReminder(scheduleId) {
    if (confirm('هل تريد إرسال تذكير لهذه الجدولة؟')) {
        fetch('{{ route("suppliers.debt.send-reminders") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify({
                schedule_ids: [scheduleId]
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('تم إرسال التذكير بنجاح');
                location.reload();
            } else {
                alert('حدث خطأ في إرسال التذكير');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('حدث خطأ في الاتصال');
        });
    }
}

// إرسال تذكيرات مجمعة
function sendBulkReminders() {
    const selectedSchedules = Array.from(document.querySelectorAll('.schedule-checkbox:checked')).map(cb => cb.value);
    
    if (selectedSchedules.length === 0) {
        alert('يرجى اختيار جدولة واحدة على الأقل');
        return;
    }
    
    if (confirm(`هل تريد إرسال ${selectedSchedules.length} تذكير؟`)) {
        fetch('{{ route("suppliers.debt.send-reminders") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify({
                schedule_ids: selectedSchedules
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('تم إرسال التذكيرات بنجاح');
                location.reload();
            } else {
                alert('حدث خطأ في إرسال التذكيرات');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('حدث خطأ في الاتصال');
        });
    }
}

// تطبيق غرامة فردية
function applyPenalty(scheduleId) {
    if (confirm('هل تريد تطبيق غرامة التأخير على هذه الجدولة؟')) {
        fetch('{{ route("suppliers.debt.apply-penalties") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify({
                schedule_ids: [scheduleId]
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('تم تطبيق الغرامة بنجاح');
                location.reload();
            } else {
                alert('حدث خطأ في تطبيق الغرامة');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('حدث خطأ في الاتصال');
        });
    }
}

// تطبيق غرامات مجمعة
function applyBulkPenalties() {
    const selectedSchedules = Array.from(document.querySelectorAll('.schedule-checkbox:checked')).map(cb => cb.value);
    
    if (selectedSchedules.length === 0) {
        alert('يرجى اختيار جدولة واحدة على الأقل');
        return;
    }
    
    if (confirm(`هل تريد تطبيق غرامات التأخير على ${selectedSchedules.length} جدولة؟`)) {
        fetch('{{ route("suppliers.debt.apply-penalties") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify({
                schedule_ids: selectedSchedules
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('تم تطبيق الغرامات بنجاح');
                location.reload();
            } else {
                alert('حدث خطأ في تطبيق الغرامات');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('حدث خطأ في الاتصال');
        });
    }
}

// تسجيل كمدفوعة
function markAsPaid(scheduleId) {
    if (confirm('هل تم سداد هذه الجدولة فعلاً؟')) {
        fetch(`/suppliers/debt/schedules/${scheduleId}/mark-paid`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('تم تسجيل الجدولة كمدفوعة');
                location.reload();
            } else {
                alert('حدث خطأ في تحديث حالة الجدولة');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('حدث خطأ في الاتصال');
        });
    }
}

// تصدير التقرير
function exportReport(format) {
    const params = new URLSearchParams(window.location.search);
    params.set('export', format);
    window.open(`{{ route('suppliers.debt.schedule-report') }}?${params.toString()}`);
}

// تهيئة DataTable
$(document).ready(function() {
    $('#schedulesTable').DataTable({
        "language": {
            "url": "//cdn.datatables.net/plug-ins/1.10.24/i18n/Arabic.json"
        },
        "order": [[ 3, "asc" ]], // ترتيب حسب تاريخ الجدولة
        "pageLength": 25,
        "responsive": true,
        "columnDefs": [
            { "orderable": false, "targets": [0, 9] } // عدم ترتيب عمود التحديد والإجراءات
        ]
    });
});
</script>
@endpush

@push('styles')
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.24/css/dataTables.bootstrap4.min.css">
<style>
.table td {
    vertical-align: middle;
}
</style>
@endpush