@extends('layouts.app')

@section('title', 'تقرير الديون المتأخرة')

@section('page-actions')
    <div class="btn-group" role="group">
        <a href="{{ route('suppliers.debt.dashboard') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-right me-2"></i>
            العودة للوحة التحكم
        </a>
        <button type="button" class="btn btn-success" onclick="exportReport('excel')">
            <i class="fas fa-file-excel me-2"></i>
            تصدير Excel
        </button>
        <button type="button" class="btn btn-danger" onclick="exportReport('pdf')">
            <i class="fas fa-file-pdf me-2"></i>
            تصدير PDF
        </button>
        <button type="button" class="btn btn-warning" onclick="sendBulkReminders()">
            <i class="fas fa-bell me-2"></i>
            إرسال تذكيرات مجمعة
        </button>
    </div>
@endsection

@section('content')
<div class="container-fluid">
    <!-- ملخص الديون المتأخرة -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card shadow border-left-danger">
                <div class="card-header py-3 bg-danger text-white">
                    <h6 class="m-0 font-weight-bold">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        ملخص الديون المتأخرة
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-xl-3 col-md-6 mb-3">
                            <div class="card border-left-danger h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                                إجمالي الفواتير المتأخرة
                                            </div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                                {{ $summary['total_overdue'] }}
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-file-invoice fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-3 col-md-6 mb-3">
                            <div class="card border-left-warning h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                                إجمالي المبلغ المتأخر
                                            </div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                                {{ number_format($summary['total_amount'], 2) }} ر.س
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-dollar-sign fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-3 col-md-6 mb-3">
                            <div class="card border-left-info h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                                متوسط أيام التأخير
                                            </div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                                {{ round($summary['avg_days_overdue'], 1) }} يوم
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-clock fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-3 col-md-6 mb-3">
                            <div class="card border-left-primary h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                                الموردين المتأثرين
                                            </div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                                {{ $summary['affected_suppliers'] }}
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-users fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- فلترة التقرير -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-filter me-2"></i>
                        فلترة التقرير
                    </h6>
                </div>
                <div class="card-body">
                    <form method="GET" class="row g-3">
                        <div class="col-md-3">
                            <label class="form-label">المورد</label>
                            <select name="supplier_id" class="form-select">
                                <option value="">جميع الموردين</option>
                                @foreach($suppliers as $supplier)
                                    <option value="{{ $supplier->id }}" {{ request('supplier_id') == $supplier->id ? 'selected' : '' }}>
                                        {{ $supplier->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-md-3">
                            <label class="form-label">أيام التأخير (أكثر من)</label>
                            <select name="overdue_days" class="form-select">
                                <option value="">جميع الأيام</option>
                                <option value="7" {{ request('overdue_days') == '7' ? 'selected' : '' }}>أكثر من 7 أيام</option>
                                <option value="15" {{ request('overdue_days') == '15' ? 'selected' : '' }}>أكثر من 15 يوم</option>
                                <option value="30" {{ request('overdue_days') == '30' ? 'selected' : '' }}>أكثر من 30 يوم</option>
                                <option value="60" {{ request('overdue_days') == '60' ? 'selected' : '' }}>أكثر من 60 يوم</option>
                                <option value="90" {{ request('overdue_days') == '90' ? 'selected' : '' }}>أكثر من 90 يوم</option>
                            </select>
                        </div>

                        <div class="col-md-3">
                            <label class="form-label">الحد الأدنى للمبلغ</label>
                            <input type="number" name="min_amount" class="form-control" 
                                   value="{{ request('min_amount') }}" placeholder="0.00" step="0.01">
                        </div>

                        <div class="col-md-3 d-flex align-items-end">
                            <button type="submit" class="btn btn-primary w-100">
                                <i class="fas fa-search me-1"></i>
                                تطبيق الفلتر
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- رسم بياني للديون المتأخرة -->
    <div class="row mb-4">
        <div class="col-lg-8">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">توزيع الديون المتأخرة حسب المدة</h6>
                </div>
                <div class="card-body">
                    <canvas id="overdueChart"></canvas>
                </div>
            </div>
        </div>
        <div class="col-lg-4">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">أكبر المديونيات المتأخرة</h6>
                </div>
                <div class="card-body">
                    @php
                        $topOverdue = $overdueInvoices->sortByDesc('remaining_amount')->take(5);
                    @endphp
                    @foreach($topOverdue as $invoice)
                    <div class="mb-3 pb-3 border-bottom">
                        <div class="d-flex justify-content-between">
                            <div>
                                <strong>{{ $invoice->supplier->name }}</strong>
                                <br>
                                <small class="text-muted">{{ $invoice->invoice_number }}</small>
                            </div>
                            <div class="text-end">
                                <div class="text-danger font-weight-bold">
                                    {{ number_format($invoice->remaining_amount, 2) }} ر.س
                                </div>
                                <small class="text-muted">
                                    {{ $invoice->days_overdue }} يوم تأخير
                                </small>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>

    <!-- جدول الفواتير المتأخرة -->
    <div class="row">
        <div class="col-12">
            <div class="card shadow">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">تفاصيل الفواتير المتأخرة</h6>
                    <div>
                        <button type="button" class="btn btn-sm btn-warning" onclick="sendSelectedReminders()">
                            <i class="fas fa-bell me-1"></i>
                            إرسال تذكيرات للمحدد
                        </button>
                        <button type="button" class="btn btn-sm btn-info" onclick="createPaymentSchedules()">
                            <i class="fas fa-calendar-plus me-1"></i>
                            إنشاء جدولة دفع
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped" id="overdueTable" width="100%" cellspacing="0">
                            <thead>
                                <tr>
                                    <th>
                                        <input type="checkbox" id="selectAll">
                                    </th>
                                    <th>المورد</th>
                                    <th>رقم الفاتورة</th>
                                    <th>تاريخ الفاتورة</th>
                                    <th>تاريخ الاستحقاق</th>
                                    <th>المبلغ المتبقي</th>
                                    <th>أيام التأخير</th>
                                    <th>مستوى المخاطر</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($overdueInvoices as $invoice)
                                @php
                                    $riskLevel = 'low';
                                    if ($invoice->days_overdue > 90) $riskLevel = 'critical';
                                    elseif ($invoice->days_overdue > 60) $riskLevel = 'high';
                                    elseif ($invoice->days_overdue > 30) $riskLevel = 'medium';
                                @endphp
                                <tr class="table-{{ $riskLevel === 'critical' ? 'danger' : ($riskLevel === 'high' ? 'warning' : '') }}">
                                    <td>
                                        <input type="checkbox" class="invoice-checkbox" value="{{ $invoice->id }}">
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="me-2">
                                                <div class="rounded-circle bg-{{ $invoice->supplier->risk_level === 'critical' ? 'danger' : ($invoice->supplier->risk_level === 'high' ? 'warning' : 'success') }} 
                                                            d-flex align-items-center justify-content-center" 
                                                     style="width: 30px; height: 30px;">
                                                    <i class="fas fa-user text-white"></i>
                                                </div>
                                            </div>
                                            <div>
                                                <a href="{{ route('suppliers.show', $invoice->supplier) }}" 
                                                   class="text-decoration-none">
                                                    <strong>{{ $invoice->supplier->name }}</strong>
                                                </a>
                                                <br>
                                                <small class="text-muted">{{ $invoice->supplier->code }}</small>
                                                @if($invoice->supplier->exceedsCreditLimit())
                                                    <br><span class="badge badge-danger badge-sm">تجاوز الحد</span>
                                                @endif
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <a href="{{ route('purchase-invoices.show', $invoice) }}" 
                                           class="text-decoration-none">
                                            <strong>{{ $invoice->invoice_number }}</strong>
                                        </a>
                                        <br>
                                        <small class="text-muted">
                                            أصل: {{ number_format($invoice->total_amount, 2) }} ر.س
                                        </small>
                                    </td>
                                    <td>{{ $invoice->invoice_date->format('d/m/Y') }}</td>
                                    <td>
                                        <span class="text-danger">
                                            {{ $invoice->due_date->format('d/m/Y') }}
                                        </span>
                                    </td>
                                    <td>
                                        <strong class="text-danger">
                                            {{ number_format($invoice->remaining_amount, 2) }} ر.س
                                        </strong>
                                    </td>
                                    <td>
                                        <span class="badge badge-{{ 
                                            $invoice->days_overdue > 90 ? 'danger' : 
                                            ($invoice->days_overdue > 60 ? 'warning' : 
                                            ($invoice->days_overdue > 30 ? 'info' : 'secondary')) 
                                        }}">
                                            {{ $invoice->days_overdue }} يوم
                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge badge-{{ 
                                            $riskLevel === 'critical' ? 'danger' : 
                                            ($riskLevel === 'high' ? 'warning' : 
                                            ($riskLevel === 'medium' ? 'info' : 'success'))
                                        }}">
                                            {{ 
                                                $riskLevel === 'critical' ? 'خطر عالي' : 
                                                ($riskLevel === 'high' ? 'متوسط' : 
                                                ($riskLevel === 'medium' ? 'منخفض' : 'طبيعي'))
                                            }}
                                        </span>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm" role="group">
                                            <button type="button" class="btn btn-outline-warning" 
                                                    onclick="sendInvoiceReminder({{ $invoice->id }})" 
                                                    title="إرسال تذكير">
                                                <i class="fas fa-bell"></i>
                                            </button>
                                            
                                            <a href="{{ route('suppliers.payments.create', ['supplier_id' => $invoice->supplier->id]) }}" 
                                               class="btn btn-outline-success" title="إضافة دفعة">
                                                <i class="fas fa-plus"></i>
                                            </a>
                                            
                                            <a href="{{ route('suppliers.debt.create-schedule', ['supplier_id' => $invoice->supplier->id]) }}" 
                                               class="btn btn-outline-info" title="إنشاء جدولة">
                                                <i class="fas fa-calendar-plus"></i>
                                            </a>
                                            
                                            <a href="{{ route('purchase-invoices.show', $invoice) }}" 
                                               class="btn btn-outline-primary" title="عرض الفاتورة">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="9" class="text-center text-muted py-5">
                                        <i class="fas fa-check-circle fa-3x mb-3 text-success"></i>
                                        <div class="h5">ممتاز! لا توجد فواتير متأخرة</div>
                                        <div>جميع الفواتير مدفوعة أو ضمن فترة السماح</div>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    
                    @if($overdueInvoices->hasPages())
                        <div class="d-flex justify-content-center mt-4">
                            {{ $overdueInvoices->withQueryString()->links() }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.24/js/dataTables.bootstrap4.min.js"></script>
<script>
// رسم بياني للديون المتأخرة
@php
    $chartData = [
        '1-30 يوم' => $overdueInvoices->where('days_overdue', '<=', 30)->sum('remaining_amount'),
        '31-60 يوم' => $overdueInvoices->whereBetween('days_overdue', [31, 60])->sum('remaining_amount'),
        '61-90 يوم' => $overdueInvoices->whereBetween('days_overdue', [61, 90])->sum('remaining_amount'),
        'أكثر من 90 يوم' => $overdueInvoices->where('days_overdue', '>', 90)->sum('remaining_amount')
    ];
@endphp

const overdueCtx = document.getElementById('overdueChart').getContext('2d');
new Chart(overdueCtx, {
    type: 'bar',
    data: {
        labels: @json(array_keys($chartData)),
        datasets: [{
            label: 'المبلغ (ر.س)',
            data: @json(array_values($chartData)),
            backgroundColor: [
                '#17a2b8',
                '#ffc107', 
                '#fd7e14',
                '#dc3545'
            ],
            borderColor: [
                '#17a2b8',
                '#ffc107',
                '#fd7e14', 
                '#dc3545'
            ],
            borderWidth: 1
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true,
                ticks: {
                    callback: function(value) {
                        return new Intl.NumberFormat('ar-SA').format(value);
                    }
                }
            }
        },
        plugins: {
            tooltip: {
                callbacks: {
                    label: function(context) {
                        return context.parsed.y.toLocaleString('ar-SA') + ' ر.س';
                    }
                }
            }
        }
    }
});

// تهيئة DataTable
$(document).ready(function() {
    $('#overdueTable').DataTable({
        "language": {
            "url": "//cdn.datatables.net/plug-ins/1.10.24/i18n/Arabic.json"
        },
        "order": [[ 6, "desc" ]], // ترتيب حسب أيام التأخير
        "pageLength": 25,
        "responsive": true,
        "columnDefs": [
            { "orderable": false, "targets": [0, 8] } // عدم ترتيب عمود التحديد والإجراءات
        ]
    });
});

// تحديد/إلغاء تحديد الكل
document.getElementById('selectAll').addEventListener('change', function() {
    const checkboxes = document.querySelectorAll('.invoice-checkbox');
    checkboxes.forEach(checkbox => {
        checkbox.checked = this.checked;
    });
});

// إرسال تذكير لفاتورة واحدة
function sendInvoiceReminder(invoiceId) {
    if (confirm('هل تريد إرسال تذكير لهذه الفاتورة؟')) {
        fetch(`/purchase-invoices/${invoiceId}/send-reminder`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('تم إرسال التذكير بنجاح');
            } else {
                alert('حدث خطأ في إرسال التذكير');
            }
        });
    }
}

// إرسال تذكيرات للفواتير المحددة
function sendSelectedReminders() {
    const selectedInvoices = Array.from(document.querySelectorAll('.invoice-checkbox:checked')).map(cb => cb.value);
    
    if (selectedInvoices.length === 0) {
        alert('يرجى اختيار فاتورة واحدة على الأقل');
        return;
    }
    
    if (confirm(`هل تريد إرسال تذكيرات لـ ${selectedInvoices.length} فاتورة؟`)) {
        fetch('/invoices/send-bulk-reminders', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify({
                invoice_ids: selectedInvoices
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('تم إرسال التذكيرات بنجاح');
            } else {
                alert('حدث خطأ في إرسال التذكيرات');
            }
        });
    }
}

// إرسال تذكيرات مجمعة لجميع الفواتير
function sendBulkReminders() {
    if (confirm('هل تريد إرسال تذكيرات لجميع الفواتير المتأخرة؟')) {
        const allInvoices = Array.from(document.querySelectorAll('.invoice-checkbox')).map(cb => cb.value);
        
        fetch('/invoices/send-bulk-reminders', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify({
                invoice_ids: allInvoices
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert(`تم إرسال ${allInvoices.length} تذكير بنجاح`);
            } else {
                alert('حدث خطأ في إرسال التذكيرات');
            }
        });
    }
}

// إنشاء جدولة دفع للفواتير المحددة
function createPaymentSchedules() {
    const selectedInvoices = Array.from(document.querySelectorAll('.invoice-checkbox:checked')).map(cb => cb.value);
    
    if (selectedInvoices.length === 0) {
        alert('يرجى اختيار فاتورة واحدة على الأقل');
        return;
    }
    
    if (selectedInvoices.length === 1) {
        // إعادة توجيه لصفحة إنشاء جدولة للفاتورة الواحدة
        window.location.href = `{{ route('suppliers.debt.create-schedule') }}?invoice_id=${selectedInvoices[0]}`;
    } else {
        // إنشاء جدولة مجمعة
        if (confirm(`هل تريد إنشاء جدولة دفع لـ ${selectedInvoices.length} فاتورة؟`)) {
            fetch('/suppliers/debt/create-bulk-schedules', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: JSON.stringify({
                    invoice_ids: selectedInvoices
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert('تم إنشاء الجدولات بنجاح');
                    location.reload();
                } else {
                    alert('حدث خطأ في إنشاء الجدولات');
                }
            });
        }
    }
}

// تصدير التقرير
function exportReport(format) {
    const params = new URLSearchParams(window.location.search);
    params.set('export', format);
    window.open(`{{ route('suppliers.debt.overdue-report') }}?${params.toString()}`);
}
</script>
@endpush

@push('styles')
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.24/css/dataTables.bootstrap4.min.css">
<style>
.table td {
    vertical-align: middle;
}

.badge-sm {
    font-size: 0.7em;
}
</style>
@endpush