@extends('layouts.app')

@section('title', 'لوحة تحكم إدارة مديونيات الموردين')

@section('content')
<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="h3 mb-0 text-gray-800">
                        <i class="fas fa-chart-line me-2"></i>
                        إدارة مديونيات الموردين
                    </h1>
                    <p class="text-muted mb-0">متابعة وإدارة المديونيات والجدولة المالية</p>
                </div>
                <div>
                    <a href="{{ route('suppliers.debt.create-schedule') }}" class="btn btn-primary">
                        <i class="fas fa-plus me-1"></i>
                        إنشاء جدولة سداد
                    </a>
                    <a href="{{ route('suppliers.debt.overdue-report') }}" class="btn btn-warning">
                        <i class="fas fa-exclamation-triangle me-1"></i>
                        الديون المتأخرة
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- إحصائيات سريعة -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                إجمالي المديونيات
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ number_format($stats['total_debt'], 2) }} ر.س
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-money-bill-wave fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-danger shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                الديون المتأخرة
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ number_format($stats['overdue_debt'], 2) }} ر.س
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-exclamation-triangle fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                مستحقة قريباً
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $stats['due_soon_schedules'] }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-clock fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                إجمالي الغرامات
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ number_format($stats['total_penalty_amount'], 2) }} ر.س
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-gavel fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- الرسوم البيانية -->
    <div class="row mb-4">
        <div class="col-xl-8 col-lg-7">
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">تطور المديونيات</h6>
                </div>
                <div class="card-body">
                    <canvas id="debtEvolutionChart"></canvas>
                </div>
            </div>
        </div>

        <div class="col-xl-4 col-lg-5">
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">توزيع أعمار الديون</h6>
                </div>
                <div class="card-body">
                    <canvas id="ageDistributionChart"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- جداول البيانات -->
    <div class="row">
        <!-- الموردين الأكثر مديونية -->
        <div class="col-xl-6 mb-4">
            <div class="card shadow">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">الموردين الأكثر مديونية</h6>
                    <a href="{{ route('suppliers.debt.bad-debt-management') }}" class="btn btn-sm btn-outline-primary">
                        عرض الكل
                    </a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>المورد</th>
                                    <th>المديونية</th>
                                    <th>متأخر</th>
                                    <th>الإجراء</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($topDebtors as $supplier)
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="mr-2">
                                                <span class="badge badge-{{ $supplier->risk_level === 'critical' ? 'danger' : ($supplier->risk_level === 'high' ? 'warning' : 'info') }}">
                                                    {{ $supplier->risk_level }}
                                                </span>
                                            </div>
                                            <div>
                                                <div class="font-weight-bold">{{ $supplier->name }}</div>
                                                <small class="text-muted">{{ $supplier->code }}</small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <strong>{{ number_format($supplier->current_balance, 2) }}</strong> ر.س
                                    </td>
                                    <td>
                                        <span class="badge badge-danger">
                                            {{ number_format($supplier->getOverdueAmount(), 2) }} ر.س
                                        </span>
                                    </td>
                                    <td>
                                        <a href="{{ route('suppliers.debt.statement', $supplier) }}" 
                                           class="btn btn-sm btn-outline-primary">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="4" class="text-center text-muted py-4">
                                        لا توجد مديونيات حالياً
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- الفواتير المتأخرة -->
        <div class="col-xl-6 mb-4">
            <div class="card shadow">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">الفواتير المتأخرة</h6>
                    <a href="{{ route('suppliers.debt.overdue-report') }}" class="btn btn-sm btn-outline-danger">
                        عرض الكل
                    </a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>الفاتورة</th>
                                    <th>المورد</th>
                                    <th>المبلغ</th>
                                    <th>أيام التأخير</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($overdueInvoices as $invoice)
                                <tr>
                                    <td>
                                        <a href="{{ route('purchase-invoices.show', $invoice) }}" 
                                           class="text-decoration-none">
                                            {{ $invoice->invoice_number }}
                                        </a>
                                        <br>
                                        <small class="text-muted">{{ $invoice->invoice_date->format('d/m/Y') }}</small>
                                    </td>
                                    <td>{{ $invoice->supplier->name }}</td>
                                    <td>
                                        <strong>{{ number_format($invoice->remaining_amount, 2) }}</strong> ر.س
                                    </td>
                                    <td>
                                        <span class="badge badge-{{ $invoice->days_overdue > 30 ? 'danger' : 'warning' }}">
                                            {{ $invoice->days_overdue }} يوم
                                        </span>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="4" class="text-center text-muted py-4">
                                        لا توجد فواتير متأخرة
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- المجدولات المستحقة قريباً -->
    <div class="row">
        <div class="col-12">
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">المدفوعات المجدولة قريباً</h6>
                    <div>
                        <button type="button" class="btn btn-sm btn-success" onclick="sendBulkReminders()">
                            <i class="fas fa-bell me-1"></i>
                            إرسال تذكيرات
                        </button>
                        <a href="{{ route('suppliers.debt.schedule-report') }}" class="btn btn-sm btn-outline-primary">
                            عرض الكل
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>
                                        <input type="checkbox" id="selectAll">
                                    </th>
                                    <th>تاريخ الاستحقاق</th>
                                    <th>المورد</th>
                                    <th>الفاتورة</th>
                                    <th>المبلغ</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($upcomingSchedules as $schedule)
                                <tr class="{{ $schedule->is_overdue ? 'table-danger' : ($schedule->schedule_date->isToday() ? 'table-warning' : '') }}">
                                    <td>
                                        <input type="checkbox" class="schedule-checkbox" value="{{ $schedule->id }}">
                                    </td>
                                    <td>
                                        <strong>{{ $schedule->schedule_date->format('d/m/Y') }}</strong>
                                        @if($schedule->is_overdue)
                                            <span class="badge badge-danger ms-1">متأخر</span>
                                        @elseif($schedule->schedule_date->isToday())
                                            <span class="badge badge-warning ms-1">اليوم</span>
                                        @endif
                                    </td>
                                    <td>{{ $schedule->supplier->name }}</td>
                                    <td>
                                        <a href="{{ route('purchase-invoices.show', $schedule->purchaseInvoice) }}">
                                            {{ $schedule->purchaseInvoice->invoice_number }}
                                        </a>
                                    </td>
                                    <td>
                                        <strong>{{ number_format($schedule->scheduled_amount, 2) }}</strong> ر.س
                                    </td>
                                    <td>
                                        <span class="badge badge-{{ $schedule->status === 'overdue' ? 'danger' : ($schedule->status === 'reminded' ? 'warning' : 'info') }}">
                                            {{ $schedule->status_label }}
                                        </span>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <button type="button" class="btn btn-outline-primary" 
                                                    onclick="sendReminder({{ $schedule->id }})">
                                                <i class="fas fa-bell"></i>
                                            </button>
                                            <a href="{{ route('suppliers.debt.statement', $schedule->supplier) }}" 
                                               class="btn btn-outline-info">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="7" class="text-center text-muted py-4">
                                        لا توجد مجدولات مستحقة قريباً
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// رسم تطور المديونيات
const debtEvolutionCtx = document.getElementById('debtEvolutionChart').getContext('2d');
new Chart(debtEvolutionCtx, {
    type: 'line',
    data: {
        labels: @json($debtEvolution['months']),
        datasets: [{
            label: 'المديونيات (ر.س)',
            data: @json($debtEvolution['data']),
            borderColor: '#4e73df',
            backgroundColor: 'rgba(78, 115, 223, 0.1)',
            borderWidth: 2,
            fill: true
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true,
                ticks: {
                    callback: function(value) {
                        return new Intl.NumberFormat('ar-SA').format(value);
                    }
                }
            }
        }
    }
});

// رسم توزيع أعمار الديون
const ageDistributionCtx = document.getElementById('ageDistributionChart').getContext('2d');
new Chart(ageDistributionCtx, {
    type: 'doughnut',
    data: {
        labels: ['حالية', '1-30 يوم', '31-60 يوم', '61-90 يوم', 'أكثر من 90 يوم'],
        datasets: [{
            data: [
                {{ $ageDistribution['current'] }},
                {{ $ageDistribution['1_30_days'] }},
                {{ $ageDistribution['31_60_days'] }},
                {{ $ageDistribution['61_90_days'] }},
                {{ $ageDistribution['over_90_days'] }}
            ],
            backgroundColor: [
                '#1cc88a',
                '#36b9cc',
                '#f6c23e',
                '#fd7e14',
                '#e74a3b'
            ]
        }]
    },
    options: {
        responsive: true,
        plugins: {
            legend: {
                position: 'bottom'
            }
        }
    }
});

// تحديد/إلغاء تحديد الكل
document.getElementById('selectAll').addEventListener('change', function() {
    const checkboxes = document.querySelectorAll('.schedule-checkbox');
    checkboxes.forEach(checkbox => {
        checkbox.checked = this.checked;
    });
});

// إرسال تذكير فردي
function sendReminder(scheduleId) {
    if (confirm('هل تريد إرسال تذكير لهذه الجدولة؟')) {
        fetch(`/suppliers/debt/send-reminders`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify({
                schedule_ids: [scheduleId]
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('تم إرسال التذكير بنجاح');
                location.reload();
            }
        });
    }
}

// إرسال تذكيرات مجمعة
function sendBulkReminders() {
    const selectedSchedules = Array.from(document.querySelectorAll('.schedule-checkbox:checked')).map(cb => cb.value);
    
    if (selectedSchedules.length === 0) {
        alert('يرجى اختيار جدولة واحدة على الأقل');
        return;
    }
    
    if (confirm(`هل تريد إرسال ${selectedSchedules.length} تذكير؟`)) {
        fetch(`/suppliers/debt/send-reminders`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify({
                schedule_ids: selectedSchedules
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('تم إرسال التذكيرات بنجاح');
                location.reload();
            }
        });
    }
}
</script>
@endpush