@extends('layouts.app')

@section('title', 'تحليلات الموردين')
@section('page-title', 'تحليلات الموردين')

@section('page-actions')
    <div class="btn-group" role="group">
        <a href="{{ route('suppliers.analytics.performance') }}" class="btn btn-primary">
            <i class="fas fa-chart-line me-2"></i>
            تقرير الأداء
        </a>
        <a href="{{ route('suppliers.analytics.aging') }}" class="btn btn-info">
            <i class="fas fa-clock me-2"></i>
            أعمار الديون
        </a>
        <a href="{{ route('suppliers.analytics.credit-monitoring') }}" class="btn btn-warning">
            <i class="fas fa-exclamation-triangle me-2"></i>
            مراقبة الائتمان
        </a>
        <div class="btn-group" role="group">
            <button type="button" class="btn btn-success dropdown-toggle" data-bs-toggle="dropdown">
                <i class="fas fa-download me-2"></i>
                تصدير
            </button>
            <ul class="dropdown-menu">
                <li><a class="dropdown-item" href="#" onclick="exportReport('dashboard', 'excel')">
                    <i class="fas fa-file-excel me-2"></i>Excel
                </a></li>
                <li><a class="dropdown-item" href="#" onclick="exportReport('dashboard', 'pdf')">
                    <i class="fas fa-file-pdf me-2"></i>PDF
                </a></li>
            </ul>
        </div>
    </div>
@endsection

@section('content')
<!-- إحصائيات سريعة -->
<div class="row mb-4">
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card text-white bg-primary">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <i class="fas fa-users fa-2x"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <div class="card-title h5 mb-1">{{ number_format($totalSuppliers) }}</div>
                        <div class="card-text small">إجمالي الموردين</div>
                    </div>
                </div>
                <div class="progress mt-2" style="height: 4px;">
                    <div class="progress-bar bg-white" style="width: {{ $totalSuppliers > 0 ? ($activeSuppliers / $totalSuppliers) * 100 : 0 }}%"></div>
                </div>
                <small class="text-white-50">{{ $activeSuppliers }} نشط</small>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card text-white bg-success">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <i class="fas fa-shopping-cart fa-2x"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <div class="card-title h5 mb-1">{{ number_format($yearlyPurchases, 0) }} ر.س</div>
                        <div class="card-text small">مشتريات هذا العام</div>
                    </div>
                </div>
                <div class="progress mt-2" style="height: 4px;">
                    <div class="progress-bar bg-white" style="width: 75%"></div>
                </div>
                <small class="text-white-50">{{ number_format($monthlyPurchases, 0) }} ر.س هذا الشهر</small>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card text-white bg-warning">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <i class="fas fa-credit-card fa-2x"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <div class="card-title h5 mb-1">{{ number_format($totalDebt, 0) }} ر.س</div>
                        <div class="card-text small">إجمالي المديونية</div>
                    </div>
                </div>
                <div class="progress mt-2" style="height: 4px;">
                    <div class="progress-bar bg-white" style="width: 60%"></div>
                </div>
                <small class="text-white-50">{{ $suppliersWithDebt }} مورد لديه مديونية</small>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card text-white bg-danger">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <i class="fas fa-exclamation-circle fa-2x"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <div class="card-title h5 mb-1">{{ $overdueInvoices }}</div>
                        <div class="card-text small">فواتير متأخرة</div>
                    </div>
                </div>
                <div class="progress mt-2" style="height: 4px;">
                    <div class="progress-bar bg-white" style="width: 45%"></div>
                </div>
                <small class="text-white-50">{{ number_format($overdueAmount, 0) }} ر.س</small>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <!-- الرسوم البيانية -->
    <div class="col-lg-8 mb-4">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">المشتريات الشهرية</h5>
                <div class="card-tools">
                    <button type="button" class="btn btn-sm btn-outline-secondary" onclick="toggleChart('purchases')">
                        <i class="fas fa-sync-alt"></i>
                    </button>
                </div>
            </div>
            <div class="card-body">
                <canvas id="monthlyPurchasesChart" style="height: 300px;"></canvas>
            </div>
        </div>
    </div>
    
    <div class="col-lg-4 mb-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">توزيع الموردين</h5>
            </div>
            <div class="card-body">
                <canvas id="suppliersDistributionChart" style="height: 300px;"></canvas>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <!-- أكبر الموردين من حيث المشتريات -->
    <div class="col-lg-6 mb-4">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">أكبر الموردين (المشتريات)</h5>
                <a href="{{ route('suppliers.analytics.comparison') }}" class="btn btn-sm btn-outline-primary">
                    عرض المقارنة
                </a>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-sm">
                        <thead>
                            <tr>
                                <th>المورد</th>
                                <th class="text-end">المبلغ</th>
                                <th class="text-end">النسبة</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($topSuppliersByPurchases->take(5) as $supplier)
                            <tr>
                                <td>
                                    <a href="{{ route('suppliers.show', $supplier) }}" class="text-decoration-none">
                                        {{ $supplier->name }}
                                    </a>
                                </td>
                                <td class="text-end">
                                    <strong>{{ number_format($supplier->total_purchases, 0) }} ر.س</strong>
                                </td>
                                <td class="text-end">
                                    @php
                                        $percentage = $yearlyPurchases > 0 ? ($supplier->total_purchases / $yearlyPurchases) * 100 : 0;
                                    @endphp
                                    <div class="d-flex align-items-center justify-content-end">
                                        <span class="me-2">{{ number_format($percentage, 1) }}%</span>
                                        <div class="progress flex-grow-1" style="width: 60px; height: 8px;">
                                            <div class="progress-bar bg-primary" style="width: {{ $percentage }}%"></div>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
    <!-- الموردين مع أعلى مديونية -->
    <div class="col-lg-6 mb-4">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">أعلى المديونيات</h5>
                <a href="{{ route('suppliers.analytics.aging') }}" class="btn btn-sm btn-outline-warning">
                    تقرير الأعمار
                </a>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-sm">
                        <thead>
                            <tr>
                                <th>المورد</th>
                                <th class="text-end">المديونية</th>
                                <th class="text-center">الحالة</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($topSuppliersByDebt->take(5) as $supplier)
                            <tr>
                                <td>
                                    <a href="{{ route('suppliers.show', $supplier) }}" class="text-decoration-none">
                                        {{ $supplier->name }}
                                    </a>
                                </td>
                                <td class="text-end">
                                    <strong class="text-danger">{{ number_format($supplier->current_balance, 0) }} ر.س</strong>
                                </td>
                                <td class="text-center">
                                    @if($supplier->exceedsCreditLimit())
                                        <span class="badge bg-danger">تجاوز الحد</span>
                                    @elseif($supplier->getOverdueAmount() > 0)
                                        <span class="badge bg-warning">متأخر</span>
                                    @else
                                        <span class="badge bg-info">مستحق</span>
                                    @endif
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <!-- تطور المديونية -->
    <div class="col-lg-8 mb-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">تطور المديونية</h5>
            </div>
            <div class="card-body">
                <canvas id="debtEvolutionChart" style="height: 300px;"></canvas>
            </div>
        </div>
    </div>
    
    <!-- إحصائيات إضافية -->
    <div class="col-lg-4 mb-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">إحصائيات أخرى</h5>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <div class="d-flex justify-content-between">
                        <span>أوامر شراء معلقة</span>
                        <strong class="text-warning">{{ $pendingOrders }}</strong>
                    </div>
                </div>
                
                <div class="mb-3">
                    <div class="d-flex justify-content-between">
                        <span>أوامر شراء مؤكدة</span>
                        <strong class="text-success">{{ $approvedOrders }}</strong>
                    </div>
                </div>
                
                <div class="mb-3">
                    <div class="d-flex justify-content-between">
                        <span>مدفوعات هذا الشهر</span>
                        <strong class="text-primary">{{ number_format($monthlyPayments, 0) }} ر.س</strong>
                    </div>
                </div>
                
                <hr>
                
                <div class="text-center">
                    <a href="{{ route('suppliers.payments.index') }}" class="btn btn-outline-primary btn-sm">
                        <i class="fas fa-money-bill-wave me-2"></i>
                        إدارة المدفوعات
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // بيانات الرسوم البيانية
    const monthlyPurchasesData = @json($monthlyPurchasesChart);
    const debtEvolutionData = @json($debtEvolutionChart);
    
    // رسم بياني للمشتريات الشهرية
    const purchasesCtx = document.getElementById('monthlyPurchasesChart').getContext('2d');
    new Chart(purchasesCtx, {
        type: 'line',
        data: {
            labels: monthlyPurchasesData.months,
            datasets: [{
                label: 'المشتريات (ر.س)',
                data: monthlyPurchasesData.data,
                borderColor: 'rgb(54, 162, 235)',
                backgroundColor: 'rgba(54, 162, 235, 0.1)',
                borderWidth: 2,
                fill: true,
                tension: 0.4
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return new Intl.NumberFormat('ar-SA').format(value) + ' ر.س';
                        }
                    }
                }
            },
            plugins: {
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            return 'المشتريات: ' + new Intl.NumberFormat('ar-SA').format(context.parsed.y) + ' ر.س';
                        }
                    }
                }
            }
        }
    });
    
    // رسم بياني لتوزيع الموردين
    const distributionCtx = document.getElementById('suppliersDistributionChart').getContext('2d');
    new Chart(distributionCtx, {
        type: 'doughnut',
        data: {
            labels: ['نشط', 'غير نشط', 'لديه مديونية'],
            datasets: [{
                data: [{{ $activeSuppliers }}, {{ $totalSuppliers - $activeSuppliers }}, {{ $suppliersWithDebt }}],
                backgroundColor: [
                    'rgb(40, 167, 69)',
                    'rgb(108, 117, 125)',
                    'rgb(255, 193, 7)'
                ]
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom'
                }
            }
        }
    });
    
    // رسم بياني لتطور المديونية
    const debtCtx = document.getElementById('debtEvolutionChart').getContext('2d');
    new Chart(debtCtx, {
        type: 'area',
        data: {
            labels: debtEvolutionData.months,
            datasets: [{
                label: 'المديونية (ر.س)',
                data: debtEvolutionData.data,
                borderColor: 'rgb(220, 53, 69)',
                backgroundColor: 'rgba(220, 53, 69, 0.1)',
                borderWidth: 2,
                fill: true,
                tension: 0.4
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return new Intl.NumberFormat('ar-SA').format(value) + ' ر.س';
                        }
                    }
                }
            },
            plugins: {
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            return 'المديونية: ' + new Intl.NumberFormat('ar-SA').format(context.parsed.y) + ' ر.س';
                        }
                    }
                }
            }
        }
    });
    
    // دالة تصدير التقارير
    function exportReport(type, format) {
        const url = "{{ route('suppliers.analytics.export') }}";
        const params = new URLSearchParams({
            type: type,
            format: format
        });
        
        window.open(`${url}?${params}`, '_blank');
    }
    
    // تبديل عرض الرسم البياني
    function toggleChart(type) {
        // يمكن إضافة منطق تبديل البيانات هنا
        console.log('Toggle chart:', type);
    }
</script>
@endpush