@extends('layouts.app')

@section('title', 'تقرير أعمار الديون')
@section('page-title', 'تقرير أعمار الديون')

@section('page-actions')
    <div class="btn-group" role="group">
        <a href="{{ route('suppliers.analytics.dashboard') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-right me-2"></i>
            العودة للوحة التحكم
        </a>
        <button type="button" class="btn btn-info" data-bs-toggle="modal" data-bs-target="#filterModal">
            <i class="fas fa-filter me-2"></i>
            تصفية
        </button>
        <div class="btn-group" role="group">
            <button type="button" class="btn btn-success dropdown-toggle" data-bs-toggle="dropdown">
                <i class="fas fa-download me-2"></i>
                تصدير
            </button>
            <ul class="dropdown-menu">
                <li><a class="dropdown-item" href="#" onclick="exportReport('aging', 'excel')">
                    <i class="fas fa-file-excel me-2"></i>Excel
                </a></li>
                <li><a class="dropdown-item" href="#" onclick="exportReport('aging', 'pdf')">
                    <i class="fas fa-file-pdf me-2"></i>PDF
                </a></li>
                <li><a class="dropdown-item" href="#" onclick="printReport()">
                    <i class="fas fa-print me-2"></i>طباعة
                </a></li>
            </ul>
        </div>
    </div>
@endsection

@section('content')
<!-- معلومات التقرير -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card border-primary">
            <div class="card-body">
                <div class="row align-items-center">
                    <div class="col-md-6">
                        <h5 class="card-title text-primary mb-2">
                            <i class="fas fa-calendar-alt me-2"></i>
                            تقرير أعمار الديون
                        </h5>
                        <p class="card-text mb-0">
                            <strong>كما في تاريخ:</strong> {{ Carbon\Carbon::parse($asOfDate)->format('d/m/Y') }}
                        </p>
                    </div>
                    <div class="col-md-6">
                        <div class="row text-center">
                            <div class="col-4">
                                <div class="h6 mb-0 text-success">{{ number_format($totals['current'], 0) }}</div>
                                <small class="text-muted">غير مستحق</small>
                            </div>
                            <div class="col-4">
                                <div class="h6 mb-0 text-warning">{{ number_format($totals['1_30_days'] + $totals['31_60_days'], 0) }}</div>
                                <small class="text-muted">متأخر حتى 60 يوم</small>
                            </div>
                            <div class="col-4">
                                <div class="h6 mb-0 text-danger">{{ number_format($totals['over_90_days'], 0) }}</div>
                                <small class="text-muted">متأخر +90 يوم</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- ملخص إجمالي -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card">
            <div class="card-header bg-light">
                <h6 class="card-title mb-0">
                    <i class="fas fa-chart-pie me-2"></i>
                    الملخص الإجمالي
                </h6>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-sm table-borderless">
                        <thead>
                            <tr class="border-bottom">
                                <th class="text-center">غير مستحق</th>
                                <th class="text-center">1-30 يوم</th>
                                <th class="text-center">31-60 يوم</th>
                                <th class="text-center">61-90 يوم</th>
                                <th class="text-center">أكثر من 90 يوم</th>
                                <th class="text-center">الإجمالي</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr class="fs-6 fw-bold">
                                <td class="text-center text-success">
                                    {{ number_format($totals['current'], 2) }} ر.س
                                    <br>
                                    <small class="text-muted">
                                        {{ $totals['total'] > 0 ? number_format(($totals['current'] / $totals['total']) * 100, 1) : 0 }}%
                                    </small>
                                </td>
                                <td class="text-center text-warning">
                                    {{ number_format($totals['1_30_days'], 2) }} ر.س
                                    <br>
                                    <small class="text-muted">
                                        {{ $totals['total'] > 0 ? number_format(($totals['1_30_days'] / $totals['total']) * 100, 1) : 0 }}%
                                    </small>
                                </td>
                                <td class="text-center text-warning">
                                    {{ number_format($totals['31_60_days'], 2) }} ر.س
                                    <br>
                                    <small class="text-muted">
                                        {{ $totals['total'] > 0 ? number_format(($totals['31_60_days'] / $totals['total']) * 100, 1) : 0 }}%
                                    </small>
                                </td>
                                <td class="text-center text-danger">
                                    {{ number_format($totals['61_90_days'], 2) }} ر.س
                                    <br>
                                    <small class="text-muted">
                                        {{ $totals['total'] > 0 ? number_format(($totals['61_90_days'] / $totals['total']) * 100, 1) : 0 }}%
                                    </small>
                                </td>
                                <td class="text-center text-danger">
                                    {{ number_format($totals['over_90_days'], 2) }} ر.س
                                    <br>
                                    <small class="text-muted">
                                        {{ $totals['total'] > 0 ? number_format(($totals['over_90_days'] / $totals['total']) * 100, 1) : 0 }}%
                                    </small>
                                </td>
                                <td class="text-center text-primary border-start">
                                    {{ number_format($totals['total'], 2) }} ر.س
                                    <br>
                                    <small class="text-muted">100%</small>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- تفاصيل أعمار الديون لكل مورد -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h6 class="card-title mb-0">
                    <i class="fas fa-list me-2"></i>
                    تفاصيل أعمار الديون حسب المورد
                </h6>
                <span class="badge bg-primary">{{ $agingData->count() }} مورد</span>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0" id="agingTable">
                        <thead class="table-light">
                            <tr>
                                <th>المورد</th>
                                <th class="text-center">غير مستحق</th>
                                <th class="text-center">1-30 يوم</th>
                                <th class="text-center">31-60 يوم</th>
                                <th class="text-center">61-90 يوم</th>
                                <th class="text-center">أكثر من 90 يوم</th>
                                <th class="text-center">الإجمالي</th>
                                <th class="text-center">الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($agingData as $data)
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="flex-shrink-0">
                                            @if($data['over_90_days'] > 0)
                                                <i class="fas fa-exclamation-triangle text-danger me-2"></i>
                                            @elseif($data['61_90_days'] > 0 || $data['31_60_days'] > 0)
                                                <i class="fas fa-clock text-warning me-2"></i>
                                            @else
                                                <i class="fas fa-check-circle text-success me-2"></i>
                                            @endif
                                        </div>
                                        <div class="flex-grow-1">
                                            <strong>{{ $data['supplier']->name }}</strong>
                                            @if($data['supplier']->name_en)
                                                <br><small class="text-muted">{{ $data['supplier']->name_en }}</small>
                                            @endif
                                        </div>
                                    </div>
                                </td>
                                <td class="text-center">
                                    @if($data['current'] > 0)
                                        <span class="text-success fw-bold">{{ number_format($data['current'], 0) }}</span>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td class="text-center">
                                    @if($data['1_30_days'] > 0)
                                        <span class="text-warning fw-bold">{{ number_format($data['1_30_days'], 0) }}</span>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td class="text-center">
                                    @if($data['31_60_days'] > 0)
                                        <span class="text-warning fw-bold">{{ number_format($data['31_60_days'], 0) }}</span>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td class="text-center">
                                    @if($data['61_90_days'] > 0)
                                        <span class="text-danger fw-bold">{{ number_format($data['61_90_days'], 0) }}</span>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td class="text-center">
                                    @if($data['over_90_days'] > 0)
                                        <span class="text-danger fw-bold">{{ number_format($data['over_90_days'], 0) }}</span>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td class="text-center">
                                    <strong class="text-primary">{{ number_format($data['total'], 0) }} ر.س</strong>
                                </td>
                                <td class="text-center">
                                    <div class="btn-group btn-group-sm" role="group">
                                        <a href="{{ route('suppliers.show', $data['supplier']) }}" 
                                           class="btn btn-outline-info" title="عرض المورد">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('suppliers.analytics.statement', $data['supplier']) }}" 
                                           class="btn btn-outline-primary" title="كشف الحساب">
                                            <i class="fas fa-file-invoice"></i>
                                        </a>
                                        @if($data['total'] > 0)
                                        <a href="{{ route('suppliers.payments.create', ['supplier_id' => $data['supplier']->id]) }}" 
                                           class="btn btn-outline-success" title="إضافة دفعة">
                                            <i class="fas fa-money-bill-wave"></i>
                                        </a>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="8" class="text-center py-4">
                                    <div class="text-muted">
                                        <i class="fas fa-info-circle fa-2x mb-3"></i>
                                        <p>لا توجد ديون مستحقة في التاريخ المحدد</p>
                                    </div>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- الرسم البياني للأعمار -->
@if($agingData->count() > 0)
<div class="row mt-4">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-chart-bar me-2"></i>
                    توزيع الديون حسب الأعمار
                </h6>
            </div>
            <div class="card-body">
                <canvas id="agingChart" style="height: 300px;"></canvas>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    تنبيهات المخاطر
                </h6>
            </div>
            <div class="card-body">
                @php
                    $criticalSuppliers = $agingData->filter(fn($data) => $data['over_90_days'] > 0);
                    $warningSuppliers = $agingData->filter(fn($data) => $data['61_90_days'] > 0 || $data['31_60_days'] > 0);
                @endphp
                
                @if($criticalSuppliers->count() > 0)
                <div class="alert alert-danger alert-sm">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    <strong>{{ $criticalSuppliers->count() }}</strong> مورد لديه ديون متأخرة أكثر من 90 يوم
                </div>
                @endif
                
                @if($warningSuppliers->count() > 0)
                <div class="alert alert-warning alert-sm">
                    <i class="fas fa-clock me-2"></i>
                    <strong>{{ $warningSuppliers->count() }}</strong> مورد لديه ديون متأخرة حتى 90 يوم
                </div>
                @endif
                
                <div class="d-grid">
                    <a href="{{ route('suppliers.payments.create') }}" class="btn btn-primary btn-sm">
                        <i class="fas fa-plus me-2"></i>
                        إضافة دفعة جديدة
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
@endif
@endsection

<!-- مودال الفلترة -->
<div class="modal fade" id="filterModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="GET" action="{{ route('suppliers.analytics.aging') }}">
                <div class="modal-header">
                    <h5 class="modal-title">فلترة التقرير</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="as_of_date" class="form-label">كما في تاريخ</label>
                        <input type="date" class="form-control" id="as_of_date" name="as_of_date" 
                               value="{{ $asOfDate }}" max="{{ now()->format('Y-m-d') }}">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">تطبيق الفلتر</button>
                </div>
            </form>
        </div>
    </div>
</div>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    @if($agingData->count() > 0)
    // رسم بياني لتوزيع الأعمار
    const agingCtx = document.getElementById('agingChart').getContext('2d');
    new Chart(agingCtx, {
        type: 'bar',
        data: {
            labels: ['غير مستحق', '1-30 يوم', '31-60 يوم', '61-90 يوم', '+90 يوم'],
            datasets: [{
                label: 'المبلغ (ر.س)',
                data: [
                    {{ $totals['current'] }},
                    {{ $totals['1_30_days'] }},
                    {{ $totals['31_60_days'] }},
                    {{ $totals['61_90_days'] }},
                    {{ $totals['over_90_days'] }}
                ],
                backgroundColor: [
                    'rgba(40, 167, 69, 0.8)',
                    'rgba(255, 193, 7, 0.8)',
                    'rgba(255, 193, 7, 0.9)',
                    'rgba(220, 53, 69, 0.8)',
                    'rgba(220, 53, 69, 0.9)'
                ],
                borderColor: [
                    'rgb(40, 167, 69)',
                    'rgb(255, 193, 7)',
                    'rgb(255, 193, 7)',
                    'rgb(220, 53, 69)',
                    'rgb(220, 53, 69)'
                ],
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return new Intl.NumberFormat('ar-SA').format(value) + ' ر.س';
                        }
                    }
                }
            },
            plugins: {
                legend: {
                    display: false
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            return 'المبلغ: ' + new Intl.NumberFormat('ar-SA').format(context.parsed.y) + ' ر.س';
                        }
                    }
                }
            }
        }
    });
    @endif
    
    // دالة التصدير
    function exportReport(type, format) {
        const url = "{{ route('suppliers.analytics.export') }}";
        const params = new URLSearchParams({
            type: type,
            format: format,
            as_of_date: '{{ $asOfDate }}'
        });
        
        window.open(`${url}?${params}`, '_blank');
    }
    
    // دالة الطباعة
    function printReport() {
        window.print();
    }
    
    // تحسين عرض الجدول على الأجهزة المحمولة
    document.addEventListener('DOMContentLoaded', function() {
        const table = document.getElementById('agingTable');
        if (table && window.innerWidth < 768) {
            // إضافة منطق تحسين العرض للأجهزة المحمولة
        }
    });
</script>
@endpush

@push('styles')
<style>
    @media print {
        .btn, .modal, .dropdown {
            display: none !important;
        }
        
        .card {
            border: 1px solid #dee2e6 !important;
            box-shadow: none !important;
        }
        
        .table th,
        .table td {
            border: 1px solid #dee2e6 !important;
        }
    }
    
    .alert-sm {
        padding: 0.5rem 0.75rem;
        font-size: 0.875rem;
    }
    
    .table th {
        font-weight: 600;
        font-size: 0.875rem;
    }
    
    .table td {
        font-size: 0.875rem;
    }
</style>
@endpush