@extends('layouts.app')

@section('title', 'عرض سند القبض - ' . $receiptVoucher->voucher_number)

@section('content')
<div class="container-fluid">
    <!-- Header Section -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800">سند القبض - {{ $receiptVoucher->voucher_number }}</h1>
        <div class="btn-group">
            <a href="{{ route('receipt-vouchers.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> العودة للقائمة
            </a>
            @if($receiptVoucher->status !== 'cancelled')
                <a href="{{ route('receipt-vouchers.edit', $receiptVoucher) }}" class="btn btn-warning">
                    <i class="fas fa-edit"></i> تحرير
                </a>
            @endif
            <a href="{{ route('receipt-vouchers.print', $receiptVoucher) }}" class="btn btn-info" target="_blank">
                <i class="fas fa-print"></i> طباعة
            </a>
        </div>
    </div>

    <div class="row">
        <!-- معلومات السند -->
        <div class="col-lg-8">
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex justify-content-between align-items-center">
                    <h6 class="m-0 font-weight-bold text-primary">تفاصيل سند القبض</h6>
                    <span class="badge badge-{{ $receiptVoucher->getStatusColor() }} badge-lg">
                        {{ $receiptVoucher->getStatusText() }}
                    </span>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td class="font-weight-bold">رقم السند:</td>
                                    <td>{{ $receiptVoucher->voucher_number }}</td>
                                </tr>
                                <tr>
                                    <td class="font-weight-bold">الشركة:</td>
                                    <td>{{ $receiptVoucher->company->name }}</td>
                                </tr>
                                <tr>
                                    <td class="font-weight-bold">العميل:</td>
                                    <td>
                                        <a href="{{ route('customers.show', $receiptVoucher->customer) }}" class="text-primary">
                                            {{ $receiptVoucher->customer->name }}
                                        </a>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="font-weight-bold">تاريخ الاستلام:</td>
                                    <td>{{ $receiptVoucher->receipt_date->format('Y-m-d H:i') }}</td>
                                </tr>
                                <tr>
                                    <td class="font-weight-bold">المبلغ:</td>
                                    <td class="h5 text-success">{{ number_format($receiptVoucher->amount, 2) }} ر.س</td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td class="font-weight-bold">طريقة الدفع:</td>
                                    <td>{{ $receiptVoucher->getPaymentMethodText() }}</td>
                                </tr>
                                <tr>
                                    <td class="font-weight-bold">الرقم المرجعي:</td>
                                    <td>{{ $receiptVoucher->reference_number ?: 'غير محدد' }}</td>
                                </tr>
                                <tr>
                                    <td class="font-weight-bold">رمز الحساب:</td>
                                    <td>{{ $receiptVoucher->account_code ?: 'غير محدد' }}</td>
                                </tr>
                                <tr>
                                    <td class="font-weight-bold">المستخدم:</td>
                                    <td>{{ $receiptVoucher->user->name }}</td>
                                </tr>
                                <tr>
                                    <td class="font-weight-bold">تاريخ الإنشاء:</td>
                                    <td>{{ $receiptVoucher->created_at->format('Y-m-d H:i') }}</td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <hr>
                            <h6 class="font-weight-bold">الوصف:</h6>
                            <p class="text-gray-800">{{ $receiptVoucher->description }}</p>

                            @if($receiptVoucher->notes)
                                <h6 class="font-weight-bold">الملاحظات:</h6>
                                <p class="text-gray-600">{{ $receiptVoucher->notes }}</p>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- معلومات إضافية -->
        <div class="col-lg-4">
            <!-- الفاتورة المرتبطة -->
            @if($receiptVoucher->invoice)
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">الفاتورة المرتبطة</h6>
                    </div>
                    <div class="card-body">
                        <div class="text-center">
                            <i class="fas fa-file-invoice fa-2x text-primary mb-3"></i>
                            <h6>{{ $receiptVoucher->invoice->invoice_number }}</h6>
                            <p class="text-muted mb-2">{{ $receiptVoucher->invoice->customer->name }}</p>
                            <p class="mb-2">
                                <strong>إجمالي الفاتورة:</strong><br>
                                {{ number_format($receiptVoucher->invoice->total_amount, 2) }} ر.س
                            </p>
                            <p class="mb-3">
                                <strong>المتبقي:</strong><br>
                                <span class="text-{{ $receiptVoucher->invoice->remaining_amount > 0 ? 'danger' : 'success' }}">
                                    {{ number_format($receiptVoucher->invoice->remaining_amount, 2) }} ر.س
                                </span>
                            </p>
                            <a href="{{ route('invoices.show', $receiptVoucher->invoice) }}" class="btn btn-sm btn-primary">
                                <i class="fas fa-eye"></i> عرض الفاتورة
                            </a>
                        </div>
                    </div>
                </div>
            @endif

            <!-- إحصائيات العميل -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">إحصائيات العميل</h6>
                </div>
                <div class="card-body">
                    @php
                        $customer = $receiptVoucher->customer;
                        $customerReceipts = $customer->receiptVouchers()->active()->get();
                        $totalReceived = $customerReceipts->sum('amount');
                        $receiptCount = $customerReceipts->count();
                    @endphp
                    <div class="text-center">
                        <i class="fas fa-user-tie fa-2x text-info mb-3"></i>
                        <h6>{{ $customer->name }}</h6>
                        <p class="text-muted mb-2">{{ $customer->email }}</p>
                        <hr>
                        <div class="row">
                            <div class="col-6">
                                <p class="mb-1">
                                    <strong>إجمالي المستلم:</strong><br>
                                    <span class="text-success">{{ number_format($totalReceived, 2) }} ر.س</span>
                                </p>
                            </div>
                            <div class="col-6">
                                <p class="mb-1">
                                    <strong>عدد السندات:</strong><br>
                                    <span class="text-info">{{ $receiptCount }}</span>
                                </p>
                            </div>
                        </div>
                        <a href="{{ route('customers.show', $customer) }}" class="btn btn-sm btn-info mt-2">
                            <i class="fas fa-eye"></i> ملف العميل
                        </a>
                    </div>
                </div>
            </div>

            <!-- إجراءات سريعة -->
            @if($receiptVoucher->status !== 'cancelled')
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">إجراءات سريعة</h6>
                    </div>
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <a href="{{ route('receipt-vouchers.edit', $receiptVoucher) }}" class="btn btn-warning btn-sm">
                                <i class="fas fa-edit"></i> تحرير السند
                            </a>
                            
                            <a href="{{ route('receipt-vouchers.print', $receiptVoucher) }}" class="btn btn-info btn-sm" target="_blank">
                                <i class="fas fa-print"></i> طباعة السند
                            </a>
                            
                            @if(!$receiptVoucher->invoice)
                                <button type="button" class="btn btn-secondary btn-sm" data-toggle="modal" data-target="#linkInvoiceModal">
                                    <i class="fas fa-link"></i> ربط بفاتورة
                                </button>
                            @endif
                            
                            <hr>
                            
                            <button type="button" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#cancelModal">
                                <i class="fas fa-times"></i> إلغاء السند
                            </button>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>

<!-- Modal إلغاء السند -->
@if($receiptVoucher->status !== 'cancelled')
<div class="modal fade" id="cancelModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">تأكيد إلغاء السند</h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span>&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>هل أنت متأكد من إلغاء سند القبض <strong>{{ $receiptVoucher->voucher_number }}</strong>؟</p>
                <p class="text-danger"><strong>تحذير:</strong> هذا الإجراء سيؤثر على حالة الدفع للفاتورة المرتبطة إن وجدت.</p>
            </div>
            <div class="modal-footer">
                <form action="{{ route('receipt-vouchers.destroy', $receiptVoucher) }}" method="POST">
                    @csrf
                    @method('DELETE')
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-danger">تأكيد الإلغاء</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endif
@endsection