<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>سند قبض - {{ $receiptVoucher->voucher_number }}</title>
    
    <!-- Bootstrap CSS (RTL) -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <!-- Google Fonts (Arabic) -->
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@200;300;400;500;700;800;900&display=swap" rel="stylesheet">
    
    <style>
        @page {
            size: A4;
            margin: 1.5cm;
        }
        
        body {
            font-family: 'Tajawal', sans-serif;
            font-size: 12px;
            line-height: 1.4;
            margin: 0;
            padding: 0;
            color: #000;
            background: #fff;
        }
        
        .voucher-header {
            border-bottom: 3px solid #000;
            margin-bottom: 20px;
            padding-bottom: 15px;
        }
        
        .voucher-title {
            background: #000;
            color: #fff;
            text-align: center;
            padding: 15px;
            margin-bottom: 15px;
            border: 2px solid #000;
        }
        
        .voucher-title h2 {
            font-size: 1.6rem;
            margin: 0;
            font-weight: 700;
            letter-spacing: 1px;
        }
        
        .voucher-title h4 {
            font-size: 1.2rem;
            margin: 5px 0 0 0;
            font-weight: 600;
        }
        
        .company-info {
            border: 2px solid #000;
            padding: 15px;
            margin-bottom: 15px;
            background: #fff;
        }
        
        .company-info h5 {
            font-size: 1.1rem;
            margin-bottom: 8px;
            font-weight: 700;
            border-bottom: 1px solid #000;
            padding-bottom: 5px;
        }
        
        .company-info p, .company-info span {
            font-size: 11px;
            margin-bottom: 4px;
            color: #000;
        }
        
        .voucher-details {
            border: 2px solid #000;
            padding: 15px;
            margin-bottom: 15px;
            background: #fff;
        }
        
        .amount-box {
            background: #fff;
            color: #000;
            text-align: center;
            padding: 20px;
            border: 3px solid #000;
            margin: 15px 0;
        }
        
        .amount-box h4 {
            font-size: 1.1rem;
            margin: 0;
            font-weight: 700;
        }
        
        .amount-box .amount {
            font-size: 1.8rem;
            font-weight: 900;
            margin: 10px 0;
            letter-spacing: 1px;
        }
        
        .signature-area {
            margin-top: 20px;
            border-top: 2px solid #000;
            padding-top: 15px;
        }
        
        .signature-box {
            border: 2px solid #000;
            height: 60px;
            margin-top: 8px;
            background: #fff;
        }
        
        .signature-area h6 {
            font-size: 12px;
            margin-bottom: 5px;
            font-weight: 700;
            color: #000;
        }
        
        .signature-area p {
            font-size: 10px;
            margin: 3px 0;
            color: #000;
            font-weight: 600;
        }
        
        @media print {
            .no-print {
                display: none !important;
            }
            
            body {
                font-size: 11px;
                margin: 0;
                padding: 0;
                color: #000 !important;
                background: #fff !important;
            }
            
            .container-fluid {
                padding: 0;
                margin: 0;
                max-width: 100%;
            }
            
            .page-break {
                page-break-before: always;
            }
            
            .voucher-content {
                page-break-inside: avoid;
            }
            
            .voucher-details {
                margin-bottom: 12px;
            }
            
            .signature-area {
                margin-top: 15px;
                padding-top: 12px;
            }
            
            * {
                color: #000 !important;
                background: #fff !important;
            }
            
            .voucher-title {
                background: #000 !important;
                color: #fff !important;
            }
            
            .voucher-title h2, .voucher-title h4 {
                color: #fff !important;
            }
        }
        
        .info-table {
            font-size: 11px;
            width: 100%;
        }
        
        .info-table td {
            padding: 6px 10px;
            border-bottom: 1px solid #000;
            border-right: 1px solid #000;
        }
        
        .info-table td:first-child {
            background: #f0f0f0;
            font-weight: 700;
            width: 35%;
            border-left: 1px solid #000;
        }
        
        .info-table tr:first-child td {
            border-top: 1px solid #000;
        }
        
        .section-title {
            font-size: 13px;
            font-weight: 700;
            margin-bottom: 10px;
            color: #000;
            border-bottom: 2px solid #000;
            padding-bottom: 5px;
            text-transform: uppercase;
        }
        
        .description-box {
            border: 2px solid #000;
            padding: 12px;
            background: #f8f8f8;
            font-size: 11px;
            margin-bottom: 10px;
            min-height: 40px;
        }
        
        .footer-info {
            font-size: 9px;
            color: #000;
            margin-top: 15px;
            padding-top: 8px;
            border-top: 2px solid #000;
            text-align: center;
            font-weight: 600;
        }
        
        .compact-row {
            margin-bottom: 12px;
        }
        
        .professional-border {
            border: 1px solid #000;
            margin: 5px 0;
        }
        
        .header-line {
            height: 2px;
            background: #000;
            margin: 10px 0;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <!-- Print Button -->
        <div class="no-print mb-2">
            <button onclick="window.print()" class="btn btn-primary btn-sm">
                <i class="fas fa-print"></i> طباعة
            </button>
            <button onclick="window.close()" class="btn btn-secondary btn-sm">
                <i class="fas fa-times"></i> إغلاق
            </button>
        </div>

        <!-- Voucher Content -->
        <div class="voucher-content">
            <!-- Header -->
            <div class="voucher-header">
                <div class="voucher-title">
                    <h2 class="mb-0">سند قبض نقدي</h2>
                    <h4 class="mb-0">{{ $receiptVoucher->voucher_number }}</h4>
                </div>
                
                <!-- Company Information -->
                <div class="company-info">
                    <div class="row">
                        <div class="col-md-8">
                            <h5 class="mb-1">{{ $receiptVoucher->company->name }}</h5>
                            <p class="mb-1">{{ $receiptVoucher->company->full_address }}</p>
                            @if($receiptVoucher->company->phone)
                                <span class="me-3"><strong>ت:</strong> {{ $receiptVoucher->company->phone }}</span>
                            @endif
                            @if($receiptVoucher->company->email)
                                <span><strong>بريد:</strong> {{ $receiptVoucher->company->email }}</span>
                            @endif
                        </div>
                        <div class="col-md-4 text-end">
                            @if($receiptVoucher->company->vat_number)
                                <p class="mb-1"><strong>رقم ضريبي : </strong> {{ $receiptVoucher->company->vat_number }}</p>
                            @endif
                            @if($receiptVoucher->company->cr_number)
                                <p class="mb-1"><strong>سجل تجاري:</strong> {{ $receiptVoucher->company->cr_number }}</p>
                            @endif
                            <p class="mb-0"><strong>التاريخ:</strong> {{ $receiptVoucher->receipt_date->format('Y-m-d') }}</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Voucher Details -->
            <div class="voucher-details">
                <div class="row">
                    <div class="col-md-6">
                        <table class="table table-borderless info-table">
                            <tr>
                                <td>رقم السند:</td>
                                <td><strong>{{ $receiptVoucher->voucher_number }}</strong></td>
                            </tr>
                            <tr>
                                <td>اسم العميل:</td>
                                <td><strong>{{ $receiptVoucher->customer->name }}</strong></td>
                            </tr>
                            <tr>
                                <td>تاريخ الاستلام:</td>
                                <td>{{ $receiptVoucher->receipt_date->format('Y-m-d H:i') }}</td>
                            </tr>
                            <tr>
                                <td>طريقة الدفع:</td>
                                <td>{{ $receiptVoucher->getPaymentMethodText() }}</td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-borderless info-table">
                            @if($receiptVoucher->reference_number)
                            <tr>
                                <td>الرقم المرجعي:</td>
                                <td>{{ $receiptVoucher->reference_number }}</td>
                            </tr>
                            @endif
                            @if($receiptVoucher->account_code)
                            <tr>
                                <td>رمز الحساب:</td>
                                <td>{{ $receiptVoucher->account_code }}</td>
                            </tr>
                            @endif
                            @if($receiptVoucher->invoice)
                            <tr>
                                <td>الفاتورة المرتبطة:</td>
                                <td>{{ $receiptVoucher->invoice->invoice_number }}</td>
                            </tr>
                            @endif
                            <tr>
                                <td>الحالة:</td>
                                <td>{{ $receiptVoucher->getStatusText() }}</td>
                            </tr>
                        </table>
                    </div>
                </div>

                <!-- Amount Box -->
                <div class="amount-box">
                    <div class="row align-items-center">
                        <div class="col-md-8">
                            <h4 class="mb-0">المبلغ المستلم</h4>
                            <div class="amount">{{ number_format($receiptVoucher->amount, 2) }} ر.س</div>
                        </div>
                        <div class="col-md-4">
                            <div class="text-end">
                                <h5 class="mb-0">{{ $receiptVoucher->amount }} ر.س</h5>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Description & Notes -->
                <div class="compact-row">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="section-title">وصف السند:</div>
                            <div class="description-box">{{ $receiptVoucher->description }}</div>
                        </div>
                        @if($receiptVoucher->notes)
                        <div class="col-md-6">
                            <div class="section-title">ملاحظات:</div>
                            <div class="description-box">{{ $receiptVoucher->notes }}</div>
                        </div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Customer Information -->
            <div class="voucher-details">
                <div class="section-title">معلومات العميل:</div>
                <div class="row">
                    <div class="col-md-6">
                        <table class="table table-borderless info-table">
                            <tr>
                                <td>الاسم:</td>
                                <td>{{ $receiptVoucher->customer->name }}</td>
                            </tr>
                            @if($receiptVoucher->customer->vat_number)
                            <tr>
                                <td>ض.ق:</td>
                                <td>{{ $receiptVoucher->customer->vat_number }}</td>
                            </tr>
                            @endif
                            @if($receiptVoucher->customer->phone)
                            <tr>
                                <td>الهاتف:</td>
                                <td>{{ $receiptVoucher->customer->phone }}</td>
                            </tr>
                            @endif
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-borderless info-table">
                            @if($receiptVoucher->customer->email)
                            <tr>
                                <td>البريد:</td>
                                <td>{{ $receiptVoucher->customer->email }}</td>
                            </tr>
                            @endif
                            @if($receiptVoucher->customer->city)
                            <tr>
                                <td>المدينة:</td>
                                <td>{{ $receiptVoucher->customer->city }}</td>
                            </tr>
                            @endif
                            <tr>
                                <td>النوع:</td>
                                <td>{{ $receiptVoucher->customer->customer_type == 'individual' ? 'فرد' : 'مؤسسة' }}</td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Signatures -->
            <div class="signature-area">
                <div class="row">
                    <div class="col-md-4">
                        <h6>توقيع المستلم:</h6>
                        <div class="signature-box"></div>
                        <p class="text-center mb-0">{{ $receiptVoucher->user->name }}</p>
                    </div>
                    <div class="col-md-4">
                        <h6>توقيع العميل:</h6>
                        <div class="signature-box"></div>
                        <p class="text-center mb-0">{{ $receiptVoucher->customer->name }}</p>
                    </div>
                    <div class="col-md-4">
                        <h6>ختم الشركة:</h6>
                        <div class="signature-box"></div>
                        <p class="text-center mb-0">{{ $receiptVoucher->company->name }}</p>
                    </div>
                </div>
            </div>

            <!-- Footer -->
            <div class="footer-info">
                تم إنشاء السند: {{ $receiptVoucher->created_at->format('Y-m-d H:i') }} - بواسطة: {{ $receiptVoucher->user->name }}
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Auto print when page loads (optional)
        // window.onload = function() { window.print(); }
        
        // Close window after printing
        window.onafterprint = function() {
            // window.close();
        }
    </script>
</body>
</html>